/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.agent.rt.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.coverage.agent.rt.internal.IExceptionLogger;
import kd.bos.unittest.coverage.agent.rt.internal.KdJmxRegistration;
import kd.bos.unittest.coverage.agent.rt.internal.output.IKdAgentOutput;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdFileOutput;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdNoneOutput;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpClientOutput;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpClusterClientOutput;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpServerOutput;
import kd.bos.unittest.coverage.agent.rt.internal.runtime.KdAgentOptions;
import kd.bos.unittest.coverage.rt.IAgent;
import org.jacoco.core.JaCoCo;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.runtime.AbstractRuntime;
import org.jacoco.core.runtime.RuntimeData;

public class KdAgent
implements IAgent {
    private static KdAgent singleton;
    private final KdAgentOptions options;
    private final IExceptionLogger logger;
    private final RuntimeData data;
    private IKdAgentOutput output;
    private Callable<Void> jmxRegistration;

    public static synchronized KdAgent getInstance(KdAgentOptions options) {
        if (singleton == null) {
            final KdAgent agent = new KdAgent(options, IExceptionLogger.SYSTEM_ERR);
            agent.startup();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    agent.shutdown();
                }
            });
            singleton = agent;
        }
        return singleton;
    }

    public static synchronized KdAgent getInstance() {
        if (singleton == null) {
            throw new IllegalStateException("JaCoCo agent not started.");
        }
        return singleton;
    }

    KdAgent(KdAgentOptions options, IExceptionLogger logger) {
        this.options = options;
        this.logger = logger;
        this.data = new RuntimeData();
    }

    public RuntimeData getData() {
        return this.data;
    }

    public void startup() {
        try {
            String sessionId = this.options.getSessionId();
            if (sessionId == null) {
                sessionId = this.createSessionId();
            }
            this.data.setSessionId(sessionId);
            this.output = this.createAgentOutput();
            this.output.startup(this.options, this.data);
            if (this.options.getJmx()) {
                this.jmxRegistration = new KdJmxRegistration(this);
            }
        }
        catch (Exception e) {
            this.logger.logExeption(e);
        }
    }

    public void shutdown() {
        try {
            if (this.options.getDumpOnExit()) {
                this.output.writeExecutionData(false);
            }
            this.output.shutdown();
            if (this.jmxRegistration != null) {
                this.jmxRegistration.call();
            }
        }
        catch (Exception e) {
            this.logger.logExeption(e);
        }
    }

    IKdAgentOutput createAgentOutput() {
        KdAgentOptions.OutputMode controllerType = this.options.getOutput();
        switch (controllerType) {
            case file: {
                return new KdFileOutput();
            }
            case tcpserver: {
                return new KdTcpServerOutput(this.logger);
            }
            case tcpclient: {
                return new KdTcpClientOutput(this.logger);
            }
            case tcpclusterclient: {
                return new KdTcpClusterClientOutput(this.logger);
            }
            case none: {
                return new KdNoneOutput();
            }
        }
        throw new AssertionError((Object)controllerType);
    }

    private String createSessionId() {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            host = "unknownhost";
        }
        String coverageHostName = System.getProperty("coverage_host_name");
        if (StringUtils.isNotEmpty(coverageHostName)) {
            host = coverageHostName + "--";
        }
        return host + "$&" + AbstractRuntime.createRandomId();
    }

    @Override
    public String getVersion() {
        return JaCoCo.VERSION;
    }

    @Override
    public String getSessionId() {
        return this.data.getSessionId();
    }

    @Override
    public void setSessionId(String id) {
        this.data.setSessionId(id);
    }

    @Override
    public void reset() {
        this.data.reset();
    }

    @Override
    public byte[] getExecutionData(boolean reset) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            ExecutionDataWriter writer = new ExecutionDataWriter((OutputStream)buffer);
            this.data.collect((IExecutionDataVisitor)writer, (ISessionInfoVisitor)writer, reset);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return buffer.toByteArray();
    }

    @Override
    public void dump(boolean reset) throws IOException {
        this.output.writeExecutionData(reset);
    }
}

