/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.agent.rt.internal;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import kd.bos.unittest.coverage.agent.rt.internal.IExceptionLogger;
import kd.bos.unittest.coverage.agent.rt.internal.KdClassFileDumper;
import kd.bos.unittest.coverage.agent.rt.internal.runtime.KdAgentOptions;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.IRuntime;
import org.jacoco.core.runtime.WildcardMatcher;

public class KdCoverageTransformer
implements ClassFileTransformer {
    private static final String AGENT_PREFIX;
    private final Instrumenter instrumenter;
    private final IExceptionLogger logger;
    private final WildcardMatcher includes;
    private final WildcardMatcher excludes;
    private final WildcardMatcher exclClassloader;
    private final KdClassFileDumper classFileDumper;
    private final boolean inclBootstrapClasses;
    private final boolean inclNoLocationClasses;

    public KdCoverageTransformer(IRuntime runtime, KdAgentOptions options, IExceptionLogger logger) {
        this.instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)runtime);
        this.logger = logger;
        this.includes = new WildcardMatcher(KdCoverageTransformer.toVMName(options.getIncludes()));
        this.excludes = new WildcardMatcher(KdCoverageTransformer.toVMName(options.getExcludes()));
        this.exclClassloader = new WildcardMatcher(options.getExclClassloader());
        this.classFileDumper = new KdClassFileDumper(options.getClassDumpDir());
        this.inclBootstrapClasses = options.getInclBootstrapClasses();
        this.inclNoLocationClasses = options.getInclNoLocationClasses();
    }

    @Override
    public byte[] transform(ClassLoader loader, String classname, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (classBeingRedefined != null) {
            return null;
        }
        if (!this.filter(loader, classname, protectionDomain)) {
            return null;
        }
        try {
            this.classFileDumper.dump(classname, classfileBuffer);
            return this.instrumenter.instrument(classfileBuffer, classname);
        }
        catch (Exception ex) {
            IllegalClassFormatException wrapper = new IllegalClassFormatException(ex.getMessage());
            wrapper.initCause(ex);
            this.logger.logExeption(wrapper);
            throw wrapper;
        }
    }

    boolean filter(ClassLoader loader, String classname, ProtectionDomain protectionDomain) {
        if (loader == null) {
            if (!this.inclBootstrapClasses) {
                return false;
            }
        } else {
            if (!this.inclNoLocationClasses && !this.hasSourceLocation(protectionDomain)) {
                return false;
            }
            if (this.exclClassloader.matches(loader.getClass().getName())) {
                return false;
            }
        }
        return !classname.startsWith(AGENT_PREFIX) && this.includes.matches(classname) && !this.excludes.matches(classname);
    }

    private boolean hasSourceLocation(ProtectionDomain protectionDomain) {
        if (protectionDomain == null) {
            return false;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return false;
        }
        return codeSource.getLocation() != null;
    }

    private static String toVMName(String srcName) {
        return srcName.replace('.', '/');
    }

    static {
        String name = KdCoverageTransformer.class.getName();
        AGENT_PREFIX = KdCoverageTransformer.toVMName(name.substring(0, name.lastIndexOf(46)));
    }
}

