/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.agent.rt.internal.core.runtime;

import java.io.IOException;
import java.io.InputStream;
import kd.bos.unittest.coverage.agent.rt.internal.core.runtime.IKdRemoteCommandVisitor;
import org.jacoco.core.data.ExecutionDataReader;

public class KdRemoteControlReader
extends ExecutionDataReader {
    private IKdRemoteCommandVisitor remoteCommandVisitor;

    public KdRemoteControlReader(InputStream input) throws IOException {
        super(input);
    }

    protected boolean readBlock(byte blockid) throws IOException {
        switch (blockid) {
            case 64: {
                this.readDumpCommand();
                return true;
            }
            case 32: {
                return false;
            }
            case 31: {
                this.readGeneralCommand();
                return true;
            }
        }
        return super.readBlock(blockid);
    }

    public void setRemoteCommandVisitor(IKdRemoteCommandVisitor visitor) {
        this.remoteCommandVisitor = visitor;
    }

    private void readDumpCommand() throws IOException {
        if (this.remoteCommandVisitor == null) {
            throw new IOException("No remote command visitor.");
        }
        boolean dump = this.in.readBoolean();
        boolean reset = this.in.readBoolean();
        this.remoteCommandVisitor.visitDumpCommand(dump, reset);
    }

    private void readGeneralCommand() throws IOException {
        if (this.remoteCommandVisitor == null) {
            throw new IOException("No remote command visitor.");
        }
        String type = this.in.readUTF();
        String cmdcontent = this.in.readUTF();
        this.remoteCommandVisitor.generalCommand(type, cmdcontent);
    }
}

