/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.agent.rt.internal.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kd.bos.unittest.coverage.agent.rt.internal.output.IKdAgentOutput;
import kd.bos.unittest.coverage.agent.rt.internal.runtime.KdAgentOptions;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.runtime.RuntimeData;

public class KdFileOutput
implements IKdAgentOutput {
    private RuntimeData data;
    private File destFile;
    private boolean append;

    @Override
    public final void startup(KdAgentOptions options, RuntimeData data) throws IOException {
        this.data = data;
        this.destFile = new File(options.getDestfile()).getAbsoluteFile();
        this.append = options.getAppend();
        File folder = this.destFile.getParentFile();
        if (folder != null) {
            folder.mkdirs();
        }
        this.openFile().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExecutionData(boolean reset) throws IOException {
        try (OutputStream output = this.openFile();){
            ExecutionDataWriter writer = new ExecutionDataWriter(output);
            this.data.collect((IExecutionDataVisitor)writer, (ISessionInfoVisitor)writer, reset);
        }
    }

    @Override
    public void shutdown() {
    }

    private OutputStream openFile() throws IOException {
        try (FileOutputStream file = new FileOutputStream(this.destFile, this.append);){
            file.getChannel().lock();
            FileOutputStream fileOutputStream = file;
            return fileOutputStream;
        }
    }
}

