/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.agent.rt.internal.output;

import java.io.IOException;
import java.net.Socket;
import kd.bos.unittest.coverage.agent.rt.internal.IExceptionLogger;
import kd.bos.unittest.coverage.agent.rt.internal.output.IKdAgentOutput;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpConnection;
import kd.bos.unittest.coverage.agent.rt.internal.runtime.KdAgentOptions;
import org.jacoco.core.runtime.RuntimeData;

public class KdTcpClientOutput
implements IKdAgentOutput {
    protected final IExceptionLogger logger;
    protected KdTcpConnection connection;
    protected Thread worker;

    public KdTcpClientOutput(IExceptionLogger logger) {
        this.logger = logger;
    }

    @Override
    public void startup(KdAgentOptions options, RuntimeData data) throws IOException {
        Socket socket = this.createSocket(options);
        this.connection = new KdTcpConnection(socket, data);
        this.connection.init();
        this.worker = new Thread(() -> {
            try {
                this.connection.run();
            }
            catch (IOException e) {
                this.logger.logExeption(e);
            }
        });
        this.worker.setName(this.getClass().getName());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    @Override
    public void shutdown() throws IOException, InterruptedException {
        this.connection.close();
        this.worker.join();
    }

    @Override
    public void writeExecutionData(boolean reset) throws IOException {
        this.connection.writeExecutionData(reset);
    }

    protected Socket createSocket(KdAgentOptions options) throws IOException {
        return new Socket(options.getAddress(), options.getPort());
    }
}

