/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.agent.rt.internal.output;

import java.io.IOException;
import java.net.Socket;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.coverage.agent.rt.internal.IExceptionLogger;
import kd.bos.unittest.coverage.agent.rt.internal.core.runtime.IKdRemoteCommandVisitor;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpClientOutput;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpConnection;
import kd.bos.unittest.coverage.agent.rt.internal.runtime.KdAgentOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jacoco.core.runtime.RuntimeData;

public class KdTcpClusterClientOutput
extends KdTcpClientOutput
implements IKdRemoteCommandVisitor {
    private static final Log loggr = LogFactory.getLog(KdTcpClusterClientOutput.class);

    public KdTcpClusterClientOutput(IExceptionLogger logger) {
        super(logger);
    }

    @Override
    public void startup(KdAgentOptions options, RuntimeData data) throws IOException {
        Socket socket = this.createSocket(options);
        this.connection = new KdTcpConnection(socket, data);
        this.connection.init();
        this.connection.setRemoteCommandVisitor(this);
        this.connection.doGeneralCommand("shake", data.getSessionId());
        this.worker = new Thread(() -> {
            try {
                this.connection.run();
            }
            catch (IOException e) {
                this.logger.logExeption(e);
            }
        });
        this.worker.setName(this.getClass().getName());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    @Override
    public void visitDumpCommand(boolean dump, boolean reset) throws IOException {
    }

    @Override
    public void generalCommand(String type, String cmdcontent) throws IOException {
        loggr.info((Object)StringUtils.filterLog("\u63a5\u53d7\u5230\u6307\u4ee4 type:" + type + ",cmdcontent:" + cmdcontent));
        if (type.equalsIgnoreCase("dump")) {
            this.writeExecutionData(false);
            this.connection.doGeneralCommand("dumpdone", cmdcontent);
        }
    }
}

