/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.agent.rt.internal.output;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import kd.bos.unittest.coverage.agent.rt.internal.core.runtime.IKdRemoteCommandVisitor;
import kd.bos.unittest.coverage.agent.rt.internal.core.runtime.KdRemoteControlReader;
import kd.bos.unittest.coverage.agent.rt.internal.core.runtime.KdRemoteControlWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.runtime.RuntimeData;

public class KdTcpConnection
implements IKdRemoteCommandVisitor {
    private final RuntimeData data;
    private final Socket socket;
    private KdRemoteControlWriter writer;
    private KdRemoteControlReader reader;
    private boolean initialized;
    private IKdRemoteCommandVisitor remoteCommandVisitor;

    public KdTcpConnection(Socket socket, RuntimeData data) {
        this.socket = socket;
        this.data = data;
        this.initialized = false;
    }

    public KdRemoteControlWriter getWriter() {
        return this.writer;
    }

    public KdRemoteControlReader getReader() {
        return this.reader;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setRemoteCommandVisitor(IKdRemoteCommandVisitor visitor) {
        this.remoteCommandVisitor = visitor;
    }

    public void setSessionInfoVisitor(ISessionInfoVisitor visitor) {
        this.reader.setSessionInfoVisitor(visitor);
    }

    public void setExecutionDataVisitor(IExecutionDataVisitor visitor) {
        this.reader.setExecutionDataVisitor(visitor);
    }

    public void init() throws IOException {
        this.writer = new KdRemoteControlWriter(this.socket.getOutputStream());
        this.reader = new KdRemoteControlReader(this.socket.getInputStream());
        this.reader.setRemoteCommandVisitor(this);
        this.initialized = true;
    }

    public void run() throws IOException {
        try {
            while (this.reader.read()) {
            }
        }
        catch (SocketException e) {
            if (!this.socket.isClosed()) {
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    public void running() throws IOException {
        block3: {
            try {
                while (this.reader.read()) {
                }
            }
            catch (SocketException e) {
                if (this.socket.isClosed()) break block3;
                throw e;
            }
        }
    }

    public void writeExecutionData(boolean reset) throws IOException {
        if (this.initialized && !this.socket.isClosed()) {
            this.visitDumpCommand(true, reset);
        }
    }

    public void close() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public void visitDumpCommand(boolean dump, boolean reset) throws IOException {
        if (dump) {
            this.data.collect((IExecutionDataVisitor)this.writer, (ISessionInfoVisitor)this.writer, reset);
        } else if (reset) {
            this.data.reset();
        }
        this.writer.sendCmdOk();
    }

    public void doGeneralCommand(String type, String cmdcontent) throws IOException {
        this.writer.generalCommand(type, cmdcontent);
    }

    @Override
    public void generalCommand(String type, String cmdcontent) throws IOException {
        if (this.remoteCommandVisitor != null) {
            this.remoteCommandVisitor.generalCommand(type, cmdcontent);
        }
    }
}

