/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.agent.rt.internal.output;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import kd.bos.unittest.coverage.agent.rt.internal.IExceptionLogger;
import kd.bos.unittest.coverage.agent.rt.internal.output.IKdAgentOutput;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpConnection;
import kd.bos.unittest.coverage.agent.rt.internal.runtime.KdAgentOptions;
import org.jacoco.core.runtime.RuntimeData;

public class KdTcpServerOutput
implements IKdAgentOutput {
    private KdTcpConnection connection;
    private final IExceptionLogger logger;
    private ServerSocket serverSocket;
    private Thread worker;

    public KdTcpServerOutput(IExceptionLogger logger) {
        this.logger = logger;
    }

    @Override
    public void startup(KdAgentOptions options, RuntimeData data) throws IOException {
        this.serverSocket = this.createServerSocket(options);
        this.worker = new Thread(() -> {
            while (!this.serverSocket.isClosed()) {
                try {
                    ServerSocket serverSocket = this.serverSocket;
                    synchronized (serverSocket) {
                        this.connection = new KdTcpConnection(this.serverSocket.accept(), data);
                    }
                    this.connection.init();
                    this.connection.run();
                }
                catch (IOException e) {
                    if (this.serverSocket.isClosed()) continue;
                    this.logger.logExeption(e);
                }
            }
        });
        this.worker.setName(this.getClass().getName());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws IOException, InterruptedException {
        this.serverSocket.close();
        ServerSocket serverSocket = this.serverSocket;
        synchronized (serverSocket) {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        this.worker.join();
    }

    @Override
    public void writeExecutionData(boolean reset) throws IOException {
        if (this.connection != null) {
            this.connection.writeExecutionData(reset);
        }
    }

    protected ServerSocket createServerSocket(KdAgentOptions options) throws IOException {
        InetAddress inetAddr = this.getInetAddress(options.getAddress());
        return new ServerSocket(options.getPort(), 1, inetAddr);
    }

    protected InetAddress getInetAddress(String address) throws UnknownHostException {
        if ("*".equals(address)) {
            return null;
        }
        return InetAddress.getByName(address);
    }
}

