/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.agent.rt.internal.runtime;

import java.util.ArrayList;
import java.util.List;

final class KdCommandLineSupport {
    private static final int M_STRIPWHITESPACE = 0;
    private static final int M_PARSEARGUMENT = 1;
    private static final int M_ESCAPED = 2;
    private static final char BLANK = ' ';
    private static final char QUOTE = '\"';
    private static final char SLASH = '\\';

    static String quote(String arg) {
        StringBuilder escaped = new StringBuilder();
        for (char c : arg.toCharArray()) {
            if (c == '\"' || c == '\\') {
                escaped.append('\\');
            }
            escaped.append(c);
        }
        if (arg.indexOf(32) != -1 || arg.indexOf(34) != -1) {
            escaped.insert(0, '\"').append('\"');
        }
        return escaped.toString();
    }

    static String quote(List<String> args) {
        StringBuilder result = new StringBuilder();
        boolean seperate = false;
        for (String arg : args) {
            if (seperate) {
                result.append(' ');
            }
            result.append(KdCommandLineSupport.quote(arg));
            seperate = true;
        }
        return result.toString();
    }

    static List<String> split(String commandline) {
        if (commandline == null || commandline.length() == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int mode = 0;
        char endChar = ' ';
        block5: for (char c : commandline.toCharArray()) {
            switch (mode) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block5;
                    if (c == '\"') {
                        endChar = '\"';
                    } else {
                        current.append(c);
                        endChar = ' ';
                    }
                    mode = 1;
                    continue block5;
                }
                case 1: {
                    if (c == endChar) {
                        KdCommandLineSupport.addArgument(args, current);
                        mode = 0;
                        continue block5;
                    }
                    if (c == '\\') {
                        current.append('\\');
                        mode = 2;
                        continue block5;
                    }
                    current.append(c);
                    continue block5;
                }
                case 2: {
                    if (c == '\"' || c == '\\') {
                        current.setCharAt(current.length() - 1, c);
                    } else if (c == endChar) {
                        KdCommandLineSupport.addArgument(args, current);
                    } else {
                        current.append(c);
                    }
                    mode = 1;
                    continue block5;
                }
            }
        }
        KdCommandLineSupport.addArgument(args, current);
        return args;
    }

    private static void addArgument(List<String> args, StringBuilder current) {
        if (current.length() > 0) {
            args.add(current.toString());
            current.setLength(0);
        }
    }

    private KdCommandLineSupport() {
    }
}

