/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.task;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpConnection;
import kd.bos.unittest.coverage.task.ExecutionDataTaskManager;
import kd.bos.unittest.coverage.task.IExecutionDataTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jacoco.core.runtime.AbstractRuntime;

public class ExecutionDataTask
implements IExecutionDataTask {
    private static final Log logger = LogFactory.getLog(ExecutionDataTask.class);
    private String taskid;
    private String servicename;
    private Map<String, KdTcpConnection> mapConn;
    private KdTcpConnection connection;
    private List<String> lstErrMsg = new LinkedList<String>();
    private String msg = "\u751f\u6210\u62a5\u544a\u6210\u529f";

    public ExecutionDataTask(KdTcpConnection connection, Map<String, KdTcpConnection> mapConn, String servicename) {
        this.connection = connection;
        this.mapConn = mapConn;
        this.servicename = servicename;
        this.createTaskId();
    }

    public String getServiceName() {
        return this.servicename;
    }

    public String getTaskId() {
        return this.taskid;
    }

    private String createTaskId() {
        String remoteAddress = this.connection.getSocket().getRemoteSocketAddress().toString();
        this.taskid = String.format("%s_%s_%s", remoteAddress, this.servicename, AbstractRuntime.createRandomId());
        return this.taskid;
    }

    public void addErrorMessage(String msg) {
        this.lstErrMsg.add(msg);
    }

    public List<String> getErrorMessage() {
        return this.lstErrMsg;
    }

    public String getErrorMessages() {
        return this.lstErrMsg.toString();
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getMsg() {
        return this.msg;
    }

    @Override
    public void start() {
        try {
            boolean hasConn = false;
            for (Map.Entry<String, KdTcpConnection> entry : this.mapConn.entrySet()) {
                if ("*".equals(this.servicename)) {
                    hasConn = this.doGeneralCommand(entry);
                    continue;
                }
                String dymServiceName = entry.getKey();
                if (!dymServiceName.contains(this.servicename)) continue;
                hasConn = this.doGeneralCommand(entry);
            }
            if (!hasConn) {
                this.addErrorMessage("\u6682\u6ca1\u6709\u63a5\u5165\u6307\u5b9a\u7684\u96c6\u7fa4\u5ba2\u6237\u7aef-" + this.servicename);
                this.finish();
            }
        }
        catch (IOException e) {
            this.addErrorMessage(e.getMessage());
            logger.error((Object)e.getMessage());
            this.finish();
        }
    }

    private boolean doGeneralCommand(Map.Entry<String, KdTcpConnection> entry) throws IOException {
        KdTcpConnection cn = entry.getValue();
        cn.doGeneralCommand("dump", this.taskid);
        return true;
    }

    @Override
    public void finish() {
        try {
            if (this.getErrorMessage().isEmpty()) {
                this.connection.doGeneralCommand("dump", this.getMsg());
            } else {
                this.connection.doGeneralCommand("dump", this.getErrorMessages());
            }
            logger.info((Object)"\u8fd4\u56de\u64cd\u4f5c\u6307\u4ee4\u7ed3\u679c:\u83b7\u53d6\u4ee3\u7801\u8986\u76d6\u7387\u5e76\u751f\u6210\u62a5\u544a\u6210\u529f");
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            try {
                this.connection.close();
                ExecutionDataTaskManager.removeTask(this.taskid);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    @Override
    public void failure() {
    }
}

