/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpConnection;
import kd.bos.unittest.coverage.task.ExecutionDataTask;

public class ExecutionDataTaskManager {
    private static ConcurrentHashMap<String, ExecutionDataTask> mapTask = new ConcurrentHashMap();

    public static ExecutionDataTask createTask(KdTcpConnection connection, Map<String, KdTcpConnection> mapConn, String servicename) {
        ExecutionDataTask task = new ExecutionDataTask(connection, mapConn, servicename);
        mapTask.put(task.getTaskId(), task);
        task.start();
        return task;
    }

    public static ExecutionDataTask getTask(String taskid) {
        ExecutionDataTask task = mapTask.get(taskid);
        return task;
    }

    public static void finishTask(String taskid) {
        ExecutionDataTask task = ExecutionDataTaskManager.getTask(taskid);
        if (task != null) {
            task.finish();
        }
    }

    public static void addTaskErrorMsg(String taskid, String msg) {
        ExecutionDataTask task = mapTask.get(taskid);
        task.addErrorMessage(msg);
    }

    public static void removeTask(String taskid) {
        mapTask.remove(taskid);
    }

    public static List<String> getAllTaskIdsWithSessionId(String sessionid) {
        ArrayList<String> lstRet = new ArrayList<String>();
        for (Map.Entry<String, ExecutionDataTask> entry : mapTask.entrySet()) {
            ExecutionDataTask task = entry.getValue();
            if (!sessionid.contains(task.getServiceName())) continue;
            lstRet.add(entry.getKey());
        }
        return lstRet;
    }
}

