/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.smoke.task;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.bos.unittest.build.HttpClientKeepCookiesUtils;
import kd.bos.unittest.build.WholeSystemTest;
import kd.bos.unittest.smoke.task.ITask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmokeRunAppCasesTask
implements ITask {
    private static final Log logger = LogFactory.getLog(SmokeRunAppCasesTask.class);
    private final List<Map<String, Object>> caseMaps;
    private List<Map<String, Object>> lstResult;
    private List<String> lstResultWithOutCaseResult;
    private final HttpClientKeepCookiesUtils obj;
    private final String hostUrl;

    public SmokeRunAppCasesTask(List<Map<String, Object>> caseMaps, List<Map<String, Object>> lstResult, List<String> lstResultWithOutCaseResult, HttpClientKeepCookiesUtils obj, String hostUrl) {
        this.caseMaps = caseMaps;
        this.lstResult = lstResult;
        this.lstResultWithOutCaseResult = lstResultWithOutCaseResult;
        this.obj = obj;
        this.hostUrl = hostUrl;
    }

    @Override
    public void execute() throws IOException {
        String threadinfo = Thread.currentThread().getName();
        int i = 0;
        for (Map<String, Object> caseMap : this.caseMaps) {
            ++i;
            String caseId = (String)caseMap.get("number");
            String caseName = (String)caseMap.get("name");
            Object appnumber = caseMap.get("appnumber");
            String appId = "bos";
            if (appnumber != null) {
                appId = (String)appnumber;
            }
            String msg = String.format("%s (%s/%s/%s):", threadinfo, appnumber, i, this.caseMaps.size());
            String startCaseApiUrl = this.hostUrl + "unittest/testByCaseId.do?caseId=" + caseId + "&appId=" + appId.toLowerCase();
            WholeSystemTest.doOneTestCaseByCaseInfo(caseMap, startCaseApiUrl, msg, this.lstResult, this.lstResultWithOutCaseResult, this.obj, this.hostUrl);
        }
    }
}

