/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.smoke.task;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kd.bos.unittest.smoke.task.ITask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TaskManager {
    private static final Log logger = LogFactory.getLog(TaskManager.class);

    private TaskManager() {
    }

    public static void execute(ITask task) {
        ArrayList<ITask> lstTask = new ArrayList<ITask>();
        lstTask.add(task);
        TaskManager.execute(lstTask, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(List<ITask> lstTask, int param) {
        ExecutorService executor = null;
        try {
            executor = Executors.newFixedThreadPool(param);
            for (ITask task : lstTask) {
                executor.execute(new TaskThread(task));
            }
            executor.shutdown();
            if (!executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    private static class TaskThread
    extends Thread {
        private final ITask fTask;

        public TaskThread(ITask fTask) {
            this.fTask = fTask;
        }

        @Override
        public void run() {
            try {
                this.fTask.execute();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }
}

