/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.unit;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class XmlHelper {
    private static final Log logger = LogFactory.getLog(XmlHelper.class);
    private String xmlFilePath;

    public XmlHelper(String xmlFilePath) {
        this.xmlFilePath = xmlFilePath;
    }

    public String getXmlStringFromFile() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (FileReader fileReader = new FileReader(this.xmlFilePath);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        return stringBuilder.toString();
    }

    public Map<String, Object> xmlToAppList() throws IOException {
        String xmlStr = this.getXmlStringFromFile();
        HashMap<String, Object> app = new HashMap<String, Object>();
        Document document = Jsoup.parse((String)xmlStr);
        Elements groupItems = document.select("group");
        for (Element groupItem : groupItems) {
            Attributes ats = groupItem.attributes();
            String groupName = ats.get("name");
            Elements appItems = groupItem.children();
            for (Element appItem : appItems) {
                String appid = appItem.attributes().get("appId");
                app.put(appid, groupName);
            }
        }
        return app;
    }

    public static void main(String[] args) throws Exception {
        XmlHelper xml = new XmlHelper("D:\\work\\\u5355\u5143\u6d4b\u8bd5\\\u8986\u76d6\u7387\\txt\\appNameToID.xml");
        Map<String, Object> appList = xml.xmlToAppList();
        logger.info(appList);
    }
}

