/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitHostingServiceImpl {
    public static final Log logger = LogFactory.getLog(GitHostingServiceImpl.class);
    public static final String NOPERMISSION = "noPermission";
    private static final String AUTHFAIL = "Auth fail";
    private static final String NOTAUTHORIZED = "not authorized";
    private static final String SUCCESS = "success";
    private static final String NOFILE = "nofile";
    private static Integer LIMITSIZ = 0x500000;
    private static String noAuthErrMsg = "\u4e0d\u5bf9\u6216\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u8d26\u53f7\u662f\u5426\u6b63\u786e\uff01";
    private static final String ERRCODE_IOECEPTION = "IOException";
    private static final String ERRCODE_GITAPIEXCEPTION = "GitAPIException";
    private static final String DELETETIPS = "is delete";

    private GitHostingServiceImpl() {
        throw new IllegalStateException("GITCodeHostingServiceImpl cannot be instantiated");
    }

    public static boolean checkRemoteAccount(String gitUrl, String userName, String passWord) throws GitAPIException {
        try {
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(userName, passWord);
            ((LsRemoteCommand)Git.lsRemoteRepository().setRemote(gitUrl).setCredentialsProvider((CredentialsProvider)credentialsProvider)).callAsMap();
        }
        catch (InvalidRemoteException e) {
            logger.info("\u8d26\u53f7:" + userName + noAuthErrMsg + e.getMessage());
            return false;
        }
        catch (GitAPIException e) {
            logger.info("\u8d26\u53f7:" + userName + noAuthErrMsg + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean checkAccount(String gitUrl, String gitRepository, String gitBranch, String gitRootpath, String userName, String passWord) throws GitAPIException {
        block18: {
            String ret;
            try {
                UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(userName, passWord);
                ((LsRemoteCommand)Git.lsRemoteRepository().setRemote(gitUrl).setCredentialsProvider((CredentialsProvider)credentialsProvider)).callAsMap();
            }
            catch (GitAPIException e) {
                logger.info("\u8d26\u53f7:" + userName + noAuthErrMsg + e.getMessage());
                return false;
            }
            catch (Exception e) {
                logger.info(e.getMessage());
                return false;
            }
            String checkGitRepository = GitHostingServiceImpl.checkFilePath(gitRepository);
            File file = new File(checkGitRepository);
            String projectURL = checkGitRepository + File.separator + ".git";
            File gitFile = new File(projectURL);
            if (!(file.exists() && gitFile.exists() || !NOPERMISSION.equals(ret = GitHostingServiceImpl.cloneRepository(gitUrl, gitRepository, gitBranch, gitRootpath, userName, passWord)))) {
                logger.info("\u8d26\u53f7:" + userName + noAuthErrMsg);
                return false;
            }
            try (Git git = Git.open((File)gitFile);){
                PullCommand pull = git.pull();
                pull.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
                PullResult pullResult = pull.call();
                pullResult.isSuccessful();
            }
            catch (Exception e) {
                if (!e.getMessage().contains(AUTHFAIL) && !e.getMessage().contains(NOTAUTHORIZED)) break block18;
                logger.info("\u8d26\u53f7:" + userName + noAuthErrMsg);
                return false;
            }
        }
        return true;
    }

    public static List<String> getBranchs(String gitUrl, String userName, String passWord) throws GitAPIException {
        try {
            ArrayList<String> result = new ArrayList<String>(16);
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(userName, passWord);
            Map asMap = ((LsRemoteCommand)Git.lsRemoteRepository().setRemote(gitUrl).setHeads(true).setCredentialsProvider((CredentialsProvider)credentialsProvider)).callAsMap();
            for (Map.Entry entry : asMap.entrySet()) {
                String branch;
                String key = (String)entry.getKey();
                if ("HEAD".equals(key) || !key.startsWith("refs/heads/") || StringUtils.isBlank((CharSequence)(branch = key.replace("refs/heads/", "")))) continue;
                result.add(branch);
            }
            return result;
        }
        catch (InvalidRemoteException e) {
            logger.info("\u8d26\u53f7:" + userName + noAuthErrMsg + e.getMessage());
            return Collections.emptyList();
        }
        catch (GitAPIException e) {
            logger.info("\u8d26\u53f7:" + userName + noAuthErrMsg + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return Collections.emptyList();
        }
    }

    public static String cloneRepository(String gitUrl, String repository, String gitBranch, String gitRootpath, String userName, String passWord) {
        try {
            String checkRepository = GitHostingServiceImpl.checkFilePath(repository);
            File rootPath = new File(checkRepository);
            GitHostingServiceImpl.deleteKd(rootPath);
            rootPath.mkdir();
            CloneCommand cloneCommand = Git.cloneRepository();
            cloneCommand.setURI(gitUrl);
            cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            cloneCommand.setDirectory(new File(checkRepository));
            if (!StringUtils.isBlank((CharSequence)gitBranch)) {
                cloneCommand.setBranch(gitBranch);
            } else {
                cloneCommand.setCloneAllBranches(true);
            }
            cloneCommand.call();
        }
        catch (Exception e) {
            if (e.getMessage().contains(AUTHFAIL) || e.getMessage().contains(NOTAUTHORIZED)) {
                logger.info("\u8d26\u53f7:" + userName + noAuthErrMsg);
                return NOPERMISSION;
            }
            return e.getMessage();
        }
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String commit(String personalGitRepository, String annotation, List<String> fileNames, String userName) {
        block23: {
            String projectURL = personalGitRepository + File.separator + ".git";
            String checkProjectURL = GitHostingServiceImpl.checkFilePath(projectURL);
            try (Git git = null;){
                String fileName;
                String[] splitFileNames;
                logger.info("commit{projectURL:" + projectURL + ";checkProjectURL:" + checkProjectURL + "}");
                git = Git.open((File)new File(checkProjectURL));
                List diffEntries = git.diff().call();
                if (diffEntries == null || diffEntries.isEmpty()) {
                    String string = "nochange";
                    return string;
                }
                ArrayList<String> addFiles = new ArrayList<String>(16);
                ArrayList<String> diffFiles = new ArrayList<String>(16);
                boolean needCommit = false;
                for (DiffEntry diffEntry : diffEntries) {
                    DiffEntry.ChangeType changeType = diffEntry.getChangeType();
                    switch (changeType) {
                        case ADD: {
                            addFiles.add(diffEntry.getNewPath());
                            break;
                        }
                        case COPY: {
                            diffFiles.add(diffEntry.getNewPath());
                            break;
                        }
                        case DELETE: {
                            diffFiles.add(diffEntry.getOldPath());
                            break;
                        }
                        case MODIFY: {
                            diffFiles.add(diffEntry.getOldPath());
                            break;
                        }
                        case RENAME: {
                            diffFiles.add(diffEntry.getNewPath());
                            break;
                        }
                    }
                }
                if (!fileNames.isEmpty()) {
                    boolean flag = false;
                    AddCommand addCmd = git.add();
                    for (String addfileName : addFiles) {
                        splitFileNames = addfileName.replaceAll("\\\\", "/").split("/");
                        fileName = splitFileNames[splitFileNames.length - 1];
                        if (!fileNames.contains(fileName)) continue;
                        addCmd.addFilepattern(addfileName);
                        flag = true;
                    }
                    if (flag) {
                        needCommit = true;
                        addCmd.call();
                    }
                }
                CommitCommand commitCmd = git.commit();
                boolean isSetOnly = false;
                for (String diffFileName : diffFiles) {
                    splitFileNames = diffFileName.replaceAll("\\\\", "/").split("/");
                    fileName = splitFileNames[splitFileNames.length - 1];
                    if (!fileNames.contains(fileName)) continue;
                    commitCmd.setOnly(diffFileName);
                    isSetOnly = true;
                }
                if (isSetOnly) {
                    needCommit = true;
                    for (String addfileName : addFiles) {
                        splitFileNames = addfileName.replaceAll("\\\\", "/").split("/");
                        fileName = splitFileNames[splitFileNames.length - 1];
                        if (!fileNames.contains(fileName)) continue;
                        commitCmd.setOnly(addfileName);
                    }
                }
                if (needCommit) {
                    commitCmd.setMessage(annotation).setAuthor(userName, userName + "@kingdee.com").call();
                    break block23;
                }
                Iterator iterator = "nochange";
                return iterator;
            }
        }
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String push(String bizAppId, String personalGitRepository, String gitBranch, String gitRootpath, String userName, String passWord, Set<String> pushFile) {
        String projectURL = personalGitRepository + File.separator + ".git";
        try (Git git = null;){
            String checkProjectURL = GitHostingServiceImpl.checkFilePath(projectURL);
            logger.info("push{projectURL:" + projectURL + ";checkProjectURL:" + checkProjectURL + "}");
            git = Git.open((File)new File(checkProjectURL));
            PushCommand push = git.push();
            push.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            push.call();
        }
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String commitAndPush(String personalGitRepository, String userName, String passWord, String annotation, List<String> fileNames) {
        String projectURL = personalGitRepository + File.separator + ".git";
        try (Git git = null;){
            String checkProjectURL = GitHostingServiceImpl.checkFilePath(projectURL);
            git = Git.open((File)new File(checkProjectURL));
            GitHostingServiceImpl.commit(personalGitRepository, annotation, fileNames, userName);
            PushCommand push = git.push();
            push.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            push.call();
        }
        return "success_commitandpush";
    }

    public static String revertRepository(String gitUrl, String gitRepository, String userName, String passWord) {
        String checkGitRepository = GitHostingServiceImpl.checkFilePath(gitRepository);
        try {
            logger.info("revertRepository{gitUrl:" + gitUrl + ";gitRepository:" + gitRepository + ";checkGitRepository:" + checkGitRepository + "}");
            GitHostingServiceImpl.deleteKd(new File(checkGitRepository));
            CloneCommand cloneCommand = Git.cloneRepository();
            cloneCommand.setURI(gitUrl);
            cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            cloneCommand.setDirectory(new File(checkGitRepository)).setCloneAllBranches(true).call();
        }
        catch (Exception e) {
            if (e.getMessage().contains(AUTHFAIL) || e.getMessage().contains(NOTAUTHORIZED)) {
                logger.info("\u8d26\u53f7:" + userName + noAuthErrMsg);
                return NOPERMISSION;
            }
            if (e.getMessage().contains("already exists and is not an empty directory")) {
                logger.info("\u6587\u4ef6\u6ca1\u6709\u5220\u9664\u6210\u529f\uff0c\u8bf7\u624b\u5de5\u5220\u9664\u8fd9\u4e2a\u6587\u4ef6\u5939\u518d\u8bd5\uff1a" + checkGitRepository);
                return "deletefilefail";
            }
            logger.info("\u8fd8\u539fgit\u672c\u5730\u4ed3\u5e93\u5931\u8d25\uff1a" + e.getMessage());
            return ResManager.loadKDString((String)"\u8fd8\u539fgit\u672c\u5730\u4ed3\u5e93\u5931\u8d25\uff1a", (String)"GITCodeHostingServiceImpl_0", (String)"bos-devportal-business", (Object[])new Object[0]) + e.getMessage();
        }
        return SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFromRepository(String metadataGitRepository, String fileName) {
        byte[] filecontent = null;
        String filePath = metadataGitRepository + File.separator + fileName;
        File file = new File(filePath);
        try (FileInputStream in = new FileInputStream(file);){
            Long filelength = file.length();
            filecontent = new byte[filelength.intValue()];
            int count = 0;
            String formRepository = "";
            while ((count = in.read(filecontent)) > 0) {
                formRepository = new String(filecontent, StandardCharsets.UTF_8);
            }
            String string = formRepository;
            return string;
        }
        catch (FileNotFoundException e) {
            return NOFILE;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pull(String gitUrl, String tempGirRepository, String gitBranch, String gitRootpath, String userName, String passWord) throws GitAPIException, IOException {
        String checkTempGirRepository = GitHostingServiceImpl.checkFilePath(tempGirRepository);
        File file = new File(checkTempGirRepository);
        String projectURL = checkTempGirRepository + File.separator + ".git";
        File gitFile = new File(projectURL);
        if (!file.exists() || !gitFile.exists()) {
            GitHostingServiceImpl.cloneRepository(gitUrl, checkTempGirRepository, gitBranch, gitRootpath, userName, passWord);
        }
        logger.info("pull{gitUrl:" + gitUrl + ";tempGirRepository:" + tempGirRepository + ";checkTempGirRepository:" + checkTempGirRepository + ";projectURL:" + projectURL + ";gitFile:" + gitFile + "}");
        try (Git git = null;){
            git = Git.open((File)gitFile);
            PullCommand pull = git.pull();
            pull.setStrategy(MergeStrategy.THEIRS);
            pull.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            pull.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFormGitUrl1(String gitRepository, String userName, String passWord, String fileName) {
        String string;
        String fileContent = null;
        Repository repository = null;
        Git git = null;
        RevWalk walk = null;
        TreeWalk treeWalk = null;
        try {
            String checkGitRepository = GitHostingServiceImpl.checkFilePath(gitRepository);
            git = Git.open((File)new File(checkGitRepository));
            repository = git.getRepository();
            walk = new RevWalk(repository);
            ObjectId objId = repository.resolve("HEAD");
            RevCommit revCommit = walk.parseCommit((AnyObjectId)objId);
            if (revCommit == null) {
                String string2 = NOFILE;
                return string2;
            }
            RevTree revTree = revCommit.getTree();
            treeWalk = TreeWalk.forPath((Repository)repository, (String)fileName, (RevTree)revTree);
            if (treeWalk == null) {
                String string3 = NOFILE;
                return string3;
            }
            ObjectId blobId = treeWalk.getObjectId(0);
            ObjectLoader loader = repository.open((AnyObjectId)blobId);
            byte[] bytes = loader.getBytes();
            if (bytes != null) {
                fileContent = new String(bytes, StandardCharsets.UTF_8);
            }
        }
        catch (FileNotFoundException e) {
            string = NOFILE;
            return string;
        }
        catch (Exception e) {
            logger.info("\u8bfb\u53d6git\u8fdc\u7a0b\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage());
            string = ResManager.loadKDString((String)"\u8bfb\u53d6git\u8fdc\u7a0b\u6587\u4ef6\u51fa\u9519\uff1a", (String)"GITCodeHostingServiceImpl_1", (String)"bos-devportal-business", (Object[])new Object[0]) + e.getMessage();
            return string;
        }
        finally {
            if (repository != null) {
                repository.close();
            }
            if (git != null) {
                git.close();
            }
            if (walk != null) {
                walk.close();
            }
            if (treeWalk != null) {
                treeWalk.close();
            }
        }
        return fileContent;
    }

    public static String readFormGitUrl(String metadataGitRepository, String fileName) {
        String fileContent = GitHostingServiceImpl.readFromRepository(metadataGitRepository, fileName);
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertFile(String personalGitRepository, String filePath) {
        String projectURL = personalGitRepository + File.separator + ".git";
        try (Git git = null;){
            String checkProjectURL = GitHostingServiceImpl.checkFilePath(projectURL);
            git = Git.open((File)new File(checkProjectURL));
            git.checkout().addPath(filePath).call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertFile(String personalGitRepository, List<String> filePath) {
        String projectURL = personalGitRepository + File.separator + ".git";
        try (Git git = null;){
            String checkProjectURL = GitHostingServiceImpl.checkFilePath(projectURL);
            git = Git.open((File)new File(checkProjectURL));
            git.checkout().addPaths(filePath).call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertPersonalRepository(String personalGitRepository) {
        String projectURL = personalGitRepository + File.separator + ".git";
        Git git = null;
        Repository repository = null;
        RevWalk walk = null;
        try {
            String checkProjectURL = GitHostingServiceImpl.checkFilePath(projectURL);
            git = Git.open((File)new File(checkProjectURL));
            repository = git.getRepository();
            Iterable logResult = git.log().setMaxCount(1).call();
            RevCommit commit = (RevCommit)logResult.iterator().next();
            String commitId = commit.getName();
            walk = new RevWalk(repository);
            ObjectId objId = repository.resolve(commitId);
            RevCommit revCommit = walk.parseCommit((AnyObjectId)objId);
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef(revCommit.getName()).call();
        }
        catch (NoHeadException e) {
            logger.info("NoHeadException" + e.getMessage());
        }
        catch (GitAPIException e) {
            logger.info(ERRCODE_GITAPIEXCEPTION + e.getMessage());
        }
        catch (IOException e) {
            logger.info(ERRCODE_IOECEPTION + e.getMessage());
        }
        finally {
            if (git != null) {
                git.close();
            }
            if (repository != null) {
                repository.close();
            }
            if (walk != null) {
                walk.close();
            }
        }
    }

    public static void saveFile(String fileName, String content, String exportPath) {
        block30: {
            String checkGitRepository = GitHostingServiceImpl.checkFilePath(exportPath + File.separator + fileName);
            try {
                String checkExportPath = GitHostingServiceImpl.checkFilePath(exportPath);
                File fileAbovePath = new File(checkExportPath);
                if (!fileAbovePath.exists()) {
                    fileAbovePath.mkdirs();
                }
                File jsFile = new File(checkGitRepository);
                boolean isSuccess = false;
                if (jsFile.exists()) {
                    boolean isDelete = jsFile.delete();
                    if (isDelete) {
                        isSuccess = jsFile.createNewFile();
                    }
                } else {
                    isSuccess = jsFile.createNewFile();
                }
                if (!isSuccess) break block30;
                Path path = Paths.get(checkGitRepository, new String[0]);
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
                     OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
                    writer.write(content);
                }
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", "\u5199\u5165\u6587\u4ef6\u5931\u8d25"), new Object[0]);
            }
        }
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    public static void deleteKd(File file) {
        if (!file.isDirectory()) {
            boolean fileDelete = file.delete();
            if (fileDelete) {
                logger.info(file + DELETETIPS);
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    boolean isDelFile = delfile.delete();
                    if (!isDelFile) continue;
                    logger.info(delfile + DELETETIPS);
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                GitHostingServiceImpl.deleteKd(fileList[i]);
            }
            boolean fileDelete = file.delete();
            if (fileDelete) {
                logger.info(file + DELETETIPS);
            }
        }
    }

    public static String getGitLocalFullPath2UnitTest(String bizAppId, String gitRepository, String gitRootpath) {
        String result = "";
        result = !gitRootpath.startsWith(File.separator) ? gitRepository + File.separator + gitRootpath : gitRepository + gitRootpath;
        return result;
    }
}

