/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.unittest.UnitTestUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;

public class UTAppSet
extends AbstractFormPlugin
implements ClickListener {
    public static final String RESPONSER_KEY = "responser";
    public static final String APPSETID_KEY = "appsetid";
    public static final String APPID_KEY = "appid";
    public static final String SAVE_KEY = "save";
    public static final String USER_KEY = "bos_user";
    public static final String SVNPATH_KEY = "svnpath";
    public static final String GITURL = "giturl";
    public static final String GITBRANCH = "gitbranch";
    public static final String GITROOTPATH = "gitrootpath";
    public static final String GITREPOSITORY = "gitrepository";
    public static final String GITUSERNAME = "gitusername";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{RESPONSER_KEY});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(UnitTestUtils.isGitManageType()), new String[]{"flexpanelap_git"});
        this.getView().setVisible(Boolean.valueOf(!UnitTestUtils.isGitManageType()), new String[]{"flexpanelap_svn"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isGit = UnitTestUtils.isGitManageType();
        this.getView().setVisible(Boolean.valueOf(isGit), new String[]{"flexpanelap_git"});
        this.getView().setVisible(Boolean.valueOf(!isGit), new String[]{"flexpanelap_svn"});
        if (isGit) {
            ((TextEdit)this.getControl(GITURL)).setMustInput(true);
            ((TextEdit)this.getControl(GITBRANCH)).setMustInput(true);
            ((TextEdit)this.getControl(GITROOTPATH)).setMustInput(true);
            ((TextEdit)this.getControl(GITREPOSITORY)).setMustInput(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (this.getView().getParentView() != null) {
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            if (result.isSuccess()) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"UTAppSet_0", (String)"bos-unittest", (Object[])new Object[0]));
            } else {
                List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
                StringBuilder sb = new StringBuilder();
                if (allErrorOrValidateInfo.size() > 0) {
                    for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                        sb.append(iOperateInfo.getMessage()).append('\n');
                    }
                }
                if (sb.length() > 0) {
                    this.getView().getParentView().showErrorNotification(sb.toString());
                } else {
                    this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"UTAppSet_1", (String)"bos-unittest", (Object[])new Object[0]));
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (source.getKey().equalsIgnoreCase(RESPONSER_KEY)) {
            ListShowParameter para = ShowFormHelper.createShowListForm((String)USER_KEY, (boolean)true);
            CloseCallBack callback = new CloseCallBack((IFormPlugin)this, RESPONSER_KEY);
            para.setCloseCallBack(callback);
            this.getView().showForm((FormShowParameter)para);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (RESPONSER_KEY.equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            StringBuilder responser = new StringBuilder();
            for (ListSelectedRow row : rows) {
                responser.append(row.getName()).append(' ');
            }
            responser = new StringBuilder(responser.toString().trim());
            this.getModel().setValue(RESPONSER_KEY, (Object)responser.toString());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate c = (FormOperate)args.getSource();
        if (SAVE_KEY.equalsIgnoreCase(c.getOperateKey()) && UnitTestUtils.isGitManageType()) {
            String gitUrl = (String)this.getView().getModel().getValue(GITURL);
            if (gitUrl.trim().length() == 0) {
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"git\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITManagePlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]);
                args.setCancelMessage(msg);
                this.getView().showErrorNotification(msg);
                return;
            }
            this.getView().getModel().setValue(GITURL, (Object)gitUrl.trim());
            String gitbranch = (String)this.getView().getModel().getValue(GITBRANCH);
            if (gitbranch.trim().length() == 0) {
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITManagePlugin_2", (String)"bos-devportal-plugin", (Object[])new Object[0]);
                args.setCancelMessage(msg);
                this.getView().showErrorNotification(msg);
                return;
            }
            this.getView().getModel().setValue(GITBRANCH, (Object)gitbranch.trim());
            String gitrootpath = (String)this.getView().getModel().getValue(GITROOTPATH);
            if (gitbranch.trim().length() == 0) {
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u6839\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITManagePlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0]);
                args.setCancelMessage(msg);
                this.getView().showErrorNotification(msg);
                return;
            }
            if (gitrootpath.contains("\u7248\u672c\u53f7")) {
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"git\u8fdc\u7a0b\u6839\u76ee\u5f55\u4e2d\uff0c\u7248\u672c\u53f7\u9700\u8981\u6307\u5b9a\u3002", (String)"GITManagePlugin_7", (String)"bos-devportal-plugin", (Object[])new Object[0]);
                args.setCancelMessage(msg);
                this.getView().showErrorNotification(msg);
                return;
            }
            this.getView().getModel().setValue(GITROOTPATH, (Object)gitrootpath.trim());
            String repository = (String)this.getView().getModel().getValue(GITREPOSITORY);
            if (gitbranch.trim().length() == 0) {
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"\u4ed3\u5e93\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITManagePlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]);
                args.setCancelMessage(msg);
                this.getView().showErrorNotification(msg);
                return;
            }
            this.getView().getModel().setValue(GITREPOSITORY, (Object)repository.trim());
        }
    }
}

