/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.unittest.UTCacheHelper;
import kd.bos.designer.unittest.UnitTestTreeListCloudAppUnitHelper;
import kd.bos.designer.unittest.UnitTestUtils;
import kd.bos.designer.unittest.UnitTestWorkHelper;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DevportalCommonUtil;

public class UTAppSettingEdit
extends AbstractFormPlugin
implements ItemClickListener,
TreeNodeClickListener,
SearchEnterListener {
    public static final String ROOT_ID = "";
    public static final String APP_TREE = "apptree";
    public static final String APP_SET_VIEW_PAGE_ID = "app_set_page_id";
    public static final String ROOT_NODE_CACHE_KEY = "root_node_cache_key";
    public static final String APP_SET_NUMBER = "ut_app_set";
    public static final String CHECKIN_KEY = "checkin";
    public static final String SAVE_KEY = "btnsave";
    public static final String EXPORT_KEY = "export";
    public static final String IMPORT_KEY = "import";
    public static final String IDS_KEY = "ids";
    private static final String SMGUSER_NAME = "smgusername";
    private static final String CLOUD = "cloud";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView tView = (TreeView)this.getView().getControl(APP_TREE);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        if (UnitTestUtils.isGitManageType()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CHECKIN_KEY});
        }
    }

    private static TreeNode loadAllAppNodes() {
        TreeNode root = new TreeNode();
        JSONObject map = new JSONObject();
        map.put("type", (Object)"root");
        root.setData((Object)map);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"UTAppSettingEdit_0", (String)"bos-unittest", (Object[])new Object[0]));
        root.setParentid(ROOT_ID);
        root.setId(ROOT_ID);
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = UnitTestTreeListCloudAppUnitHelper.getAllCloudNodes();
        for (TreeNode cloudNode : cloudNodes) {
            List<TreeNode> appNodes = UnitTestTreeListCloudAppUnitHelper.getAppsByCloudId(cloudNode.getId());
            if (appNodes.size() <= 0) continue;
            cloudNode.addChildren(appNodes);
        }
        if (cloudNodes.size() > 0) {
            root.setChildren(cloudNodes);
        }
        return root;
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl(APP_TREE);
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (focusNode != null) {
            this.getView().getFormShowParameter().setCustomParam("id", focusNode.get("id"));
        }
        TreeNode node = UTAppSettingEdit.loadAllAppNodes();
        UTCacheHelper.setTreeNodeToPageCache(this, ROOT_NODE_CACHE_KEY, node);
        treeView.addNode(node);
    }

    private void initDiscriptor() {
        StringBuilder discriptor = new StringBuilder();
        discriptor.append(ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a", (String)"UTAppSettingEdit_1", (String)"bos-unittest", (Object[])new Object[0])).append("\r\n");
        discriptor.append(ResManager.loadKDString((String)"\u4ee3\u7801\u5e93\u8def\u5f84\uff1a\u5355\u5143\u6d4b\u8bd5\u5e94\u7528\u4e0b\u6240\u6709\u76f8\u5173\u7b7e\u5165\u529f\u80fd\u7684\u8def\u5f84\uff0c\u5982\u7528\u4f8b\u3001\u914d\u7f6e", (String)"UTAppSettingEdit_2", (String)"bos-unittest", (Object[])new Object[0])).append("\r\n");
        discriptor.append(ResManager.loadKDString((String)"\u8d1f\u8d23\u4eba\uff1a\u5404\u5e94\u7528\u7684\u7528\u4f8b\u8d1f\u8d23\u4eba\uff0c\u652f\u6301\u591a\u4eba\u3002\u5982\u679c\u7528\u4f8b\u4e2d\u6ca1\u6709\u914d\u7f6e\u8d1f\u8d23\u4eba\u7684\u8bdd\uff0c\u5219\u9ed8\u8ba4\u4f7f\u7528", (String)"UTAppSettingEdit_3", (String)"bos-unittest", (Object[])new Object[0])).append("\r\n");
        this.getModel().setValue("discriptor", (Object)discriptor.toString());
    }

    private void loadAppSet() {
        BillShowParameter para = new BillShowParameter();
        para.getOpenStyle().setShowType(ShowType.InContainer);
        para.getOpenStyle().setTargetKey("appset");
        para.setFormId(APP_SET_NUMBER);
        para.setBillStatus(BillOperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)para);
        this.getPageCache().put(APP_SET_VIEW_PAGE_ID, para.getPageId());
        this.updateBillLock(false);
        this.getView().sendFormAction(this.getAppSetView());
    }

    private IFormView getAppSetView() {
        String pageId = this.getPageCache().get(APP_SET_VIEW_PAGE_ID);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        return view;
    }

    private void setModelToModifyType(String id) {
        Object[] ids = new Object[]{Long.valueOf(id)};
        PkSnapshotSet set = new PkSnapshotSet();
        PkSnapshot shot = new PkSnapshot();
        shot.TableName = "t_ut_app_set";
        shot.Oids = ids;
        set.Snapshots.add(shot);
        this.getAppSetView().getModel().getDataEntity().getDataEntityState().setPkSnapshotSet(set);
    }

    private void setModelToNewType() {
        PkSnapshotSet set = this.getAppSetView().getModel().getDataEntity().getDataEntityState().getPkSnapshotSet();
        if (null != set) {
            set.Snapshots.clear();
        }
    }

    private void updateBillLock(boolean lock) {
        this.getAppSetView().setEnable(Boolean.valueOf(lock), new String[]{"save"});
        this.getAppSetView().setEnable(Boolean.valueOf(lock), new String[]{"responser"});
        this.getAppSetView().setEnable(Boolean.valueOf(lock), new String[]{"appid"});
        this.getAppSetView().setEnable(Boolean.valueOf(lock), new String[]{"svnpath"});
        this.getAppSetView().setEnable(Boolean.valueOf(lock), new String[]{"giturl"});
        this.getAppSetView().setEnable(Boolean.valueOf(lock), new String[]{"gitbranch"});
        this.getAppSetView().setEnable(Boolean.valueOf(lock), new String[]{"gitrootpath"});
        this.getAppSetView().setEnable(Boolean.valueOf(lock), new String[]{"gitrepository"});
    }

    private void doCheckIn() {
        TreeView treeView;
        TreeView.TreeState treeState;
        Map focusNode;
        JSONArray ids = new JSONArray();
        String strids = this.getPageCache().get(IDS_KEY);
        if ((StringUtils.isBlank((CharSequence)strids) || strids.equalsIgnoreCase("[]")) && StringUtils.isNotBlank((Object)(focusNode = (treeState = (treeView = (TreeView)this.getControl(APP_TREE)).getTreeState()).getFocusNode()))) {
            this.updateIdsToCache((String)focusNode.get("id"), null);
        }
        if (StringUtils.isBlank((CharSequence)(strids = this.getPageCache().get(IDS_KEY)))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u5e94\u7528\u914d\u7f6e\uff0c\u65e0\u6cd5\u7b7e\u5165\uff01", (String)"UTAppSettingEdit_4", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        ids = (JSONArray)SerializationUtils.fromJsonString((String)strids, JSONArray.class);
        if (ids.size() <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51c6\u5907\u7b7e\u5165\u7684\u5e94\u7528\u914d\u7f6e\u8fd8\u672a\u4fdd\u5b58\u8fc7\uff0c\u8bf7\u5148\u4fdd\u5b58\u518d\u8fdb\u884c\u7b7e\u5165\uff01", (String)"UTAppSettingEdit_5", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        UnitTestWorkHelper.doUTAppSetCheckIn(this, ids, APP_SET_NUMBER);
    }

    private void updateIdsToCache(String focusNodeId, String userName) {
        if (StringUtils.isBlank((CharSequence)userName) && UnitTestUtils.isGitManageType() && UnitTestUtils.isGitMultiParallel()) {
            userName = SessionManager.getCurrent().get(SMGUSER_NAME);
        }
        JSONArray ids = new JSONArray();
        String appid = focusNodeId;
        TreeNode root = UTCacheHelper.getTreeNodeFromPageCache(this, ROOT_NODE_CACHE_KEY);
        TreeNode current = root.getTreeNode(appid, 2);
        String type = (String)((Map)current.getData()).get("type");
        if (type.equalsIgnoreCase(CLOUD) || type.equalsIgnoreCase("root")) {
            QFilter userFilter;
            this.updateBtn(false);
            JSONArray appids = new JSONArray();
            List lstAppNode = current.getChildren();
            if (null == lstAppNode) {
                return;
            }
            for (TreeNode item : lstAppNode) {
                List appNodes;
                String nodetype = (String)((Map)item.getData()).get("type");
                if (nodetype.equalsIgnoreCase("app")) {
                    appids.add((Object)item.getId());
                    continue;
                }
                if (!nodetype.equalsIgnoreCase(CLOUD) || null == (appNodes = item.getChildren())) continue;
                for (TreeNode app : appNodes) {
                    appids.add((Object)app.getId());
                }
            }
            ORM orm = ORM.create();
            QFilter filter = new QFilter("appid", "in", (Object)appids);
            Object[] filters = new QFilter[]{filter};
            String gitUserName = SessionManager.getCurrent().get(SMGUSER_NAME);
            if (!StringUtils.isBlank((CharSequence)gitUserName) && DevportalCommonUtil.isGitMultiParallel()) {
                userFilter = new QFilter("gitusername", "=", (Object)gitUserName);
                filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)userFilter);
            } else {
                userFilter = new QFilter("gitusername", "=", (Object)Character.valueOf(' '));
                filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)userFilter);
            }
            DynamicObjectCollection items = orm.query(APP_SET_NUMBER, (QFilter[])filters);
            for (DynamicObject item : items) {
                ids.add((Object)item.getString("id"));
            }
        } else if (type.equalsIgnoreCase("app")) {
            this.updateBtn(true);
            this.updateBillLock(true);
            DynamicObject appSetInfo = UnitTestWorkHelper.getAppSetInfo(appid, userName);
            if (appSetInfo != null) {
                ids.add(appSetInfo.get("id"));
            }
        }
        String strids = SerializationUtils.toJsonString((Object)ids);
        this.getPageCache().put(IDS_KEY, strids);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateBtn(false);
        this.initTree();
        this.initDiscriptor();
        this.loadAppSet();
    }

    private void updateBtn(boolean isUse) {
        this.getView().setVisible(Boolean.valueOf(isUse), new String[]{"tabap"});
        this.getView().setVisible(Boolean.valueOf(isUse), new String[]{"discriptor"});
        this.getView().setEnable(Boolean.valueOf(isUse), new String[]{SAVE_KEY});
        this.getView().setEnable(Boolean.valueOf(isUse), new String[]{CHECKIN_KEY});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (CHECKIN_KEY.equalsIgnoreCase(evt.getItemKey())) {
            this.doCheckIn();
        } else if (SAVE_KEY.equalsIgnoreCase(evt.getItemKey())) {
            this.doSave();
        }
    }

    private void doSave() {
        BillView appView = (BillView)this.getAppSetView();
        Button btnsave = (Button)appView.getControl("save");
        btnsave.click();
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String appid = (String)e.getNodeId();
        String userName = null;
        if (UnitTestUtils.isGitManageType() && UnitTestUtils.isGitMultiParallel() && StringUtils.isBlank((CharSequence)(userName = SessionManager.getCurrent().get(SMGUSER_NAME)))) {
            this.showGitUserLogon(appid);
            return;
        }
        this.updateIdsToCache(appid, userName);
        TreeNode root = UTCacheHelper.getTreeNodeFromPageCache(this, ROOT_NODE_CACHE_KEY);
        TreeNode current = root.getTreeNode(appid, 2);
        String type = (String)((Map)current.getData()).get("type");
        if (type.equalsIgnoreCase(CLOUD) || type.equalsIgnoreCase("root")) {
            this.updateBtn(false);
            TreeView tree = (TreeView)this.getControl(APP_TREE);
            tree.expand(appid);
            this.updateBillLock(false);
            this.getAppSetView().getModel().setValue("id", null);
            this.getAppSetView().getModel().setValue("responser", null);
            this.getAppSetView().getModel().setValue("svnpath", null);
            this.getAppSetView().getModel().setValue("appid", null);
            this.getAppSetView().getModel().setValue("giturl", null);
            this.getAppSetView().getModel().setValue("gitbranch", null);
            this.getAppSetView().getModel().setValue("gitrootpath", null);
            this.getAppSetView().getModel().setValue("gitrepository", null);
        } else if (type.equalsIgnoreCase("app")) {
            this.updateBtn(true);
            this.updateBillLock(true);
            this.navToApp(appid, null);
        }
        this.getView().sendFormAction(this.getAppSetView());
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("UTAppSettingEditLoginCallBack".equals(evt.getActionId()) && evt.getReturnData() != null) {
            Map map = (Map)evt.getReturnData();
            String username = (String)map.get("username");
            String appId = (String)map.get("appid");
            this.navToApp(appId, username);
            this.getView().sendFormAction(this.getAppSetView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        UTCacheHelper.removeTreeNodeInPageCache(this, ROOT_NODE_CACHE_KEY);
        this.getPageCache().remove(IDS_KEY);
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String searchText = evt.getText();
        TreeNode rootNode = UTCacheHelper.getTreeNodeFromPageCache(this, ROOT_NODE_CACHE_KEY);
        IPageCache pageCache = this.getPageCache();
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 2);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"UTAppSettingEdit_6", (String)"bos-unittest", (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getView().getControl(APP_TREE);
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                    treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                    treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"UTAppSettingEdit_7", (String)"bos-unittest", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private boolean showGitUserLogon(String appId) {
        if (!UnitTestUtils.isGitMultiParallel()) {
            return true;
        }
        String username = SessionManager.getCurrent().get(SMGUSER_NAME);
        String password = SessionManager.getCurrent().get("smgpassword");
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            return true;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("unit_test_svn_login");
        parameter.setCustomParam("type", (Object)"loginonly");
        parameter.setCustomParam("issave", (Object)Boolean.TRUE);
        parameter.setCustomParam("appid", (Object)appId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "UTAppSettingEditLoginCallBack"));
        this.getView().showForm(parameter);
        return false;
    }

    private void navToApp(String appId, String userName) {
        if (StringUtils.isBlank((CharSequence)userName) && UnitTestUtils.isGitManageType() && UnitTestUtils.isGitMultiParallel() && StringUtils.isBlank((CharSequence)(userName = SessionManager.getCurrent().get(SMGUSER_NAME)))) {
            this.showGitUserLogon(appId);
            return;
        }
        DynamicObject appSetInfo = UnitTestWorkHelper.getAppSetInfo(appId, userName);
        if (null != appSetInfo) {
            String id = appSetInfo.getString("id");
            String responser = appSetInfo.getString("responser");
            String svnpath = appSetInfo.getString("svnpath");
            this.getAppSetView().getModel().setValue("id", (Object)id);
            this.getAppSetView().getModel().setValue("responser", (Object)responser);
            this.getAppSetView().getModel().setValue("svnpath", (Object)svnpath);
            this.getAppSetView().getModel().setValue("appid", (Object)appId);
            this.getAppSetView().getModel().setValue("giturl", (Object)appSetInfo.getString("giturl"));
            this.getAppSetView().getModel().setValue("gitbranch", (Object)appSetInfo.getString("gitbranch"));
            this.getAppSetView().getModel().setValue("gitrootpath", (Object)appSetInfo.getString("gitrootpath"));
            this.getAppSetView().getModel().setValue("gitrepository", (Object)appSetInfo.getString("gitrepository"));
            this.getAppSetView().getModel().setValue("gitusername", (Object)appSetInfo.getString("gitusername"));
            this.setModelToModifyType(id);
        } else {
            this.getAppSetView().getModel().setValue("id", null);
            this.getAppSetView().getModel().setValue("responser", null);
            this.getAppSetView().getModel().setValue("svnpath", null);
            this.getAppSetView().getModel().setValue("appid", (Object)appId);
            this.getAppSetView().getModel().setValue("giturl", null);
            this.getAppSetView().getModel().setValue("gitbranch", null);
            this.getAppSetView().getModel().setValue("gitrootpath", null);
            this.getAppSetView().getModel().setValue("gitrepository", null);
            this.getAppSetView().getModel().setValue("gitusername", (Object)userName);
            this.setModelToNewType();
        }
    }
}

