/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.baserecordset.AbstractDataSetOperater;
import kd.bos.designer.unittest.UnitTestUtils;
import kd.bos.designer.unittest.UnitTestWorkHelper;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;

public class UnitTestDetailListPlugin
extends AbstractFormPlugin
implements ItemClickListener,
RowClickEventListener,
HyperLinkClickListener {
    private static final String EXEC_CASES_LIST_NAME = "execaselist";
    private static final String KEY_JOBDISPATCH = "btnjobdispatch";
    private static final String SETUP_TAG_CLOSE_CALLBACK = "setup_tag_close_callback";
    private static final String SETUP_LEVEL_CLOSE_CALLBACK = "setup_level_close_callback";
    private static final String IS_SHOW_EXEC_LIST = "isShowExecList";
    private static final String FLEX_EXE_CASE_LIST = "flex_execaselist";
    private static final String DESCRIPTION = "\u672a\u9009\u4e2d\u4efb\u4f55\u6d4b\u8bd5\u7528\u4f8b~";
    private static final String UNIT_TEST_DETAIL_LIST_PLUGIN_6 = "UnitTestDetailListPlugin_6";
    private static final String ERROR = "error";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String CASE_STATUS = "casestatus";

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{KEY_JOBDISPATCH});
        Control exec = this.getControl(EXEC_CASES_LIST_NAME);
        if (exec != null) {
            this.addClickListeners(new String[]{EXEC_CASES_LIST_NAME});
            ((EntryGrid)this.getView().getControl(EXEC_CASES_LIST_NAME)).addHyperClickListener((HyperLinkClickListener)this);
            this.addClickListeners(new String[]{"btn_hide", "btn_clear"});
            String isShowExecList = this.getPageCache().get(IS_SHOW_EXEC_LIST);
            if (StringUtils.isNotBlank((CharSequence)isShowExecList) && "1".equals(isShowExecList)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_EXE_CASE_LIST});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_EXE_CASE_LIST});
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
        super.afterBindData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_checkin": {
                this.checkIn();
                break;
            }
            case "btn_export": {
                this.exportDataSet();
                break;
            }
            case "btn_delete": {
                this.deleteUnitTestConfirm();
                break;
            }
            case "btn_history": {
                this.getHistoryResult();
                break;
            }
            case "btn_execute": {
                this.startExecuteTestCase();
                break;
            }
            case "btn_level": {
                this.setupLevel();
                break;
            }
        }
    }

    private void setupLevel() {
        JSONArray ids = this.getSelectedRowIds();
        if (ids == null) {
            return;
        }
        this.getPageCache().put("ids", ids.toJSONString());
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ut_batch_setup_case_level");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SETUP_LEVEL_CLOSE_CALLBACK));
        this.getView().showForm(parameter);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btn_hide".equalsIgnoreCase(c.getKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_EXE_CASE_LIST});
            this.getPageCache().put(IS_SHOW_EXEC_LIST, "0");
        } else if ("btn_clear".equalsIgnoreCase(c.getKey())) {
            this.getView().getModel().deleteEntryData(EXEC_CASES_LIST_NAME);
        }
    }

    private void dispatch(String ids) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setName("\u542f\u7528\u5e76\u53d1\u5927\u4efb\u52a1\u6267\u884c\u6d4b\u8bd5\u7528\u4f8b");
        jobInfo.setTaskClassname("kd.bos.mservice.form.unittest.task.CaseRunnerTask");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ids", ids);
        params.put("tasktype", "number");
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption("\u6d4b\u8bd5\u4efb\u52a1\u7684\u6267\u884c");
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.bos.designer.unittest.CaseTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private void taskCallBack(Object returnData) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        Object taskinfoObj;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (taskinfoObj = (result = (Map)returnData).get("taskinfo")) != null && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)taskinfoObj)) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            boolean success = (Boolean)mapData.get("success");
            if (success) {
                String casesResult = (String)mapData.get("result");
                List mapCaseResult = (List)SerializationUtils.fromJsonString((String)casesResult, List.class);
                int i = 0;
                int count = this.getModel().getEntryRowCount(EXEC_CASES_LIST_NAME);
                this.getModel().appendEntryRow(EXEC_CASES_LIST_NAME, count, mapCaseResult.size());
                for (Map caseMapResult : mapCaseResult) {
                    this.getModel().setValue("casename", caseMapResult.get("name"), count + i);
                    this.getModel().setValue("detail", (Object)SerializationUtils.toJsonString((Object)caseMapResult), i);
                    boolean bCompleted = (Boolean)caseMapResult.get("completed");
                    if (!bCompleted) {
                        this.getModel().setValue(CASE_STATUS, (Object)ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25", (String)"UnitTestDetailListPlugin_2", (String)"bos-unittest", (Object[])new Object[0]), count + i);
                    } else if (caseMapResult.get("status").equals(0)) {
                        this.getModel().setValue(CASE_STATUS, (Object)ResManager.loadKDString((String)"\u5168\u90e8\u6210\u529f", (String)"UnitTestDetailListPlugin_3", (String)"bos-unittest", (Object[])new Object[0]), count + i);
                    } else {
                        this.getModel().setValue(CASE_STATUS, (Object)ResManager.loadKDString((String)"\u5b58\u5728\u5931\u8d25", (String)"UnitTestDetailListPlugin_4", (String)"bos-unittest", (Object[])new Object[0]), count + i);
                    }
                    ++i;
                }
            } else {
                this.getView().showErrMessage("\u6267\u884c\u7528\u4f8b\u4efb\u52a1\u5f02\u5e38", (String)mapData.get(ERROR));
            }
        }
    }

    private void startExecuteTestCase() {
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_EXE_CASE_LIST});
        this.getPageCache().put(IS_SHOW_EXEC_LIST, "1");
        BillList list = (BillList)this.getView().getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u7528\u4f8b\u6267\u884c\uff0c\u8bf7\u5148\u9009\u62e9\uff01", (String)"UnitTestDetailListPlugin_0", (String)"bos-unittest", (Object[])new Object[0]));
        } else {
            Object[] pks = selectedRows.getPrimaryKeyValues();
            if (pks.length <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u7528\u4f8b\u6267\u884c\uff0c\u8bf7\u5148\u9009\u62e9\uff01", (String)"UnitTestDetailListPlugin_0", (String)"bos-unittest", (Object[])new Object[0]));
                return;
            }
            this.getView().getModel().deleteEntryData(EXEC_CASES_LIST_NAME);
            this.addSelectCasesToExecList(selectedRows);
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            billList.clearSelection();
        }
    }

    private void addSelectCasesToExecList(ListSelectedRowCollection selectedRows) {
        this.doExecCases(selectedRows);
    }

    private void doExecCases(ListSelectedRowCollection selectedRows) {
        StringBuilder numbers = new StringBuilder();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            numbers.append(',').append(listSelectedRow.getNumber());
        }
        numbers = new StringBuilder(numbers.substring(1));
        this.dispatch(numbers.toString());
    }

    private void getHistoryResult() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("ide_unit_test_result");
        parameter.setFormId("bos_list");
        parameter.setCaption(ResManager.loadKDString((String)"\u7528\u4f8b\u6267\u884c\u7ed3\u679c\u8bb0\u5f55\u5217\u8868", (String)"UnitTestDetailListPlugin_5", (String)"bos-unittest", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("tabap");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void checkIn() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)DESCRIPTION, (String)UNIT_TEST_DETAIL_LIST_PLUGIN_6, (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        JSONArray ids = new JSONArray();
        for (ListSelectedRow listSelectedRow : rows) {
            String caseid = listSelectedRow.getPrimaryKeyValue().toString();
            ids.add((Object)caseid);
        }
        UnitTestWorkHelper.doCheckIn(this, ids);
    }

    private void exportDataSet() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)DESCRIPTION, (String)UNIT_TEST_DETAIL_LIST_PLUGIN_6, (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        ArrayList<Map<String, Object>> lstMapCaseInfo = new ArrayList<Map<String, Object>>();
        for (ListSelectedRow listSelectedRow : rows) {
            HashMap<String, String> mapCaseInfo = new HashMap<String, String>();
            mapCaseInfo.put("caseid", listSelectedRow.getPrimaryKeyValue().toString());
            mapCaseInfo.put("casenumber", listSelectedRow.getNumber());
            lstMapCaseInfo.add(mapCaseInfo);
        }
        UnitTestUtils.exportUnitTestCallBack(lstMapCaseInfo, this.getView());
    }

    private void deleteUnitTestConfirm() {
        JSONArray ids = this.getSelectedRowIds();
        if (ids == null) {
            return;
        }
        UnitTestWorkHelper.doDelete(this, ids);
    }

    private JSONArray getSelectedRowIds() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)DESCRIPTION, (String)UNIT_TEST_DETAIL_LIST_PLUGIN_6, (String)"bos-unittest", (Object[])new Object[0]));
            return null;
        }
        JSONArray ids = new JSONArray();
        for (ListSelectedRow listSelectedRow : rows) {
            String sIds = listSelectedRow.getPrimaryKeyValue().toString();
            ids.add((Object)sIds);
        }
        return ids;
    }

    private void deleteUnitTestCase(String sIds) {
        JSONArray ids = JSON.parseArray((String)sIds);
        ORM orm = ORM.create();
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        orm.delete("ide_unit_test_detail", filter);
        this.getView().updateView(BILL_LIST_AP);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b\u5220\u9664\u6210\u529f\uff01", (String)"UnitTestDetailListPlugin_7", (String)"bos-unittest", (Object[])new Object[0]));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        switch (e.getActionId()) {
            case "exportCallBack": {
                this.handleExportCallBack(e);
                break;
            }
            case "importCallBack": {
                this.handleImportCallBack(e);
                break;
            }
            case "deleteUnitTestCaseCloseCallBack": {
                this.handleDeleteUnitTestCaseCloseCallBack();
                break;
            }
            case "taskcloseback": {
                this.taskCallBack(e.getReturnData());
                break;
            }
            case "setup_tag_close_callback": {
                this.handleSetupTagCloseCallback(e);
                break;
            }
            case "setup_level_close_callback": {
                this.handleSetupLevelCloseCallback(e);
                break;
            }
        }
    }

    private void handleSetupLevelCloseCallback(ClosedCallBackEvent e) {
        ORM orm = ORM.create();
        String selectFields = "id,level";
        JSONArray caseIds = JSON.parseArray((String)this.getPageCache().get("ids"));
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)caseIds)};
        DynamicObjectCollection cases = orm.query("ide_unit_test_detail", selectFields, filter);
        String level = String.valueOf(e.getReturnData());
        for (DynamicObject dynamicObj : cases) {
            dynamicObj.set("level", (Object)level);
        }
        orm.update((List)cases);
        this.getView().updateView(BILL_LIST_AP);
    }

    private void handleSetupTagCloseCallback(ClosedCallBackEvent e) {
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)e.getReturnData();
        List<Object> tagPrimaryKeys = listSelectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        JSONArray caseIds = JSON.parseArray((String)this.getPageCache().get("ids"));
        this.getPageCache().remove("ids");
        this.batchUpdateCaseTags(tagPrimaryKeys, caseIds);
        this.getView().updateView(BILL_LIST_AP);
    }

    private void batchUpdateCaseTags(List<Object> tagPrimaryKeys, JSONArray caseIds) {
        String deleteSql = "delete from t_bas_unittestdetail_tag where FID in (";
        StringBuilder sb = new StringBuilder(deleteSql);
        for (int i = 0; i < caseIds.size(); ++i) {
            sb.append('\'').append(caseIds.get(i)).append('\'');
            if (i == caseIds.size() - 1) {
                sb.append(')');
                continue;
            }
            sb.append(',');
        }
        deleteSql = sb.toString();
        String insertSql = "insert into t_bas_unittestdetail_tag (FPKID,FID,FBASEDATAID) values (?,?,?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Object caseId : caseIds) {
            for (Object tagId : tagPrimaryKeys) {
                params.add(new Object[]{new SqlParameter("FPKID", -9, (Object)DB.genLongId((String)"t_bas_unittestdetail_tag")), new SqlParameter("FID", -9, caseId), new SqlParameter("FBASEDATAID", 12, tagId)});
            }
        }
        try (TXHandle h = TX.beginRequired();){
            DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql);
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, params);
        }
    }

    private void handleDeleteUnitTestCaseCloseCallBack() {
        String scriptIds = this.getPageCache().get("ids");
        this.getPageCache().remove("ids");
        this.deleteUnitTestCase(scriptIds);
    }

    private void handleImportCallBack(ClosedCallBackEvent e) {
        JSONObject message = (JSONObject)e.getReturnData();
        if (message != null) {
            String errorMessage = message.getString("ERROR");
            String successMessage = message.getString("SUCCESS");
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25!\u5931\u8d25\u539f\u56e0\uff1a", (String)"UnitTestDetailListPlugin_9", (String)"bos-unittest", (Object[])new Object[0]) + errorMessage);
            } else if (StringUtils.isNotBlank((CharSequence)successMessage)) {
                this.getView().showSuccessNotification(successMessage);
                this.getView().updateView();
            }
        }
    }

    private void handleExportCallBack(ClosedCallBackEvent e) {
        Object expPath = e.getReturnData();
        String number = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        AbstractDataSetOperater dbOperator = new AbstractDataSetOperater(number);
        JSONObject jsonRet = dbOperator.expBaseData(expPath.toString());
        if (jsonRet.get((Object)ERROR) != null) {
            this.getView().showErrorNotification(jsonRet.get((Object)ERROR).toString());
        } else if (jsonRet.get((Object)"notification") != null) {
            this.getView().showMessage(jsonRet.get((Object)"notification").toString());
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u96c6\u6210\u529f", (String)"UnitTestDetailListPlugin_8", (String)"bos-unittest", (Object[])new Object[0]) + "\r\n" + jsonRet.get((Object)"flist"));
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (CASE_STATUS.equals(evt.getFieldName())) {
            String result = (String)this.getView().getModel().getValue("detail", evt.getRowIndex());
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ut_show_case_result");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.getOpenStyle().setTargetKey("tabap");
            parameter.setCustomParam("result", (Object)result);
            this.getView().showForm(parameter);
        }
    }
}

