/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.unittest.UnitTestWorkHelper;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.DirtyManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.unittest.ExcelDataObject;
import kd.bos.form.unittest.ImportExcelDataList;
import kd.bos.form.unittest.JMXForAnalysis;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.unittest.UnitTestService;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.unittest.UnitTestDao;
import kd.bos.upload.UploadOption;

public class UnitTestDetailPlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener,
UploadListener,
IConfirmCallBack {
    public static final String KEY_TXT_PARAM = "txt_param";
    public static final String KEY_TXT_TEST_PLUGIN = "txt_test_plugin";
    public static final String IDE_DEFINE_PARAMS = "ide_define_params";
    public static final String IDE_PLUGINS = "ide_plugins";
    public static final String BTN_SAVE = "btn_save";
    public static final String RESPONSERS_KEY = "responsers";
    public static final String USER_KEY = "bos_user";
    private static final Log log = LogFactory.getLog(UnitTestDetailPlugin.class);
    private static final String TXT_OBJECT = "txt_object";
    private static final String BIZ_APP_ID = "bizappid";
    private static final String APP_ID = "appid";
    private static final String BIZ_UNIT_ID = "bizunitid";
    private static final String UNIT_ID = "unitid";
    private static final String FRAME_CHOSE = "framechose";
    private static final String JMX_LOACTION = "jmxloaction";
    private static final String JMX_DETAIL = "jmxdetail";
    private static final String PREPARE_INDEX = "prepareindex";
    private static final String IMPORT_DATA_SOURCE = "importdatasource";
    private static final String C_BOX_TYPE = "cbox_type";
    private static final String TXT_FORM_LIST = "txt_form_list";
    private static final String DYNAMIC_FORM_MODEL = "DynamicFormModel";
    private static final String QUERY_LIST_NUMBER = "query_list_number";
    private static final String BUTTON_AP = "buttonap";
    private static final String DATA_SOURCE_BUTTON_AP = "datasourcebuttonap";
    private static final String TXT_NUMBER = "txt_number";
    private static final String UNIT_TEST_DETAIL_PLUGIN_1 = "UnitTestDetailPlugin_1";
    private static final String BIZ_APP_ID_ID = "bizappid_id";
    private static final String NUMBER = "number";
    private static final String MODEL_TYPE = "modeltype";
    private static final String UNIT_TEST_DETAIL_PLUGIN_10 = "UnitTestDetailPlugin_10";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshFormListNumber();
        this.initalizeFrame();
        this.initAppAndUnit();
        this.getView().setVisible(Boolean.FALSE, new String[]{"responser"});
    }

    private void initAppAndUnit() {
        Map appAndUnitId = (Map)this.getView().getFormShowParameter().getCustomParam("appinfo");
        if (appAndUnitId != null) {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)appAndUnitId.get("objectid")))) {
                this.getModel().setValue(TXT_OBJECT, appAndUnitId.get("objectid"));
                this.getView().setEnable(Boolean.FALSE, new String[]{TXT_OBJECT});
            } else {
                this.getModel().setValue(BIZ_APP_ID, appAndUnitId.get(APP_ID));
                this.getModel().setValue(BIZ_UNIT_ID, appAndUnitId.get(UNIT_ID));
            }
        }
    }

    private void initalizeFrame() {
        boolean isJunit = this.getFrameChose();
        if (isJunit) {
            this.showCaseFrameView();
        } else {
            this.showHttpFrameView();
        }
        this.getControl(FRAME_CHOSE);
    }

    private boolean getFrameChose() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return true;
        }
        Map parentCustomParams = parentView.getFormShowParameter().getCustomParams();
        Object param = parentCustomParams.get("isJunitMenu");
        if (param == null) {
            return true;
        }
        boolean isJunitMenu = Boolean.parseBoolean(param.toString());
        String testFrameType = "1";
        if (isJunitMenu) {
            testFrameType = "0";
        }
        this.getModel().setValue(FRAME_CHOSE, (Object)testFrameType);
        this.getView().setEnable(Boolean.FALSE, new String[]{FRAME_CHOSE});
        return isJunitMenu;
    }

    public void setEnable(Boolean value, String ... ctlKeys) {
        HashMap<String, Object> enableMap = new HashMap<String, Object>();
        enableMap.put("policy", "");
        enableMap.put("enable", value);
        enableMap.put("keys", ctlKeys);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("setEnable", enableMap);
    }

    private void showCaseFrameView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{JMX_LOACTION});
        this.getView().setVisible(Boolean.FALSE, new String[]{JMX_DETAIL});
        this.getView().setVisible(Boolean.FALSE, new String[]{PREPARE_INDEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{IMPORT_DATA_SOURCE});
        ((BasedataEdit)this.getControl(TXT_OBJECT)).setMustInput(false);
        ((BasedataProp)this.getModel().getDataEntityType().getProperty(TXT_OBJECT)).setMustInput(false);
        this.getView().setEnable(Boolean.FALSE, new String[]{BIZ_APP_ID});
        ((BasedataEdit)this.getControl(BIZ_APP_ID)).setMustInput(true);
        ((BasedataProp)this.getModel().getDataEntityType().getProperty(BIZ_APP_ID)).setMustInput(true);
        this.getView().setEnable(Boolean.FALSE, new String[]{BIZ_UNIT_ID});
        ((TextEdit)this.getControl(BIZ_UNIT_ID)).setMustInput(true);
        ((TextProp)this.getModel().getDataEntityType().getProperty(BIZ_UNIT_ID)).setMustInput(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{TXT_OBJECT});
        this.getView().setVisible(Boolean.TRUE, new String[]{BIZ_UNIT_ID});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TXT_TEST_PLUGIN});
        this.getView().setVisible(Boolean.TRUE, new String[]{C_BOX_TYPE});
        String type = (String)this.getModel().getValue(C_BOX_TYPE);
        String modelType = this.getModelType();
        if ("1".equals(type) || "3".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TXT_FORM_LIST});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{TXT_FORM_LIST});
            if (modelType.equals(DYNAMIC_FORM_MODEL)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TXT_FORM_LIST});
            }
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TXT_PARAM});
    }

    private void showHttpFrameView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{JMX_LOACTION});
        this.getView().setVisible(Boolean.TRUE, new String[]{JMX_DETAIL});
        this.getView().setVisible(Boolean.TRUE, new String[]{PREPARE_INDEX});
        this.getView().setVisible(Boolean.TRUE, new String[]{IMPORT_DATA_SOURCE});
        ((BasedataEdit)this.getControl(TXT_OBJECT)).setMustInput(false);
        ((BasedataProp)this.getModel().getDataEntityType().getProperty(TXT_OBJECT)).setMustInput(false);
        ((BasedataEdit)this.getControl(BIZ_APP_ID)).setMustInput(true);
        ((BasedataProp)this.getModel().getDataEntityType().getProperty(BIZ_APP_ID)).setMustInput(true);
        this.getView().setEnable(Boolean.FALSE, new String[]{BIZ_UNIT_ID});
        ((TextEdit)this.getControl(BIZ_UNIT_ID)).setMustInput(true);
        ((TextProp)this.getModel().getDataEntityType().getProperty(BIZ_UNIT_ID)).setMustInput(true);
        this.getView().setVisible(Boolean.FALSE, new String[]{TXT_OBJECT});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TXT_TEST_PLUGIN});
        this.getView().setVisible(Boolean.FALSE, new String[]{C_BOX_TYPE});
        String type = (String)this.getModel().getValue(C_BOX_TYPE);
        if ("1".equals(type) || "3".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TXT_FORM_LIST});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{TXT_FORM_LIST});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TXT_PARAM});
        this.getView().setVisible(Boolean.FALSE, new String[]{BIZ_UNIT_ID});
    }

    public void initialize() {
        this.addClickListeners(new String[]{KEY_TXT_PARAM, KEY_TXT_TEST_PLUGIN, BTN_SAVE, JMX_LOACTION, JMX_DETAIL, IMPORT_DATA_SOURCE, RESPONSERS_KEY});
        Button btn = (Button)this.getControl(BUTTON_AP);
        btn.addUploadListener((UploadListener)this);
        Button dataSourceBtn = (Button)this.getControl(DATA_SOURCE_BUTTON_AP);
        dataSourceBtn.addUploadListener((UploadListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (BTN_SAVE.equals(source.getKey()) && this.checkValidPlugins() && this.checkAssert(evt)) {
            return;
        }
        super.beforeClick(evt);
    }

    private boolean checkValidPlugins() {
        String plugins = (String)this.getModel().getValue(KEY_TXT_TEST_PLUGIN);
        boolean notEmptyPlugins = StringUtils.isNotBlank((CharSequence)plugins);
        if (notEmptyPlugins) {
            Map mapPlugin = (Map)SerializationUtils.fromJsonString((String)plugins, Map.class);
            List lstPlugin = (List)mapPlugin.get("value");
            for (Map map : lstPlugin) {
                boolean enabled = (Boolean)map.get("Enabled");
                if (!enabled) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkAssert(BeforeClickEvent evt) {
        IDataModel model = this.getModel();
        String junitType = "0";
        boolean isJunit = junitType.equals(String.valueOf(model.getValue(FRAME_CHOSE)));
        boolean isPublish = Boolean.parseBoolean(String.valueOf(model.getValue("checkreleasetype")));
        if (isJunit && isPublish) {
            String txtNumber = String.valueOf(model.getValue(TXT_NUMBER));
            Map<String, Object> map = UnitTestDao.getTestCase(txtNumber);
            if (map == null || map.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u8fdb\u884c\u53d1\u5e03\uff01", (String)UNIT_TEST_DETAIL_PLUGIN_1, (String)"bos-unittest", (Object[])new Object[0]));
                evt.setCancel(true);
                return true;
            }
            String appNumber = BizAppServiceHelp.getAppNumByAppId((String)((String)map.get(APP_ID)));
            String result = (String)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)"UnitTestService", (String)"testByCaseIdInner", (Object[])new Object[]{txtNumber, Boolean.FALSE});
            List lstMapResult = (List)SerializationUtils.fromJsonString((String)result, List.class);
            Map mapResult = (Map)lstMapResult.get(0);
            boolean existNoAssert = (Boolean)mapResult.get("hasnoassert");
            if (existNoAssert) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58(\u53d1\u5e03)\u5931\u8d25\uff01\u5355\u5143\u6d4b\u8bd5\u5b58\u5728\u9519\u8bef\u6216\u672a\u4f7f\u7528\u65ad\u8a00\u7684\u65b9\u6cd5\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u76f8\u5173\u4ee3\u7801\uff01", (String)UNIT_TEST_DETAIL_PLUGIN_1, (String)"bos-unittest", (Object[])new Object[0]));
                evt.setCancel(true);
                return true;
            }
        }
        return false;
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if (KEY_TXT_PARAM.equalsIgnoreCase(c.getKey())) {
            this.setDefineParams();
        } else if (KEY_TXT_TEST_PLUGIN.equalsIgnoreCase(c.getKey())) {
            this.setUnitTestPlugins();
        } else if (c.getKey().equals(JMX_LOACTION)) {
            UploadOption uploadOption = new UploadOption();
            uploadOption.setMultiple(false);
            uploadOption.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20jmx", (String)"UnitTestDetailPlugin_0", (String)"bos-unittest", (Object[])new Object[0]));
            uploadOption.setSuffix(".jmx");
            this.getView().showUpload(uploadOption, BUTTON_AP);
        } else if (c.getKey().equals(JMX_DETAIL)) {
            FormShowParameter showparameter = new FormShowParameter();
            showparameter.setFormId("unit_httpdetailtree");
            showparameter.setCustomParam("context", this.getModel().getValue("jmxcontext"));
            showparameter.setCustomParam("datasourcecontext", this.getModel().getValue("datasourcecontent"));
            showparameter.setCustomParam("caseNumber", this.getModel().getValue(TXT_NUMBER));
            showparameter.setCustomParam("jmxLocation", this.getModel().getValue(JMX_LOACTION));
            showparameter.setCustomParam("casenumber", this.getModel().getValue(TXT_NUMBER));
            showparameter.setCustomParam("pkID", this.getModel().getDataEntityType().getPrimaryKey().getValueFast((Object)this.getModel().getDataEntity()));
            showparameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showparameter);
        } else if (c.getKey().equals(IMPORT_DATA_SOURCE)) {
            if (!this.isSave()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u4fdd\u5b58\u4e0d\u80fd\u5bfc\u5165\u6570\u636e", (String)UNIT_TEST_DETAIL_PLUGIN_1, (String)"bos-unittest", (Object[])new Object[0]));
                return;
            }
            UploadOption uploadOption = new UploadOption();
            uploadOption.setMultiple(false);
            uploadOption.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u6570\u636e\u6e90", (String)"UnitTestDetailPlugin_2", (String)"bos-unittest", (Object[])new Object[0]));
            uploadOption.setSuffix(".xlsx");
            this.getView().showUpload(uploadOption, DATA_SOURCE_BUTTON_AP);
        } else if (RESPONSERS_KEY.equalsIgnoreCase(c.getKey())) {
            ListShowParameter para = ShowFormHelper.createShowListForm((String)USER_KEY, (boolean)true);
            CloseCallBack callback = new CloseCallBack((IFormPlugin)this, RESPONSERS_KEY);
            para.setCloseCallBack(callback);
            this.getView().showForm((FormShowParameter)para);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("save".equals(afterDoOperationEventArgs.getOperateKey())) {
            String frameChose = (String)this.getModel().getValue(FRAME_CHOSE);
            if (afterDoOperationEventArgs.getOperationResult().isSuccess() && (StringUtils.isBlank((CharSequence)frameChose) || "0".equals(frameChose))) {
                String number = this.getObjectFormNumber();
                String modelType = null;
                if (number != null && !number.isEmpty()) {
                    modelType = this.getFormModelType(number);
                }
                if (!(modelType == null || modelType.isEmpty() || this.isDynamicFormModel(modelType) || this.hasRegisterListCase(number))) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_register");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61(", (String)"UnitTestDetailPlugin_3", (String)"bos-unittest", (Object[])new Object[0]) + number + ResManager.loadKDString((String)")\u8fd8\u6ca1\u6709\u6ce8\u518c\u5217\u8868\u7528\u4f8b\uff0c\u662f\u5426\u6ce8\u518c\uff1f", (String)"UnitTestDetailPlugin_4", (String)"bos-unittest", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
                } else {
                    this.getView().close();
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        BillView formView = (BillView)evt.getSource();
        if ("intoApp_callback".equals(evt.getCallBackId())) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                String appId = (String)this.getModel().getValue(BIZ_APP_ID_ID);
                this.changeAppEnv(appId);
                BusinessDataServiceHelper.save((IDataEntityType)this.getModel().getDataEntityType(), (Object[])new Object[]{this.getModel().getDataEntity()});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"UnitTestDetailPlugin_5", (String)"bos-unittest", (Object[])new Object[0]));
                DirtyManager manager = new DirtyManager((AbstractFormDataModel)this.getModel());
                manager.setBizChanged(false);
            }
        } else if (evt.getResult() == MessageBoxResult.Yes) {
            String number = (String)this.getModel().getValue(TXT_NUMBER);
            ILocaleString lName = (ILocaleString)this.getModel().getValue("multi_txt_name");
            formView.invokeOperation("copy");
            this.getModel().setValue(TXT_NUMBER, (Object)(number + "_list"));
            this.getModel().setValue("multi_txt_name", (Object)(lName.getLocaleValue() + ResManager.loadKDString((String)"_\u5217\u8868", (String)"UnitTestDetailPlugin_6", (String)"bos-unittest", (Object[])new Object[0])));
            this.getModel().setValue(KEY_TXT_PARAM, (Object)"");
            this.getModel().setValue(KEY_TXT_TEST_PLUGIN, (Object)"");
            this.getModel().setValue(C_BOX_TYPE, (Object)0);
        } else {
            formView.close();
        }
    }

    private void changeAppEnv(String appId) {
        Map<String, Object> map = UnitTestDao.getPrepareEnvStartCase(appId);
        String caseId = (String)map.get("caseId");
        Object[] saveParams = new Object[]{new SqlParameter("FPREPAREINDEX", 12, (Object)" "), new SqlParameter("fid", 12, (Object)caseId)};
        String sql = "update t_bas_unittestdetail_a set FPREPAREINDEX = ?  WHERE fid =?";
        try (TXHandle h = TX.required();){
            DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])saveParams);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String appId;
        Object action = this.getModel().getValue(FRAME_CHOSE);
        if ("save".equals(((AbstractOperate)beforeDoOperationEventArgs.getSource()).getType()) && StringUtils.isNotBlank((CharSequence)(appId = (String)this.getModel().getValue(BIZ_APP_ID_ID)))) {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)this.getModel().getValue(PREPARE_INDEX))) && "1".equals(action)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u811a\u672c\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"UnitTestDetailPlugin_7", (String)"bos-unittest", (Object[])new Object[0]));
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getModel().getValue(PREPARE_INDEX))) && "0".equals(this.getModel().getValue(PREPARE_INDEX)) && this.checkHasAppEnv(appId, (String)this.getModel().getValue(TXT_NUMBER))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8fdb\u5165\u5e94\u7528\uff0c\u662f\u5426\u6539\u53d8", (String)"UnitTestDetailPlugin_8", (String)"bos-unittest", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("intoApp_callback"));
                beforeDoOperationEventArgs.setCancel(true);
            }
        }
    }

    private boolean checkHasAppEnv(String appId, String caseId) {
        Map<String, Object> map = UnitTestDao.getPrepareEnvStartCase(appId);
        return map != null && !map.isEmpty() && !map.get("casenumber").equals(caseId);
    }

    private void setDefineParams() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(IDE_DEFINE_PARAMS);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String sParams = (String)this.getModel().getValue(KEY_TXT_PARAM);
        Map mapParams = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)sParams)) {
            mapParams = (Map)SerializationUtils.fromJsonString((String)sParams, Map.class);
        }
        showParameter.setCustomParam("params", mapParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, IDE_DEFINE_PARAMS);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void setUnitTestPlugins() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(IDE_PLUGINS);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String sTestPlugins = (String)this.getModel().getValue(KEY_TXT_TEST_PLUGIN);
        Map mapTestPlugins = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)sTestPlugins)) {
            mapTestPlugins = (Map)SerializationUtils.fromJsonString((String)sTestPlugins, Map.class);
        }
        showParameter.setCustomParams(mapTestPlugins);
        showParameter.setCustomParam("scriptfiltertype", (Object)"unittest");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, IDE_PLUGINS);
        showParameter.setCloseCallBack(closeCallBack);
        String formId = (String)this.getModel().getValue("txt_object_id");
        if (formId == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u586b\u5199\u4e1a\u52a1\u5bf9\u8c61", (String)"UnitTestDetailPlugin_9", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        showParameter.setCustomParam("formId", (Object)formId);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (IDE_DEFINE_PARAMS.equals(e.getActionId())) {
            Map ret = (Map)e.getReturnData();
            String sRet = "";
            if (ret != null) {
                sRet = SerializationUtils.toJsonString((Object)ret);
                this.getModel().setValue(KEY_TXT_PARAM, (Object)sRet);
            }
        } else if (IDE_PLUGINS.equals(e.getActionId())) {
            Map ret = (Map)e.getReturnData();
            String sRet = "";
            if (ret != null) {
                if (((ArrayList)ret.get("value")).size() > 0) {
                    sRet = SerializationUtils.toJsonString((Object)ret);
                    this.getModel().setValue(KEY_TXT_TEST_PLUGIN, (Object)sRet);
                } else {
                    this.getModel().setValue(KEY_TXT_TEST_PLUGIN, (Object)"");
                }
            }
        } else if (RESPONSERS_KEY.equalsIgnoreCase(e.getActionId())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            StringBuilder responsers = new StringBuilder();
            for (ListSelectedRow row : rows) {
                responsers.append(row.getName()).append(' ');
            }
            responsers = new StringBuilder(responsers.toString().trim());
            this.getModel().setValue(RESPONSERS_KEY, (Object)responsers.toString());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(TXT_OBJECT)) {
            Map<String, Object> mapAppInfo = this.getAppInfo(this.getModel().getValue("txt_object_Id").toString());
            if (StringUtils.isBlank((Object)this.getModel().getValue(BIZ_APP_ID)) && StringUtils.isBlank((Object)this.getModel().getValue(BIZ_UNIT_ID))) {
                this.getModel().setValue(BIZ_APP_ID, mapAppInfo.get(APP_ID));
                this.getModel().setValue(BIZ_UNIT_ID, mapAppInfo.get(UNIT_ID));
            }
            String form = null;
            Object object = this.getModel().getValue(TXT_OBJECT);
            if (object != null) {
                form = ((DynamicObject)object).getString(NUMBER);
            }
            String modelType = "";
            if (form != null && !form.isEmpty()) {
                modelType = this.getFormModelType(form);
            }
            this.refreshComboxCaseReleaseType((String)mapAppInfo.get(MODEL_TYPE), form);
            String listForm = this.getListForm(form);
            if (listForm != null) {
                this.getModel().setValue(TXT_FORM_LIST, (Object)listForm);
            }
            if (this.isDynamicFormModel(modelType) || this.isMobileFormModel(modelType)) {
                this.getModel().setValue(TXT_FORM_LIST, (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{TXT_FORM_LIST});
                this.getModel().setValue(C_BOX_TYPE, (Object)"1");
            } else {
                String type = this.getModel().getValue(C_BOX_TYPE).toString();
                if ("1".equals(type)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{TXT_FORM_LIST});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{TXT_FORM_LIST});
                }
            }
        } else if (e.getProperty().getName().equals(C_BOX_TYPE)) {
            this.refreshFormList();
        } else if (e.getProperty().getName().equals(FRAME_CHOSE)) {
            if ("1".equals(e.getChangeSet()[0].getNewValue())) {
                this.showHttpFrameView();
            } else {
                this.showCaseFrameView();
            }
        } else if (e.getProperty().getName().equals(BIZ_APP_ID) && this.getModel().getValue(FRAME_CHOSE) != null && "1".equals(this.getModel().getValue(FRAME_CHOSE))) {
            String unitId = this.getMainPageUnitId((String)this.getModel().getValue(BIZ_APP_ID_ID));
            this.getModel().setValue(BIZ_UNIT_ID, (Object)unitId);
        }
    }

    private String getListForm(String number) {
        FormConfig cnf;
        String listForm = null;
        if (number != null && (cnf = FormMetadataCache.getListFormConfig((String)number)) != null) {
            listForm = cnf.getListFormId();
        }
        return listForm;
    }

    private void refreshFormListNumber() {
        String modelType = "";
        String form = null;
        Object object = this.getModel().getValue(TXT_OBJECT);
        if (object != null && (form = ((DynamicObject)object).getString(NUMBER)) != null && !form.isEmpty()) {
            modelType = this.getFormModelType(form);
        }
        this.refreshComboxCaseReleaseType(modelType, form);
        this.refreshFormList();
    }

    private String getObjectFormNumber() {
        String form = null;
        Object object = this.getModel().getValue(TXT_OBJECT);
        if (object != null) {
            form = ((DynamicObject)object).getString(NUMBER);
        }
        return form;
    }

    private String getModelType() {
        String modelType = "";
        String form = null;
        Object object = this.getModel().getValue(TXT_OBJECT);
        if (object != null && (form = ((DynamicObject)object).getString(NUMBER)) != null && !form.isEmpty()) {
            modelType = this.getFormModelType(form);
        }
        return modelType;
    }

    private void refreshFormList() {
        String type = this.getModel().getValue(C_BOX_TYPE).toString();
        String list = this.getModel().getValue(TXT_FORM_LIST).toString();
        String modelType = this.getModelType();
        this.hideQueryListTextEdit();
        if ("0".equals(type)) {
            if (!"".equals(list) && !list.contains("mob")) {
                this.getModel().setValue(TXT_FORM_LIST, (Object)list);
            } else {
                this.getModel().setValue(TXT_FORM_LIST, (Object)"bos_list");
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{TXT_FORM_LIST});
            if ("QueryListModel".equals(modelType)) {
                this.showQueryListTextEdit();
            }
        } else if ("2".equals(type)) {
            if (!"".equals(list) && list.contains("mob")) {
                this.getModel().setValue(TXT_FORM_LIST, (Object)list);
            } else {
                this.getModel().setValue(TXT_FORM_LIST, (Object)"bos_moblist");
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{TXT_FORM_LIST});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TXT_FORM_LIST});
        }
        if (modelType == null) {
            return;
        }
        if (this.isDynamicFormModel(modelType) || this.isMobileFormModel(modelType)) {
            this.getModel().setValue(TXT_FORM_LIST, (Object)"");
            this.getView().setVisible(Boolean.FALSE, new String[]{TXT_FORM_LIST});
        }
    }

    private void hideQueryListTextEdit() {
        this.getView().setVisible(Boolean.FALSE, new String[]{QUERY_LIST_NUMBER});
    }

    private void showQueryListTextEdit() {
        this.getView().setVisible(Boolean.TRUE, new String[]{QUERY_LIST_NUMBER});
    }

    private boolean isDynamicFormModel(String modelType) {
        return modelType.equals(DYNAMIC_FORM_MODEL) || "ReportFormModel".equals(modelType);
    }

    private boolean isMobileFormModel(String modelType) {
        return "MobileFormModel".equals(modelType);
    }

    private void refreshComboxCaseReleaseType(String modelType, String form) {
        ComboEdit cbx = (ComboEdit)this.getView().getControl(C_BOX_TYPE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        ComboItem formItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8868\u5355", (String)UNIT_TEST_DETAIL_PLUGIN_10, (String)"bos-unittest", (Object[])new Object[0])), "1");
        if (form != null && !form.isEmpty()) {
            ComboItem listItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"UnitTestDetailPlugin_11", (String)"bos-unittest", (Object[])new Object[0])), "0");
            if (modelType.equals(DYNAMIC_FORM_MODEL)) {
                items.add(formItem);
                items.add(listItem);
            } else if ("ReportFormModel".equals(modelType) || this.isMobileFormModel(modelType)) {
                items.add(formItem);
            } else if ("QueryListModel".equals(modelType)) {
                items.add(listItem);
            } else {
                items.add(listItem);
                items.add(formItem);
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u5217\u8868", (String)"UnitTestDetailPlugin_12", (String)"bos-unittest", (Object[])new Object[0])), "2"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355", (String)"UnitTestDetailPlugin_13", (String)"bos-unittest", (Object[])new Object[0])), "3"));
            }
        } else {
            items.add(formItem);
        }
        cbx.setComboItems(items);
    }

    private String getFormModelType(String formId) {
        ORM orm = ORM.create();
        String selectFields = "id,modeltype";
        QFilter q1 = new QFilter(NUMBER, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{q1};
        DynamicObject ds = orm.queryOne("bos_entityobject", selectFields, filters);
        String modelType = ds.getString(MODEL_TYPE);
        return modelType;
    }

    private boolean hasRegisterListCase(String formid) {
        ORM orm = ORM.create();
        String selectFields = "id";
        QFilter q1 = new QFilter(TXT_OBJECT, "=", (Object)formid);
        QFilter q2 = new QFilter(C_BOX_TYPE, "=", (Object)"0");
        QFilter[] filters = new QFilter[]{q1, q2};
        DynamicObject ds = orm.queryOne("ide_unit_test_detail", selectFields, filters);
        return ds != null;
    }

    private void autoCreateListCase() {
        ORM orm = ORM.create();
        DynamicObject dy = this.getModel().getDataEntity();
        orm.insert(dy);
    }

    private Map<String, Object> getAppInfo(String number) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number)};
        String sql = "select a.fbizappid,fbizunitid,b.fmodeltype from t_meta_bizunitrelform a LEFT JOIN t_meta_formdesign b on a.fformid = b.fid where b.fnumber = ?";
        try {
            Map obRet = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

                public Map<String, Object> handle(ResultSet rs) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (rs.next()) {
                        map.put(UnitTestDetailPlugin.APP_ID, rs.getObject(1));
                        map.put(UnitTestDetailPlugin.UNIT_ID, rs.getObject(2));
                        map.put(UnitTestDetailPlugin.MODEL_TYPE, rs.getObject(3));
                    }
                    return map;
                }
            });
            return obRet;
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    private String getMainPageUnitId(String appId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FBIZAPPID", 12, (Object)appId)};
        String sql = "select FID from t_meta_bizunit where FNUMBER='MainPage' and FBIZAPPID=?";
        try {
            String obRet = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws SQLException {
                    if (rs.next()) {
                        return rs.getString(1);
                    }
                    return "";
                }
            });
            return obRet;
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public void upload(UploadEvent evt) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        if (((Control)evt.getSource()).getKey().equals(BUTTON_AP)) {
            Map map = (Map)evt.getUrls()[0];
            String url = (String)map.get("url");
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            if (StringUtils.isEmpty((CharSequence)url)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25,\u8bf7\u91cd\u65b0\u4e0a\u4f20", (String)"UnitTestDetailPlugin_14", (String)"bos-unittest", (Object[])new Object[0]));
                return;
            }
            fileService.download(url, (OutputStream)outStream, "httpclient");
            ByteArrayInputStream input = new ByteArrayInputStream(outStream.toByteArray());
            HashMap<String, Object> resultMap = JMXForAnalysis.analysisJMXFile(input);
            if (resultMap.isEmpty()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u89e3\u6790\u4e3a\u7a7a,\u8bf7\u786e\u8ba4:\r\n1.\u8be5\u6587\u4ef6\u4e3a\u7a7a\r\n2.\u8be5\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e", (String)"UnitTestDetailPlugin_15", (String)"bos-unittest", (Object[])new Object[0]));
            } else if (((Boolean)resultMap.get("status")).booleanValue()) {
                String context = resultMap.get("result").toString();
                String temp = "";
                try {
                    temp = URLEncoder.encode(context, "UTF-8");
                    this.getModel().setValue("jmxcontext", (Object)temp);
                }
                catch (UnsupportedEncodingException e) {
                    log.info(e.getMessage());
                }
                this.getModel().setValue(JMX_LOACTION, map.get("name"));
            } else {
                this.getView().showMessage((String)resultMap.get("result"));
            }
        } else if (((Control)evt.getSource()).getKey().equals(DATA_SOURCE_BUTTON_AP)) {
            Map map = (Map)evt.getUrls()[0];
            String url = (String)map.get("url");
            this.getModel().setValue(IMPORT_DATA_SOURCE, map.get("name"));
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            fileService.download(url, (OutputStream)outStream, "httpclient");
            ByteArrayInputStream input = new ByteArrayInputStream(outStream.toByteArray());
            ImportExcelDataList excelResolver = ImportExcelDataList.getImportExcelDataListSingleInstance();
            HashMap<String, List<ExcelDataObject>> resultMap = excelResolver.analsisExcelData(input, (String)map.get("name"));
            this.getModel().setValue("datasourcecontent", (Object)SerializationUtils.toJsonString(resultMap));
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map appAndUnitId;
        String appid = (String)this.getView().getFormShowParameter().getCustomParam(APP_ID);
        String appunitid = (String)this.getView().getFormShowParameter().getCustomParam(APP_ID);
        this.getModel().setValue(BIZ_APP_ID, (Object)appid);
        this.getModel().setValue(BIZ_UNIT_ID, (Object)appunitid);
        this.getView().setVisible(Boolean.FALSE, new String[]{"responser"});
        if (StringUtils.isBlank((Object)this.getModel().getValue(RESPONSERS_KEY)) && (appAndUnitId = (Map)this.getView().getFormShowParameter().getCustomParam("appinfo")) != null) {
            String responsers = UnitTestWorkHelper.getAppSetResponser((String)appAndUnitId.get(APP_ID));
            this.getModel().setValue(RESPONSERS_KEY, (Object)responsers);
        }
    }

    public UnitTestService getUnitTestService() {
        return (UnitTestService)ServiceFactory.getService(UnitTestService.class);
    }

    private boolean isSave() {
        String pkId = (String)this.getModel().getDataEntityType().getPrimaryKey().getValueFast((Object)this.getModel().getDataEntity());
        return !StringUtils.isBlank((CharSequence)pkId);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("isNeedRefresh", "false");
        e.setCheckDataChange(false);
        this.getView().returnDataToParent(returnData);
    }
}

