/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.designer.unittest.UnitTestTreeListCloudAppUnitHelper;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class UnitTestDetailTreeListPlugin
extends StandardTreeListPlugin {
    public static final String ROOT_NODE_ID = "977bd9f8-ae11-4cf6-bd66-8e24a401cafb";
    private static final int NODE_SEARCH_LIMIT = 5;

    private static TreeNode loadAllAppNodes() {
        return (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"func", (boolean)true, (boolean)false, (boolean)false);
    }

    public void initializeTree(EventObject e) {
        this.initTree();
        this.getTreeModel().setRoot(UnitTestDetailTreeListPlugin.loadAllAppNodes());
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if ("script".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_return"});
        }
        this.setBarItemEnable(false);
    }

    public void treeNodeClick(TreeNodeEvent nodeEvent) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        super.treeNodeClick(nodeEvent);
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (focusNode == null) {
            return;
        }
        this.getView().getFormShowParameter().setCustomParam("id", focusNode.get("id"));
        this.setTreeBarVisible(false);
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if ("script".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_return"});
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        super.billClosedCallBack(e);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        JSONArray units = new JSONArray();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode current = root.getTreeNode(nodeId, 5);
        String nodeType = (String)current.getData();
        if ("root".equalsIgnoreCase(nodeType)) {
            this.setBarItemEnable(false);
            return;
        }
        if ("cloud".equals(nodeType)) {
            units = UnitTestTreeListCloudAppUnitHelper.getUnitIdsByCloudId(nodeId);
            this.setBarItemEnable(false);
        } else if ("app".equals(nodeType)) {
            units = UnitTestTreeListCloudAppUnitHelper.getUnitsByAppIdNew(nodeId);
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_checkin"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_delete"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_add"});
        } else if ("func".equals(nodeType)) {
            units = UnitTestTreeListCloudAppUnitHelper.getChildrenUnitIdsByParentId(current.getParentid(), nodeId);
            this.setBarItemEnable(true);
        }
        QFilter qFilter = new QFilter("bizunitid", "in", (Object)units);
        e.addQFilter(qFilter);
        e.setCancel(true);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        TreeNode root;
        TreeNode current;
        if (e.getParameter().getBillStatusValue().equals(BillOperationStatus.ADDNEW.ordinal()) && (current = (root = this.getTreeModel().getRoot()).getTreeNode((String)this.getTreeModel().getCurrentNodeId(), 5)) != null) {
            String nodeType = (String)current.getData();
            if ("func".equals(nodeType)) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("appid", current.getParentid());
                info.put("unitid", current.getId());
                e.getParameter().setCustomParam("appinfo", info);
            } else if ("sunit".equals(nodeType)) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("appid", root.getTreeNode(root.getTreeNode(current.getParentid(), 5).getId(), 5).getParentid());
                info.put("unitid", current.getId());
                e.getParameter().setCustomParam("appinfo", info);
            }
        }
        super.beforeShowBill(e);
    }

    private void setBarItemEnable(boolean enabled) {
        this.getView().setEnable(Boolean.valueOf(enabled), new String[]{"btn_add"});
    }

    private void setTreeBarVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btnnew"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btnedit"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btndel"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        TreeNode curentNode = root.getTreeNode(e.getNodeId().toString(), 20);
        e.setChildNodes(curentNode.getChildren());
        super.refreshNode(e);
    }
}

