/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.list.ListView;

public class UnitTestFormWhitePlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener,
IConfirmCallBack {
    public static final String KEY_FORM_OBJECT = "number";
    public static final String KEY_APP = "appid";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initApp();
    }

    private void initApp() {
        Map appAndUnitId = (Map)this.getView().getFormShowParameter().getCustomParam("appinfo");
        if (appAndUnitId != null) {
            this.getModel().setValue(KEY_APP, appAndUnitId.get(KEY_APP));
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_APP});
    }

    public void initialize() {
        this.addClickListeners(new String[]{KEY_FORM_OBJECT});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(KEY_FORM_OBJECT)) {
            String number = this.getModel().getValue("number_Id").toString();
            Map<String, Object> mapAppInfo = this.getAppInfo(number);
            if (StringUtils.isBlank((Object)this.getModel().getValue(KEY_APP))) {
                this.getModel().setValue(KEY_APP, mapAppInfo.get(KEY_APP));
            } else {
                String currentNodeId = (String)((ListView)this.getView().getParentView()).getTreeListView().getTreeModel().getCurrentNodeId();
                if (currentNodeId == null || currentNodeId != null && currentNodeId.equals("977bd9f8-ae11-4cf6-bd66-8e24a401cafb")) {
                    this.getModel().setValue(KEY_APP, mapAppInfo.get(KEY_APP));
                }
            }
            this.getModel().setValue(KEY_FORM_OBJECT, (Object)number);
        }
    }

    private Map<String, Object> getAppInfo(String number) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number)};
        String sql = "select a.fbizappid,fbizunitid,b.fmodeltype from t_meta_bizunitrelform a LEFT JOIN t_meta_formdesign b on a.fformid = b.fid where b.fnumber = ?";
        try {
            Map obRet = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

                public Map<String, Object> handle(ResultSet rs) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (rs.next()) {
                        map.put(UnitTestFormWhitePlugin.KEY_APP, rs.getObject(1));
                        map.put("unitid", rs.getObject(2));
                        map.put("modeltype", rs.getObject(3));
                    }
                    return map;
                }
            });
            return obRet;
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }
}

