/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.unittest.UnitTestTreeListCloudAppUnitHelper;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;

public class UnitTestFormWhiteTreeListPlugin
extends StandardTreeListPlugin {
    public static final String ROOT_NODE_ID = "5bfd3b83-1a68-45b0-b451-4d5edd8f5a6d";
    private static final String TREE_NODES_CACHE_UUID = "8801c52e-5d20-4483-8b05-2ac6337b683d";
    private static final int NODE_SEARCH_LIMIT = 5;

    public static void setCacheTreeNodes(AbstractFormPlugin plugin, String cacheKey, TreeNode treeNode) {
        String json = SerializationUtils.toJsonString((Object)treeNode);
        plugin.getPageCache().put(cacheKey, json);
    }

    private static TreeNode loadAllAppNodes() {
        TreeNode root = new TreeNode();
        JSONObject map = new JSONObject();
        map.put("type", (Object)"root");
        root.setData((Object)map);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"UnitTestFormWhiteTreeListPlugin_0", (String)"bos-unittest", (Object[])new Object[0]));
        root.setParentid("");
        root.setId(ROOT_NODE_ID);
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = UnitTestTreeListCloudAppUnitHelper.getAllCloudNodes();
        for (TreeNode cloudNode : cloudNodes) {
            List<TreeNode> appNodes = UnitTestTreeListCloudAppUnitHelper.getAppsByCloudId(cloudNode.getId());
            if (appNodes.size() <= 0) continue;
            cloudNode.addChildren(appNodes);
        }
        if (cloudNodes.size() > 0) {
            root.setChildren(cloudNodes);
        }
        return root;
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void initializeTree(EventObject e) {
        this.initTree();
        this.getTreeModel().setRoot(UnitTestFormWhiteTreeListPlugin.loadAllAppNodes());
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if ("script".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_return"});
        }
        this.setBarItemEnable(false);
    }

    public void treeNodeClick(TreeNodeEvent nodeEvent) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        super.treeNodeClick(nodeEvent);
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (focusNode == null) {
            return;
        }
        this.getView().getFormShowParameter().setCustomParam("id", focusNode.get("id"));
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if ("script".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_return"});
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        super.billClosedCallBack(e);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        if (nodeId.equalsIgnoreCase(ROOT_NODE_ID)) {
            this.setBarItemEnable(false);
            return;
        }
        JSONArray appids = new JSONArray();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode current = root.getTreeNode(nodeId, 5);
        Map nodeData = (Map)current.getData();
        String nodeType = (String)nodeData.get("type");
        if ("cloud".equals(nodeType)) {
            appids = UnitTestTreeListCloudAppUnitHelper.getAppIdsByCloudId(nodeId);
            this.setBarItemEnable(false);
        } else if ("app".equals(nodeType)) {
            appids.add((Object)nodeId);
            this.setBarItemEnable(true);
        }
        QFilter qFilter = new QFilter("appid", "in", (Object)appids);
        e.addQFilter(qFilter);
        e.setCancel(true);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (e.getParameter().getBillStatusValue().equals(BillOperationStatus.ADDNEW.ordinal())) {
            String nodeType;
            TreeNode root = this.getTreeModel().getRoot();
            TreeNode current = root.getTreeNode((String)this.getTreeModel().getCurrentNodeId(), 5);
            if (current == null) {
                return;
            }
            Map nodeData = (Map)current.getData();
            if (nodeData != null && "app".equals(nodeType = (String)nodeData.get("type"))) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("appid", current.getId());
                e.getParameter().setCustomParam("appinfo", info);
            }
        }
        super.beforeShowBill(e);
    }

    private void setBarItemEnable(boolean enabled) {
        this.getView().setEnable(Boolean.valueOf(enabled), new String[]{"lstcheckin"});
        this.getView().setEnable(Boolean.valueOf(enabled), new String[]{"lstdel"});
        this.getView().setEnable(Boolean.valueOf(enabled), new String[]{"lstadd"});
    }
}

