/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.unittest.AssertController;
import kd.bos.form.unittest.ExcelDataObject;
import kd.bos.form.unittest.JMXForAnalysis;
import kd.bos.form.unittest.JmeterSrcForResponseAssertion;
import kd.bos.form.unittest.RegularController;
import kd.bos.form.unittest.UnitTestCase;
import kd.bos.form.unittest.UnitTestGroup;
import kd.bos.form.unittest.UnitTestHttpProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.unittest.UnitTestService;
import kd.bos.mvc.cache.PageCache;
import kd.bos.service.ServiceFactory;
import kd.bos.upload.UploadOption;

public class UnitTestHTTPTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
UploadListener,
IDataModelChangeListener {
    private static final String TREE_VIEW = "treeview";
    private static final String IMPORT_DATA_SOURCE = "importdatasource";
    private static final String HTTP_PROXY_NODE = "httpProxyNode";
    private static final String ASSERT_CONTROLLER = "assertController";
    private static final String REGULAR_CONTROLLER = "regularController";
    private static final String UNIT_TEST_HTTP_TREE_PLUGIN_0 = "UnitTestHTTPTreePlugin_0";
    private static final String CURRENT_NODE_ID = "currentNodeId";
    private static final String MESSAGE = "message";
    private static final String GROU_PNAME = "groupname";
    private static final String CASE_NAME = "casename";
    private static final String METHOD = "method";
    private static final String PARAMS_ENTRY_ENTITY = "paramsentryentity";
    private static final String DATA_SROUCE_ENTRY = "datasrouceentry";
    private static final String REGULAR_ENTRY_ENTITY = "regularentryentity";
    private static final String ASSERT_ENTRY_ENTITY = "assertentryentity";
    private static final String ASSERTION_TEST_TYPE = "assertion_test_type";
    private static final String ASSERT_FIELD = "assertfield";
    private static final String TEXT_FIELD = "textfield";
    private UnitTestService unitTestService;
    private static final String KEY_ENTRY_TEST_RESULT = "entryresult";
    private IPageCache pageCache;
    private static final Log log = LogFactory.getLog(UnitTestHTTPTreePlugin.class);

    public void initialize() {
        super.initialize();
    }

    private void init() {
        this.showRootDetail();
    }

    private boolean isSave() {
        String pkId = (String)this.getView().getFormShowParameter().getCustomParam("pkID");
        return !StringUtils.isBlank((CharSequence)pkId);
    }

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        this.addClickListeners(new String[]{"buttonap"});
        Button btn = (Button)this.getControl(IMPORT_DATA_SOURCE);
        btn.addUploadListener((UploadListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"datasave", "enable", "disable"});
        this.getModel().addDataModelChangeListener((IDataModelChangeListener)this);
    }

    private void disable() {
        String currentNodeId = this.getCurrentNodeId();
        TreeNode root = this.getRoot();
        if (root == null) {
            throw new KDException(BosErrorCode.systemError, new Object[0]);
        }
        TreeNode currentNode = root.getTreeNode(currentNodeId, 20);
        String type = currentNodeId.split("_")[0];
        if (HTTP_PROXY_NODE.equals(type) || ASSERT_CONTROLLER.equals(type) || REGULAR_CONTROLLER.equals(type)) {
            currentNode.setText(ResManager.loadKDString((String)"(\u7981)", (String)UNIT_TEST_HTTP_TREE_PLUGIN_0, (String)"bos-unittest", (Object[])new Object[0]) + currentNode.getText());
            this.getTreeView().updateNode(currentNode);
            this.updateRootNode(root);
        }
    }

    private void enable() {
        String currentNodeId = this.getCurrentNodeId();
        TreeNode root = this.getRoot();
        if (root == null) {
            throw new KDException(BosErrorCode.systemError, new Object[0]);
        }
        TreeNode currentNode = root.getTreeNode(currentNodeId, 20);
        if (currentNode.getText().contains(ResManager.loadKDString((String)"(\u7981)", (String)UNIT_TEST_HTTP_TREE_PLUGIN_0, (String)"bos-unittest", (Object[])new Object[0]))) {
            currentNode.setText(currentNode.getText().substring(3, currentNode.getText().length()));
            this.getTreeView().updateNode(currentNode);
            this.updateRootNode(root);
        }
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("buttonap".equals(controlKey)) {
            if (!this.isSave()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u4fdd\u5b58\u4e0d\u80fd\u8bd5\u8dd1", (String)"UnitTestHTTPTreePlugin_1", (String)"bos-unittest", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParamter = this.getView().getFormShowParameter();
            String codeNumber = (String)formShowParamter.getCustomParam("caseNumber");
            if (codeNumber == null || "".equals(codeNumber)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7528\u4f8b\u7f16\u7801\u4e3a\u7a7a", (String)"UnitTestHTTPTreePlugin_2", (String)"bos-unittest", (Object[])new Object[0]));
                return;
            }
            this.doTestCase(codeNumber);
            TreeNode root = this.getRoot();
            ((TreeView)this.getView().getControl(TREE_VIEW)).focusNode(root);
            this.rightShow(root);
        } else if ("disable".equals(controlKey)) {
            this.disable();
        } else if ("enable".equals(controlKey)) {
            this.enable();
        } else if (controlKey.equals(IMPORT_DATA_SOURCE)) {
            if (!this.isSave()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u4fdd\u5b58\u4e0d\u80fd\u5bfc\u5165\u6570\u636e", (String)"UnitTestHTTPTreePlugin_3", (String)"bos-unittest", (Object[])new Object[0]));
                return;
            }
            UploadOption uploadOption = new UploadOption();
            uploadOption.setMultiple(false);
            uploadOption.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u6570\u636e\u6e90", (String)"UnitTestHTTPTreePlugin_4", (String)"bos-unittest", (Object[])new Object[0]));
            uploadOption.setSuffix(".xlsx");
            this.getView().showUpload(uploadOption, IMPORT_DATA_SOURCE);
        } else if ("datasave".equals(controlKey)) {
            if (this.isSave()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u5b8c\u6210\u540e\u5173\u95ed\u9875\u9762\uff0c\u7981\u7528\u9879\u5c06\u4f1a\u88ab\u6e05\u9664", (String)"UnitTestHTTPTreePlugin_5", (String)"bos-unittest", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("btnsave", (IFormPlugin)this));
                this.saveData();
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u8fc7\u518d\u4fee\u6539", (String)"UnitTestHTTPTreePlugin_6", (String)"bos-unittest", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.saveData();
        }
    }

    private boolean isDisable(String name) {
        return StringUtils.isNotBlank((CharSequence)name) && name.contains(ResManager.loadKDString((String)"(\u7981)", (String)UNIT_TEST_HTTP_TREE_PLUGIN_0, (String)"bos-unittest", (Object[])new Object[0]));
    }

    private void saveData() {
        TreeNode root = this.getRoot();
        String temp = "";
        ArrayList<UnitTestGroup> testGroupList = new ArrayList<UnitTestGroup>(10);
        List childNodes = root.getChildren();
        for (TreeNode groupNode : childNodes) {
            UnitTestGroup tempGroup = (UnitTestGroup)SerializationUtils.fromJsonString((String)groupNode.getData().toString(), UnitTestGroup.class);
            ArrayList<UnitTestCase> tempList = new ArrayList<UnitTestCase>(10);
            for (TreeNode unitTestCaseNode : groupNode.getChildren()) {
                UnitTestCase unitTestCase = (UnitTestCase)SerializationUtils.fromJsonString((String)unitTestCaseNode.getData().toString(), UnitTestCase.class);
                ArrayList<UnitTestHttpProxy> tempHttpList = new ArrayList<UnitTestHttpProxy>(10);
                for (TreeNode httpProxyNode : unitTestCaseNode.getChildren()) {
                    UnitTestHttpProxy httpProxy = (UnitTestHttpProxy)SerializationUtils.fromJsonString((String)httpProxyNode.getData().toString(), UnitTestHttpProxy.class);
                    if (this.isDisable(httpProxyNode.getText())) continue;
                    ArrayList<RegularController> regularList = new ArrayList<RegularController>(10);
                    ArrayList<AssertController> assertList = new ArrayList<AssertController>(10);
                    if (httpProxyNode.getChildren() != null) {
                        for (TreeNode regularControllerNode : httpProxyNode.getChildren()) {
                            RegularController regularController = (RegularController)SerializationUtils.fromJsonString((String)regularControllerNode.getData().toString(), RegularController.class);
                            if (this.isDisable(regularControllerNode.getText()) || !REGULAR_CONTROLLER.equals(regularControllerNode.getId().split("_")[0])) continue;
                            regularList.add(regularController);
                        }
                        for (TreeNode assertControllerNode : httpProxyNode.getChildren()) {
                            AssertController assertController = (AssertController)SerializationUtils.fromJsonString((String)assertControllerNode.getData().toString(), AssertController.class);
                            if (this.isDisable(assertControllerNode.getText()) || !ASSERT_CONTROLLER.equals(assertControllerNode.getId().split("_")[0])) continue;
                            assertList.add(assertController);
                        }
                    }
                    if (!regularList.isEmpty()) {
                        httpProxy.setRegularController(regularList);
                    } else {
                        httpProxy.setRegularController(null);
                    }
                    if (!assertList.isEmpty()) {
                        httpProxy.setAssertController(assertList);
                    } else {
                        httpProxy.setAssertController(null);
                    }
                    tempHttpList.add(httpProxy);
                }
                unitTestCase.setUnitTestHttpProxys(tempHttpList);
                tempList.add(unitTestCase);
            }
            tempGroup.setUnitTestCases(tempList);
            testGroupList.add(tempGroup);
        }
        String finalData = SerializationUtils.toJsonString(testGroupList);
        try {
            temp = URLEncoder.encode(finalData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.info(e.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)temp)) {
            this.saveData(temp);
        }
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl(TREE_VIEW);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParamter = this.getView().getFormShowParameter();
        String contextTemp = (String)formShowParamter.getCustomParam("context");
        String jmxLocation = (String)formShowParamter.getCustomParam("jmxLocation");
        String casenumber = (String)formShowParamter.getCustomParam("casenumber");
        String context = "";
        try {
            context = URLDecoder.decode(contextTemp, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.info(e1.getMessage());
        }
        this.getModel().setValue("jmxlocation", (Object)jmxLocation);
        this.getModel().setValue("casenumber", (Object)casenumber);
        Object result = JMXForAnalysis.jsonToUnitTestGroupBean(context).get("result");
        if (result == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u89e3\u6790\u4e0d\u6210\u529f", (String)"UnitTestHTTPTreePlugin_7", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        if (!(result instanceof List)) {
            this.getView().showMessage((String)result);
            return;
        }
        List testGroupList = (List)result;
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"UnitTestHTTPTreePlugin_8", (String)"bos-unittest", (Object[])new Object[0]));
        root.setExpend(true);
        root.setIsOpened(true);
        root.setId("root_" + this.getUUID());
        root.setData((Object)testGroupList);
        for (UnitTestGroup unitTestGroup : testGroupList) {
            TreeNode groupNode = new TreeNode();
            groupNode.setText(unitTestGroup.getName());
            groupNode.setId("groupNode_" + this.getUUID());
            groupNode.setData((Object)SerializationUtils.toJsonString((Object)unitTestGroup));
            for (UnitTestCase unitTestCase : unitTestGroup.getUnitTestCases()) {
                unitTestCase.setParentGroupName(unitTestGroup.getName());
                TreeNode unitCaseNode = new TreeNode();
                unitCaseNode.setText(unitTestCase.getName());
                unitCaseNode.setId("caseNode_" + this.getUUID());
                unitCaseNode.setData((Object)SerializationUtils.toJsonString((Object)unitTestCase));
                if (unitTestCase.getUnitTestHttpProxys() != null) {
                    for (UnitTestHttpProxy unitTestHTTPProxy : unitTestCase.getUnitTestHttpProxys()) {
                        TreeNode unitHTTPProxyNode = new TreeNode();
                        unitHTTPProxyNode.setText(unitTestHTTPProxy.getName());
                        unitHTTPProxyNode.setId("httpProxyNode_" + this.getUUID());
                        unitHTTPProxyNode.setData((Object)SerializationUtils.toJsonString((Object)unitTestHTTPProxy));
                        if (unitTestHTTPProxy.getAssertController() != null) {
                            for (AssertController assertController : unitTestHTTPProxy.getAssertController()) {
                                TreeNode assertNode = new TreeNode();
                                assertNode.setText(ResManager.loadKDString((String)"\u54cd\u5e94\u65ad\u8a00", (String)"UnitTestHTTPTreePlugin_9", (String)"bos-unittest", (Object[])new Object[0]));
                                assertNode.setId("assertController_" + this.getUUID());
                                assertNode.setData((Object)SerializationUtils.toJsonString((Object)assertController));
                                unitHTTPProxyNode.addChild(assertNode);
                            }
                        }
                        if (unitTestHTTPProxy.getRegularController() != null) {
                            for (RegularController regularController : unitTestHTTPProxy.getRegularController()) {
                                TreeNode regularNode = new TreeNode();
                                regularNode.setText(regularController.getName());
                                regularNode.setId("regularController_" + this.getUUID());
                                regularNode.setData((Object)SerializationUtils.toJsonString((Object)regularController));
                                unitHTTPProxyNode.addChild(regularNode);
                            }
                        }
                        unitCaseNode.addChild(unitHTTPProxyNode);
                    }
                }
                groupNode.addChild(unitCaseNode);
            }
            root.addChild(groupNode);
        }
        treeView.addNode(root);
        treeView.focusNode(root);
        this.rightShow(root);
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
        this.getCache().put(CURRENT_NODE_ID, root.getId());
    }

    private void doTestCase(String testCaseNumber) {
        boolean bCompleted;
        String result = this.getUnitTestService().testByCaseId(testCaseNumber, false);
        List lstMapResult = (List)SerializationUtils.fromJsonString((String)result, List.class);
        Map mapResult = (Map)lstMapResult.get(0);
        boolean issuccess = true;
        StringBuilder message = new StringBuilder();
        List lstCaseResult = (List)mapResult.get("testCaseResults");
        IDataModel model = this.getModel();
        if (!lstCaseResult.isEmpty()) {
            if (lstCaseResult.size() > 0) {
                model.deleteEntryData(KEY_ENTRY_TEST_RESULT);
                model.batchCreateNewEntryRow(KEY_ENTRY_TEST_RESULT, lstCaseResult.size());
            }
            int i = 0;
            for (Map caseResult : lstCaseResult) {
                model.setValue("fucname", mapResult.get("name"), i);
                model.setValue("testcase", caseResult.get("name"), i);
                model.setValue("function", caseResult.get("methodName"), i);
                model.setValue("testinfo", this.getMessageFromResult(caseResult.get(MESSAGE)), i);
                model.setValue("testresult", (Object)ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"UnitTestHTTPTreePlugin_10", (String)"bos-unittest", (Object[])new Object[0]), i);
                if (((String)this.getMessageFromResult(caseResult.get(MESSAGE))).contains(ResManager.loadKDString((String)"\u5931\u8d25\uff08\u8bf7\u70b9\u51fb\u53f3\u4fa7\u67e5\u770b\u8be6\u60c5\uff09\uff1a", (String)"UnitTestHTTPTreePlugin_11", (String)"bos-unittest", (Object[])new Object[0]))) {
                    model.setValue("testresult", (Object)ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25", (String)"UnitTestHTTPTreePlugin_12", (String)"bos-unittest", (Object[])new Object[0]), i);
                    issuccess = false;
                    message.append(ResManager.loadKDString((String)"\u7b2c", (String)"UnitTestHTTPTreePlugin_13", (String)"bos-unittest", (Object[])new Object[0])).append(i + 1).append(ResManager.loadKDString((String)"\u884c\u5b58\u5728\u5931\u8d25\uff01\uff01\uff01\uff01\n", (String)"UnitTestHTTPTreePlugin_14", (String)"bos-unittest", (Object[])new Object[0]));
                }
                model.setValue("testinfo_tag", caseResult.get(MESSAGE), i);
                ++i;
            }
        }
        if (!(bCompleted = ((Boolean)mapResult.get("completed")).booleanValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bd5\u8dd1\u5931\u8d25\uff01\uff01\uff01", (String)"UnitTestHTTPTreePlugin_15", (String)"bos-unittest", (Object[])new Object[0]) + mapResult);
        } else {
            if (issuccess) {
                message = new StringBuilder(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u529f\uff01\uff01\uff01", (String)"UnitTestHTTPTreePlugin_16", (String)"bos-unittest", (Object[])new Object[0]));
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bd5\u8dd1\u5b8c\u6210\uff01\u6267\u884c\u7ed3\u679c\uff1a", (String)"UnitTestHTTPTreePlugin_17", (String)"bos-unittest", (Object[])new Object[0]) + message);
        }
    }

    public UnitTestService getUnitTestService() {
        if (this.unitTestService == null) {
            this.unitTestService = (UnitTestService)ServiceFactory.getService(UnitTestService.class);
        }
        return this.unitTestService;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.expand(nodeId);
        TreeNode root = this.getRoot();
        if (root == null) {
            throw new KDException(BosErrorCode.systemError, new Object[0]);
        }
        TreeNode currentNode = root.getTreeNode(nodeId, 20);
        this.getCache().put(CURRENT_NODE_ID, nodeId);
        this.rightShow(currentNode);
    }

    private String getCurrentNodeId() {
        return this.getCache().get(CURRENT_NODE_ID);
    }

    private void rightShow(TreeNode currentNode) {
        String type = currentNode.getId().split("_")[0];
        String data = "";
        if (currentNode.getData() != null) {
            data = currentNode.getData().toString();
        }
        switch (type) {
            case "root": {
                this.showRootDetail();
                break;
            }
            case "groupNode": {
                this.showGroupDetail(data);
                break;
            }
            case "caseNode": {
                this.showCaseDetail(data);
                break;
            }
            case "httpProxyNode": {
                this.showHTTPProxyDetail(data);
                break;
            }
            case "regularController": {
                this.showRegularDetail(data);
                break;
            }
            case "assertController": {
                this.showAssertDetail(data);
                break;
            }
        }
    }

    private void showRootDetail() {
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENTRY_TEST_RESULT});
        this.getView().setVisible(Boolean.FALSE, new String[]{GROU_PNAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{CASE_NAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{METHOD});
        this.getView().setVisible(Boolean.FALSE, new String[]{PARAMS_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{"path"});
        this.getView().setVisible(Boolean.FALSE, new String[]{IMPORT_DATA_SOURCE});
        this.getView().setVisible(Boolean.FALSE, new String[]{DATA_SROUCE_ENTRY});
        this.getView().setVisible(Boolean.FALSE, new String[]{REGULAR_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{ASSERT_ENTRY_ENTITY});
    }

    private void showGroupDetail(String data) {
        UnitTestGroup unitTestGroup = (UnitTestGroup)SerializationUtils.fromJsonString((String)data, UnitTestGroup.class);
        this.getView().setVisible(Boolean.TRUE, new String[]{GROU_PNAME});
        String[] tempArray = unitTestGroup.getName().split(":");
        if (tempArray.length != 2) {
            this.getView().showMessage(unitTestGroup.getName() + ResManager.loadKDString((String)" jmx\u683c\u5f0f\u4e0d\u5bf9", (String)"UnitTestHTTPTreePlugin_18", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        String groupName = tempArray[1];
        this.getModel().setValue(GROU_PNAME, (Object)groupName);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENTRY_TEST_RESULT});
        this.getView().setVisible(Boolean.FALSE, new String[]{CASE_NAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{METHOD});
        this.getView().setVisible(Boolean.FALSE, new String[]{PARAMS_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{"path"});
        this.getView().setVisible(Boolean.FALSE, new String[]{IMPORT_DATA_SOURCE});
        this.getView().setVisible(Boolean.FALSE, new String[]{DATA_SROUCE_ENTRY});
        this.getView().setVisible(Boolean.FALSE, new String[]{REGULAR_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{ASSERT_ENTRY_ENTITY});
    }

    private void showCaseDetail(String data) {
        UnitTestCase unitTestCase = (UnitTestCase)SerializationUtils.fromJsonString((String)data, UnitTestCase.class);
        this.getView().setVisible(Boolean.TRUE, new String[]{CASE_NAME});
        this.getView().setVisible(Boolean.TRUE, new String[]{IMPORT_DATA_SOURCE});
        this.getView().setVisible(Boolean.TRUE, new String[]{DATA_SROUCE_ENTRY});
        String[] tempArray = unitTestCase.getName().split(":");
        if (tempArray.length != 2) {
            this.getView().showMessage(unitTestCase.getName() + ResManager.loadKDString((String)" jmx\u683c\u5f0f\u4e0d\u5bf9", (String)"UnitTestHTTPTreePlugin_18", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        String caseName = tempArray[1];
        this.getModel().setValue(CASE_NAME, (Object)caseName);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENTRY_TEST_RESULT});
        this.getView().setVisible(Boolean.FALSE, new String[]{GROU_PNAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{METHOD});
        this.getView().setVisible(Boolean.FALSE, new String[]{PARAMS_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{"path"});
        this.getView().setVisible(Boolean.FALSE, new String[]{REGULAR_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{ASSERT_ENTRY_ENTITY});
        String dataSourceJson = this.getPageCache().get("dataSource");
        if (StringUtils.isNotBlank((CharSequence)dataSourceJson)) {
            this.showDataSource(unitTestCase, (Map)SerializationUtils.fromJsonString((String)dataSourceJson, Map.class));
        } else {
            String dataSource = this.getDataSource();
            if (StringUtils.isNotBlank((CharSequence)dataSource)) {
                this.showDataSource(unitTestCase, (Map)SerializationUtils.fromJsonString((String)dataSource, Map.class));
            }
            this.getPageCache().put("dataSource", dataSource);
        }
    }

    private void showAssertDetail(String data) {
        this.getView().setVisible(Boolean.TRUE, new String[]{ASSERT_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENTRY_TEST_RESULT});
        this.getView().setVisible(Boolean.FALSE, new String[]{GROU_PNAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{CASE_NAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{METHOD});
        this.getView().setVisible(Boolean.FALSE, new String[]{PARAMS_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{"path"});
        this.getView().setVisible(Boolean.FALSE, new String[]{IMPORT_DATA_SOURCE});
        this.getView().setVisible(Boolean.FALSE, new String[]{DATA_SROUCE_ENTRY});
        this.getView().setVisible(Boolean.FALSE, new String[]{REGULAR_ENTRY_ENTITY});
        AssertController assertController = (AssertController)SerializationUtils.fromJsonString((String)data, AssertController.class);
        List<String> assertModelString = assertController.getAsserion_test_strings();
        this.getModel().setValue(ASSERTION_TEST_TYPE, (Object)JmeterSrcForResponseAssertion.getJmeterSrcForResponseAssertionSingleton().convertTypeToString(Integer.valueOf(assertController.getAssertion_test_type())), 0);
        this.hideAllAssertModel(false);
        this.getView().setVisible(Boolean.TRUE, new String[]{ASSERTION_TEST_TYPE});
        if (assertModelString != null) {
            if (assertModelString.size() < 10) {
                for (int i = 0; i < assertModelString.size(); ++i) {
                    this.getModel().setValue(ASSERT_FIELD + (i + 1), (Object)assertModelString.get(i), 0);
                    this.getView().setVisible(Boolean.TRUE, new String[]{ASSERT_FIELD + (i + 1)});
                }
            } else {
                this.hideAllAssertModel(true);
            }
        }
    }

    private void hideAllAssertModel(boolean isShow) {
        for (int i = 1; i < 10; ++i) {
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{ASSERT_FIELD + i});
        }
    }

    private String getDataSource() {
        return (String)this.getView().getFormShowParameter().getCustomParam("datasourcecontext");
    }

    private void showHTTPProxyDetail(String data) {
        UnitTestHttpProxy unitTestHttpProxy = (UnitTestHttpProxy)SerializationUtils.fromJsonString((String)data, UnitTestHttpProxy.class);
        this.getView().setVisible(Boolean.TRUE, new String[]{PARAMS_ENTRY_ENTITY});
        Map<String, Object> paramMap = unitTestHttpProxy.getParams();
        Iterator<Map.Entry<String, Object>> it = paramMap.entrySet().iterator();
        int count = this.getModel().getEntryRowCount(PARAMS_ENTRY_ENTITY);
        this.getModel().deleteEntryData(PARAMS_ENTRY_ENTITY);
        if (paramMap.size() > 0) {
            this.getModel().batchCreateNewEntryRow(PARAMS_ENTRY_ENTITY, paramMap.size());
        }
        int i = 0;
        ((EntryGrid)this.getControl(PARAMS_ENTRY_ENTITY)).clearEntryState();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            this.getModel().setValue("paramname", (Object)entry.getKey(), i);
            this.getModel().setValue("paramvalue", entry.getValue(), i);
            ++i;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENTRY_TEST_RESULT});
        this.getView().setVisible(Boolean.FALSE, new String[]{CASE_NAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{METHOD});
        this.getView().setVisible(Boolean.FALSE, new String[]{GROU_PNAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{"path"});
        this.getView().setVisible(Boolean.FALSE, new String[]{IMPORT_DATA_SOURCE});
        this.getView().setVisible(Boolean.FALSE, new String[]{DATA_SROUCE_ENTRY});
        this.getView().setVisible(Boolean.FALSE, new String[]{REGULAR_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{ASSERT_ENTRY_ENTITY});
    }

    private void showRegularDetail(String data) {
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENTRY_TEST_RESULT});
        this.getView().setVisible(Boolean.FALSE, new String[]{CASE_NAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{METHOD});
        this.getView().setVisible(Boolean.FALSE, new String[]{GROU_PNAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{"path"});
        this.getView().setVisible(Boolean.FALSE, new String[]{IMPORT_DATA_SOURCE});
        this.getView().setVisible(Boolean.FALSE, new String[]{DATA_SROUCE_ENTRY});
        this.getView().setVisible(Boolean.FALSE, new String[]{PARAMS_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{ASSERT_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.TRUE, new String[]{REGULAR_ENTRY_ENTITY});
        RegularController regular = (RegularController)SerializationUtils.fromJsonString((String)data, RegularController.class);
        this.getModel().deleteEntryData(REGULAR_ENTRY_ENTITY);
        this.getModel().createNewEntryRow(REGULAR_ENTRY_ENTITY);
        this.getModel().setValue("refname", (Object)regular.getRegexExtractor_refname(), 0);
        this.getModel().setValue("regularexpression", (Object)regular.getRegexExtractor_regex(), 0);
    }

    private TreeNode getRoot() {
        String rootNodeStr = this.getPageCache().get("root");
        TreeNode rootNode = new TreeNode();
        if (rootNodeStr != null && !"".equals(rootNodeStr)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        }
        return rootNode;
    }

    private void updateRootNode(TreeNode root) {
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
    }

    private String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private IPageCache getCache() {
        if (this.pageCache == null) {
            this.pageCache = new PageCache(this.getView().getPageId());
        }
        return this.pageCache;
    }

    public void upload(UploadEvent evt) {
    }

    private void showDataSource(UnitTestCase currentCase, Map<String, List<ExcelDataObject>> resultMap) {
        this.getModel().deleteEntryData(DATA_SROUCE_ENTRY);
        this.hideAllTextField();
        for (Map.Entry<String, List<ExcelDataObject>> entry : resultMap.entrySet()) {
            List<ExcelDataObject> value = entry.getValue();
            ArrayList<ExcelDataObject> temp = new ArrayList<ExcelDataObject>(10);
            if (value.size() > 0 && value.get(0) instanceof Map) {
                for (ExcelDataObject object : value) {
                    temp.add((ExcelDataObject)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)object), ExcelDataObject.class));
                    value = temp;
                }
            }
            this.setColumn(value, currentCase);
            for (ExcelDataObject excelDataObject : value) {
                if (!currentCase.getParentGroupName().equals(ResManager.loadKDString((String)"\u7528\u4f8b\u5206\u7ec4:", (String)"UnitTestHTTPTreePlugin_19", (String)"bos-unittest", (Object[])new Object[0]) + excelDataObject.getCaseGroupName()) || !currentCase.getName().equals(ResManager.loadKDString((String)"\u6d4b\u8bd5\u7528\u4f8b:", (String)"UnitTestHTTPTreePlugin_20", (String)"bos-unittest", (Object[])new Object[0]) + excelDataObject.getCaseName())) continue;
                for (int i = 0; i < excelDataObject.getDataList().size(); ++i) {
                    Iterator<Map.Entry<String, String>> paraValueIt = excelDataObject.getDataList().get(i).entrySet().iterator();
                    int columnIndex = 1;
                    this.getModel().createNewEntryRow(DATA_SROUCE_ENTRY);
                    this.getModel().setValue("rowseq", (Object)(i + 1), i);
                    while (paraValueIt.hasNext()) {
                        Map.Entry<String, String> paraValueEntry = paraValueIt.next();
                        if (!paraValueEntry.getKey().equals("sq")) {
                            this.getModel().setValue(TEXT_FIELD + columnIndex, (Object)paraValueEntry.getValue(), i);
                        }
                        ++columnIndex;
                    }
                }
            }
        }
    }

    private void hideAllTextField() {
        for (int i = 1; i <= 50; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_FIELD + i});
        }
    }

    private void setColumn(List<ExcelDataObject> value, UnitTestCase currentCase) {
        int index = 1;
        EntryGrid entryGrid = (EntryGrid)this.getControl(DATA_SROUCE_ENTRY);
        for (ExcelDataObject excelDataObject : value) {
            if (!currentCase.getParentGroupName().equals(ResManager.loadKDString((String)"\u7528\u4f8b\u5206\u7ec4:", (String)"UnitTestHTTPTreePlugin_19", (String)"bos-unittest", (Object[])new Object[0]) + excelDataObject.getCaseGroupName()) || !currentCase.getName().equals(ResManager.loadKDString((String)"\u6d4b\u8bd5\u7528\u4f8b:", (String)"UnitTestHTTPTreePlugin_20", (String)"bos-unittest", (Object[])new Object[0]) + excelDataObject.getCaseName()) || excelDataObject.getDataList().size() <= 0) continue;
            for (Map.Entry<String, String> paraValueEntry : excelDataObject.getDataList().get(0).entrySet()) {
                if (paraValueEntry.getKey().equals("sq")) continue;
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("en", paraValueEntry.getKey());
                header.put("zh_TW", paraValueEntry.getKey());
                header.put("zh_CN", paraValueEntry.getKey());
                entryGrid.setColumnProperty(TEXT_FIELD + index, "header", header);
                this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_FIELD + index});
                ++index;
            }
        }
    }

    private Object getMessageFromResult(Object result) {
        String strRet = (String)result;
        String ret = null;
        String[] s = strRet.split("\n");
        if (s.length >= 1 && !s[0].equalsIgnoreCase(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"UnitTestHTTPTreePlugin_10", (String)"bos-unittest", (Object[])new Object[0]))) {
            ret = ResManager.loadKDString((String)"\u5931\u8d25\uff08\u8bf7\u70b9\u51fb\u53f3\u4fa7\u67e5\u770b\u8be6\u60c5\uff09\uff1a", (String)"UnitTestHTTPTreePlugin_11", (String)"bos-unittest", (Object[])new Object[0]);
            ret = ret + s[0];
        } else {
            ret = strRet;
        }
        return ret;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        block14: {
            TreeNode currentNode;
            TreeNode root;
            block15: {
                block13: {
                    super.propertyChanged(e);
                    String currentId = this.getPageCache().get(CURRENT_NODE_ID);
                    root = this.getRoot();
                    currentNode = root.getTreeNode(currentId, 20);
                    if (!"paramvalue".equals(e.getProperty().getName())) break block13;
                    String data = currentNode.getData().toString();
                    String type = currentNode.getId().split("_")[0];
                    if (!type.equals(HTTP_PROXY_NODE)) break block14;
                    UnitTestHttpProxy unitTestHttpProxy = (UnitTestHttpProxy)SerializationUtils.fromJsonString((String)data, UnitTestHttpProxy.class);
                    String paraName = null;
                    String changeValue = null;
                    for (ChangeData changeData : e.getChangeSet()) {
                        Map<String, Object> map;
                        paraName = changeData.getDataEntity().getString("paramname");
                        changeValue = changeData.getNewValue().toString();
                        if (changeData.getOldValue() == null) continue;
                        if (paraName != null && changeValue != null && (map = unitTestHttpProxy.getParams()).containsKey(paraName)) {
                            map.put(paraName, changeValue);
                        }
                        String newData = SerializationUtils.toJsonString((Object)unitTestHttpProxy);
                        currentNode.setData((Object)newData);
                        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
                    }
                    break block14;
                }
                if (!"regularexpression".equals(e.getProperty().getName())) break block15;
                String regularData = currentNode.getData().toString();
                try {
                    RegularController regularController = (RegularController)SerializationUtils.fromJsonString((String)regularData, RegularController.class);
                    String refName = null;
                    String changeValue = null;
                    for (ChangeData changeData : e.getChangeSet()) {
                        refName = changeData.getDataEntity().getString("refname");
                        changeValue = changeData.getNewValue().toString();
                        if (changeData.getOldValue() == null) continue;
                        if (refName != null && changeValue != null) {
                            regularController.setRegexExtractor_regex(changeData.getNewValue().toString());
                        }
                        String newData = SerializationUtils.toJsonString((Object)regularController);
                        currentNode.setData((Object)newData);
                        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
                    }
                }
                catch (Exception e2) {
                    log.info(e2.getMessage());
                }
                break block14;
            }
            if (!e.getProperty().getName().contains(ASSERT_FIELD)) break block14;
            String assertData = currentNode.getData().toString();
            try {
                AssertController assertController = (AssertController)SerializationUtils.fromJsonString((String)assertData, AssertController.class);
                String refName = null;
                String changeValue = null;
                for (ChangeData changeData : e.getChangeSet()) {
                    refName = changeData.getDataEntity().getString(ASSERTION_TEST_TYPE);
                    changeValue = changeData.getNewValue().toString();
                    if (changeData.getOldValue() == null) continue;
                    if (refName != null && changeValue != null) {
                        List<String> nowString = assertController.getAsserion_test_strings();
                        int index = 0;
                        if (nowString != null) {
                            for (String string : nowString) {
                                if (string.contains(changeData.getOldValue().toString())) {
                                    nowString.set(index, changeData.getNewValue().toString());
                                }
                                ++index;
                            }
                        }
                        assertController.setAsserion_test_strings(nowString);
                    }
                    String newData = SerializationUtils.toJsonString((Object)assertController);
                    currentNode.setData((Object)newData);
                    this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
                }
            }
            catch (Exception e2) {
                log.info(e2.getMessage());
            }
        }
    }

    private void saveData(String jmxData) {
        String pkId = (String)this.getView().getFormShowParameter().getCustomParam("pkID");
        Object[] saveParams = new Object[]{new SqlParameter("FJMXCONTEXT", 12, (Object)jmxData), new SqlParameter("FID", 12, (Object)pkId)};
        String sql = "update t_bas_unittestdetail_a set FJMXCONTEXT = ?  WHERE FID=?";
        try (TXHandle h = TX.required();){
            DB.update((DBRoute)DBRoute.main, (String)sql, (Object[])saveParams);
        }
    }
}

