/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mservice.unittest.UnitTestService;
import kd.bos.service.ServiceFactory;
import kd.bos.unittest.UnitTestDao;

public class UnitTestPlugin
extends AbstractFormPlugin
implements ClickListener {
    public static final String KEY_ENTRY_TESTCASE = "entryentity";
    public static final String KEY_ENTRY_TEST_RESULT = "entryresult";
    public static final String NUMBER = "number";
    public static final String SUBSYSNAME = "subsysname";
    private UnitTestService unitTestService;

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btntest".equalsIgnoreCase(key)) {
            this.startAllUnitTest();
        } else if ("btntestselect".equalsIgnoreCase(key)) {
            this.startSelectedUnitTest();
        } else if ("btnreflesh".equalsIgnoreCase(key)) {
            this.loadPublishedUnitTest();
        } else if ("btnhistory".equalsIgnoreCase(key)) {
            this.getHistoryResult();
        } else if ("btnunitmanager".equalsIgnoreCase(key)) {
            ListShowParameter unittestmanager = new ListShowParameter();
            unittestmanager.setFormId("ide_unit_test_manager");
            unittestmanager.setBillFormId("ide_unit_test_detail");
            unittestmanager.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)unittestmanager);
        }
    }

    public UnitTestService getUnitTestService() {
        this.unitTestService = (UnitTestService)ServiceFactory.getService(UnitTestService.class);
        return this.unitTestService;
    }

    private void getHistoryResult() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("ide_unit_test_result");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setTargetKey("tabap");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void doTestUnitCase(int index) {
        boolean bCompleted;
        String testCaseNumber = (String)this.getModel().getValue(NUMBER, index);
        String result = this.getUnitTestService().testByCaseId(testCaseNumber, false);
        List lstMapResult = (List)SerializationUtils.fromJsonString((String)result, List.class);
        Map mapResult = (Map)lstMapResult.get(0);
        List lstCaseResult = (List)mapResult.get("testCaseResults");
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(KEY_ENTRY_TEST_RESULT);
        if (!lstCaseResult.isEmpty()) {
            model.batchCreateNewEntryRow(KEY_ENTRY_TEST_RESULT, lstCaseResult.size());
            int i = 0;
            for (Map caseResult : lstCaseResult) {
                model.setValue("fucname", mapResult.get("name"), i + count);
                model.setValue("testcase", caseResult.get("name"), i + count);
                model.setValue("function", caseResult.get("methodName"), i + count);
                model.setValue("testinfo", this.getMessageFromResult(caseResult.get("message")), i + count);
                model.setValue("testinfo_tag", caseResult.get("message"), i + count);
                model.setValue("usetime", (Object)(caseResult.get("consumeTime") + " ms"), i + count);
                ++i;
            }
        }
        if (!(bCompleted = ((Boolean)mapResult.get("completed")).booleanValue())) {
            this.getView().showErrorNotification(mapResult.toString());
        }
    }

    private Object getMessageFromResult(Object result) {
        String strRet = (String)result;
        String ret = null;
        String[] s = strRet.split("\n");
        if (s.length >= 1 && !s[0].equalsIgnoreCase(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"UnitTestPlugin_0", (String)"bos-unittest", (Object[])new Object[0]))) {
            ret = ResManager.loadKDString((String)"\u5931\u6557\uff08\u8bf7\u70b9\u51fb\u53f3\u4fa7\u67e5\u770b\u8be6\u60c5\uff09\uff1a", (String)"UnitTestPlugin_1", (String)"bos-unittest", (Object[])new Object[0]);
            ret = ret + s[0];
        } else {
            ret = strRet;
        }
        return ret;
    }

    private void startAllUnitTest() {
        this.getModel().deleteEntryData(KEY_ENTRY_TEST_RESULT);
        int iCount = this.getModel().getEntryRowCount(KEY_ENTRY_TESTCASE);
        if (iCount < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53d1\u5e03\u7684\u53ef\u7528\u6d4b\u8bd5\u7528\u4f8b~", (String)"UnitTestPlugin_2", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        for (int index = 0; index < iCount; ++index) {
            this.doTestUnitCase(index);
        }
    }

    private void startSelectedUnitTest() {
        this.getModel().deleteEntryData(KEY_ENTRY_TEST_RESULT);
        int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_TESTCASE);
        if (index != -1) {
            this.doTestUnitCase(index);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6d4b\u8bd5\u7528\u4f8b\uff01", (String)"UnitTestPlugin_3", (String)"bos-unittest", (Object[])new Object[0]));
        }
    }

    private void loadPublishedUnitTest() {
        this.loadAllUnitTest();
    }

    private void loadAllUnitTest() {
        List<Map<String, Object>> lstPublished = UnitTestDao.getAllTestCaseByORM();
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY_TESTCASE);
        if (!lstPublished.isEmpty()) {
            int count = model.getEntryRowCount(KEY_ENTRY_TESTCASE);
            if (!lstPublished.isEmpty()) {
                model.batchCreateNewEntryRow(KEY_ENTRY_TESTCASE, lstPublished.size() - count);
                int i = 0;
                for (Map<String, Object> form : lstPublished) {
                    model.setValue(NUMBER, form.get(NUMBER), i);
                    model.setValue("objectnumber", form.get("ObjectNumber"), i);
                    model.setValue("testfuncname", form.get("fname"), i);
                    model.setValue(SUBSYSNAME, form.get("subsystemname"), i);
                    model.setValue("framechose", form.get("framechose"), i);
                    ++i;
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.loadAllUnitTest();
    }
}

