/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.baserecordset.AbstractDataSetOperater;
import kd.bos.designer.baserecordset.IDataSetOperater;
import kd.bos.designer.baserecordset.SVNUtil;
import kd.bos.designer.unittest.GitHostingServiceImpl;
import kd.bos.designer.unittest.UnitTestUtils;
import kd.bos.designer.unittest.UnitTestWorkHelper;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class UnitTestSVNLoginPlugin
extends AbstractFormPlugin {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String IS_SAVE = "issave";
    private static final String DATA_SET = "dataset";
    private static final String SMG_USERNAME = "smgusername";
    private static final String SMG_PASSWORD = "smgpassword";
    private static final String SVN_PATH = "svnpath";
    private static final String APP_NUMBER = "appnumber";
    private static final String ANNOTATION = "annotation";
    private static final String ERROR = "error";
    private static final String PREF_FIX = "preffix";
    private static final String SUF_FIX = "suffix";
    private static final String NUMBER = "number";
    private static final String NUMBER_NAME = "numbername";
    private static final String LOCAL_PATH = "localpath";
    private static final String SAVE_SVN_MSG = "SAVE_SVN_MSG";
    private static final String CAP_NAME = "capName";
    private static final String UNIT_TEST_SVN_LOGIN_PLUGIN_7 = "UnitTestSVNLoginPlugin_7";
    private static final Log log = LogFactory.getLog(UnitTestSVNLoginPlugin.class);
    public static final String verSion = "0.1";
    private String appSVNEntryKey = "appsvnentry";
    private String appidFieldKey = "appid";
    private String gitUrlFieldKey = "giturl";
    private String mapidsParamKey = "mapids";
    private String gitRootPath = "gitrootpath";
    private String appSVNPathFieldKey = "appsvnpath";
    private String appSVNPathParamKey = "appsvnpath";
    private String bizAppIdParamKey = "bizappid";
    private String classNameParamKey = "classname";
    private String notificationParamKey = "notification";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        Map appIds;
        String type;
        boolean isGitManage = UnitTestUtils.isGitManageType();
        String username = (String)this.getView().getFormShowParameter().getCustomParam(USERNAME);
        String password = (String)this.getView().getFormShowParameter().getCustomParam(PASSWORD);
        Object remember = this.getView().getFormShowParameter().getCustomParam(IS_SAVE);
        boolean issave = false;
        if (remember != null) {
            issave = (Boolean)remember;
        }
        if ("loginonly".equals(type = (String)this.getView().getFormShowParameter().getCustomParam("type"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.appSVNEntryKey, ANNOTATION});
            String appid = (String)this.getView().getFormShowParameter().getCustomParam(this.appidFieldKey);
            DynamicObject appSetInfo = UnitTestWorkHelper.getAppSetInfo(appid, null);
            if (appSetInfo != null) {
                Object giturl = appSetInfo.get(this.gitUrlFieldKey);
                this.getModel().setValue(this.gitUrlFieldKey, giturl);
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue(this.gitUrlFieldKey))) {
                this.getModel().setValue(this.gitUrlFieldKey, (Object)UnitTestUtils.getGitCommonRemoteUrl());
            }
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{this.gitUrlFieldKey});
        ((TextEdit)this.getControl(this.gitUrlFieldKey)).setMustInput(false);
        if (DATA_SET.equals(type)) {
            username = SessionManager.getCurrent().get(SMG_USERNAME);
            password = SessionManager.getCurrent().get(SMG_PASSWORD);
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                issave = true;
            }
            this.getPageCache().put("type", DATA_SET);
        }
        if (issave) {
            this.getModel().setValue(IS_SAVE, (Object)String.valueOf(issave));
        }
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            this.getModel().setValue(USERNAME, (Object)username);
            try {
                password = Encrypters.decode((String)password);
            }
            catch (Exception e1) {
                log.error((Throwable)e1);
            }
            this.getModel().setValue(PASSWORD, (Object)password);
        }
        if ((appIds = (Map)this.getView().getFormShowParameter().getCustomParam(this.mapidsParamKey)).size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(this.appSVNEntryKey, appIds.size());
            int i = 0;
            for (Map.Entry entry : appIds.entrySet()) {
                String appId = (String)entry.getKey();
                Map item = (Map)entry.getValue();
                DynamicObject appSet = UnitTestWorkHelper.getAppSetInfo(appId, username);
                String path = null;
                if (isGitManage) {
                    if (appSet == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c1a\u672a\u914d\u7f6egit\u4fe1\u606f\uff0c\u8bf7\u5728[\u6d4b\u8bd5\u5e73\u53f0-\u76f8\u5173\u8bbe\u7f6e-\u914d\u7f6e\u8d23\u4efb\u4eba]\u914d\u7f6e\u5148\u3002", (String)"UnitTestSVNLoginPlugin_12", (String)"bos-unittest", (Object[])new Object[0]));
                    } else {
                        path = GitHostingServiceImpl.getGitLocalFullPath2UnitTest(appId, (String)appSet.get("gitrepository"), (String)appSet.get(this.gitRootPath));
                    }
                } else {
                    if (appSet != null) {
                        path = appSet.getString(SVN_PATH);
                    }
                    if (StringUtils.isBlank(path)) {
                        path = SVNUtil.getUnitTestSvnPathByAppId((String)appId);
                    }
                }
                model.setValue(APP_NUMBER, item.get(APP_NUMBER), i);
                model.setValue(this.appSVNPathFieldKey, (Object)path, i);
                model.setValue(this.appidFieldKey, (Object)appId, i);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("btnok".equals(key)) {
            String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
            if ("loginonly".equals(type)) {
                this.doLogin();
                return;
            }
            try {
                this.confirm();
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error(e.getMessage());
            }
        } else if ("btncancel".equals(key)) {
            this.cancel();
        }
    }

    private void confirm() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean isGitManage = UnitTestUtils.isGitManageType();
        Object delete = this.getView().getFormShowParameter().getCustomParam("deletePageFlag");
        boolean deletePageFlag = false;
        if (delete != null) {
            deletePageFlag = (Boolean)delete;
        }
        if (deletePageFlag) {
            if (isGitManage) {
                this.doWork_git(1);
            } else {
                this.doWork_svn(1);
            }
        } else if (isGitManage) {
            this.doWork_git(0);
        } else {
            this.doWork_svn(0);
        }
    }

    private void delete() {
        IDataModel model = this.getModel();
        String username = (String)model.getValue(USERNAME);
        String password = (String)model.getValue(PASSWORD);
        password = Encrypters.encode((String)password);
        String annotation = (String)model.getValue(ANNOTATION);
        boolean isSave = (Boolean)model.getValue(IS_SAVE);
        if (StringUtils.isBlank((CharSequence)username)) {
            this.getView().showTipNotification(this.getBlankUserNameTips());
            return;
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"UnitTestSVNLoginPlugin_2", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        SVNUtil svnUtil = new SVNUtil();
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(this.bizAppIdParamKey);
        JSONObject svnMsg = svnUtil.getUnitTestSVNMsgByAppId(bizAppId);
        if (svnMsg.get((Object)ERROR) != null) {
            this.getView().showErrorNotification(svnMsg.get((Object)ERROR).toString());
            return;
        }
        svnMsg.put(USERNAME, (Object)username);
        svnMsg.put(PASSWORD, (Object)password);
        svnMsg.put(ANNOTATION, (Object)annotation);
        svnMsg.put(PREF_FIX, this.getView().getFormShowParameter().getCustomParam(PREF_FIX));
        svnMsg.put(SUF_FIX, this.getView().getFormShowParameter().getCustomParam(SUF_FIX));
        svnMsg.put(NUMBER, this.getView().getFormShowParameter().getCustomParam(NUMBER));
        svnMsg.put(NUMBER_NAME, this.getView().getFormShowParameter().getCustomParam(NUMBER_NAME));
        JSONObject checkInMsg = new JSONObject();
        String type = this.getPageCache().get("type");
        if (type != null && DATA_SET.equals(type)) {
            JSONArray ids = JSONArray.parseArray((String)this.getView().getFormShowParameter().getCustomParam("ids").toString());
            svnMsg.put("ids", (Object)ids);
            String number = (String)this.getView().getFormShowParameter().getCustomParam(NUMBER);
            AbstractDataSetOperater dbOperator = new AbstractDataSetOperater(number, svnMsg);
            checkInMsg = dbOperator.deleteBaseDataFromSvnWithIds();
        } else {
            JSONArray forms = (JSONArray)JSONArray.parse((String)this.getView().getFormShowParameter().getCustomParam("forms").toString());
            checkInMsg = svnUtil.delete(svnMsg, forms);
        }
        if (checkInMsg.get((Object)ERROR) != null) {
            String msg = (String)checkInMsg.get((Object)ERROR);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("msg", msg);
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("success", this.getSuccessfullyDeleteTips());
            if (type != null && this.isScriptType(type)) {
                if (isSave) {
                    SessionManager.getCurrent().put(SMG_USERNAME, username);
                    SessionManager.getCurrent().put(SMG_PASSWORD, password);
                } else {
                    SessionManager.getCurrent().put(SMG_USERNAME, "");
                    SessionManager.getCurrent().put(SMG_PASSWORD, "");
                }
            } else if (isSave) {
                svnMsg.remove((Object)LOCAL_PATH);
                svnMsg.remove((Object)SVN_PATH);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction(SAVE_SVN_MSG, (Object)svnMsg);
            } else {
                svnMsg.clear();
                svnMsg.put(USERNAME, (Object)"");
                svnMsg.put(PASSWORD, (Object)"");
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction(SAVE_SVN_MSG, (Object)svnMsg);
            }
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork_svn(int iType) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String msg;
        String number;
        IDataModel model = this.getModel();
        String username = (String)model.getValue(USERNAME);
        String password = (String)model.getValue(PASSWORD);
        String annotation = (String)model.getValue(ANNOTATION);
        boolean isSave = (Boolean)model.getValue(IS_SAVE);
        if (StringUtils.isBlank((CharSequence)username)) {
            this.getView().showTipNotification(this.getBlankUserNameTips());
            return;
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            this.getView().showTipNotification(this.getBlankPassWordTips());
            return;
        }
        if (StringUtils.isBlank((CharSequence)annotation)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u91ca\u4e0d\u80fd\u4e3a\u7a7a", (String)"UnitTestSVNLoginPlugin_5", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        password = Encrypters.encode((String)password);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(this.bizAppIdParamKey);
        String capName = (String)this.getView().getFormShowParameter().getCustomParam(CAP_NAME);
        SVNUtil svnUtil = new SVNUtil();
        DynamicObjectCollection checkInfoCollect = this.getModel().getEntryEntity(this.appSVNEntryKey);
        ArrayList<String> lstError = new ArrayList<String>();
        if (checkInfoCollect.size() <= 0) {
            String err = ResManager.loadKDString((String)"\u7b7e\u5165\u5185\u5bb9\u4e3a\u7a7a\r\n", (String)"UnitTestSVNLoginPlugin_6", (String)"bos-unittest", (Object[])new Object[0]);
            lstError.add(err);
        }
        ArrayList<JSONObject> lstSvnMsg = new ArrayList<JSONObject>();
        for (Object checkInfo : checkInfoCollect) {
            String string = checkInfo.getString(this.appSVNPathParamKey);
            String number2 = checkInfo.getString(APP_NUMBER);
            String appid = checkInfo.getString(this.appidFieldKey);
            if (StringUtils.isBlank((CharSequence)string)) {
                String err = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + number2 + ResManager.loadKDString((String)")\u7684SVN\u8def\u5f84\u4e3a\u7a7a\r\n", (String)"UnitTestSVNLoginPlugin_8", (String)"bos-unittest", (Object[])new Object[0]);
                lstError.add(err);
                continue;
            }
            JSONObject svnMsg = svnUtil.getUnitTestSVNMsgByAppId(string, number2);
            svnMsg.put(this.appidFieldKey, (Object)appid);
            Map mapids = (Map)this.getView().getFormShowParameter().getCustomParam(this.mapidsParamKey);
            List ids = (List)((Map)mapids.get(appid)).get("ids");
            svnMsg.put("ids", (Object)ids);
            svnMsg.put(APP_NUMBER, (Object)number2);
            lstSvnMsg.add(svnMsg);
        }
        if (lstError.size() > 0) {
            this.getView().showErrorNotification(((Object)lstError).toString());
            return;
        }
        ArrayList<String> lstCommitInfo = new ArrayList<String>();
        if (iType == 0) {
            try {
                for (JSONObject jSONObject : lstSvnMsg) {
                    jSONObject.put(USERNAME, (Object)username);
                    jSONObject.put(PASSWORD, (Object)password);
                    jSONObject.put(ANNOTATION, (Object)annotation);
                    jSONObject.put(CAP_NAME, (Object)capName);
                    jSONObject.put(PREF_FIX, this.getView().getFormShowParameter().getCustomParam(PREF_FIX));
                    jSONObject.put(SUF_FIX, this.getView().getFormShowParameter().getCustomParam(SUF_FIX));
                    JSONObject workMsg = new JSONObject();
                    String type = this.getPageCache().get("type");
                    if (DATA_SET.equals(type)) {
                        number = (String)this.getView().getFormShowParameter().getCustomParam(NUMBER);
                        Object classname = (String)this.getView().getFormShowParameter().getCustomParam(this.classNameParamKey);
                        if (StringUtils.isBlank((CharSequence)classname)) {
                            classname = this.getDefaultDataSetClassName();
                        }
                        Class<?> cls = Class.forName((String)classname);
                        Class[] parameterTypes = new Class[]{String.class, JSONObject.class};
                        Constructor<?> constructor = cls.getConstructor(parameterTypes);
                        Object[] parameters = new Object[]{number, jSONObject};
                        IDataSetOperater dbOperator = (IDataSetOperater)constructor.newInstance(parameters);
                        workMsg = dbOperator.commitBaseDataToSvn();
                    }
                    msg = "";
                    if (workMsg.get((Object)ERROR) != null) {
                        msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + jSONObject.get((Object)APP_NUMBER) + ")\uff1a" + workMsg.get((Object)ERROR) + "";
                        lstCommitInfo.add(msg);
                        this.getView().showErrorNotification(((Object)lstCommitInfo).toString());
                        return;
                    }
                    if (workMsg.get((Object)this.notificationParamKey) != null) {
                        msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + jSONObject.get((Object)APP_NUMBER) + ")\uff1a" + workMsg.get((Object)this.notificationParamKey) + "";
                        lstCommitInfo.add(msg);
                        this.saveUserName(type, isSave, username, password, jSONObject);
                        continue;
                    }
                    if (workMsg.get((Object)"NOPATH") != null) {
                        this.saveUserName(type, isSave, username, password, jSONObject);
                        this.getPageCache().put("svnMsg", jSONObject.toJSONString());
                        this.getPageCache().put("bizAppId", bizAppId);
                        this.getView().showConfirm(ResManager.loadKDString((String)"SVN\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u662f\u5426\u521b\u5efa?", (String)"UnitTestSVNLoginPlugin_9", (String)"bos-unittest", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("CreateSvnPathCallBack"));
                        return;
                    }
                    msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + jSONObject.get((Object)APP_NUMBER) + this.getSuccessfullyCommitTips();
                    lstCommitInfo.add(msg);
                    this.saveUserName(type, isSave, username, password, jSONObject);
                }
                this.getView().close();
                StringBuilder showMsg = new StringBuilder();
                for (String commitInfo : lstCommitInfo) {
                    showMsg.append(commitInfo).append("\r\n");
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u7b7e\u5165\u6210\u529f", (String)"UnitTestSVNLoginPlugin_11", (String)"bos-unittest", (Object[])new Object[0]), showMsg.toString(), MessageTypes.Default);
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
            finally {
                for (JSONObject jSONObject : lstSvnMsg) {
                    String localPath = (String)jSONObject.get((Object)LOCAL_PATH);
                    String number3 = (String)jSONObject.get((Object)APP_NUMBER);
                    String delPath = localPath.substring(0, localPath.length() - number3.length());
                    svnUtil.delUnittestFile(new File(delPath));
                }
            }
        } else {
            String type = this.getPageCache().get("type");
            for (JSONObject svnMsg : lstSvnMsg) {
                JSONObject workMsg;
                svnMsg.put(USERNAME, (Object)username);
                svnMsg.put(PASSWORD, (Object)password);
                svnMsg.put(ANNOTATION, (Object)annotation);
                svnMsg.put(CAP_NAME, (Object)capName);
                svnMsg.put(PREF_FIX, this.getView().getFormShowParameter().getCustomParam(PREF_FIX));
                svnMsg.put(SUF_FIX, this.getView().getFormShowParameter().getCustomParam(SUF_FIX));
                svnMsg.put(NUMBER, this.getView().getFormShowParameter().getCustomParam(NUMBER));
                svnMsg.put(NUMBER_NAME, this.getView().getFormShowParameter().getCustomParam(NUMBER_NAME));
                if (DATA_SET.equals(type)) {
                    number = (String)this.getView().getFormShowParameter().getCustomParam(NUMBER);
                    AbstractDataSetOperater dbOperator = new AbstractDataSetOperater(number, svnMsg);
                    workMsg = dbOperator.deleteBaseDataFromSvnWithIds();
                } else {
                    JSONArray forms = (JSONArray)JSONArray.parse((String)this.getView().getFormShowParameter().getCustomParam("forms").toString());
                    workMsg = svnUtil.delete(svnMsg, forms);
                }
                msg = "";
                if (workMsg.get((Object)ERROR) == null) continue;
                msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + svnMsg.get((Object)APP_NUMBER) + ")\uff1a" + workMsg.get((Object)ERROR) + "";
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("msg", msg);
                this.getView().returnDataToParent(map);
                this.getView().close();
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("success", this.getSuccessfullyDeleteTips());
            if (this.isScriptType(type)) {
                if (isSave) {
                    SessionManager.getCurrent().put(SMG_USERNAME, username);
                    SessionManager.getCurrent().put(SMG_PASSWORD, password);
                } else {
                    SessionManager.getCurrent().put(SMG_USERNAME, "");
                    SessionManager.getCurrent().put(SMG_PASSWORD, "");
                }
            } else {
                if (isSave) {
                    ((JSONObject)lstSvnMsg.get(0)).remove((Object)LOCAL_PATH);
                    ((JSONObject)lstSvnMsg.get(0)).remove((Object)SVN_PATH);
                } else {
                    ((JSONObject)lstSvnMsg.get(0)).clear();
                    ((JSONObject)lstSvnMsg.get(0)).put(USERNAME, (Object)"");
                    ((JSONObject)lstSvnMsg.get(0)).put(PASSWORD, (Object)"");
                }
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction(SAVE_SVN_MSG, lstSvnMsg.get(0));
            }
            this.getView().returnDataToParent(hashMap);
            this.getView().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork_git(int iType) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String sError;
        String path;
        String appId;
        Git git;
        IDataModel model = this.getModel();
        String username = (String)model.getValue(USERNAME);
        String password = (String)model.getValue(PASSWORD);
        String annotation = (String)model.getValue(ANNOTATION);
        boolean isSave = (Boolean)model.getValue(IS_SAVE);
        if (StringUtils.isBlank((CharSequence)username)) {
            this.getView().showTipNotification(this.getBlankUserNameTips());
            return;
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            this.getView().showTipNotification(this.getBlankPassWordTips());
            return;
        }
        if (StringUtils.isBlank((CharSequence)annotation)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u91ca\u4e0d\u80fd\u4e3a\u7a7a", (String)"UnitTestSVNLoginPlugin_5", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(this.bizAppIdParamKey);
        String capName = (String)this.getView().getFormShowParameter().getCustomParam(CAP_NAME);
        DynamicObjectCollection checkInfoCollect = this.getModel().getEntryEntity(this.appSVNEntryKey);
        ArrayList<String> lstError = new ArrayList<String>();
        if (checkInfoCollect.size() <= 0) {
            String err = ResManager.loadKDString((String)"\u7b7e\u5165\u5185\u5bb9\u4e3a\u7a7a\r\n", (String)"UnitTestSVNLoginPlugin_6", (String)"bos-unittest", (Object[])new Object[0]);
            lstError.add(err);
        }
        ArrayList<JSONObject> lstGitMsg = new ArrayList<JSONObject>();
        for (Object checkInfo : checkInfoCollect) {
            String string = checkInfo.getString(this.appSVNPathParamKey);
            String number = checkInfo.getString(APP_NUMBER);
            String appid = checkInfo.getString(this.appidFieldKey);
            if (StringUtils.isBlank((CharSequence)string)) {
                String err = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + number + ResManager.loadKDString((String)")\u7684\u8def\u5f84\u4e3a\u7a7a\r\n", (String)"UnitTestSVNLoginPlugin_8", (String)"bos-unittest", (Object[])new Object[0]);
                lstError.add(err);
                continue;
            }
            JSONObject gitMng = new JSONObject();
            gitMng.put(this.appidFieldKey, (Object)appid);
            Map mapids = (Map)this.getView().getFormShowParameter().getCustomParam(this.mapidsParamKey);
            List ids = (List)((Map)mapids.get(appid)).get("ids");
            gitMng.put("ids", (Object)ids);
            gitMng.put(APP_NUMBER, (Object)number);
            gitMng.put("path", (Object)string);
            lstGitMsg.add(gitMng);
        }
        if (lstError.size() > 0) {
            this.getView().showErrorNotification(((Object)lstError).toString());
            return;
        }
        ArrayList<String> lstCommitInfo = new ArrayList<String>();
        if (iType == 0) {
            try {
                for (JSONObject jSONObject : lstGitMsg) {
                    jSONObject.put(USERNAME, (Object)username);
                    jSONObject.put(PASSWORD, (Object)password);
                    jSONObject.put(ANNOTATION, (Object)annotation);
                    jSONObject.put(CAP_NAME, (Object)capName);
                    jSONObject.put(PREF_FIX, this.getView().getFormShowParameter().getCustomParam(PREF_FIX));
                    jSONObject.put(SUF_FIX, this.getView().getFormShowParameter().getCustomParam(SUF_FIX));
                    JSONObject workMsg = new JSONObject();
                    String type = this.getPageCache().get("type");
                    if (!DATA_SET.equals(type)) continue;
                    git = null;
                    try {
                        String gitRepository;
                        appId = (String)jSONObject.get((Object)this.appidFieldKey);
                        path = (String)jSONObject.get((Object)"path");
                        DynamicObject appSet = UnitTestWorkHelper.getAppSetInfo(appId, username);
                        String gitUrl = (String)appSet.get(this.gitUrlFieldKey);
                        String gitBranch = (String)appSet.get("gitbranch");
                        String gitRootpath = (String)appSet.get(this.gitRootPath);
                        String personalGitRepository = gitRepository = (String)appSet.get("gitrepository");
                        File repPath = new File(gitRepository);
                        if (!repPath.exists()) {
                            this.getView().showMessage(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u5730\u5740\u4e0d\u5b58\u5728", (String)"GitOperationUtil_40", (String)"bos-devportal-business", (Object[])new Object[0]));
                            return;
                        }
                        String projectURL = personalGitRepository + File.separator + ".git";
                        File gitFile = new File(projectURL);
                        boolean justClone = false;
                        if (!gitFile.exists()) {
                            String ret = GitHostingServiceImpl.cloneRepository(gitUrl, personalGitRepository, gitBranch, gitRootpath, username, password);
                            justClone = true;
                            if ("noPermission".equals(ret)) {
                                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\uff01", (String)"BizPageOperationUtil_0", (String)"bos-devportal-business", (Object[])new Object[0]));
                                return;
                            }
                        }
                        git = Git.open((File)gitFile);
                        Repository repository = git.getRepository();
                        String branchName = repository.getBranch();
                        if (!StringUtils.isBlank((CharSequence)gitBranch) && !gitBranch.equalsIgnoreCase(branchName)) {
                            git.checkout().setCreateBranch(true).setName(branchName).call();
                            if (UnitTestSVNLoginPlugin.branchNameExist(git, branchName)) {
                                git.checkout().setCreateBranch(false).setName(branchName).call();
                            } else {
                                git.checkout().setCreateBranch(true).setName(branchName).setStartPoint("origin/" + branchName).call();
                            }
                        }
                        if (!justClone) {
                            GitHostingServiceImpl.pull(gitUrl, personalGitRepository, gitBranch, gitRootpath, username, password);
                        }
                        Status status = git.status().call();
                        Set conflictSet = status.getConflicting();
                        JSONArray arr = new JSONArray();
                        arr.addAll((Collection)conflictSet);
                        if (!conflictSet.isEmpty()) {
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u4ed3\u5e93\u5b58\u5728\u51b2\u7a81\uff0c\u662f\u5426\u524d\u5f80\u89e3\u51b3\u51b2\u7a81\uff1f", (String)"GitOperationUtil_27", (String)"bos-devportal-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("gitConflictCallBack"));
                            return;
                        }
                        this.saveUserName(type, isSave, username, password, jSONObject);
                        String number = (String)this.getView().getFormShowParameter().getCustomParam(NUMBER);
                        String classname = (String)this.getView().getFormShowParameter().getCustomParam(this.classNameParamKey);
                        if (StringUtils.isBlank((CharSequence)classname)) {
                            classname = this.getDefaultDataSetClassName();
                        }
                        Class<?> cls = Class.forName(classname);
                        Class[] parameterTypes = new Class[]{String.class, JSONObject.class};
                        Constructor<?> constructor = cls.getConstructor(parameterTypes);
                        Object[] parameters = new Object[]{number, jSONObject};
                        IDataSetOperater dbOperator = (IDataSetOperater)constructor.newInstance(parameters);
                        JSONObject expMsg = dbOperator.expBaseData(path);
                        String msg = "";
                        if (expMsg.get((Object)ERROR) != null) {
                            msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + jSONObject.get((Object)APP_NUMBER) + ")\uff1a" + workMsg.get((Object)ERROR) + "";
                            lstCommitInfo.add(msg);
                            this.getView().showErrorNotification(((Object)lstCommitInfo).toString());
                            return;
                        }
                        if (expMsg.get((Object)this.notificationParamKey) != null) {
                            msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + jSONObject.get((Object)APP_NUMBER) + ")\uff1a" + workMsg.get((Object)this.notificationParamKey) + "";
                            lstCommitInfo.add(msg);
                        }
                        ArrayList<String> fileNames = new ArrayList<String>();
                        List filePathList = (List)expMsg.get((Object)"flist");
                        if (filePathList.isEmpty()) continue;
                        for (String mapfile : filePathList) {
                            String[] split = mapfile.replace('/', '\\').split("\\\\");
                            String fileName = split[split.length - 1];
                            fileNames.add(fileName);
                        }
                        String msgCp = GitHostingServiceImpl.commitAndPush(personalGitRepository, username, password, annotation, fileNames);
                        if ("success_commitandpush".equals(msgCp)) {
                            msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + jSONObject.get((Object)APP_NUMBER) + this.getSuccessfullyCommitTips();
                            lstCommitInfo.add(msg);
                            continue;
                        }
                        lstCommitInfo.add(msgCp);
                    }
                    catch (Exception e) {
                        sError = e.getMessage();
                        if (sError.contains("cannot be resolved")) {
                            sError = "\u68c0\u67e5\u914d\u7f6e\u7684[Git\u8fdc\u7a0b\u5206\u652f]\u5728\u8fdc\u7a0b\u4ed3\u5e93\u4e2d\u662f\u5426\u5b58\u5728\uff1f";
                        }
                        this.getView().showErrorNotification(sError);
                        return;
                    }
                    finally {
                        if (git == null) continue;
                        git.close();
                    }
                }
                this.getView().close();
                StringBuilder showMsg = new StringBuilder();
                for (String commitInfo : lstCommitInfo) {
                    showMsg.append(commitInfo).append("\r\n");
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u7b7e\u5165\u6210\u529f", (String)"UnitTestSVNLoginPlugin_11", (String)"bos-unittest", (Object[])new Object[0]), showMsg.toString(), MessageTypes.Default);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        } else {
            String type = this.getPageCache().get("type");
            for (JSONObject svnMsg : lstGitMsg) {
                svnMsg.put(USERNAME, (Object)username);
                svnMsg.put(PASSWORD, (Object)password);
                svnMsg.put(ANNOTATION, (Object)annotation);
                svnMsg.put(CAP_NAME, (Object)capName);
                svnMsg.put(PREF_FIX, this.getView().getFormShowParameter().getCustomParam(PREF_FIX));
                svnMsg.put(SUF_FIX, this.getView().getFormShowParameter().getCustomParam(SUF_FIX));
                svnMsg.put(NUMBER, this.getView().getFormShowParameter().getCustomParam(NUMBER));
                svnMsg.put(NUMBER_NAME, this.getView().getFormShowParameter().getCustomParam(NUMBER_NAME));
                JSONObject workMsg = new JSONObject();
                if (DATA_SET.equals(type)) {
                    git = null;
                    try {
                        Status status;
                        Set conflictSet;
                        String gitRepository;
                        appId = (String)svnMsg.get((Object)this.appidFieldKey);
                        path = (String)svnMsg.get((Object)"path");
                        DynamicObject appSet = UnitTestWorkHelper.getAppSetInfo(appId, username);
                        String gitUrl = (String)appSet.get(this.gitUrlFieldKey);
                        String gitBranch = (String)appSet.get("gitbranch");
                        String gitRootpath = (String)appSet.get(this.gitRootPath);
                        String personalGitRepository = gitRepository = (String)appSet.get("gitrepository");
                        String projectURL = personalGitRepository + File.separator + ".git";
                        File gitFile = new File(projectURL);
                        if (!gitFile.exists()) {
                            GitHostingServiceImpl.cloneRepository(gitUrl, personalGitRepository, gitBranch, gitRootpath, username, password);
                        }
                        git = Git.open((File)gitFile);
                        Repository repository = git.getRepository();
                        String branchName = repository.getBranch();
                        if (!StringUtils.isBlank((CharSequence)gitBranch) && !gitBranch.equalsIgnoreCase(branchName)) {
                            git.checkout().setCreateBranch(true).setName(branchName).call();
                            if (UnitTestSVNLoginPlugin.branchNameExist(git, branchName)) {
                                git.checkout().setCreateBranch(false).setName(branchName).call();
                            } else {
                                git.checkout().setCreateBranch(true).setName(branchName).setStartPoint("origin/" + branchName).call();
                            }
                        }
                        if (!(conflictSet = (status = git.status().call()).getConflicting()).isEmpty()) {
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u4ed3\u5e93\u5b58\u5728\u51b2\u7a81\uff0c\u662f\u5426\u524d\u5f80\u89e3\u51b3\u51b2\u7a81\uff1f", (String)"GitOperationUtil_27", (String)"bos-devportal-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("gitConflictCallBack"));
                            return;
                        }
                        String number = (String)this.getView().getFormShowParameter().getCustomParam(NUMBER);
                        String classname = (String)this.getView().getFormShowParameter().getCustomParam(this.classNameParamKey);
                        if (StringUtils.isBlank((CharSequence)classname)) {
                            classname = this.getDefaultDataSetClassName();
                        }
                        Class<?> cls = Class.forName(classname);
                        Class[] parameterTypes = new Class[]{String.class, JSONObject.class};
                        Constructor<?> constructor = cls.getConstructor(parameterTypes);
                        Object[] parameters = new Object[]{number, svnMsg};
                        IDataSetOperater dbOperator = (IDataSetOperater)constructor.newInstance(parameters);
                        JSONObject expMsg = dbOperator.expBaseData(path);
                        String msg = "";
                        if (expMsg.get((Object)ERROR) != null) {
                            msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + svnMsg.get((Object)APP_NUMBER) + ")\uff1a" + workMsg.get((Object)ERROR) + "";
                            lstCommitInfo.add(msg);
                            this.getView().showErrorNotification(((Object)lstCommitInfo).toString());
                            return;
                        }
                        if (expMsg.get((Object)this.notificationParamKey) != null) {
                            msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + svnMsg.get((Object)APP_NUMBER) + ")\uff1a" + workMsg.get((Object)this.notificationParamKey) + "";
                            lstCommitInfo.add(msg);
                        }
                        ArrayList<String> fileNames = new ArrayList<String>();
                        List filePathList = (List)expMsg.get((Object)"flist");
                        if (filePathList.isEmpty()) continue;
                        for (String mapfile : filePathList) {
                            String[] split = mapfile.replace('/', '\\').split("\\\\");
                            String fileName = split[split.length - 1];
                            fileNames.add(fileName);
                            File file = new File(mapfile);
                            if (!file.exists()) continue;
                            file.delete();
                        }
                        String msgCp = GitHostingServiceImpl.commitAndPush(personalGitRepository, username, password, annotation, fileNames);
                        if ("success_commitandpush".equals(msgCp)) {
                            msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + svnMsg.get((Object)APP_NUMBER) + this.getSuccessfullyCommitTips();
                            lstCommitInfo.add(msg);
                        } else {
                            lstCommitInfo.add(msgCp);
                        }
                    }
                    catch (Exception e) {
                        sError = e.getMessage();
                        if (sError.contains("cannot be resolved")) {
                            sError = "\u68c0\u67e5\u914d\u7f6e\u7684[Git\u8fdc\u7a0b\u5206\u652f]\u5728\u8fdc\u7a0b\u4ed3\u5e93\u4e2d\u662f\u5426\u5b58\u5728\uff1f";
                        }
                        this.getView().showErrorNotification(sError);
                        return;
                    }
                    finally {
                        if (git == null) continue;
                        git.close();
                        continue;
                    }
                }
                String msg = "";
                if (workMsg.get((Object)ERROR) == null) continue;
                msg = ResManager.loadKDString((String)"\u5e94\u7528(", (String)UNIT_TEST_SVN_LOGIN_PLUGIN_7, (String)"bos-unittest", (Object[])new Object[0]) + svnMsg.get((Object)APP_NUMBER) + ")\uff1a" + workMsg.get((Object)ERROR) + "";
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("msg", msg);
                this.getView().returnDataToParent(map);
                this.getView().close();
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("success", this.getSuccessfullyDeleteTips());
            if (this.isScriptType(type)) {
                if (isSave) {
                    SessionManager.getCurrent().put(SMG_USERNAME, username);
                    SessionManager.getCurrent().put(SMG_PASSWORD, password);
                } else {
                    SessionManager.getCurrent().put(SMG_USERNAME, "");
                    SessionManager.getCurrent().put(SMG_PASSWORD, "");
                }
            } else if (isSave) {
                ((JSONObject)lstGitMsg.get(0)).remove((Object)LOCAL_PATH);
                ((JSONObject)lstGitMsg.get(0)).remove((Object)SVN_PATH);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction(SAVE_SVN_MSG, lstGitMsg.get(0));
            } else {
                ((JSONObject)lstGitMsg.get(0)).clear();
                ((JSONObject)lstGitMsg.get(0)).put(USERNAME, (Object)"");
                ((JSONObject)lstGitMsg.get(0)).put(PASSWORD, (Object)"");
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction(SAVE_SVN_MSG, lstGitMsg.get(0));
            }
            this.getView().returnDataToParent(hashMap);
            this.getView().close();
        }
    }

    private static boolean branchNameExist(Git git, String branchName) throws GitAPIException {
        List refs = git.branchList().call();
        for (Ref ref : refs) {
            if (!ref.getName().contains(branchName)) continue;
            return true;
        }
        return false;
    }

    private void cancel() {
        this.getView().close();
    }

    private void saveUserName(String type, boolean isSave, String username, String password, JSONObject svnMsg) {
        if (isSave) {
            SessionManager.getCurrent().put(SMG_USERNAME, username);
            SessionManager.getCurrent().put(SMG_PASSWORD, password);
        } else {
            SessionManager.getCurrent().put(SMG_USERNAME, "");
            SessionManager.getCurrent().put(SMG_PASSWORD, "");
        }
    }

    public void delUnittestFile(File file) {
        if (file.isDirectory()) {
            String[] files;
            for (String s : files = file.list()) {
                this.delUnittestFile(new File(file, s));
            }
        }
        file.delete();
    }

    private void doLogin() {
        IDataModel model = this.getModel();
        String username = (String)model.getValue(USERNAME);
        String password = (String)model.getValue(PASSWORD);
        String giturl = (String)model.getValue(this.gitUrlFieldKey);
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(this.appidFieldKey);
        boolean isSave = (Boolean)model.getValue(IS_SAVE);
        if (StringUtils.isBlank((CharSequence)giturl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (String)"UnitTestSVNLoginPlugin_13", (String)"bos-unittest", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            this.getView().showTipNotification(this.getBlankUserNameTips());
            return;
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            this.getView().showTipNotification(this.getBlankPassWordTips());
            return;
        }
        try {
            if (!GitHostingServiceImpl.checkRemoteAccount(giturl, username, password)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\uff01", (String)"UnitTestSVNLoginPlugin_14", (String)"bos-unittest", (Object[])new Object[0]));
                return;
            }
        }
        catch (GitAPIException e) {
            if (e.getMessage().contains("not authorized")) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\uff01", (String)"UnitTestSVNLoginPlugin_14", (String)"bos-unittest", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8fdc\u7a0b\u4ed3\u5e93\u8fde\u63a5\u5f02\u5e38\uff1a", (String)"UnitTestSVNLoginPlugin_15", (String)"bos-unittest", (Object[])new Object[0]) + e.getMessage());
            }
            return;
        }
        if (isSave) {
            SessionManager.getCurrent().put(SMG_USERNAME, username);
            SessionManager.getCurrent().put(SMG_PASSWORD, password);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.gitUrlFieldKey, giturl);
        map.put(USERNAME, username);
        map.put(PASSWORD, password);
        map.put(this.appidFieldKey, appId);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private String getBlankUserNameTips() {
        return ResManager.loadKDString((String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"UnitTestSVNLoginPlugin_1", (String)"bos-unittest", (Object[])new Object[0]);
    }

    private String getBlankPassWordTips() {
        return ResManager.loadKDString((String)"\u7528\u6237\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"UnitTestSVNLoginPlugin_4", (String)"bos-unittest", (Object[])new Object[0]);
    }

    private String getSuccessfullyCommitTips() {
        return ResManager.loadKDString((String)")\uff1a\u7b7e\u5165\u6210\u529f", (String)"UnitTestSVNLoginPlugin_10", (String)"bos-unittest", (Object[])new Object[0]);
    }

    private String getSuccessfullyDeleteTips() {
        return ResManager.loadKDString((String)"SVN\u5220\u9664\u6210\u529f", (String)"UnitTestSVNLoginPlugin_3", (String)"bos-unittest", (Object[])new Object[0]);
    }

    private boolean isScriptType(String type) {
        return "script".equals(type);
    }

    private String getDefaultDataSetClassName() {
        return "kd.bos.designer.baserecordset.AbstractDataSetOperater";
    }
}

