/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class UnitTestTreeListCloudAppUnitHelper {
    private static final String NUMBER = "number";

    public static List<TreeNode> getAllCloudNodes() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject dynamicObject : dynamicObjects) {
            TreeNode node = new TreeNode();
            node.setId(dynamicObject.getString("id"));
            node.setText(dynamicObject.getString("name"));
            JSONObject map = new JSONObject();
            map.put("type", (Object)"cloud");
            map.put(NUMBER, (Object)dynamicObject.getString(NUMBER));
            node.setData((Object)map);
            node.setParentid("");
            nodes.add(node);
        }
        return nodes;
    }

    public static List<TreeNode> getAppsByCloudId(String bizCloudId) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        List lstAppInfo = BizAppServiceHelp.getAppsDesigntimeInfo((String)bizCloudId);
        if (lstAppInfo != null) {
            for (String info : lstAppInfo) {
                Map app = (Map)SerializationUtils.fromJsonString((String)info, Map.class);
                TreeNode node = new TreeNode();
                node.setId((String)app.get("id"));
                node.setText(((Map)app.get("name")).get("zh_CN").toString());
                JSONObject map = new JSONObject();
                map.put("type", (Object)"app");
                map.put(NUMBER, app.get(NUMBER));
                node.setData((Object)map);
                node.setParentid(bizCloudId);
                nodes.add(node);
            }
        }
        return nodes;
    }

    public static JSONArray getAppIdsByCloudId(String bizCloudId) {
        JSONArray appIds = new JSONArray();
        List lstAppInfo = BizAppServiceHelp.getAppsDesigntimeInfo((String)bizCloudId);
        if (lstAppInfo != null) {
            for (String info : lstAppInfo) {
                Map app = (Map)SerializationUtils.fromJsonString((String)info, Map.class);
                String bizAppId = (String)app.get("id");
                appIds.add((Object)bizAppId);
            }
        }
        return appIds;
    }

    public static JSONArray getUnitIdsByCloudId(String bizCloudId) {
        JSONArray unitIds = new JSONArray();
        List lstAppInfo = BizAppServiceHelp.getAppsDesigntimeInfo((String)bizCloudId);
        if (lstAppInfo != null) {
            for (String info : lstAppInfo) {
                Map app = (Map)SerializationUtils.fromJsonString((String)info, Map.class);
                String bizAppId = (String)app.get("id");
                JSONArray tempUnitIds = UnitTestTreeListCloudAppUnitHelper.getUnitsByAppIdNew(bizAppId);
                unitIds.addAll((Collection)tempUnitIds);
            }
        }
        return unitIds;
    }

    public static JSONArray getUnitIdsByAppId(String bizAppId) {
        JSONArray unitIds = new JSONArray();
        List menus = BizAppServiceHelp.getAppLevelOneFuncsRuntimeInfoById((String)bizAppId);
        for (String menu : menus) {
            Map unit = (Map)SerializationUtils.fromJsonString((String)menu, Map.class);
            unitIds.add((Object)((String)unit.get("id")));
        }
        return unitIds;
    }

    public static List<TreeNode> getUnitsByAppId(String bizAppId) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        List units = BizAppServiceHelp.getAppFuncsRuntimeInfoById((String)bizAppId);
        HashMap<String, TreeNode> mapNodes = new HashMap<String, TreeNode>();
        if (units != null) {
            JSONObject map;
            TreeNode node;
            String parentId;
            Map unitInfo;
            for (String unit : units) {
                unitInfo = (Map)SerializationUtils.fromJsonString((String)unit, Map.class);
                parentId = (String)unitInfo.get("parentid");
                if (!StringUtils.isBlank((CharSequence)parentId)) continue;
                node = new TreeNode();
                node.setId((String)unitInfo.get("id"));
                node.setText((String)unitInfo.get("name"));
                node.setParentid(bizAppId);
                map = new JSONObject();
                map.put("type", (Object)"funit");
                map.put(NUMBER, unitInfo.get(NUMBER));
                node.setData((Object)map);
                nodes.add(node);
                mapNodes.put(node.getId(), node);
            }
            for (String unit : units) {
                unitInfo = (Map)SerializationUtils.fromJsonString((String)unit, Map.class);
                parentId = (String)unitInfo.get("parentid");
                if (StringUtils.isBlank((CharSequence)parentId)) continue;
                node = new TreeNode();
                node.setId((String)unitInfo.get("id"));
                node.setText((String)unitInfo.get("name"));
                node.setParentid(parentId);
                map = new JSONObject();
                map.put("type", (Object)"funit");
                map.put(NUMBER, unitInfo.get(NUMBER));
                node.setData((Object)map);
                TreeNode nodeParent = (TreeNode)mapNodes.get(parentId);
                if (nodeParent == null) continue;
                nodeParent.addChild(node);
            }
        }
        return nodes;
    }

    public static List<TreeNode> getChildrenUnitByParentId(String appId, String parentUnitId) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        List lstSubUtils = BizAppServiceHelp.getAppSubFuncsRuntimeInfo((String)appId, (String)parentUnitId);
        if (lstSubUtils != null) {
            for (String subUnit : lstSubUtils) {
                Map subUnitInfo = (Map)SerializationUtils.fromJsonString((String)subUnit, Map.class);
                TreeNode node = new TreeNode();
                node.setId((String)subUnitInfo.get("id"));
                node.setText((String)subUnitInfo.get("name"));
                node.setParentid(parentUnitId);
                JSONObject map = new JSONObject();
                map.put("type", (Object)"sunit");
                map.put(NUMBER, subUnitInfo.get(NUMBER));
                node.setData((Object)map);
                nodes.add(node);
            }
        }
        return nodes;
    }

    public static JSONArray getUnitsByAppIdNew(String appId) {
        JSONArray unitIds = new JSONArray();
        List lstUnits = BizAppServiceHelp.getAppFuncsRuntimeInfoById((String)appId);
        if (lstUnits != null) {
            for (String unit : lstUnits) {
                Map unitMap = (Map)SerializationUtils.fromJsonString((String)unit, Map.class);
                unitIds.add((Object)((String)unitMap.get("id")));
            }
        }
        return unitIds;
    }

    public static JSONArray getChildrenUnitIdsByParentId(String appId, String parentUnitId) {
        JSONArray unitIds = new JSONArray();
        unitIds.add((Object)parentUnitId);
        List lstSubUtils = BizAppServiceHelp.getAppSubFuncsRuntimeInfo((String)appId, (String)parentUnitId);
        if (lstSubUtils != null) {
            for (String subUnit : lstSubUtils) {
                Map subUnitInfo = (Map)SerializationUtils.fromJsonString((String)subUnit, Map.class);
                unitIds.add((Object)((String)subUnitInfo.get("id")));
            }
        }
        return unitIds;
    }
}

