/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.baserecordset.AbstractDataSetOperater;
import kd.bos.designer.unittest.ZipTools;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.util.DevportalCommonUtil;

public class UnitTestUtils {
    public static final String ERROR = "ERROR";
    public static final String SUCCESS = "SUCCESS";
    private static final String MESS = "\u5bfc\u51fa\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a";
    private static final String UNIT_TEST_UTILS_0 = "UnitTestUtils_0";

    public static Map<String, String> expUnitTestSql(String unittestid) {
        AbstractDataSetOperater dbOperator = new AbstractDataSetOperater("ide_unit_test_detail");
        ArrayList<String> listIds = new ArrayList<String>();
        listIds.add(unittestid);
        HashMap<String, String> returnMap = new HashMap<String, String>(10);
        List lstMap = dbOperator.getExpDataSetSqlWithIds(listIds);
        if (lstMap.isEmpty()) {
            return null;
        }
        String sql = "";
        for (Map map : lstMap) {
            sql = (String)map.get("sql");
            returnMap.put("sql", sql);
            if (map.get("xml") == null) continue;
            Map xmlMap = (Map)map.get("xml");
            for (Map.Entry entry : xmlMap.entrySet()) {
                returnMap.put("xml", entry.getValue().toString());
            }
        }
        return returnMap;
    }

    public static void exportUnitTestCallBack(String unittestid, String unittestnumber, IFormView formView) {
        Map<String, String> returnMap = UnitTestUtils.expUnitTestSql(unittestid);
        if (returnMap == null) {
            throw new KDException(BosErrorCode.systemError, new Object[0]);
        }
        for (Map.Entry<String, String> entry : returnMap.entrySet()) {
            String urls2;
            Throwable throwable;
            ByteArrayInputStream in;
            String fileName;
            if ("sql".equals(entry.getKey())) {
                fileName = UnitTestUtils.getUnittestSqlName(unittestnumber);
                String unitTestSql = entry.getValue();
                try {
                    in = new ByteArrayInputStream(unitTestSql.getBytes(StandardCharsets.UTF_8));
                    throwable = null;
                    try {
                        urls2 = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5);
                        formView.openUrl(urls2);
                        continue;
                    }
                    catch (Throwable urls2) {
                        throwable = urls2;
                        throw urls2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable urls2) {
                                throwable.addSuppressed(urls2);
                            }
                            continue;
                        }
                        ((InputStream)in).close();
                        continue;
                    }
                }
                catch (Exception e) {
                    formView.showErrorNotification(ResManager.loadKDString((String)MESS, (String)UNIT_TEST_UTILS_0, (String)"bos-unittest", (Object[])new Object[0]) + e.getMessage());
                    return;
                }
            }
            if (!"xml".equals(entry.getKey())) continue;
            fileName = UnitTestUtils.getUnittestXmlName(unittestnumber);
            String xmlSql = entry.getValue();
            try {
                in = new ByteArrayInputStream(xmlSql.getBytes(StandardCharsets.UTF_8));
                throwable = null;
                try {
                    urls2 = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5);
                    formView.openUrl(urls2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
            catch (Exception e) {
                formView.showErrorNotification(ResManager.loadKDString((String)MESS, (String)UNIT_TEST_UTILS_0, (String)"bos-unittest", (Object[])new Object[0]) + e.getMessage());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportUnitTestCallBack(List<Map<String, Object>> lstMapCaseInfo, IFormView formView) {
        String zipName = UnitTestUtils.getZipName(lstMapCaseInfo, true);
        File zipFile = new File(zipName);
        try {
            ArrayList<ZipTools.ZipParam> lstParam = new ArrayList<ZipTools.ZipParam>();
            for (Map<String, Object> mapCaseInfo : lstMapCaseInfo) {
                String caseId = (String)mapCaseInfo.get("caseid");
                String caseNumber = (String)mapCaseInfo.get("casenumber");
                Map<String, String> returnMap = UnitTestUtils.expUnitTestSql(caseId);
                if (returnMap == null) {
                    throw new KDException(BosErrorCode.systemError, new Object[0]);
                }
                for (Map.Entry<String, String> entry : returnMap.entrySet()) {
                    ZipTools.ZipParam param;
                    String fileName;
                    if ("sql".equals(entry.getKey())) {
                        fileName = UnitTestUtils.getUnittestSqlName(caseNumber);
                        String unitTestSql = entry.getValue();
                        ByteArrayInputStream sql = new ByteArrayInputStream(unitTestSql.getBytes(StandardCharsets.UTF_8));
                        param = new ZipTools.ZipParam();
                        param.isfile = true;
                        param.name = fileName;
                        param.stream = sql;
                        lstParam.add(param);
                        continue;
                    }
                    if (!"xml".equals(entry.getKey())) continue;
                    fileName = UnitTestUtils.getUnittestXmlName(caseNumber);
                    String xmlSql = entry.getValue();
                    ByteArrayInputStream xml = new ByteArrayInputStream(xmlSql.getBytes(StandardCharsets.UTF_8));
                    param = new ZipTools.ZipParam();
                    param.isfile = true;
                    param.name = fileName;
                    param.stream = xml;
                    param.direct = "xml";
                    lstParam.add(param);
                }
            }
            ZipTools.zipStreams(lstParam, zipFile);
        }
        catch (Exception e) {
            formView.showErrorNotification(ResManager.loadKDString((String)MESS, (String)UNIT_TEST_UTILS_0, (String)"bos-unittest", (Object[])new Object[0]) + e.getMessage());
            return;
        }
        try {
            FileInputStream zipFileInputStream = new FileInputStream(zipFile);
            Object object = null;
            try {
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(UnitTestUtils.getZipName(lstMapCaseInfo, false), (InputStream)zipFileInputStream, 5);
                zipFileInputStream.close();
                formView.download(urls);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (zipFileInputStream != null) {
                    if (object != null) {
                        try {
                            zipFileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        zipFileInputStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            formView.showErrorNotification(ResManager.loadKDString((String)MESS, (String)UNIT_TEST_UTILS_0, (String)"bos-unittest", (Object[])new Object[0]) + e.getMessage());
        }
        finally {
            zipFile.delete();
        }
    }

    public static String getUnittestSqlName(String number) {
        return "unittest_" + number + "_pre_ins.SQL";
    }

    public static String getUnittestXmlName(String number) {
        return "unittest_" + number + "_pre_ins.xml";
    }

    public static String getZipName(List<Map<String, Object>> lstMapCaseInfo, boolean bWithUUID) {
        String zipName = "";
        zipName = lstMapCaseInfo.size() <= 1 ? (String)lstMapCaseInfo.get(0).get("casenumber") : "preinsdata";
        if (bWithUUID) {
            zipName = zipName + "_" + UUID.randomUUID();
        }
        zipName = zipName + ".zip";
        return zipName;
    }

    public static boolean isGitManageType() {
        return DevportalCommonUtil.isGitManageType();
    }

    public static String getGitCommonRemoteUrl() {
        return DevportalCommonUtil.getGitCommonRemoteUrl();
    }

    public static boolean isGitMultiParallel() {
        return DevportalCommonUtil.isGitMultiParallel();
    }
}

