/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import com.alibaba.fastjson.JSONArray;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DevportalCommonUtil;

public class UnitTestWorkHelper {
    private static final String APP_ID = "appid";
    private static final String APP_NUMBER = "appnumber";
    private static final String NUMBER = "number";
    private static final String MAP_IDS = "mapids";
    private static final String FORM_NUMBER = "ide_unit_test_detail";

    public static void doCheckIn(AbstractFormPlugin plugin, JSONArray caseIds) {
        ORM orm = ORM.create();
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)caseIds)};
        String selectFields = "id,bizappid,bizappid.number";
        HashMap mapIds = new HashMap();
        DynamicObjectCollection itemCollection = orm.query(FORM_NUMBER, selectFields, filter);
        for (DynamicObject item : itemCollection) {
            String appId = item.getString("bizappid.id");
            String caseId = item.getString("id");
            String appNumber = item.getString("bizappid.number");
            if (StringUtils.isBlank((CharSequence)appId)) continue;
            Map<String, String> mapItem = (HashMap<String, String>)mapIds.get(appId);
            if (mapItem == null) {
                mapItem = new HashMap<String, String>();
                JSONArray appIds = new JSONArray();
                mapItem.put(APP_ID, appId);
                mapItem.put(APP_NUMBER, appNumber);
                mapItem.put("ids", (String)appIds);
                mapIds.put(appId, mapItem);
                mapItem = (Map)mapIds.get(appId);
            }
            ((JSONArray)mapItem.get("ids")).add((Object)caseId);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("unit_test_svn_login");
        parameter.setCustomParam("type", (Object)"dataset");
        parameter.setCustomParam(NUMBER, (Object)FORM_NUMBER);
        parameter.setCustomParam(MAP_IDS, mapIds);
        parameter.setCustomParam("deletePageFlag", (Object)Boolean.FALSE);
        parameter.setCustomParam("issave", (Object)Boolean.TRUE);
        plugin.getView().showForm(parameter);
    }

    public static void doDelete(AbstractFormPlugin plugin, JSONArray caseIds) {
        plugin.getPageCache().put("ids", caseIds.toJSONString());
        ORM orm = ORM.create();
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)caseIds)};
        String selectFields = "id,bizappid,bizappid.number";
        HashMap mapIds = new HashMap();
        DynamicObjectCollection itemCollection = orm.query(FORM_NUMBER, selectFields, filter);
        for (DynamicObject item : itemCollection) {
            String appId = item.getString("bizappid.id");
            String caseId = item.getString("id");
            String appNumber = item.getString("bizappid.number");
            if (StringUtils.isBlank((CharSequence)appId)) continue;
            Map<String, String> mapItem = (HashMap<String, String>)mapIds.get(appId);
            if (mapItem == null) {
                mapItem = new HashMap<String, String>();
                JSONArray appIds = new JSONArray();
                mapItem.put(APP_ID, appId);
                mapItem.put(APP_NUMBER, appNumber);
                mapItem.put("ids", (String)appIds);
                mapIds.put(appId, mapItem);
                mapItem = (Map)mapIds.get(appId);
            }
            ((JSONArray)mapItem.get("ids")).add((Object)caseId);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("unit_test_delete_confirm");
        parameter.setCaption(ResManager.loadKDString((String)"\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b\u5220\u9664\u786e\u8ba4\u5bf9\u8bdd\u6846", (String)"UnitTestWorkHelper_0", (String)"bos-unittest", (Object[])new Object[0]));
        parameter.setCustomParam("message", (Object)ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u6240\u9009\u4e2d\u7684\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b\u5417\uff1f", (String)"UnitTestWorkHelper_1", (String)"bos-unittest", (Object[])new Object[0]));
        parameter.setCustomParam(NUMBER, (Object)FORM_NUMBER);
        parameter.setCustomParam(MAP_IDS, mapIds);
        parameter.setCustomParam("numbername", (Object)"txt_number");
        parameter.setCustomParam("appname", (Object)"bizappid");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "deleteUnitTestCaseCloseCallBack"));
        plugin.getView().showForm(parameter);
    }

    public static void doUTAppSetCheckIn(AbstractFormPlugin plugin, JSONArray ids, String formNumber) {
        ORM orm = ORM.create();
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        String selectFields = "id,appid,appid.number";
        HashMap mapIds = new HashMap();
        DynamicObjectCollection itemCollection = orm.query(formNumber, selectFields, filter);
        for (DynamicObject item : itemCollection) {
            String appId = item.getString("appid.id");
            String id = item.getString("id");
            String appNumber = item.getString("appid.number");
            if (StringUtils.isBlank((CharSequence)appId)) continue;
            Map<String, String> mapItem = (HashMap<String, String>)mapIds.get(appId);
            if (mapItem == null) {
                mapItem = new HashMap<String, String>();
                JSONArray appIds = new JSONArray();
                mapItem.put(APP_ID, appId);
                mapItem.put(APP_NUMBER, appNumber);
                mapItem.put("ids", (String)appIds);
                mapIds.put(appId, mapItem);
                mapItem = (Map)mapIds.get(appId);
            }
            ((JSONArray)mapItem.get("ids")).add((Object)id);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("unit_test_svn_login");
        parameter.setCustomParam("type", (Object)"dataset");
        parameter.setCustomParam(NUMBER, (Object)formNumber);
        parameter.setCustomParam(MAP_IDS, mapIds);
        parameter.setCustomParam("deletePageFlag", (Object)Boolean.FALSE);
        parameter.setCustomParam("issave", (Object)Boolean.TRUE);
        parameter.setCustomParam("preffix", (Object)"ut_");
        parameter.setCustomParam("suffix", (Object)"_setting.SQL");
        parameter.setCustomParam("classname", (Object)"kd.bos.designer.baserecordset.UtAppSetDataSetOperator");
        plugin.getView().showForm(parameter);
    }

    public static String getAppSetResponser(String appid) {
        String responser = "";
        ORM orm = ORM.create();
        QFilter filter = new QFilter(APP_ID, "=", (Object)appid);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject item = orm.queryOne("ut_app_set", filters);
        if (null != item) {
            responser = item.getString("responser");
        }
        return responser;
    }

    public static DynamicObject getAppSetInfo(String appid, String gitUserName) {
        QFilter userFilter;
        ORM orm = ORM.create();
        QFilter filter = new QFilter(APP_ID, "=", (Object)appid);
        Object[] filters = new QFilter[]{filter};
        if (!StringUtils.isBlank((CharSequence)gitUserName) && DevportalCommonUtil.isGitMultiParallel()) {
            userFilter = new QFilter("gitusername", "=", (Object)gitUserName);
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)userFilter);
        } else {
            userFilter = new QFilter("gitusername", "=", (Object)Character.valueOf(' '));
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)userFilter);
        }
        DynamicObject item = orm.queryOne("ut_app_set", (QFilter[])filters);
        return item;
    }
}

