/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.unittest;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ZipTools {
    private static final Log logger = LogFactory.getLog(ZipTools.class);
    private static final String CHARSET_UTF8 = "UTF-8";

    private ZipTools() {
    }

    public static void zipStreams(List<ZipParam> lstParam, File zipFile) throws IOException {
        if (lstParam != null) {
            if (zipFile.exists()) {
                for (ZipParam param : lstParam) {
                    ZipTools.zip(zipFile, param);
                }
            } else {
                try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
                     ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)fileOutputStream, Charset.forName(CHARSET_UTF8));
                     BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);){
                    for (ZipParam param : lstParam) {
                        ZipTools.zipStream(param, zipOutStream, bufferOutStream);
                    }
                    bufferOutStream.close();
                    zipOutStream.close();
                }
            }
        }
    }

    public static void zipFiles(List<File> fileList, File zipFile) throws IOException {
        if (fileList != null) {
            if (zipFile.exists()) {
                for (File file : fileList) {
                    ZipTools.zip(zipFile, file);
                }
            } else {
                try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
                     ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)fileOutputStream, Charset.forName(CHARSET_UTF8));
                     BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);){
                    for (File file : fileList) {
                        ZipTools.zipFile(file, zipOutStream, bufferOutStream);
                    }
                    bufferOutStream.close();
                    zipOutStream.close();
                }
            }
        }
    }

    private static void zipStream(ZipParam param, ZipOutputStream zipOutStream, BufferedOutputStream bufferOutStream) throws IOException {
        String direct = param.direct;
        String path = StringUtils.isNotBlank((CharSequence)direct) ? direct + File.separator + param.name : param.name;
        ZipEntry entry = new ZipEntry(path);
        zipOutStream.putNextEntry(entry);
        BufferedInputStream bufferInputStream = new BufferedInputStream(param.stream);
        ZipTools.write(bufferInputStream, bufferOutStream);
        zipOutStream.closeEntry();
    }

    private static void zipFile(File file, ZipOutputStream zipOutStream, BufferedOutputStream bufferOutStream) throws IOException {
        ZipEntry entry = new ZipEntry(file.getName());
        zipOutStream.putNextEntry(entry);
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferInputStream = new BufferedInputStream(fileInputStream);){
            ZipTools.write(bufferInputStream, bufferOutStream);
            zipOutStream.closeEntry();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zip(File zipFile, ZipParam sourceParam) throws IOException {
        if (zipFile.exists()) {
            File tempFile = new File(zipFile.getCanonicalPath() + ".tmp");
            try (FileOutputStream zipOutFileStream = new FileOutputStream(tempFile);
                 ZipFile zipOutFile = new ZipFile(zipFile);){
                boolean bRet;
                ZipEntry entry;
                ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)zipOutFileStream, StandardCharsets.UTF_8);
                BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);
                Enumeration<? extends ZipEntry> entries = zipOutFile.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    zipOutStream.putNextEntry(entry);
                    if (!entry.isDirectory()) {
                        ZipTools.write(zipOutFile.getInputStream(entry), bufferOutStream);
                    }
                    zipOutStream.closeEntry();
                }
                entry = new ZipEntry(sourceParam.name);
                zipOutStream.putNextEntry(entry);
                BufferedInputStream bufferInputStream = new BufferedInputStream(sourceParam.stream);
                ZipTools.write(bufferInputStream, bufferOutStream);
                bufferOutStream.close();
                zipOutStream.close();
                boolean flag = zipFile.delete();
                if (!flag || (bRet = tempFile.renameTo(zipFile))) return;
                logger.error("zip\u91cd\u547d\u540d\u5931\u8d25");
                return;
            }
        }
        try (FileOutputStream zipOutFileStream = new FileOutputStream(zipFile);){
            ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)zipOutFileStream, Charset.forName(CHARSET_UTF8));
            BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);
            ZipEntry entry = new ZipEntry(sourceParam.name);
            zipOutStream.putNextEntry(entry);
            BufferedInputStream bufferInputStream = new BufferedInputStream(sourceParam.stream);
            ZipTools.write(bufferInputStream, bufferOutStream);
            bufferOutStream.close();
            zipOutStream.close();
            return;
        }
    }

    public static void zip(File zipFile, File sourceFile) throws IOException {
        block64: {
            if (zipFile.exists()) {
                File tempFile = new File(zipFile.getCanonicalPath() + ".tmp");
                try (FileOutputStream outZipFile = new FileOutputStream(tempFile);
                     ZipFile zipOutFile = new ZipFile(zipFile);
                     FileInputStream inSourceFile = new FileInputStream(sourceFile);){
                    boolean bRet;
                    ZipEntry entry;
                    ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)outZipFile, Charset.forName(CHARSET_UTF8));
                    BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);
                    Enumeration<? extends ZipEntry> entries = zipOutFile.entries();
                    while (entries.hasMoreElements()) {
                        entry = entries.nextElement();
                        zipOutStream.putNextEntry(entry);
                        if (!entry.isDirectory()) {
                            ZipTools.write(zipOutFile.getInputStream(entry), bufferOutStream);
                        }
                        zipOutStream.closeEntry();
                    }
                    zipOutFile.close();
                    entry = new ZipEntry(sourceFile.getName());
                    zipOutStream.putNextEntry(entry);
                    BufferedInputStream bufferInputStream = new BufferedInputStream(inSourceFile);
                    ZipTools.write(bufferInputStream, bufferOutStream);
                    bufferOutStream.close();
                    zipOutStream.close();
                    boolean flag = zipFile.delete();
                    if (flag && !(bRet = tempFile.renameTo(zipFile))) {
                        logger.error("zip\u91cd\u547d\u540d\u5931\u8d25");
                    }
                    break block64;
                }
            }
            try (FileOutputStream outZipFile = new FileOutputStream(zipFile);
                 FileInputStream inSourceFile = new FileInputStream(sourceFile);){
                ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)outZipFile, Charset.forName(CHARSET_UTF8));
                BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);
                ZipEntry entry = new ZipEntry(sourceFile.getName());
                zipOutStream.putNextEntry(entry);
                BufferedInputStream bufferInputStream = new BufferedInputStream(inSourceFile);
                ZipTools.write(bufferInputStream, bufferOutStream);
                bufferOutStream.close();
                zipOutStream.close();
            }
        }
    }

    private static void write(InputStream inputStream, OutputStream outStream) throws IOException {
        byte[] data = new byte[4096];
        int length = 0;
        while ((length = inputStream.read(data)) != -1) {
            outStream.write(data, 0, length);
        }
        outStream.flush();
        inputStream.close();
    }

    public static void zipDirectory(File dirFile, File zipFile) throws IOException {
        if (dirFile != null && dirFile.isDirectory()) {
            if (zipFile != null) {
                try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
                     ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)fileOutputStream, Charset.forName(CHARSET_UTF8));
                     BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);){
                    String dirName = dirFile.getName() + File.separator;
                    ZipTools.dealDirFile(dirFile, dirName, bufferOutStream, zipOutStream);
                    bufferOutStream.close();
                    zipOutStream.close();
                }
            }
        } else if (dirFile == null) {
            logger.error("dirFile\u4e3a\u7a7a");
        } else {
            logger.error("[" + dirFile.getName() + "]\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939,\u6216\u8005\u4e0d\u5b58\u5728\u3002");
        }
    }

    private static void dealDirFile(File dirFile, String parentDir, BufferedOutputStream bufferOutStream, ZipOutputStream zipOutStream) throws IOException {
        File[] fileList;
        for (File file : fileList = dirFile.listFiles()) {
            if (file.isFile()) {
                ZipEntry entry = new ZipEntry(parentDir + file.getName());
                zipOutStream.putNextEntry(entry);
                try (FileInputStream fileInputStream = new FileInputStream(file);
                     BufferedInputStream bufferInputStream = new BufferedInputStream(fileInputStream);){
                    ZipTools.write(bufferInputStream, bufferOutStream);
                    continue;
                }
            }
            ZipTools.dealDirFile(file, parentDir + file.getName() + File.separator, bufferOutStream, zipOutStream);
        }
    }

    public static void zipDirectory(String dirPath, String zipPath) throws IOException {
        if (zipPath == null || "".equals(zipPath)) {
            ZipTools.zipDirectory(new File(dirPath), null);
        } else {
            ZipTools.zipDirectory(new File(dirPath), new File(zipPath));
        }
    }

    public static void unzip(File zipFile, File destDir) throws IOException {
        try (ZipFile zipOutFile = new ZipFile(zipFile.getCanonicalFile(), Charset.forName("gbk"));){
            Enumeration<? extends ZipEntry> entries = zipOutFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File tempFile = new File(ZipTools.cleanString((destDir.getCanonicalPath() + File.separator + entry.getName()).replace("../", "#")));
                if (entry.isDirectory()) {
                    if (tempFile.exists()) continue;
                    tempFile.mkdirs();
                    continue;
                }
                ZipTools.checkParentDir(tempFile);
                FileOutputStream fileOutStream = new FileOutputStream(tempFile);
                Throwable throwable = null;
                try {
                    BufferedOutputStream bufferOutStream = new BufferedOutputStream(fileOutStream);
                    Throwable throwable2 = null;
                    try {
                        InputStream inputStream = zipOutFile.getInputStream(entry);
                        Throwable throwable3 = null;
                        try {
                            ZipTools.write(inputStream, bufferOutStream);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable3 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (bufferOutStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                bufferOutStream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        bufferOutStream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (fileOutStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileOutStream.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    fileOutStream.close();
                }
            }
        }
    }

    private static void checkParentDir(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
    }

    private static String cleanString(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("../", "#");
        StringBuilder cleanString = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            cleanString.append(ZipTools.cleanChar(str.charAt(i)));
        }
        return cleanString.toString();
    }

    private static char cleanChar(char c) {
        int i;
        for (i = 48; i < 58; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        for (i = 65; i < 91; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        for (i = 97; i < 123; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        switch (c) {
            case 58: {
                return ':';
            }
            case 47: {
                return '/';
            }
            case 46: {
                return '.';
            }
            case 45: {
                return '-';
            }
            case 95: {
                return '_';
            }
            case 32: {
                return ' ';
            }
        }
        if (((char)c + "").equals("\\")) {
            return (char)c;
        }
        return '%';
    }

    public static class ZipParam {
        public String name;
        public boolean isfile;
        public InputStream stream;
        public String direct;
    }
}

