/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.unittest.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.unittest.ExcelDataObject;
import kd.bos.form.unittest.ImportExcelDataList;
import kd.bos.form.unittest.JMXForAnalysis;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.upload.UploadOption;

public class BizUnitTestPageNewPlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener {
    private static final String JMXLOACTION = "jmxloaction";
    private static final String BUTTONAP = "buttonap";
    private static final String DATASOURCEBUTTONAP = "datasourcebuttonap";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String TXT_NUMBER = "txt_number";
    private static final String MULTI_TXT_NAME = "multi_txt_name";
    private static final String STEP_2 = "step2";
    private static final String JMXCONTEXT = "jmxcontext";
    private static final String DATASOURCECONTENT = "datasourcecontent";
    private static final String SUCCESS = "success";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnnext1", "btnlast2", "btnnext2", "btnlast3", "btnfinish", JMXLOACTION, "importdatasource", "responsers"});
        Button btn = (Button)this.getControl(BUTTONAP);
        btn.addUploadListener((UploadListener)this);
        Button dataSourceBtn = (Button)this.getControl(DATASOURCEBUTTONAP);
        dataSourceBtn.addUploadListener((UploadListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "btnnext1": {
                this.step1next();
                break;
            }
            case "btnlast2": {
                this.step2last();
                break;
            }
            case "btnnext2": {
                this.step2next();
                break;
            }
            case "btnlast3": {
                this.step3last();
                break;
            }
            case "btnfinish": {
                this.finish();
                break;
            }
            case "jmxloaction": {
                this.showUploadView(JMXLOACTION);
                break;
            }
            case "importdatasource": {
                this.showUploadView("importdatasource");
                break;
            }
            case "responsers": {
                ListShowParameter para = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
                CloseCallBack callback = new CloseCallBack((IFormPlugin)this, "responsers");
                para.setCloseCallBack(callback);
                this.getView().showForm((FormShowParameter)para);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("responsers".equalsIgnoreCase(e.getActionId())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            StringBuilder responsers = new StringBuilder();
            for (ListSelectedRow row : rows) {
                responsers.append(row.getName()).append(' ');
            }
            responsers = new StringBuilder(responsers.toString().trim());
            this.getModel().setValue("responsers", (Object)responsers.toString());
        }
    }

    private void showUploadView(String fromControl) {
        if (fromControl.equals(JMXLOACTION)) {
            UploadOption uploadOption = new UploadOption();
            uploadOption.setMultiple(false);
            uploadOption.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20jmx", (String)"BizUnitTestPageNewPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            uploadOption.setSuffix(".jmx");
            this.getView().showUpload(uploadOption, BUTTONAP);
        } else {
            UploadOption uploadOption = new UploadOption();
            uploadOption.setMultiple(false);
            uploadOption.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u6570\u636e\u6e90", (String)"BizUnitTestPageNewPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            uploadOption.setSuffix(".xlsx");
            this.getView().showUpload(uploadOption, DATASOURCEBUTTONAP);
        }
    }

    private void step1next() {
        String name;
        String number = (String)this.getModel().getValue(TXT_NUMBER);
        String errorMsg = this.validateNameAndNumber(number, name = (String)this.getModel().getValue(MULTI_TXT_NAME));
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"step1"});
        this.getView().setVisible(Boolean.TRUE, new String[]{STEP_2});
    }

    private void step2last() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"step1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{STEP_2});
    }

    private void step2next() {
        this.getView().setVisible(Boolean.FALSE, new String[]{STEP_2});
        this.getView().setVisible(Boolean.TRUE, new String[]{"step3"});
    }

    private void step3last() {
        this.getView().setVisible(Boolean.TRUE, new String[]{STEP_2});
        this.getView().setVisible(Boolean.FALSE, new String[]{"step3"});
    }

    private void finish() {
        HashMap<String, Object> message;
        block2: {
            Map configInfo = this.getView().getFormShowParameter().getCustomParams();
            Map appInfo = (Map)configInfo.get("appinfo");
            String bizAppId = (String)appInfo.get("appid");
            String bizUnitId = (String)appInfo.get("unitid");
            message = new HashMap<String, Object>();
            HashMap save = new HashMap();
            try {
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"ide_unit_test_detail");
                dObject.set(TXT_NUMBER, this.getModel().getValue(TXT_NUMBER));
                dObject.set(MULTI_TXT_NAME, this.getModel().getValue(MULTI_TXT_NAME));
                dObject.set("prepareindex", (Object)Character.valueOf(this.booleanConvert((Boolean)this.getModel().getValue("prepareindex"))));
                dObject.set("responsers", this.getModel().getValue("responsers"));
                dObject.set("bizappid", (Object)bizAppId);
                dObject.set("bizunitid", (Object)bizUnitId);
                dObject.set("framechose", (Object)"1");
                dObject.set("cbox_type", (Object)"1");
                dObject.set(JMXLOACTION, this.getModel().getValue(JMXLOACTION));
                dObject.set(JMXCONTEXT, this.getModel().getValue(JMXCONTEXT));
                dObject.set("importdatasource", this.getModel().getValue("importdatasource"));
                dObject.set(DATASOURCECONTENT, this.getModel().getValue(DATASOURCECONTENT));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
            }
            catch (Throwable e) {
                message.put(SUCCESS, Boolean.FALSE);
                if (save.get(SUCCESS) == null || ((Boolean)save.get(SUCCESS)).booleanValue() || save.get("errors") == null) break block2;
                message.put("message", ((ErrorInfo)((ArrayList)save.get("errors")).get(0)).getError());
                this.getView().returnDataToParent(message);
                this.getView().close();
                return;
            }
        }
        message.put(SUCCESS, Boolean.TRUE);
        message.put("message", ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"BizUnitTestPageNewPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().returnDataToParent(message);
        this.getView().close();
    }

    private char booleanConvert(boolean prepareindex) {
        return prepareindex ? (char)'0' : ' ';
    }

    private String validateNameAndNumber(String number, String name) {
        StringBuilder buffer = new StringBuilder();
        String regex = "[a-z0-9A-Z_]+";
        if (StringUtils.isBlank((CharSequence)number)) {
            buffer.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002\r\n", (String)"BizUnitTestPageNewPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (number.endsWith("_devportal")) {
            buffer.append(ResManager.loadKDString((String)"\u4e3a\u4e86\u533a\u5206svn\u811a\u672c\u6587\u4ef6\u547d\u540d\uff0c\u7f16\u7801\u4e0d\u80fd\u4ee5\"_devportal\u7ed3\u5c3e\u3002\"\r\n", (String)"BizUnitTestPageNewPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (!Pattern.matches(regex, number)) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210!\r\n", (String)"BizUnitTestPageNewPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (number.startsWith("_") || number.endsWith("_")) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e!\r\n", (String)"BizUnitTestPageNewPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (number.length() > 25) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e25\u3002\r\n", (String)"BizUnitTestPageNewPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            buffer.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002\r\n", (String)"BizUnitTestPageNewPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        if (this.checkNumber(number)) {
            buffer.append(ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002\r\n", (String)"BizUnitTestPageNewPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        return buffer.toString();
    }

    public void upload(UploadEvent evt) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        if (((Control)evt.getSource()).getKey().equals(BUTTONAP)) {
            Map map = (Map)evt.getUrls()[0];
            String url = (String)map.get("url");
            this.getModel().setValue(JMXLOACTION, map.get("name"));
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            fileService.download(url, (OutputStream)outStream, "httpclient");
            ByteArrayInputStream input = new ByteArrayInputStream(outStream.toByteArray());
            HashMap<String, Object> resultMap = JMXForAnalysis.analysisJMXFile(input);
            if (((Boolean)resultMap.get("status")).booleanValue()) {
                this.getModel().setValue(JMXCONTEXT, (Object)resultMap.get("result").toString().replace("\\", "\\\\\\"));
            } else {
                this.getView().showMessage((String)resultMap.get("result"));
            }
        } else if (((Control)evt.getSource()).getKey().equals(DATASOURCEBUTTONAP)) {
            Map map = (Map)evt.getUrls()[0];
            String url = (String)map.get("url");
            this.getModel().setValue("importdatasource", map.get("name"));
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            fileService.download(url, (OutputStream)outStream, "httpclient");
            ByteArrayInputStream input = new ByteArrayInputStream(outStream.toByteArray());
            ImportExcelDataList excelResolver = ImportExcelDataList.getImportExcelDataListSingleInstance();
            HashMap<String, List<ExcelDataObject>> resultMap = excelResolver.analsisExcelData(input, (String)map.get("name"));
            this.getModel().setValue(DATASOURCECONTENT, (Object)SerializationUtils.toJsonString(resultMap));
        }
    }

    protected boolean checkNumber(String number) {
        String sql = "select 1 from t_bas_unittestdetail where FNUMBER = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number)};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt(1) > 0;
                }
                return Boolean.FALSE;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)action);
    }
}

