/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.unittest;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.unittest.AssertController;
import kd.bos.form.unittest.JmeterSrcForResponseAssertion;
import kd.bos.form.unittest.RegularController;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;

public class AnalysisResponseBody {
    private static Log log = LogFactory.getLog(AnalysisResponseBody.class);
    private static final Random rand = new SecureRandom();
    private static final String SUCCESS = "success";
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final Object lock = new Object();

    public static void main(String[] args) {
        ExecutorService executorService = Executors.newFixedThreadPool(1000);
        executorService.shutdown();
    }

    public Map<String, Object> checkMatchTypeAndAnalysis(AssertController assertController, String responBodyString) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        JmeterSrcForResponseAssertion jsfra = JmeterSrcForResponseAssertion.getJmeterSrcForResponseAssertionSingleton();
        boolean found = false;
        if (!ObjectUtils.isEmpty((Object)assertController)) {
            Pattern pattern;
            Integer type = Integer.valueOf(assertController.getAssertion_test_type());
            List<String> expression = assertController.getAsserion_test_strings();
            if (jsfra.isContainsType(type) && !ObjectUtils.isEmpty(expression)) {
                for (String _expression : expression) {
                    pattern = new PatternCacheLRU().getPattern(_expression, 32768);
                    found = new Perl5Matcher().contains(responBodyString, pattern);
                    if (jsfra.isNotType(type)) {
                        if (found) {
                            if (jsfra.isOrType(type)) continue;
                            result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:\u5305\u62ec\u5e76\u4e14\u5426,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_0", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                            found = false;
                            break;
                        }
                        if (jsfra.isOrType(type)) {
                            found = true;
                            break;
                        }
                        found = true;
                        continue;
                    }
                    if (!found) {
                        if (jsfra.isOrType(type)) continue;
                        result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:\u5305\u62ec,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_1", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                        break;
                    }
                    if (!jsfra.isOrType(type)) continue;
                    break;
                }
                if (found) {
                    result.put(SUCCESS, ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:\u5305\u62ec,\u5339\u914d\u6210\u529f", (String)"AnalysisResponseBody_2", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                } else {
                    result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:\u5305\u62ec,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_1", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                }
            }
            if (jsfra.isEqualsType(type) && !ObjectUtils.isEmpty(expression)) {
                for (String _expression : expression) {
                    found = responBodyString.equals(_expression);
                    if (jsfra.isNotType(type)) {
                        if (found) {
                            if (jsfra.isOrType(type)) continue;
                            result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:equals\u5e76\u4e14\u5426,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_3", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                            found = false;
                            break;
                        }
                        if (jsfra.isOrType(type)) {
                            found = true;
                            break;
                        }
                        found = true;
                        continue;
                    }
                    if (!found) {
                        if (jsfra.isOrType(type)) continue;
                        result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:equals,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_4", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                        break;
                    }
                    if (!jsfra.isOrType(type)) continue;
                    break;
                }
                if (found) {
                    result.put(SUCCESS, ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:equals,\u5339\u914d\u6210\u529f", (String)"AnalysisResponseBody_5", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                } else {
                    result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:equals,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_4", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                }
            }
            if (jsfra.isMatchType(type) && !ObjectUtils.isEmpty(expression)) {
                for (String _expression : expression) {
                    pattern = new PatternCacheLRU().getPattern(_expression, 32768);
                    found = new Perl5Matcher().matches(responBodyString, pattern);
                    if (jsfra.isNotType(type)) {
                        if (found) {
                            if (jsfra.isOrType(type)) continue;
                            result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:\u5339\u914d\u5e76\u4e14\u5426,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_6", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                            found = false;
                            break;
                        }
                        if (jsfra.isOrType(type)) {
                            found = true;
                            break;
                        }
                        found = true;
                        continue;
                    }
                    if (!found) {
                        if (jsfra.isOrType(type)) continue;
                        result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:\u5339\u914d,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_7", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                        break;
                    }
                    if (!jsfra.isOrType(type)) continue;
                    break;
                }
                if (found) {
                    result.put(SUCCESS, ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:\u5339\u914d,\u5339\u914d\u6210\u529f", (String)"AnalysisResponseBody_8", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                } else {
                    result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:\u5339\u914d,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_7", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                }
            }
            if (jsfra.isSubstringType(type) && !ObjectUtils.isEmpty(expression)) {
                for (String _expression : expression) {
                    boolean bl = found = responBodyString.indexOf(_expression) != -1;
                    if (jsfra.isNotType(type)) {
                        if (found) {
                            if (jsfra.isOrType(type)) continue;
                            result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:Substring\u5e76\u4e14\u5426,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_9", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                            found = false;
                            break;
                        }
                        if (jsfra.isOrType(type)) {
                            found = true;
                            break;
                        }
                        found = true;
                        continue;
                    }
                    if (!found) {
                        if (jsfra.isOrType(type)) continue;
                        result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:Substring,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_10", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                        break;
                    }
                    if (!jsfra.isOrType(type)) continue;
                    break;
                }
                if (found) {
                    result.put(SUCCESS, ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:Substring,\u5339\u914d\u6210\u529f", (String)"AnalysisResponseBody_11", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                } else {
                    result.put("fail", ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f:Substring,\u5339\u914d\u5931\u8d25", (String)"AnalysisResponseBody_10", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                }
            }
        } else {
            result.put("fail", ResManager.loadKDString((String)"\u54cd\u5e94\u65ad\u8a00\u7684\u503c\u4e3a\u7a7a", (String)"AnalysisResponseBody_12", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        }
        return result;
    }

    public Map<String, Object> analysisRegexExtractor(String responesBodyString, RegularController controller) {
        String regex = controller.getRegexExtractor_regex();
        int matchNumber = Integer.parseInt(controller.getRegexExtractor_match_number());
        String rawTemplate = controller.getRegexExtractor_template();
        String regexExtractor_default = controller.getRegexExtractor_default();
        HashMap<String, Object> result = new HashMap<String, Object>();
        Perl5Matcher matcher = new Perl5Matcher();
        Pattern pattern = new PatternCacheLRU().getPattern(regex, 32768);
        List<MatchResult> matches = this.processMatches(pattern, matchNumber, matcher, responesBodyString);
        String refNameValue = null;
        try {
            if (matchNumber >= 0) {
                MatchResult match = this.getCorrectMatch(matches, matchNumber);
                refNameValue = match != null ? this.generateResult(match, rawTemplate) : regexExtractor_default;
                result.put("refName", refNameValue);
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage());
        }
        return result;
    }

    private String generateResult(MatchResult match, String rawTemplate) {
        StringBuilder result = new StringBuilder();
        List<Object> template = this.initRegexExtractorTemplate(rawTemplate);
        for (Object obj : template) {
            if (obj instanceof Integer) {
                result.append(match.group(((Integer)obj).intValue()));
                continue;
            }
            result.append(obj);
        }
        return result.toString();
    }

    private List<MatchResult> processMatches(Pattern pattern, int matchNumber, Perl5Matcher matcher, String responesBodyString) {
        ArrayList<MatchResult> matches = new ArrayList<MatchResult>();
        PatternMatcherInput input = new PatternMatcherInput(responesBodyString);
        for (int found = 0; (matchNumber <= 0 || found != matchNumber) && matcher != null && matcher.contains(input, pattern); ++found) {
            matches.add(matcher.getMatch());
        }
        return matches;
    }

    private MatchResult getCorrectMatch(List<MatchResult> matches, int entry) {
        int matchSize = matches.size();
        if (matchSize <= 0 || entry > matchSize) {
            return null;
        }
        if (entry == 0) {
            return matches.get(rand.nextInt(matchSize));
        }
        return matches.get(entry - 1);
    }

    private List<Object> initRegexExtractorTemplate(String rawTemplate) {
        ArrayList<Object> combined = new ArrayList<Object>();
        Perl5Matcher matcher = new Perl5Matcher();
        Pattern pattern = new PatternCacheLRU().getPattern("\\$(\\d+)\\$", 0);
        int beginOffset = 0;
        PatternMatcherInput pinput = new PatternMatcherInput(rawTemplate);
        while (matcher.contains(pinput, pattern)) {
            MatchResult currentResult = matcher.getMatch();
            int beginMatch = currentResult.beginOffset(0);
            if (beginMatch > beginOffset) {
                combined.add(rawTemplate.substring(beginOffset, beginMatch));
            }
            combined.add(Integer.valueOf(currentResult.group(1)));
            beginOffset = currentResult.endOffset(0);
        }
        if (beginOffset < rawTemplate.length()) {
            combined.add(rawTemplate.substring(beginOffset, rawTemplate.length()));
        }
        return combined;
    }
}

