/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.unittest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.unittest.ExcelDataObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ImportExcelDataList {
    private static final Log logger = LogFactory.getLog(ImportExcelDataList.class);
    private static ImportExcelDataList importExcelDataListInstance;

    public static ImportExcelDataList getImportExcelDataListSingleInstance() {
        if (importExcelDataListInstance == null) {
            importExcelDataListInstance = new ImportExcelDataList();
        }
        return importExcelDataListInstance;
    }

    public static void main(String[] args) {
        ImportExcelDataList test = ImportExcelDataList.getImportExcelDataListSingleInstance();
        File file = new File("D:/untilTest.xlsx");
        try (FileInputStream fileIn = new FileInputStream(file.getCanonicalPath());){
            test.analsisExcelData(fileIn, "untilTest.xlsx");
        }
        catch (FileNotFoundException e) {
            logger.error((Throwable)e);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public HashMap<String, List<ExcelDataObject>> analsisExcelData(InputStream in, String excelName) {
        HashMap<String, List<ExcelDataObject>> result = new HashMap<String, List<ExcelDataObject>>();
        ArrayList<ExcelDataObject> excelDataObejctResultList = new ArrayList<ExcelDataObject>();
        try (Workbook wb = WorkbookFactory.create((InputStream)in);){
            int sheetTotal;
            if (wb != null && (sheetTotal = wb.getNumberOfSheets()) > 0) {
                for (int index = 0; index < sheetTotal; ++index) {
                    Sheet tempSheet = wb.getSheetAt(index);
                    String sheetName = tempSheet.getSheetName();
                    String[] groupNameAndCaseNameArr = sheetName.split("\\.|:");
                    if (groupNameAndCaseNameArr == null || groupNameAndCaseNameArr.length != 2) continue;
                    ExcelDataObject excelDataObject = new ExcelDataObject();
                    List<HashMap<String, String>> resultDataMapList = this.readSheetData(tempSheet);
                    excelDataObject.setCaseGroupName(groupNameAndCaseNameArr[0]);
                    excelDataObject.setCaseName(groupNameAndCaseNameArr[1]);
                    excelDataObject.setDataList(resultDataMapList);
                    excelDataObejctResultList.add(excelDataObject);
                }
            }
            result.put(excelName, excelDataObejctResultList);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return result;
    }

    private List<HashMap<String, String>> readSheetData(Sheet sheetTempData) {
        ArrayList<HashMap<String, String>> excelDataList = new ArrayList<HashMap<String, String>>();
        if (sheetTempData == null || sheetTempData.getLastRowNum() < 1) {
            return excelDataList;
        }
        Row r0 = sheetTempData.getRow(0);
        int columns0 = r0.getPhysicalNumberOfCells();
        for (Row row : sheetTempData) {
            HashMap<String, String> rowHashMap = new HashMap<String, String>();
            if (row.getRowNum() <= 0) continue;
            for (int i = 0; i < columns0; ++i) {
                Cell cellKeyObject = r0.getCell(i);
                cellKeyObject.setCellType(CellType.STRING);
                String cellKey = cellKeyObject.getStringCellValue();
                Cell cellValueObject = row.getCell(i);
                if (ObjectUtils.isEmpty((Object)cellValueObject)) {
                    rowHashMap.put(cellKey, "");
                    continue;
                }
                cellValueObject.setCellType(CellType.STRING);
                String cellValue = cellValueObject.getStringCellValue();
                rowHashMap.put(cellKey, cellValue);
            }
            excelDataList.add(rowHashMap);
        }
        return excelDataList;
    }
}

