/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.unittest;

import com.alibaba.fastjson.JSONArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.unittest.AssertController;
import kd.bos.form.unittest.HTTPInvokeMethod;
import kd.bos.form.unittest.RegularController;
import kd.bos.form.unittest.StopException;
import kd.bos.form.unittest.UnitTestCase;
import kd.bos.form.unittest.UnitTestGroup;
import kd.bos.form.unittest.UnitTestHttpProxy;
import kd.bos.util.SAXReaderUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class JMXForAnalysis {
    private static final String RESPONSE_ASSERTION_PATH = "ResponseAssertion";
    private static final String GENERIC_CONTROLLER_PATH = "GenericController";
    private static final String CONSTANT_TIMER_PATH = "ConstantTimer";
    private static final String HASH_TREE_PATH = "hashTree";
    private static final String REGEX_EXTRACTOR_PATH = "RegexExtractor";
    private static final String HTTP_SAMPLER_PROXY_PATH = "HTTPSamplerProxy";
    private static final String NAME_FOR_CHECK_CASE_GROUP = ResManager.loadKDString((String)"\u7528\u4f8b\u5206\u7ec4", (String)"JMXForAnalysis_0", (String)"bos-unittest", (Object[])new Object[0]);
    private static final String NAME_FOR_CHECK_CASE = ResManager.loadKDString((String)"\u6d4b\u8bd5\u7528\u4f8b", (String)"JMXForAnalysis_1", (String)"bos-unittest", (Object[])new Object[0]);
    private static final String STATUS = "status";
    private static final String ENABLED = "enabled";
    private static final String TESTNAME = "testname";
    private static final String STRING_PROP = "stringProp";
    private static final String RESULT = "result";

    public static List<Object> getCaseName(String json) {
        HashMap<String, Object> temp = JMXForAnalysis.jsonToUnitTestGroupBean(json);
        ArrayList<Object> result = new ArrayList<Object>();
        if (!((Boolean)temp.get(STATUS)).booleanValue()) {
            return result;
        }
        List list = (List)temp.get(RESULT);
        if (ObjectUtils.isEmpty((Object)list)) {
            return result;
        }
        for (UnitTestGroup unitTestGroup : list) {
            List<UnitTestCase> unitTestCases = unitTestGroup.getUnitTestCases();
            if (ObjectUtils.isEmpty(unitTestCases)) continue;
            for (UnitTestCase unitTestCase : unitTestCases) {
                if (ObjectUtils.isEmpty(unitTestCase.getUnitTestHttpProxys())) continue;
                for (UnitTestHttpProxy unitTestHttpProxy : unitTestCase.getUnitTestHttpProxys()) {
                    Object[] tempArr = new Object[]{unitTestGroup.getName(), unitTestCase.getName(), unitTestHttpProxy.getName()};
                    result.add(tempArr);
                }
            }
        }
        return result;
    }

    public static HashMap<String, Object> jsonToUnitTestGroupBean(String json) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            List list = JSONArray.parseArray((String)json, UnitTestGroup.class);
            result.put(STATUS, Boolean.TRUE);
            result.put(RESULT, list);
        }
        catch (Exception e) {
            result.put(STATUS, Boolean.FALSE);
            String err = String.format(ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5931\u8d25,\u5f53\u524d\u811a\u672c\u5185\u5bb9HttpContext:\r\n%s", (String)"JMXForAnalysis_2", (String)"bos-unittest", (Object[])new Object[0]), json);
            result.put(RESULT, err);
        }
        return result;
    }

    public static void getNodes(Element node) throws Exception {
        List listElement = node.elements();
        for (Element el : listElement) {
            if (el.getName().equals(GENERIC_CONTROLLER_PATH)) {
                throw new StopException("had find GenericController at frist", el);
            }
            JMXForAnalysis.getNodes(el);
        }
    }

    public static HashMap<String, Object> analysisUnitTestGroup(Element e) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean status = false;
        StringBuilder msg = new StringBuilder();
        Element parentEle = e.getParent();
        List childrensOfParentEle = parentEle.elements();
        if (!ObjectUtils.isEmpty((Object)childrensOfParentEle)) {
            ArrayList<UnitTestGroup> unitTestGroupList = new ArrayList<UnitTestGroup>();
            for (int index = 0; index < childrensOfParentEle.size(); ++index) {
                Element tempDataElement = (Element)childrensOfParentEle.get(index);
                tempDataElement.attribute(ENABLED);
                if (!tempDataElement.getName().equals(GENERIC_CONTROLLER_PATH) || !Boolean.parseBoolean(tempDataElement.attributeValue(ENABLED))) continue;
                String name = ((Element)childrensOfParentEle.get(index)).attribute(TESTNAME).getText();
                if (!JMXForAnalysis.checkCaseGroupNameIsNorm(name)) {
                    status = false;
                    msg.append(name).append(ResManager.loadKDString((String)":\u7528\u4f8b\u5206\u7ec4\u547d\u540d\u4e0d\u89c4\u8303", (String)"JMXForAnalysis_3", (String)"bos-unittest", (Object[])new Object[0]));
                    break;
                }
                status = true;
                UnitTestGroup unitTestGroup = new UnitTestGroup();
                unitTestGroup.setName(name);
                Element hashTreeEle = (Element)childrensOfParentEle.get(index + 1);
                HashMap<String, Object> resultTempData = JMXForAnalysis.analysisUnitTestCaseList(hashTreeEle);
                if (ObjectUtils.isEmpty(resultTempData)) continue;
                Object statusObj = resultTempData.get(STATUS);
                if (statusObj != null && ((Boolean)statusObj).booleanValue()) {
                    unitTestGroup.setUnitTestCases((List)resultTempData.get("unitTestCaseTempList"));
                    unitTestGroupList.add(unitTestGroup);
                    continue;
                }
                status = false;
                msg.append(String.valueOf(resultTempData.get("msg")));
                break;
            }
            if (status) {
                result.put(STATUS, status);
                result.put("unitTestGroupList", unitTestGroupList);
            } else {
                result.put(STATUS, status);
                result.put("msg", msg.toString());
            }
            return result;
        }
        return null;
    }

    public static HashMap<String, Object> analysisUnitTestCaseList(Element parentElement) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean status = false;
        StringBuilder msg = new StringBuilder();
        ArrayList<UnitTestCase> unitTestCaseTempList = new ArrayList<UnitTestCase>();
        List eleHashTreeList = parentElement.elements(HASH_TREE_PATH);
        List eleUnitTestCaseNameList = parentElement.elements(GENERIC_CONTROLLER_PATH);
        if (!ObjectUtils.isEmpty((Object)eleHashTreeList) && !ObjectUtils.isEmpty((Object)eleUnitTestCaseNameList)) {
            if (eleHashTreeList.size() == eleUnitTestCaseNameList.size()) {
                int index = eleUnitTestCaseNameList.size();
                int i = 0;
                while (i < index) {
                    Element eleUnitTestCaseNameTempData = (Element)eleUnitTestCaseNameList.get(i);
                    if (Boolean.parseBoolean(eleUnitTestCaseNameTempData.attributeValue(ENABLED))) {
                        UnitTestCase unitTestCase = new UnitTestCase();
                        String name = eleUnitTestCaseNameTempData.attributeValue(TESTNAME);
                        if (!JMXForAnalysis.checkCaseNameIsNorm(name)) {
                            status = false;
                            msg = msg.append(name);
                            result.put(STATUS, status);
                            result.put("msg", msg.toString());
                            break;
                        }
                        status = true;
                        unitTestCase.setName(name);
                        List<UnitTestHttpProxy> unitTestHttpProxyTempData = JMXForAnalysis.analysisUnitTestHttpProxyList((Element)eleHashTreeList.get(i));
                        ++i;
                        if (!ObjectUtils.isEmpty(unitTestHttpProxyTempData)) {
                            unitTestCase.setUnitTestHttpProxys(unitTestHttpProxyTempData);
                        }
                        unitTestCaseTempList.add(unitTestCase);
                        continue;
                    }
                    ++i;
                }
                if (status) {
                    result.put(STATUS, status);
                    result.put("unitTestCaseTempList", unitTestCaseTempList);
                } else {
                    result.put(STATUS, status);
                    result.put("msg", msg + ResManager.loadKDString((String)":\u7528\u4f8b\u547d\u540d\u4e0d\u89c4\u8303", (String)"JMXForAnalysis_4", (String)"bos-unittest", (Object[])new Object[0]));
                }
                for (UnitTestCase testCase : unitTestCaseTempList) {
                    HashSet<String> names = new HashSet<String>();
                    for (UnitTestHttpProxy proxy : testCase.getUnitTestHttpProxys()) {
                        if (names.contains(proxy.getName())) {
                            status = false;
                            result.put(STATUS, status);
                            result.put("msg", ResManager.loadKDString((String)"\u540c\u7528\u4f8b\u4e0b\u6709\u91cd\u540d\u65b9\u6cd5", (String)"JMXForAnalysis_5", (String)"bos-unittest", (Object[])new Object[0]));
                            continue;
                        }
                        names.add(proxy.getName());
                    }
                }
                return result;
            }
            return new HashMap<String, Object>();
        }
        return new HashMap<String, Object>();
    }

    public static List<UnitTestHttpProxy> analysisUnitTestHttpProxyList(Element e) {
        List eleHashTreeList = e.elements(HASH_TREE_PATH);
        List httpSamplerProxyElementList = e.elements(HTTP_SAMPLER_PROXY_PATH);
        if (!ObjectUtils.isEmpty((Object)eleHashTreeList) && !ObjectUtils.isEmpty((Object)httpSamplerProxyElementList)) {
            ArrayList<UnitTestHttpProxy> unitTestHttpProxyListData = new ArrayList<UnitTestHttpProxy>(eleHashTreeList.size());
            int i = 0;
            for (Element httpSamplerProxyEleTempData : httpSamplerProxyElementList) {
                if (Boolean.parseBoolean(httpSamplerProxyEleTempData.attributeValue(ENABLED))) {
                    UnitTestHttpProxy t = JMXForAnalysis.analysisUnitTestHttpProxy((Element)eleHashTreeList.get(i), httpSamplerProxyEleTempData);
                    unitTestHttpProxyListData.add(t);
                }
                ++i;
            }
            return unitTestHttpProxyListData;
        }
        return null;
    }

    public static UnitTestHttpProxy analysisUnitTestHttpProxy(Element hashTreeElement, Element httpSamplerProxyElement) {
        UnitTestHttpProxy unitTestHttpProxyTempData = new UnitTestHttpProxy();
        if (!ObjectUtils.isEmpty((Object)httpSamplerProxyElement)) {
            String name = httpSamplerProxyElement.attributeValue(TESTNAME);
            unitTestHttpProxyTempData.setName(name);
            JMXForAnalysis.analysisHTTPSamplerProxyNode(httpSamplerProxyElement, unitTestHttpProxyTempData);
        }
        if (!ObjectUtils.isEmpty((Object)hashTreeElement)) {
            JMXForAnalysis.analysisHashTreeNode(hashTreeElement, unitTestHttpProxyTempData);
        }
        return unitTestHttpProxyTempData;
    }

    public static void analysisHTTPSamplerProxyNode(Element httpSamplerProxyElement, UnitTestHttpProxy unitTestHttpProxyTempData) {
        List httpParamsElement = httpSamplerProxyElement.elements(STRING_PROP);
        if (!ObjectUtils.isEmpty((Object)httpParamsElement)) {
            HTTPInvokeMethod httpInvokeMethod = new HTTPInvokeMethod();
            for (Element e : httpParamsElement) {
                if (e.attributeValue("name").equals("HTTPSampler.domain")) {
                    httpInvokeMethod.setDomain(e.getText().trim());
                }
                if (e.attributeValue("name").equals("HTTPSampler.port")) {
                    httpInvokeMethod.setPort(e.getText().trim());
                }
                if (!e.attributeValue("name").equals("HTTPSampler.path")) continue;
                httpInvokeMethod.setPath(e.getText().trim());
            }
            unitTestHttpProxyTempData.setInvokeMethod(httpInvokeMethod);
        }
        HashMap<String, Object> userParams = new HashMap<String, Object>();
        List paramsElements = httpSamplerProxyElement.elements("elementProp");
        for (Element paramsElement : paramsElements) {
            List userParamsElementList;
            if (!paramsElement.attributeValue("name").equalsIgnoreCase("HTTPsampler.Arguments")) continue;
            if (ObjectUtils.isEmpty((Object)paramsElement)) break;
            List paramsElementList = paramsElement.elements("collectionProp");
            if (ObjectUtils.isEmpty((Object)paramsElement) || ObjectUtils.isEmpty((Object)(userParamsElementList = ((Element)paramsElementList.get(0)).elements("elementProp")))) break;
            for (Element userParamsElement : userParamsElementList) {
                String paramName = JMXForAnalysis.getNodeByName("Argument.name", userParamsElement, STRING_PROP);
                String value = JMXForAnalysis.getNodeByName("Argument.value", userParamsElement, STRING_PROP);
                userParams.put(paramName, value);
            }
        }
        unitTestHttpProxyTempData.setParams(userParams);
    }

    public static void analysisHashTreeNode(Element hashTreeElement, UnitTestHttpProxy unitTestHttpProxyTempData) {
        List regularControllerElementList;
        List responseAssertionElementList = hashTreeElement.elements(RESPONSE_ASSERTION_PATH);
        if (!ObjectUtils.isEmpty((Object)responseAssertionElementList)) {
            ArrayList<AssertController> assertControllerList = new ArrayList<AssertController>();
            for (Element responseAssertionElement : responseAssertionElementList) {
                if (!Boolean.parseBoolean(responseAssertionElement.attributeValue(ENABLED))) continue;
                AssertController assertController = new AssertController();
                Element test_stringsElement = responseAssertionElement.element("collectionProp");
                if (!ObjectUtils.isEmpty((Object)test_stringsElement)) {
                    List test_stringsElementChildrens = test_stringsElement.elements(STRING_PROP);
                    if (!ObjectUtils.isEmpty((Object)test_stringsElementChildrens)) {
                        ArrayList<String> test_StringList = new ArrayList<String>(10);
                        for (Element test_stringsElementChildren : test_stringsElementChildrens) {
                            test_StringList.add(test_stringsElementChildren.getText());
                        }
                        assertController.setAsserion_test_strings(test_StringList);
                    } else {
                        assertController.setAsserion_test_strings(null);
                    }
                } else {
                    assertController.setAsserion_test_strings(null);
                }
                assertController.setAssertion_test_field(JMXForAnalysis.getNodeByName("Assertion.test_field", responseAssertionElement, STRING_PROP));
                assertController.setAssertion_test_type(JMXForAnalysis.getNodeByName("Assertion.test_type", responseAssertionElement, "intProp"));
                assertControllerList.add(assertController);
            }
            unitTestHttpProxyTempData.setAssertController(assertControllerList);
        }
        if (!ObjectUtils.isEmpty((Object)(regularControllerElementList = hashTreeElement.elements(REGEX_EXTRACTOR_PATH)))) {
            ArrayList<RegularController> regularControllerList = new ArrayList<RegularController>();
            for (Element regularControllerElement : regularControllerElementList) {
                if (Boolean.parseBoolean(regularControllerElement.attributeValue(ENABLED))) {
                    List regularControllerParamsElement = regularControllerElement.elements(STRING_PROP);
                    RegularController uc = new RegularController();
                    String regularControllerName = regularControllerElement.attributeValue(TESTNAME);
                    uc.setName(regularControllerName);
                    if (!ObjectUtils.isEmpty((Object)regularControllerParamsElement)) {
                        for (Element e : regularControllerParamsElement) {
                            if (e.attributeValue("name").equals("RegexExtractor.useHeaders")) {
                                uc.setRegexExtractor_useHeaders(e.getText());
                            }
                            if (e.attributeValue("name").equals("RegexExtractor.refname")) {
                                uc.setRegexExtractor_refname(e.getText());
                            }
                            if (e.attributeValue("name").equals("RegexExtractor.regex")) {
                                uc.setRegexExtractor_regex(e.getText());
                            }
                            if (e.attributeValue("name").equals("RegexExtractor.template")) {
                                uc.setRegexExtractor_template(e.getText());
                            }
                            if (e.attributeValue("name").equals("RegexExtractor.default")) {
                                uc.setRegexExtractor_default(e.getText());
                            }
                            if (!e.attributeValue("name").equals("RegexExtractor.match_number")) continue;
                            uc.setRegexExtractor_match_number(e.getText());
                        }
                        regularControllerList.add(uc);
                    }
                }
                unitTestHttpProxyTempData.setRegularController(regularControllerList);
            }
        }
    }

    public static void main(String[] args) {
        String path = ResManager.loadKDString((String)"D:/jmeter\u65b0\u6846\u67b6\u6d4b\u8bd5\u5e26\u6570\u636e2.jmx", (String)"JMXForAnalysis_6", (String)"bos-unittest", (Object[])new Object[0]);
        File f = new File(path);
        try (FileInputStream in = new FileInputStream(f);){
            JMXForAnalysis.analysisJMXFile(in);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static HashMap<String, Object> analysisJMXFile(InputStream in) {
        HashMap<String, Object> resultFinallData;
        block9: {
            resultFinallData = new HashMap<String, Object>();
            try {
                StringBuffer buffer = new StringBuffer();
                BufferedReader bf = new BufferedReader(new InputStreamReader(in));
                String str = null;
                while ((str = bf.readLine()) != null) {
                    buffer.append(str.trim());
                }
                String tempXML = buffer.toString();
                StringReader strReader = new StringReader(tempXML);
                SAXReader saxReader = SAXReaderUtil.getSAXReader();
                try {
                    HashMap<String, Object> result;
                    Element eTemp;
                    block8: {
                        Document document = saxReader.read((Reader)strReader);
                        Element ele = document.getRootElement();
                        eTemp = null;
                        try {
                            JMXForAnalysis.getNodes(ele);
                        }
                        catch (Exception e) {
                            StopException se;
                            if (!(e instanceof StopException) || !(se = (StopException)e).getMessage().equals("had find GenericController at frist")) break block8;
                            eTemp = ((StopException)e).getE();
                        }
                    }
                    if (eTemp == null || (result = JMXForAnalysis.analysisUnitTestGroup(eTemp)) == null) break block9;
                    if (((Boolean)result.get(STATUS)).booleanValue()) {
                        List u = (List)result.get("unitTestGroupList");
                        JSONArray jsonObjectResult = (JSONArray)JSONArray.toJSON((Object)u);
                        JMXForAnalysis.getCaseName(jsonObjectResult.toJSONString());
                        resultFinallData.put(STATUS, Boolean.TRUE);
                        resultFinallData.put(RESULT, jsonObjectResult.toJSONString());
                        break block9;
                    }
                    resultFinallData.put(STATUS, Boolean.FALSE);
                    resultFinallData.put(RESULT, result.get("msg"));
                }
                catch (DocumentException e) {
                    resultFinallData.put(STATUS, Boolean.FALSE);
                    resultFinallData.put(RESULT, ResManager.loadKDString((String)"\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (String)"JMXForAnalysis_7", (String)"bos-unittest", (Object[])new Object[0]) + (Object)((Object)e));
                }
            }
            catch (Exception e) {
                resultFinallData.put(STATUS, Boolean.FALSE);
                resultFinallData.put(RESULT, ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"JMXForAnalysis_8", (String)"bos-unittest", (Object[])new Object[0]));
            }
        }
        return resultFinallData;
    }

    private static String getNodeByName(String name, Element e, String flag) {
        Element temp = (Element)e.selectSingleNode(flag + "[@name='" + name + "']");
        if (!ObjectUtils.isEmpty((Object)temp)) {
            return temp.getText().trim();
        }
        return "";
    }

    private static boolean checkCaseGroupNameIsNorm(String name) {
        String[] nameList = name.split(":|\uff1a|\\s+");
        return nameList.length > 0 && NAME_FOR_CHECK_CASE_GROUP.equals(nameList[0]);
    }

    private static boolean checkCaseNameIsNorm(String name) {
        String[] nameList = name.split(":|\uff1a|\\s+");
        return nameList.length > 0 && NAME_FOR_CHECK_CASE.equals(nameList[0]);
    }
}

