/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.unittest;

import java.util.List;
import kd.bos.form.unittest.IKDListensToTestExecutions;
import kd.bos.form.unittest.IKDTestIdentifier;
import kd.bos.form.unittest.IKDUnitTestClientView;
import kd.bos.form.unittest.KDCaseMethodResult;
import kd.bos.form.unittest.KDTestReferenceFailure;

public class KDRunExecutionListener
implements IKDListensToTestExecutions {
    protected IKDUnitTestClientView fSender;

    public KDRunExecutionListener(IKDUnitTestClientView sender) {
        this.fSender = sender;
    }

    @Override
    public void notifyTestEnded(IKDTestIdentifier test) {
        this.sendMessage(test, "%TESTE");
    }

    @Override
    public void notifyTestFailed(KDTestReferenceFailure failure) {
        this.sendMessage(failure.getTest(), failure.getStatus() + failure.getTrace());
    }

    @Override
    public void notifyTestStarted(IKDTestIdentifier test) {
        this.sendMessage(test, "%TESTS");
    }

    private void sendMessage(IKDTestIdentifier test, String status) {
        this.fSender.sendMessage(test, status);
    }

    @Override
    public void notifyRunFinished(List<KDCaseMethodResult> lstCaseResult) {
        this.fSender.notifyRunFinished(lstCaseResult);
    }
}

