/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.unittest;

import kd.bos.context.RequestContext;
import kd.bos.form.unittest.IKDClassifiesThrowables;
import kd.bos.form.unittest.IKDListensToTestExecutions;
import kd.bos.form.unittest.IKDTestReference;

public class KDUnitTestPluginRunner {
    private IKDListensToTestExecutions fExecutionListener;
    private IKDClassifiesThrowables fClassifier;

    public KDUnitTestPluginRunner(IKDListensToTestExecutions listener, IKDClassifiesThrowables classifier) {
        this.fClassifier = classifier;
        this.fExecutionListener = listener;
    }

    public void run(IKDTestReference[] suites) {
        if (suites.length > 0) {
            for (IKDTestReference suite : suites) {
                suite.run(this);
            }
        }
    }

    public IKDListensToTestExecutions getListener() {
        return this.fExecutionListener;
    }

    public IKDClassifiesThrowables getClassifier() {
        return this.fClassifier;
    }

    static class ThreadRunTest
    implements Runnable {
        private IKDTestReference kdtref;
        private KDUnitTestPluginRunner kdte;
        private RequestContext rc;

        public ThreadRunTest(IKDTestReference kdtref, KDUnitTestPluginRunner kdte, RequestContext rc) {
            this.kdtref = kdtref;
            this.kdte = kdte;
            this.rc = rc;
        }

        @Override
        public void run() {
            RequestContext.set((RequestContext)this.rc);
            this.kdtref.run(this.kdte);
        }
    }
}

