/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.unittest;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.form.unittest.IKDClassifiesThrowables;
import kd.bos.form.unittest.IKDTestIdentifier;
import kd.bos.form.unittest.IKDTestLoader;
import kd.bos.form.unittest.IKDTestReference;
import kd.bos.form.unittest.IKDUnitTestClientView;
import kd.bos.form.unittest.KDCase;
import kd.bos.form.unittest.KDDefaultClassifier;
import kd.bos.form.unittest.KDRunExecutionListener;
import kd.bos.form.unittest.KDUnitTestMessages;
import kd.bos.form.unittest.KDUnitTestPluginRunner;

public class KDUnitTestRunner {
    public static final String RERAN_FAILURE = "FAILURE";
    public static final String RERAN_ERROR = "ERROR";
    public static final String RERAN_OK = "OK";
    public static final String CASE_PLUGIN_INFOS = "pluginInfos";
    public static final String CASE_FORM_VIEW = "formview";
    private static final String CLASS = "class";
    private String[] fTestClassNames;
    private List<Map<String, Object>> fLstPluginInfos;
    private KDUnitTestPluginRunner fpluginRunner;
    private IKDTestLoader fLoader;
    private IKDUnitTestClientView fUnitTestClientView;
    private RequestContext rc;
    private HashMap<String, Object> runMapParams = new HashMap();

    public void setRequestContext(RequestContext rc) {
        this.rc = rc;
    }

    public RequestContext getRequestContext() {
        return this.rc;
    }

    public HashMap<String, Object> getRunnerParams() {
        return this.runMapParams;
    }

    public void setUnitTestClientView(IKDUnitTestClientView UnitTestClientView) {
        this.fUnitTestClientView = UnitTestClientView;
    }

    public static void run(RequestContext rc, HashMap<String, Object> runMapArgs, IKDUnitTestClientView UnitTestClientView) throws Throwable {
        KDUnitTestRunner testRunServer = new KDUnitTestRunner();
        testRunServer.setRequestContext(rc);
        testRunServer.setUnitTestClientView(UnitTestClientView);
        testRunServer.doPackage(runMapArgs);
        testRunServer.run();
    }

    protected ClassLoader getTestClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected final void doPackage(HashMap<String, Object> runMapArgs) {
        Map param;
        this.fLstPluginInfos = (ArrayList)runMapArgs.get(CASE_PLUGIN_INFOS);
        ArrayList<String> lstClass = new ArrayList<String>(10);
        for (Map<String, Object> pluginInfo : this.fLstPluginInfos) {
            lstClass.add((String)pluginInfo.get(CLASS));
        }
        Object formview = runMapArgs.get(CASE_FORM_VIEW);
        if (formview != null) {
            Map<String, Object> pluginInfo;
            pluginInfo = new HashMap<String, Object>();
            pluginInfo.put("type", (Object)KDCase.CasePluginType.javaclass);
            pluginInfo.put(CLASS, "kd.bos.unittest.UnitTestCommonPlugIn");
            this.fLstPluginInfos.add(0, pluginInfo);
            lstClass.add(0, "kd.bos.unittest.UnitTestCommonPlugIn");
            this.runMapParams.put(CASE_FORM_VIEW, formview);
        }
        if ((param = (Map)runMapArgs.get("param")) != null) {
            this.runMapParams.put("param", param);
        }
        this.fTestClassNames = lstClass.toArray(new String[0]);
        String loadClassName = (String)runMapArgs.get("testloaderclass");
        this.createLoader(loadClassName);
        if (this.getTestLoader() == null) {
            this.initDefaultLoader();
        }
        if (this.fTestClassNames == null || this.fTestClassNames.length == 0) {
            throw new IllegalArgumentException("KDUnitTestRunner.error.classnamemissing");
        }
    }

    public void initDefaultLoader() {
        this.createLoader("KDUnitTestLoader");
    }

    public void createLoader(String className) {
        this.setLoader(this.createRawTestLoader(className));
    }

    protected IKDTestLoader createRawTestLoader(String className) {
        try {
            return (IKDTestLoader)this.loadTestLoaderClass(className).newInstance();
        }
        catch (Exception e) {
            StringWriter trace = new StringWriter();
            e.printStackTrace(new PrintWriter(trace));
            String message = KDUnitTestMessages.getFormattedString("KDUnitTestRunner.error.invalidloader", new Object[]{className, trace.toString()});
            throw new IllegalArgumentException(message, e);
        }
    }

    protected Class<?> loadTestLoaderClass(String className) throws ClassNotFoundException {
        return TypesContainer.getOrRegister((String)className);
    }

    public void setLoader(IKDTestLoader newInstance) {
        this.fLoader = newInstance;
    }

    protected void run() throws ClassNotFoundException {
        KDRunExecutionListener listener = new KDRunExecutionListener(this.fUnitTestClientView);
        this.fpluginRunner = new KDUnitTestPluginRunner(listener, this.getClassifier());
        this.runTests(this.fpluginRunner);
    }

    public void runFailed(String message, Exception exception) {
        if (exception != null) {
            exception.printStackTrace(System.err);
        }
    }

    protected List<Map<String, Object>> loadClassesWithPlugin(List<Map<String, Object>> lstPluginInfos) throws ClassNotFoundException {
        for (Map<String, Object> pluginInfo : lstPluginInfos) {
            String name = (String)pluginInfo.get(CLASS);
            Class<?> clazz = this.loadClass(name, this);
            if (clazz == null) continue;
            pluginInfo.put("clazz", clazz);
        }
        return lstPluginInfos;
    }

    protected Class<?>[] loadClasses(String[] testClassNames) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        for (int i = 0; i < testClassNames.length; ++i) {
            String name = testClassNames[i];
            Class<?> clazz = this.loadClass(name, this);
            if (clazz == null) continue;
            classes.add(clazz);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    protected void notifyListenersOfTestEnd(KDUnitTestPluginRunner execution, long testStartTime) {
        if (execution == null) {
            this.notifyTestRunStopped(System.currentTimeMillis() - testStartTime);
        } else {
            this.notifyTestRunEnded(System.currentTimeMillis() - testStartTime);
        }
    }

    public void runTests(KDUnitTestPluginRunner execution) throws ClassNotFoundException {
        IKDTestReference[] suites = this.fLoader.loadTests(this.loadClassesWithPlugin(this.fLstPluginInfos), this);
        int count = this.countTests(suites);
        this.notifyTestRunStarted(count);
        if (count == 0) {
            this.notifyTestRunEnded(0L);
        }
        this.sendTrees(suites);
        long testStartTime = System.currentTimeMillis();
        execution.run(suites);
        this.notifyListenersOfTestEnd(execution, testStartTime);
    }

    private void sendTrees(IKDTestReference[] suites) {
        for (int i = 0; i < suites.length; ++i) {
            suites[i].sendTree(this.fUnitTestClientView);
        }
    }

    private int countTests(IKDTestReference[] tests) {
        int count = 0;
        for (int i = 0; i < tests.length; ++i) {
            IKDTestReference test = tests[i];
            if (test == null) continue;
            count += test.countTestCases();
        }
        return count;
    }

    protected IKDClassifiesThrowables getClassifier() {
        return new KDDefaultClassifier();
    }

    public void visitTreeEntry(IKDTestIdentifier id, boolean b, int i) {
        this.notifyTestTreeEntry(this.escapeComma(id.getName()) + ',' + b + ',' + i);
    }

    private String escapeComma(String s) {
        if (s.indexOf(44) < 0 && s.indexOf(92) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 10);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ',') {
                sb.append("\\,");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected void notifyTestRunStarted(int testCount) {
        this.fUnitTestClientView.sendMessage(null, "%TESTC  " + testCount);
    }

    private void notifyTestRunEnded(long elapsedTime) {
        this.fUnitTestClientView.sendMessage(null, "%RUNTIME" + elapsedTime);
    }

    protected void notifyTestRunStopped(long elapsedTime) {
        this.fUnitTestClientView.sendMessage(null, "%TSTSTP " + elapsedTime);
    }

    protected void notifyTestTreeEntry(String treeEntry) {
        this.fUnitTestClientView.sendMessage(null, "%TSTTREE" + treeEntry);
    }

    public IKDTestLoader getTestLoader() {
        return this.fLoader;
    }

    public Class<?> loadClass(String className, KDUnitTestRunner listener) {
        Class clazz = null;
        clazz = TypesContainer.getOrRegister((String)className);
        return clazz;
    }
}

