/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.ResultSet;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.unittest.UnitTestServiceImpl;

public class FormCoverCount {
    private static final String ALL_COVER = "allCover";
    private static final String ALL_COVER_WITH_PLUGIN = "allCoverWithPlugin";
    private static final String SUCCESS = "success";
    private static final String APP_CASE_NUMBER = "appCaseNumber";
    private static final String COVER_WITH = "0/0(100.00%)";
    private static final String APPID = "appid";
    private static final String ERROR_S_SQL_S = "error:%s;  sql:%s";
    private static Log log = LogFactory.getLog(FormCoverCount.class);

    public static String getFormCoverCount(List<String> resultList, String s_appNumbers) {
        HashMap<String, String> tempMap;
        ObjectMapper mapper = new ObjectMapper();
        ArrayList formCoverResultLists = new ArrayList(10);
        HashMap<String, Map<String, String>> bizCoverPercent = new HashMap<String, Map<String, String>>();
        StringBuilder allFormSql = new StringBuilder();
        allFormSql.append(ResManager.loadKDString((String)"select a.fnumber,t_meta_bizunitrelform.FBIZAPPID,t_meta_bizapp.FNUMBER from (select t_meta_formdesign.FNUMBER,t_meta_formdesign.fbizappid,t_meta_formdesign.FID from t_meta_formdesign INNER JOIN (select fid,fname,flocaleid from t_meta_formdesign_l where FLOCALEID='zh_CN' and fname not LIKE '%\u5e9f\u5f03%') formdesign_l ON t_meta_formdesign.fid=formdesign_l.fid where fistemplate!='1') A INNER JOIN t_meta_bizunitrelform on a.fid=t_meta_bizunitrelform.FFORMID", (String)"FormCoverCount_0", (String)"bos-unittest", (Object[])new Object[0])).append(" INNER JOIN t_meta_bizapp on t_meta_bizunitrelform.FBIZAPPID=t_meta_bizapp.FID");
        String countSql = "select FOBJECT,min(FBIZAPPID) from t_bas_unittestdetail where FRELEASETYPE='1' GROUP BY FOBJECT";
        StringBuilder allFormSqlWithPlugin = new StringBuilder();
        allFormSqlWithPlugin.append(ResManager.loadKDString((String)"select a.fnumber,t_meta_bizunitrelform.FBIZAPPID,t_meta_bizapp.FNUMBER from (select t_meta_formdesign.FNUMBER,t_meta_formdesign.fbizappid,t_meta_formdesign.FID from t_meta_formdesign INNER JOIN (select fid,fname,flocaleid from t_meta_formdesign_l where FLOCALEID='zh_CN' and fname not LIKE '%\u5e9f\u5f03%') formdesign_l ON t_meta_formdesign.fid=formdesign_l.fid where fistemplate!='1') A INNER JOIN t_meta_bizunitrelform on a.fid=t_meta_bizunitrelform.FFORMID INNER JOIN (select fid from t_meta_formdesign where fdata like '%<Plugins>%') C on a.fid=c.fid", (String)"FormCoverCount_1", (String)"bos-unittest", (Object[])new Object[0])).append(" INNER JOIN t_meta_bizapp on t_meta_bizunitrelform.FBIZAPPID=t_meta_bizapp.FID");
        if (StringUtils.isNotBlank((CharSequence)s_appNumbers)) {
            String[] appNumbers = s_appNumbers.split(",");
            for (int i = 0; i < appNumbers.length; ++i) {
                if (i == 0) {
                    allFormSql.append(" where t_meta_bizapp.FNUMBER='").append(appNumbers[i]).append('\'');
                    allFormSqlWithPlugin.append(" where t_meta_bizapp.FNUMBER='").append(appNumbers[i]).append('\'');
                    continue;
                }
                allFormSql.append(" or t_meta_bizapp.FNUMBER='").append(appNumbers[i]).append('\'');
                allFormSqlWithPlugin.append(" or t_meta_bizapp.FNUMBER='").append(appNumbers[i]).append('\'');
            }
        }
        String countSqlWithPlugin = "select FOBJECT,min(FBIZAPPID) from (select FID,FBIZAPPID,FOBJECT from t_bas_unittestdetail where FTESTPLUGIN!='' and FRELEASETYPE='1') A group by FOBJECT";
        String allAppSql = "select t_meta_bizapp.fid,t_meta_bizapp_l.fname from t_meta_bizapp INNER JOIN t_meta_bizapp_l on t_meta_bizapp.FID=t_meta_bizapp_l.FID where flocaleid='zh_CN'";
        HashMap<String, String> objectApp = new HashMap<String, String>();
        HashMap<String, Integer> allFormCount = new HashMap<String, Integer>();
        HashMap<String, Integer> coverCount = new HashMap<String, Integer>();
        HashMap<String, String> appSets = new HashMap<String, String>();
        FormCoverCount.queryAllForm(objectApp, allFormSql.toString(), allFormCount);
        FormCoverCount.queryCountForm(coverCount, countSql, objectApp);
        FormCoverCount.count(coverCount, allFormCount, bizCoverPercent, ALL_COVER);
        objectApp = new HashMap();
        allFormCount = new HashMap();
        coverCount = new HashMap();
        FormCoverCount.queryAllForm(objectApp, allFormSqlWithPlugin.toString(), allFormCount);
        FormCoverCount.queryCountForm(coverCount, countSqlWithPlugin, objectApp);
        FormCoverCount.count(coverCount, allFormCount, bizCoverPercent, ALL_COVER_WITH_PLUGIN);
        FormCoverCount.queryAllApp(appSets, allAppSql);
        String result = null;
        for (String string : resultList) {
            try {
                String number;
                Map map = (Map)mapper.readValue(string, Map.class);
                String bizId = (String)map.get(APPID);
                Integer status = (Integer)map.get("status");
                Map mapTemp = (Map)bizCoverPercent.get(bizId);
                if (status != 0 && bizCoverPercent.containsKey(bizId)) {
                    mapTemp.put(SUCCESS, "false");
                    bizCoverPercent.put(bizId, mapTemp);
                }
                if ((number = (String)mapTemp.get(APP_CASE_NUMBER)) != null) {
                    mapTemp.put(APP_CASE_NUMBER, String.valueOf(Integer.parseInt(number) + Integer.parseInt(map.get("methodNumber").toString())));
                } else {
                    mapTemp.put(APP_CASE_NUMBER, String.valueOf(map.get("methodNumber").toString()));
                }
                bizCoverPercent.put(bizId, mapTemp);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        for (Map.Entry entry : bizCoverPercent.entrySet()) {
            String bizApp = (String)entry.getKey();
            tempMap = (HashMap<String, String>)entry.getValue();
            if (tempMap.get(SUCCESS) == null) {
                tempMap.put(SUCCESS, "true");
                bizCoverPercent.put(bizApp, tempMap);
            }
            HashMap<String, String> tempMaps = new HashMap<String, String>();
            tempMaps.put(APPID, bizApp);
            tempMaps.put("appName", (String)appSets.get(bizApp));
            tempMaps.put(SUCCESS, (String)tempMap.get(SUCCESS));
            tempMaps.put(ALL_COVER, (String)tempMap.get(ALL_COVER));
            if (appSets.containsKey(bizApp)) {
                appSets.remove(bizApp);
            }
            if (tempMap.get(ALL_COVER_WITH_PLUGIN) == null) {
                tempMaps.put(ALL_COVER_WITH_PLUGIN, COVER_WITH);
            } else {
                tempMaps.put(ALL_COVER_WITH_PLUGIN, (String)tempMap.get(ALL_COVER_WITH_PLUGIN));
            }
            if (tempMap.get(APP_CASE_NUMBER) == null) {
                tempMaps.put(APP_CASE_NUMBER, "0");
            } else {
                tempMaps.put(APP_CASE_NUMBER, (String)tempMap.get(APP_CASE_NUMBER));
            }
            formCoverResultLists.add(tempMaps);
        }
        if (StringUtils.isBlank((CharSequence)s_appNumbers)) {
            for (Map.Entry entry : appSets.entrySet()) {
                tempMap = new HashMap<String, String>();
                tempMap.put(APPID, (String)entry.getKey());
                tempMap.put("appName", (String)entry.getValue());
                tempMap.put(ALL_COVER, COVER_WITH);
                tempMap.put(ALL_COVER_WITH_PLUGIN, COVER_WITH);
                tempMap.put(APP_CASE_NUMBER, "0");
                formCoverResultLists.add(tempMap);
            }
        }
        try {
            result = mapper.writeValueAsString(formCoverResultLists);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return result;
    }

    private static void count(Map<String, Integer> numeratorMap, Map<String, Integer> denominatorMap, Map<String, Map<String, String>> bizCoverPercent, String displayName) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMinimumFractionDigits(2);
        for (Map.Entry<String, Integer> entry : denominatorMap.entrySet()) {
            String bizAppId = entry.getKey();
            Map<Object, Object> tempMap = new HashMap();
            Integer divNum = numeratorMap.get(bizAppId);
            if (divNum == null) {
                divNum = 0;
            }
            Integer allNum = entry.getValue();
            Map<String, String> stringStringMap = bizCoverPercent.get(bizAppId);
            if (stringStringMap != null) {
                tempMap = stringStringMap;
            }
            if (allNum == 0) {
                tempMap.put(displayName, COVER_WITH);
            } else {
                tempMap.put(displayName, divNum + "/" + allNum + "(" + format.format((float)divNum.intValue() / (float)allNum.intValue()) + ")");
            }
            bizCoverPercent.put(bizAppId, tempMap);
        }
    }

    private static boolean isUncheckForm(String number) {
        List<String> list = UnitTestServiceImpl.getUnCheckControlFormNumberList();
        for (String string : list) {
            if (!string.equals(number)) continue;
            return true;
        }
        return false;
    }

    private static void queryAllApp(final Map<String, String> appSets, String sql) {
        try {
            DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        String appId = rs.getString(1);
                        String appName = rs.getString(2);
                        appSets.put(appId, appName);
                    }
                    return Boolean.TRUE;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_S_SQL_S, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    private static void queryAllForm(final Map<String, String> objectApp, String sql, final Map<String, Integer> allFormCount) {
        try {
            DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        String number;
                        if (rs.getString(2).equals("") || FormCoverCount.isUncheckForm(number = rs.getString(1))) continue;
                        String appId = rs.getString(2);
                        objectApp.put(number, appId);
                        Integer integer = (Integer)allFormCount.get(appId);
                        if (integer != null) {
                            allFormCount.put(appId, integer + 1);
                            continue;
                        }
                        allFormCount.put(appId, 1);
                    }
                    return Boolean.TRUE;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_S_SQL_S, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    private static void queryCountForm(final Map<String, Integer> coverCount, String sql, final Map<String, String> objectApp) {
        try {
            DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        String bizAppId;
                        String number = rs.getString(1);
                        if (FormCoverCount.isUncheckForm(number) || (bizAppId = (String)objectApp.get(number)) == null) continue;
                        Integer integer = (Integer)coverCount.get(bizAppId);
                        if (integer != null) {
                            coverCount.put(bizAppId, integer + 1);
                            continue;
                        }
                        coverCount.put(bizAppId, 1);
                    }
                    return Boolean.TRUE;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_S_SQL_S, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    private static void queryData(final Map<String, Map<String, String>> storeMap, String sql, final String stroreText) {
        final NumberFormat format = NumberFormat.getPercentInstance();
        format.setMinimumFractionDigits(2);
        try {
            DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        String bizAppId = rs.getString(1);
                        int divNum = rs.getInt(2);
                        int allNum = rs.getInt(3);
                        Map<String, String> mapInfo = new HashMap();
                        Map map = (Map)storeMap.get(bizAppId);
                        if (map != null) {
                            mapInfo = map;
                        }
                        if (allNum != 0) {
                            mapInfo.put(stroreText, divNum + "/" + allNum + "(" + format.format((float)divNum / (float)allNum) + ")");
                        } else {
                            mapInfo.put(stroreText, "0/0(0.00%)");
                        }
                        storeMap.put(bizAppId, mapInfo);
                    }
                    return Boolean.TRUE;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_S_SQL_S, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }
}

