/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.unittest.AnalysisResponseBody;
import kd.bos.form.unittest.AssertController;
import kd.bos.form.unittest.JMXForAnalysis;
import kd.bos.form.unittest.KDCase;
import kd.bos.form.unittest.KDCaseMethodResult;
import kd.bos.form.unittest.RegularController;
import kd.bos.form.unittest.UnitTestCase;
import kd.bos.form.unittest.UnitTestGroup;
import kd.bos.form.unittest.UnitTestHttpProxy;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.form.FormServiceImpl;
import kd.bos.mservice.form.unittest.ITestCase;
import kd.bos.mservice.form.unittest.TestCase;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.unittest.UnitTestDao;

public class HttpActionFrameTestCase
extends TestCase
implements ITestCase {
    private static final String PAGE_ID = "pageId";
    private static final String FORM_ID = "formId";
    private static final String PREPARE = "prepare : ";
    private static final String PARENT_PAGE_ID = "parentPageId";
    private static final String REF_NAME = "refName";
    private static final String ALL_SYS_PARA = "allSysPara";
    private final Map<String, Map<String, Object>> prepareAppMap = new HashMap<String, Map<String, Object>>();
    private final ConcurrentLinkedQueue<String> runCaseIdQueue = new ConcurrentLinkedQueue();
    private ObjectMapper mapper = new ObjectMapper();
    private FormService formServiceImpl = new FormServiceImpl();
    private Pattern paraPattern = Pattern.compile("(?<=\\$\\{)(.*?)(?=\\})");
    private Map<String, Map<String, Object>> prepareAppMapNoStatic;

    @Override
    public String execute(KDCase kcase) {
        return this.executeHttpFrameWithNoEnv(kcase);
    }

    private boolean openPrepareAppEnv(String appId, Map<String, Map<String, Object>> prepareAppMapPara) throws Exception {
        Map<String, Object> appEnvInfo = UnitTestDao.getPrepareEnvStartCase(appId);
        this.testResult.setFucSum(this.testResult.getFucSum() + 1);
        KDCaseMethodResult ret1 = new KDCaseMethodResult();
        ret1.setHasassert(true);
        ret1.setName(ResManager.loadKDString((String)"prepare: \u83b7\u53d6\u521d\u59cb\u5316\u8fdb\u5165\u5e94\u7528\u7528\u4f8b\u4fe1\u606f", (String)"HttpActionFrameTestCase_0", (String)"bos-unittest", (Object[])new Object[0]));
        ret1.setMethodName(ResManager.loadKDString((String)"prepare: \u83b7\u53d6\u521d\u59cb\u5316\u8fdb\u5165\u5e94\u7528\u7528\u4f8b\u4fe1\u606f", (String)"HttpActionFrameTestCase_0", (String)"bos-unittest", (Object[])new Object[0]));
        ret1.setStartTime(new Date());
        if (appEnvInfo == null) {
            ret1.setEndTime(new Date());
            ret1.setCompleted(false);
            ret1.setMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u521d\u59cb\u5316\u8fdb\u5165\u5e94\u7528\u4fe1\u606f\uff0c\u8bf7\u6dfb\u52a0\u8fdb\u5165\u5e94\u7528\u7528\u4f8b", (String)"HttpActionFrameTestCase_1", (String)"bos-unittest", (Object[])new Object[0]));
            this.testResult.addTestCaseResult(ret1);
            return false;
        }
        ret1.setMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\n\u83b7\u53d6\u521d\u59cb\u5316\u8fdb\u5165\u5e94\u7528\u4fe1\u606f,\u5f53\u524d\u521d\u59cb\u5316\u5e94\u7528\u7528\u4f8b\u4e3a:\n ", (String)"HttpActionFrameTestCase_2", (String)"bos-unittest", (Object[])new Object[0]) + "=========================================\ncasename: " + appEnvInfo.get("casename") + ",casenumber: " + appEnvInfo.get("casenumber"));
        ret1.setEndTime(new Date());
        ret1.setCompleted(true);
        this.testResult.addTestCaseResult(ret1);
        String context = (String)appEnvInfo.get("context");
        HashMap<String, Object> para = JMXForAnalysis.jsonToUnitTestGroupBean(context);
        Object paraResult = para.get("result");
        List groupList = new ArrayList();
        if (!(paraResult instanceof List)) {
            ret1.setEndTime(new Date());
            ret1.setCompleted(false);
            ret1.setMessage(paraResult.toString());
            return false;
        }
        groupList = (List)paraResult;
        for (UnitTestGroup unitTestGroup : groupList) {
            for (UnitTestCase unitTestCase : unitTestGroup.getUnitTestCases()) {
                for (UnitTestHttpProxy unitTestHttpProxy : unitTestCase.getUnitTestHttpProxys()) {
                    String path = unitTestHttpProxy.getInvokeMethod().getPath();
                    String action = path.substring(path.lastIndexOf(47) + 1);
                    if (!this.isHandleActions(action)) continue;
                    this.testResult.setFucSum(this.testResult.getFucSum() + 1);
                    KDCaseMethodResult ret = new KDCaseMethodResult();
                    ret.setHasassert(true);
                    ret.setName("prepare" + unitTestCase.getName());
                    ret.setMethodName("prepare" + unitTestHttpProxy.getName());
                    ret.setStartTime(new Date());
                    Map<String, Object> param = unitTestHttpProxy.getParams();
                    for (Map.Entry<String, Object> entry : param.entrySet()) {
                        String value = entry.getValue().toString();
                        Object matcher = this.paraPattern.matcher(value);
                        while (((Matcher)matcher).find()) {
                            String findKey = ((Matcher)matcher).group();
                            if (prepareAppMapPara != null) {
                                if (!prepareAppMapPara.get(appId).containsKey(findKey)) continue;
                                value = value.replace("${" + findKey + "}", prepareAppMapPara.get(appId).get(findKey).toString());
                                continue;
                            }
                            if (!this.prepareAppMap.get(appId).containsKey(findKey)) continue;
                            value = value.replace("${" + findKey + "}", this.prepareAppMap.get(appId).get(findKey).toString());
                        }
                        param.put(entry.getKey(), value);
                    }
                    String result = "";
                    String tempApp = "bos";
                    if (param.get("appId") != null) {
                        tempApp = param.get("appId").toString();
                    }
                    switch (action) {
                        case "batchInvokeAction.do": {
                            result = (String)DispatchServiceHelper.invokeBOSService((String)tempApp, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{param.get(PAGE_ID).toString(), unitTestHttpProxy.getParams().get("params").toString()});
                            break;
                        }
                        case "getConfig.do": {
                            Map paras = (Map)SerializationUtils.fromJsonString((String)param.get("params").toString(), Map.class);
                            result = this.formServiceImpl.getConfig(paras);
                            break;
                        }
                    }
                    HttpActionFrameTestCase.assertInvokeAction(result);
                    String erroInfo = null;
                    if (unitTestHttpProxy.getRegularController() != null) {
                        erroInfo = this.regularCatch(result, unitTestHttpProxy, appId, prepareAppMapPara);
                    }
                    if (unitTestHttpProxy.getAssertController() != null) {
                        for (AssertController asserController : unitTestHttpProxy.getAssertController()) {
                            this.assertCatch(result, asserController, ret);
                        }
                    }
                    if (erroInfo != null) {
                        ret.setMessage(erroInfo);
                    }
                    if (erroInfo == null && ret.getMessage() == null) {
                        ret.setMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\n", (String)"HttpActionFrameTestCase_3", (String)"bos-unittest", (Object[])new Object[0]) + result);
                    }
                    ret.setEndTime(new Date());
                    ret.setCompleted(true);
                    this.testResult.addTestCaseResult(ret);
                }
            }
        }
        return true;
    }

    private boolean isHandleActions(String action) {
        switch (action) {
            case "batchInvokeAction.do": 
            case "getConfig.do": {
                return true;
            }
        }
        return false;
    }

    private void assertCatch(String result, AssertController assertController, KDCaseMethodResult ret) {
        AnalysisResponseBody analyser = new AnalysisResponseBody();
        Map<String, Object> resultMap = analyser.checkMatchTypeAndAnalysis(assertController, result);
        Object fail = resultMap.get("fail");
        if (fail != null) {
            ret.setMessage(fail + ResManager.loadKDString((String)"\n\u8fd4\u56de\u7ed3\u679c\u4e3a:\n", (String)"HttpActionFrameTestCase_4", (String)"bos-unittest", (Object[])new Object[0]) + result);
        }
    }

    private String regularCatch(String result, UnitTestHttpProxy proxy, String appId, Map<String, Map<String, Object>> prepareAppMapPara) {
        AnalysisResponseBody analyser = new AnalysisResponseBody();
        for (RegularController controller : proxy.getRegularController()) {
            String regex = controller.getRegexExtractor_regex();
            if (regex != null && regex.contains("\\\\")) {
                regex = regex.replace("\\\\", "\\");
            }
            controller.setRegexExtractor_regex(regex);
            try {
                Map<String, Object> map;
                Map<String, Object> resultMap = analyser.analysisRegexExtractor(result, controller);
                resultMap.put(controller.getRegexExtractor_refname(), resultMap.get(REF_NAME));
                if (prepareAppMapPara != null) {
                    map = prepareAppMapPara.get(appId);
                    if (map != null) {
                        map.put(controller.getRegexExtractor_refname(), resultMap.get(REF_NAME));
                        prepareAppMapPara.put(appId, map);
                        continue;
                    }
                    prepareAppMapPara.put(appId, resultMap);
                    continue;
                }
                map = this.prepareAppMap.get(appId);
                if (map != null) {
                    map.put(controller.getRegexExtractor_refname(), resultMap.get(REF_NAME));
                    this.prepareAppMap.put(appId, map);
                    continue;
                }
                this.prepareAppMap.put(appId, resultMap);
            }
            catch (Exception e) {
                String erroInfo = ResManager.loadKDString((String)"\u5f88\u5947\u602a\u7684\u5076\u53d1\u95ee\u9898\uff0c\u628a\u9519\u8bef\u4fe1\u606f\u5148\u6253\u5370\u51fa\u6765\u770b:", (String)"HttpActionFrameTestCase_5", (String)"bos-unittest", (Object[])new Object[0]) + "\n  result:\n" + result + "\n   controllerInfo:\n\n controllerName:" + controller.getName() + "\n RegexExtractor_default:" + controller.getRegexExtractor_default() + "\n RegexExtractor_match_number:" + controller.getRegexExtractor_match_number() + "\n RegexExtractor_refname:" + controller.getRegexExtractor_refname() + "\n RegexExtractor_regex:" + controller.getRegexExtractor_regex() + "\n RegexExtractor_template:" + controller.getRegexExtractor_template() + "\n RegexExtractor_useHeaders:" + controller.getRegexExtractor_useHeaders() + "\n cause by" + e.getMessage();
                return erroInfo;
            }
        }
        return null;
    }

    private Map<String, String> openResolve(String jsonString) throws Exception {
        List list = (List)this.mapper.readValue(jsonString, List.class);
        for (Map map : list) {
            List openForms = (List)map.get("p");
            for (Object object : openForms) {
                Map temp;
                if (!(object instanceof Map) || !"tenant_myapp".equals((temp = (Map)object).get(FORM_ID))) continue;
                return temp;
            }
        }
        return null;
    }

    private String openHomePage(Map<String, Map<String, Object>> prepareAppMapPara) {
        HashMap<String, String> pa = new HashMap<String, String>();
        pa.put(FORM_ID, "pc_main_console");
        pa.put("billFormId", "pc_main_console");
        this.testResult.setFucSum(this.testResult.getFucSum() + 1);
        KDCaseMethodResult ret = new KDCaseMethodResult();
        ret.setHasassert(true);
        ret.setName(PREPARE + ResManager.loadKDString((String)"\u83b7\u53d6\u4e3b\u9875config", (String)"HttpActionFrameTestCase_6", (String)"bos-unittest", (Object[])new Object[0]));
        ret.setMethodName("prepare : getHomePageConfig");
        ret.setStartTime(new Date());
        String retGetconfig = this.formServiceImpl.getConfig(pa);
        HttpActionFrameTestCase.assertInvokeAction(retGetconfig);
        Map config = (Map)SerializationUtils.fromJsonString((String)retGetconfig, Map.class);
        if (config == null) {
            ret.setEndTime(new Date());
            ret.setMessage(ResManager.loadKDString((String)"\u6d4b\u8bd5\u5931\u8d25,\u8bfb\u53d6\u4e3b\u9875Config\u4e3a\u7a7a\uff01", (String)"HttpActionFrameTestCase_7", (String)"bos-unittest", (Object[])new Object[0]));
            ret.setCompleted(false);
            return null;
        }
        ret.setEndTime(new Date());
        ret.setMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\n\u83b7\u53d6\u4e3b\u9875config\u6210\u529f", (String)"HttpActionFrameTestCase_8", (String)"bos-unittest", (Object[])new Object[0]));
        ret.setCompleted(true);
        this.testResult.addTestCaseResult(ret);
        this.testResult.setFucSum(this.testResult.getFucSum() + 1);
        KDCaseMethodResult pageRet = new KDCaseMethodResult();
        pageRet.setHasassert(true);
        pageRet.setName(PREPARE + ResManager.loadKDString((String)"\u83b7\u53d6\u4e3b\u9875pageId", (String)"HttpActionFrameTestCase_9", (String)"bos-unittest", (Object[])new Object[0]));
        pageRet.setMethodName("prepare : getHomePageId");
        pageRet.setStartTime(new Date());
        String meta = this.metaDataService.loadFormMeta((String)config.get(FORM_ID));
        if (StringUtils.isNotBlank((CharSequence)meta)) {
            this.currentPageId = (String)config.get(PAGE_ID);
            String loaddata = this.formServiceImpl.invokeAction(this.currentPageId, "", "loadData", new Object[0], new ArrayList());
            if (loaddata == null || loaddata.contains("errorTitle")) {
                pageRet.setEndTime(new Date());
                pageRet.setMessage(loaddata);
                pageRet.setCompleted(false);
                this.testResult.addTestCaseResult(pageRet);
                return null;
            }
            try {
                Map<String, String> para = this.openResolve(loaddata);
                if (para == null) {
                    pageRet.setEndTime(new Date());
                    pageRet.setMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230tenant_myapp,\u9996\u9875\u6709\u8c03\u6574\uff0c\u8054\u7cfb\u7ba1\u7406\u5458", (String)"HttpActionFrameTestCase_10", (String)"bos-unittest", (Object[])new Object[0]));
                    pageRet.setCompleted(false);
                    this.testResult.addTestCaseResult(pageRet);
                    return null;
                }
                HashMap<String, String> temp = new HashMap<String, String>();
                temp.put("pc_main_console_pageId", para.get(PARENT_PAGE_ID));
                if (para.get(PARENT_PAGE_ID) == null || para.get(PAGE_ID) == null) {
                    pageRet.setEndTime(new Date());
                    pageRet.setMessage(loaddata);
                    pageRet.setCompleted(false);
                    this.testResult.addTestCaseResult(pageRet);
                    return null;
                }
                temp.put("tenant_myapp_pageId", para.get(PAGE_ID));
                if (prepareAppMapPara != null) {
                    prepareAppMapPara.put(ALL_SYS_PARA, temp);
                } else {
                    this.prepareAppMap.put(ALL_SYS_PARA, temp);
                }
                pageRet.setEndTime(new Date());
                pageRet.setMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\n\u83b7\u53d6\u4e3b\u9875pageId\u6210\u529f: pc_main_console_pageId:", (String)"HttpActionFrameTestCase_11", (String)"bos-unittest", (Object[])new Object[0]) + para.get(PARENT_PAGE_ID) + " tenant_myapp_pageId:" + para.get(PAGE_ID));
                pageRet.setCompleted(true);
                this.testResult.addTestCaseResult(pageRet);
                return para.get(PAGE_ID);
            }
            catch (Exception e) {
                pageRet.setEndTime(new Date());
                pageRet.setMessage(e.getMessage());
                pageRet.setCompleted(false);
                this.testResult.addTestCaseResult(pageRet);
            }
        } else {
            pageRet.setEndTime(new Date());
            pageRet.setMessage(ResManager.loadKDString((String)"\u4e3b\u9875\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25", (String)"HttpActionFrameTestCase_12", (String)"bos-unittest", (Object[])new Object[0]));
            pageRet.setCompleted(false);
            this.testResult.addTestCaseResult(pageRet);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeHttpFrameWithNoEnv(KDCase kcase) {
        String sRet;
        this.testResult.setStartTime(new Date());
        this.testResult.setStatus(0);
        this.testResult.setCaseId(kcase.getId());
        this.testResult.setCaseNumber(kcase.getNumber());
        this.testResult.setCaseLevel(kcase.getLevel());
        this.testResult.setDeviceType(kcase.getDevicetype());
        this.testResult.setQueryListNumber(kcase.getQuerylistnumber());
        this.testResult.setName(kcase.getName());
        this.testResult.setCaseFrame(kcase.getFrame());
        this.testResult.setResponser(kcase.getResponser());
        this.testResult.setAppid(kcase.getAppid());
        this.testResult.setAppname(kcase.getAppname());
        this.runCaseIdQueue.add(kcase.getId());
        this.prepareAppMapNoStatic = new HashMap<String, Map<String, Object>>();
        String AppInfo = "";
        Map<Object, Object> map = new HashMap();
        try {
            String appid = kcase.getAppid();
            boolean successOpenAppEnv = false;
            this.openHomePage(this.prepareAppMapNoStatic);
            map = this.prepareAppMapNoStatic.get(ALL_SYS_PARA);
            if (map != null) {
                this.prepareAppMapNoStatic.put(appid, map);
            }
            if (successOpenAppEnv = this.openPrepareAppEnv(appid, this.prepareAppMapNoStatic)) {
                String prepareindex = kcase.getPrepareindex();
                if (StringUtils.isNotBlank((CharSequence)prepareindex) && "0".equals(prepareindex)) {
                    this.testResult.setMessage(ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f!", (String)"HttpActionFrameTestCase_13", (String)"bos-unittest", (Object[])new Object[0]));
                    this.testResult.setCompleted(true);
                    this.testResult.setEndTime(new Date());
                    String string = SerializationUtils.toJsonString((Object)this.testResult);
                    return string;
                }
                this.testJunitFunction(kcase);
                this.testResult.setMessage(ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f!", (String)"HttpActionFrameTestCase_13", (String)"bos-unittest", (Object[])new Object[0]));
                this.testResult.setCompleted(true);
            } else {
                this.testResult.setMessage(ResManager.loadKDString((String)"\u6d4b\u8bd5\u5931\u8d25!", (String)"HttpActionFrameTestCase_14", (String)"bos-unittest", (Object[])new Object[0]));
                this.testResult.setCompleted(false);
            }
        }
        catch (Exception e) {
            this.testResult.setMessage(this.getTrace(e));
            this.testResult.setCompleted(false);
            this.testResult.setStatus(1);
            AppInfo = this.getNodeInfo();
            this.testResult.setMessage(this.testResult.getMessage() + System.getProperty("line.separator") + AppInfo);
        }
        catch (Throwable e) {
            this.testResult.setMessage(this.getTrace(e));
            this.testResult.setCompleted(false);
            this.testResult.setStatus(1);
        }
        finally {
            this.testResult.setEndTime(new Date());
            sRet = SerializationUtils.toJsonString((Object)this.testResult);
            this.runCaseIdQueue.remove(kcase.getId());
            if (this.prepareAppMapNoStatic.containsKey(ALL_SYS_PARA)) {
                this.release((String)map.get("tenant_myapp_pageId"));
                this.release((String)map.get("pc_main_console_pageId"));
            }
        }
        return sRet;
    }

    public static synchronized boolean releaseEnv(String appId) {
        return true;
    }

    @Override
    public HashMap<String, Object> createRuntimeParams(KDCase kcase) {
        HashMap<String, Object> runMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> classPlugins = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> mapPluginInfo = new HashMap<String, Object>();
        String context = kcase.getContext();
        mapPluginInfo.put("appEnv", this.prepareAppMapNoStatic.get(kcase.getAppid()));
        mapPluginInfo.put("type", (Object)KDCase.CasePluginType.action);
        mapPluginInfo.put("class", "kd.bos.unittest.UnitTestHttpActionPlugin");
        mapPluginInfo.put("context", context);
        mapPluginInfo.put("casename", kcase.getNumber());
        mapPluginInfo.put("datasourcecontent", kcase.getDatasourcecontent());
        classPlugins.add(mapPluginInfo);
        this.testResult.setMethodNumber(this.countMthodeNumber(classPlugins));
        runMap.put("pluginInfos", classPlugins);
        runMap.put("testloaderclass", "kd.bos.unittest.runner.KDUnitTestLoader");
        return runMap;
    }
}

