/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.IUnitTestPlugIn;
import kd.bos.form.unittest.KDCaseMethodResult;
import kd.bos.form.unittest.TestMethod;

public class PlugInTestAction
implements Comparator<PlugInTestAction> {
    private static final String JS_PLUGIN_SORT_NAME = "sort";
    public static IUnitTestPlugIn PlugIn;
    private MyMethod method;
    private String displayName;
    private int ExecuteSeq;

    private static void addTestActionFromMethod(List<PlugInTestAction> actions, Method[] ms, IUnitTestPlugIn plugin) {
        for (Method method : ms) {
            Annotation[] methodAnnotations = method.getDeclaredAnnotations();
            if (methodAnnotations.length < 2) continue;
            boolean bHaveTestmethod = false;
            boolean bHaveDisplayName = false;
            int iExecuteSeq = 0;
            String sDisplayName = null;
            for (Annotation anno : methodAnnotations) {
                if (anno.annotationType() == TestMethod.class) {
                    iExecuteSeq = ((TestMethod)anno).value();
                    bHaveTestmethod = true;
                    continue;
                }
                if (anno.annotationType() != DisplayName.class) continue;
                sDisplayName = ((DisplayName)anno).value();
                bHaveDisplayName = true;
            }
            if (!bHaveTestmethod || !bHaveDisplayName) continue;
            PlugInTestAction addNew = new PlugInTestAction();
            addNew.displayName = sDisplayName;
            addNew.ExecuteSeq = iExecuteSeq;
            PlugIn = plugin;
            addNew.method = new MyMethod();
            addNew.method.method = method;
            actions.add(addNew);
        }
    }

    public static List<PlugInTestAction> Search(IUnitTestPlugIn plugin, boolean bSearchParent) {
        ArrayList<PlugInTestAction> actions = new ArrayList<PlugInTestAction>();
        if (plugin == null) {
            return null;
        }
        if (bSearchParent) {
            Method[] msParent = plugin.getClass().getSuperclass().getDeclaredMethods();
            PlugInTestAction.addTestActionFromMethod(actions, msParent, plugin);
        }
        if (plugin.getPluginType() == 0) {
            try {
                List lst = (List)plugin.invoke(JS_PLUGIN_SORT_NAME, new Object[0]);
                int i = 0;
                while (i < lst.size()) {
                    List innerLis = (List)lst.get(i);
                    PlugInTestAction addNew = new PlugInTestAction();
                    addNew.displayName = innerLis.get(0).toString();
                    addNew.ExecuteSeq = i++;
                    PlugIn = plugin;
                    addNew.method = new MyMethod();
                    addNew.method.methodName = innerLis.get(1).toString();
                    actions.add(addNew);
                }
                return actions;
            }
            catch (Exception e) {
                throw new RuntimeException("Unit test js plugin have not function sort()", e);
            }
        }
        Method[] ms = plugin.getClass().getDeclaredMethods();
        PlugInTestAction.addTestActionFromMethod(actions, ms, plugin);
        if (actions.size() > 1) {
            PlugInTestAction comp = new PlugInTestAction();
            Collections.sort(actions, comp);
        }
        return actions;
    }

    public KDCaseMethodResult Execute() {
        KDCaseMethodResult ret = new KDCaseMethodResult();
        try {
            ret.setCompleted(false);
            ret.setName(this.displayName);
            ret.setMethodName(this.method.getName());
            ret.setStartTime(new Date());
            this.method.invoke();
            ret.setEndTime(new Date());
            ret.setCompleted(true);
        }
        catch (Exception e) {
            ret.setEndTime(new Date());
            ret.setCompleted(false);
            ret.setMessage(this.getErrorInfoFromException(e));
        }
        finally {
            if (ret.getCompleted()) {
                ret.setMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"PlugInTestAction_0", (String)"bos-unittest", (Object[])new Object[0]));
            }
        }
        return ret;
    }

    @Override
    public int compare(PlugInTestAction arg0, PlugInTestAction arg1) {
        return Integer.compare(arg0.ExecuteSeq, arg1.ExecuteSeq);
    }

    private String getErrorInfoFromException(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "\r\n" + sw + "\r\n";
        }
        catch (Exception e2) {
            return "bad getErrorInfoFromException";
        }
    }

    public static class MyMethod {
        public Method method = null;
        public String methodName;

        public String getName() {
            if (this.method != null) {
                return this.method.getName();
            }
            return this.methodName;
        }

        public void invoke() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.method != null) {
                this.method.invoke((Object)PlugIn, new Object[0]);
            } else {
                PlugIn.invoke(this.methodName, new Object[0]);
            }
        }
    }
}

