/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorPageCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.ExcelDataObject;
import kd.bos.form.unittest.KDCase;
import kd.bos.form.unittest.KDCaseMethodResult;
import kd.bos.form.unittest.KDUnitTestRunnerManager;
import kd.bos.instance.Instance;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.form.FormServiceImpl;
import kd.bos.mservice.form.unittest.TestObjectResult;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.MetadataServiceImpl;
import kd.bos.unittest.UnitTestDao;
import org.junit.Ignore;
import org.junit.Test;

public class TestCase {
    public static final String JS_PLUGIN_CLASS_NAME = "kd.bos.unittest.UnitTestScriptPlugin";
    public static final String NEW_JS_PLUGIN_CLASS_NAME = "kd.bos.unittest.KDUnitTestScriptPlugIn";
    private static final String CLASS = "class";
    private static final String TEST_CASE_2 = "TestCase_2";
    private static final String FORM_ID = "formId";
    protected FormService formService = null;
    protected MetadataService metaDataService = null;
    public String currentPageId;
    public TestObjectResult testResult = new TestObjectResult();
    private IFormView formView = null;

    public TestCase() {
        this.formService = new FormServiceImpl();
        this.metaDataService = new MetadataServiceImpl();
    }

    protected int countMthodeNumber(List<Map<String, Object>> testPluginName) {
        int temp = 0;
        for (Map<String, Object> map : testPluginName) {
            if ("javaclass".equals(map.get("type"))) {
                try {
                    Method[] methods;
                    Class<?> clazz = Class.forName((String)map.get(CLASS));
                    for (Method method : methods = clazz.getMethods()) {
                        if (ArrayUtils.isNotEmpty((Object[])method.getAnnotationsByType(Ignore.class)) || !ArrayUtils.isNotEmpty((Object[])method.getAnnotationsByType(Test.class))) continue;
                        ++temp;
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{e.getMessage()});
                }
            }
            if (!"action".equals(map.get("type"))) continue;
            String dataSourceString = (String)map.get("datasourcecontent");
            if (StringUtils.isNotBlank((CharSequence)dataSourceString)) {
                Map contentMap = (Map)SerializationUtils.fromJsonString((String)dataSourceString, Map.class);
                for (Map.Entry entry : contentMap.entrySet()) {
                    String tempString = SerializationUtils.toJsonString(entry.getValue());
                    List list = SerializationUtils.fromJsonStringToList((String)tempString, ExcelDataObject.class);
                    for (ExcelDataObject excelDataObject : list) {
                        if (excelDataObject.getDataList() != null) {
                            temp += excelDataObject.getDataList().size();
                            continue;
                        }
                        ++temp;
                    }
                }
                continue;
            }
            ++temp;
        }
        return temp;
    }

    public HashMap<String, Object> createRuntimeParams(KDCase kcase) {
        HashMap<String, Object> runMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> classPlugins = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotBlank((CharSequence)kcase.getPlugin())) {
            Map mapPlugin = (Map)SerializationUtils.fromJsonString((String)kcase.getPlugin(), Map.class);
            List lstPlugin = (List)mapPlugin.get("value");
            for (Map map : lstPlugin) {
                boolean bEnable = (Boolean)map.get("Enabled");
                if (!bEnable || !StringUtils.isNotBlank(map.get("ClassName"))) continue;
                String plugInClass = map.get("ClassName").toString();
                String sPluginType = "0";
                if (StringUtils.isNotBlank(map.get("Type"))) {
                    sPluginType = map.get("Type").toString();
                }
                HashMap<String, Object> mapPluginInfo = new HashMap<String, Object>();
                if ("0".equals(sPluginType)) {
                    mapPluginInfo.put("type", (Object)KDCase.CasePluginType.javaclass);
                    mapPluginInfo.put(CLASS, plugInClass);
                } else {
                    String sJsPluginContext = UnitTestDao.getJsPluginContext(map.get("FPK"));
                    mapPluginInfo.put("type", (Object)KDCase.CasePluginType.js);
                    mapPluginInfo.put(CLASS, NEW_JS_PLUGIN_CLASS_NAME);
                    mapPluginInfo.put("context", sJsPluginContext);
                }
                classPlugins.add(mapPluginInfo);
            }
        }
        this.testResult.setMethodNumber(this.countMthodeNumber(classPlugins));
        runMap.put("pluginInfos", classPlugins);
        runMap.put("testloaderclass", "kd.bos.unittest.runner.KDUnitTestLoader");
        if (kcase.getCaseType() == KDCase.CaseType.JavaClassWithform) {
            Map param;
            runMap.put("formview", this.formView);
            String sparam = kcase.getParam();
            if (StringUtils.isNotBlank((CharSequence)sparam) && (param = (Map)SerializationUtils.fromJsonString((String)sparam, Map.class)) != null) {
                runMap.put("param", param);
            }
        }
        return runMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJunitFunction(KDCase kcase) throws Throwable {
        HashMap<String, Object> runtimeParams = this.createRuntimeParams(kcase);
        ArrayList<KDCaseMethodResult> lstKDResult = null;
        try {
            lstKDResult = KDUnitTestRunnerManager.RunUnitTest(runtimeParams);
        }
        finally {
            IFormView formView;
            if (kcase.getCaseType() == KDCase.CaseType.JavaClassWithform && (formView = SessionManager.getCurrent().getView(this.currentPageId)) != null) {
                IFormController srv = (IFormController)formView.getService(IFormController.class);
                srv.destory();
            }
        }
        if (kcase.getCaseType() == KDCase.CaseType.HttpActionFrame) {
            HashSet<String> methodSet = new HashSet<String>();
            for (KDCaseMethodResult caseResult : lstKDResult) {
                caseResult.setHasassert(true);
                methodSet.add(caseResult.getName());
            }
            this.testResult.setFucSum(this.testResult.getFucSum() + methodSet.size());
        } else {
            this.testResult.setFucSum(this.testResult.getFucSum() + lstKDResult.size());
        }
        for (KDCaseMethodResult kdCaseMethodResult : lstKDResult) {
            if (kdCaseMethodResult.getCompleted()) continue;
            kdCaseMethodResult.setMessage(kdCaseMethodResult.getMessage() + System.getProperty("line.separator") + this.getNodeInfo());
            this.testResult.setStatus(2);
            break;
        }
        for (KDCaseMethodResult kdCaseMethodResult : lstKDResult) {
            if (kdCaseMethodResult.getHasassert()) continue;
            this.testResult.setHasnoassert(true);
            break;
        }
        this.testResult.addTestCaseResultAll(lstKDResult);
    }

    protected String getTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    protected String getTrace(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testLoadData(String currentPageId) {
        this.testResult.setFucSum(this.testResult.getFucSum() + 1);
        boolean bRet = false;
        KDCaseMethodResult ret = new KDCaseMethodResult();
        ret.setHasassert(true);
        try {
            ret.setName(ResManager.loadKDString((String)"\u7ed1\u5b9a\u52a8\u6001\u8868\u5355\u6570\u636e", (String)"TestCase_0", (String)"bos-unittest", (Object[])new Object[0]));
            ret.setMethodName("testLoadData");
            ret.setStartTime(new Date());
            String loaddata = this.formService.invokeAction(currentPageId, "", "loadData", new Object[0], new ArrayList());
            ret.setEndTime(new Date());
            if (StringUtils.isBlank((CharSequence)loaddata)) {
                ret.setEndTime(new Date());
                this.testResult.setStatus(2);
                ret.setCompleted(false);
                ret.setMessage(ResManager.loadKDString((String)"LoadData\u5931\u8d25\uff0c\u8bfb\u53d6\u52a8\u6001\u8868\u5355\u6570\u636e\u4e3a\u7a7a~", (String)"TestCase_1", (String)"bos-unittest", (Object[])new Object[0]));
            } else {
                bRet = true;
                ret.setCompleted(true);
                ret.setMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)TEST_CASE_2, (String)"bos-unittest", (Object[])new Object[0]));
                SessionManager.getCurrent().setRequestThread(true);
                this.formView = SessionManager.getCurrent().getView(currentPageId);
                List lstActRet = (List)SerializationUtils.fromJsonString((String)loaddata, List.class);
                if (lstActRet != null) {
                    List para = new ArrayList();
                    for (Object object : lstActRet) {
                        Map itemMap = (Map)object;
                        para = (List)itemMap.get("p");
                        if ("showErrMsg".equalsIgnoreCase((String)itemMap.get("a"))) {
                            this.testResult.setStatus(2);
                            ret.setCompleted(false);
                            ret.setMessage(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u51fa\u5931\u8d25\uff1a%s,%s", (String)"TestCase_3", (String)"bos-unittest", (Object[])new Object[0]), (String)((Map)para.get(0)).get("errorTitle"), (String)((Map)para.get(0)).get("errorInfo")));
                            continue;
                        }
                        if (!"showForm".equalsIgnoreCase((String)itemMap.get("a"))) continue;
                        String innerPageId = (String)((Map)para.get(0)).get("pageId");
                        this.formService.invokeAction(innerPageId, "", "loadData", new Object[0], new ArrayList());
                    }
                }
            }
        }
        catch (Exception e) {
            ret.setEndTime(new Date());
            this.testResult.setStatus(2);
            ret.setCompleted(false);
            ret.setMessage(this.getErrorInfoFromException(e));
        }
        finally {
            ret.setEndTime(new Date());
            this.testResult.addTestCaseResult(ret);
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testGetUIMetadata(Map<String, Object> config) {
        this.testResult.setFucSum(this.testResult.getFucSum() + 1);
        boolean bRet = false;
        KDCaseMethodResult ret = new KDCaseMethodResult();
        ret.setHasassert(true);
        try {
            ret.setName(ResManager.loadKDString((String)"\u83b7\u53d6\u52a8\u6001\u8868UI\u5143\u6570\u636e", (String)"TestCase_4", (String)"bos-unittest", (Object[])new Object[0]));
            ret.setMethodName("testGetUIMetadata");
            ret.setStartTime(new Date());
            String meta = this.metaDataService.loadFormMeta((String)config.get(FORM_ID));
            ret.setEndTime(new Date());
            if (StringUtils.isBlank((CharSequence)meta)) {
                ret.setEndTime(new Date());
                this.testResult.setStatus(2);
                ret.setCompleted(false);
                ret.setMessage(ResManager.loadKDString((String)"\u5931\u8d25\uff0c\u8bfb\u53d6\u8868\u5355UI\u5143\u6570\u636e\u4e3a\u7a7a~(FormId=", (String)"TestCase_5", (String)"bos-unittest", (Object[])new Object[0]) + (String)config.get(FORM_ID) + ")");
            } else {
                bRet = true;
                ret.setCompleted(true);
                ret.setMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)TEST_CASE_2, (String)"bos-unittest", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            ret.setEndTime(new Date());
            this.testResult.setStatus(2);
            ret.setCompleted(false);
            ret.setMessage(this.getErrorInfoFromException(e));
        }
        finally {
            this.testResult.addTestCaseResult(ret);
        }
        return bRet;
    }

    private String getErrorInfoFromException(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "\r\n" + sw + "\r\n";
        }
        catch (Exception e2) {
            return "bad getErrorInfoFromException";
        }
    }

    public static void assertInvokeAction(String actionResult) {
        List lstActRet;
        if ((actionResult.contains("\"errorTitle\":") || actionResult.contains("\"ShowNotificationMsg\":")) && (lstActRet = (List)SerializationUtils.fromJsonString((String)actionResult, List.class)) != null) {
            List para = new ArrayList();
            for (Object object : lstActRet) {
                Map itemMap = (Map)object;
                para = (List)itemMap.get("p");
                if ("showErrMsg".equalsIgnoreCase((String)itemMap.get("a"))) {
                    throw new RuntimeException(String.format("%s,%s", (String)((Map)para.get(0)).get("errorTitle"), (String)((Map)para.get(0)).get("errorInfo")));
                }
                if (!"ShowNotificationMsg".equalsIgnoreCase((String)itemMap.get("a")) || 0 == (Integer)((Map)para.get(0)).get("type")) continue;
                throw new RuntimeException(String.format("%s,%s", ((Map)para.get(0)).get("type"), (String)((Map)para.get(0)).get("content")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> testGetDynamicFormConfig(Map<String, Object> para) throws Exception {
        this.testResult.setFucSum(this.testResult.getFucSum() + 1);
        KDCaseMethodResult ret = new KDCaseMethodResult();
        ret.setHasassert(true);
        Map config = null;
        try {
            Object httpNameObj = para.get("httpName");
            if (httpNameObj != null) {
                ret.setName((String)httpNameObj);
            } else {
                ret.setName(ResManager.loadKDString((String)"\u83b7\u53d6\u52a8\u6001\u8868\u5355\u914d\u7f6e", (String)"TestCase_6", (String)"bos-unittest", (Object[])new Object[0]));
            }
            Object httpMethodNameObj = para.get("httpMethodName");
            if (httpMethodNameObj != null) {
                ret.setMethodName((String)httpMethodNameObj);
            } else {
                ret.setMethodName("testGetDynamicFormConfig");
            }
            ret.setStartTime(new Date());
            String retGetconfig = this.formService.getConfig(para);
            TestCase.assertInvokeAction(retGetconfig);
            config = (Map)SerializationUtils.fromJsonString((String)retGetconfig, Map.class);
            ret.setEndTime(new Date());
            if (config == null) {
                ret.setEndTime(new Date());
                this.testResult.setStatus(2);
                ret.setCompleted(false);
                ret.setMessage(ResManager.loadKDString((String)"\u8bfb\u53d6\u8868\u5355\u914d\u7f6e\u5143\u6570\u636e\u4e3a\u7a7a", (String)"TestCase_7", (String)"bos-unittest", (Object[])new Object[0]));
            } else {
                String formid = (String)config.get(FORM_ID);
                if ("error_403".equalsIgnoreCase(formid) || "error_404".equalsIgnoreCase(formid)) {
                    ErrorPageCode pageCode = "error_403".equalsIgnoreCase(formid) ? ErrorPageCode.ERROR_403 : ErrorPageCode.ERROR_404;
                    String msg = null;
                    Object cancelMsg = config.get("cancelMessage");
                    msg = cancelMsg != null ? String.format("code=%s, \u4e1a\u52a1\u63d2\u4ef6preOpenForm\u4e2d\u5df2\u53d6\u6d88\u5355\u6253\u5f00\uff0c cancelMessage=%s", pageCode.getCode(), (String)cancelMsg) : String.format("code=%s, msg=%s", pageCode.getCode(), pageCode.getName());
                    ret.setCompleted(false);
                    ret.setMessage(msg);
                    throw new RuntimeException(msg);
                }
                ret.setCompleted(true);
                ret.setMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)TEST_CASE_2, (String)"bos-unittest", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            ret.setEndTime(new Date());
            this.testResult.setStatus(2);
            ret.setCompleted(false);
            ret.setMessage(this.getErrorInfoFromException(e));
        }
        finally {
            this.testResult.addTestCaseResult(ret);
        }
        return config;
    }

    public void release(String pid) {
        this.formService.invokeAction(pid, "", "release", new Object[]{new HashMap()}, new ArrayList());
    }

    protected String getNodeInfo() {
        String info = " AppName: " + Instance.getAppName();
        info = info + " InstanceId: " + Instance.getInstanceId();
        info = info + " AppIds: " + Arrays.toString(Instance.getAppIds());
        info = info + " DeployedAppIds: " + Arrays.toString(Instance.getDeployedAppIds());
        return info;
    }
}

