/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.mservice.form.unittest.FormCoverCount;
import kd.bos.mservice.form.unittest.TestCaseByCaseId;
import kd.bos.mservice.unittest.UnitTestService;
import kd.bos.orm.ORM;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.unittest.UnitTestDao;

public class UnitTestServiceImpl
implements UnitTestService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String testByCaseId(String caseId, boolean oneUser, boolean ignoreSuccessDetail, Long methodTimeOut) {
        if (methodTimeOut != null && methodTimeOut != 0L) {
            System.setProperty("unit_test_case_method_timeOut", String.valueOf(methodTimeOut));
        }
        RequestContext ctx = RequestContext.get();
        ArrayList<String> lstResult = new ArrayList<String>();
        try {
            if (caseId != null) {
                String[] caseIds;
                for (String cid : caseIds = caseId.split(",")) {
                    TestCaseByCaseId testCase = new TestCaseByCaseId();
                    String result = null;
                    result = testCase.execute(cid, oneUser);
                    RequestContext.set((RequestContext)ctx);
                    if (result == null) continue;
                    Map mapResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                    UnitTestDao.saveTestCaseResult(mapResult);
                    if (ignoreSuccessDetail && testCase.tcase.testResult.getCompleted() && testCase.tcase.testResult.getStatus() == 0) {
                        testCase.tcase.testResult.getTestCaseResults().clear();
                        result = SerializationUtils.toJsonString((Object)testCase.tcase.testResult);
                    }
                    lstResult.add(result);
                }
            }
            String string = ((Object)lstResult).toString();
            return string;
        }
        finally {
            RequestContext.set((RequestContext)ctx);
        }
    }

    public String testByCaseId(String caseId, boolean oneUser) {
        return this.testByCaseId(caseId, oneUser, 180000L);
    }

    public String testByCaseId(String caseId, boolean oneUser, Long methodTimeOut) {
        boolean ignoreSuccessDetail = "true".equals(System.getProperty("ignoreSuccessDetail"));
        return this.testByCaseId(caseId, oneUser, ignoreSuccessDetail, methodTimeOut);
    }

    public String testByCaseIdWithIgnoreSuccessDetail(String caseId, boolean oneUser, boolean ignoreSuccessDetail, Long methodTimeOut) {
        return this.testByCaseId(caseId, oneUser, ignoreSuccessDetail, methodTimeOut);
    }

    public String testByCaseIdInner(String caseId, boolean oneUser) {
        return this.testByCaseId(caseId, oneUser, false, 180000L);
    }

    public String testByFormId(Map<String, Object> para) {
        return null;
    }

    public String checkInStatus(String formId) {
        HashMap<String, Object> mapRet = new HashMap<String, Object>();
        int code = 0;
        String msg = ResManager.loadKDString((String)"\u5141\u8bb8\u7b7e\u5165", (String)"UnitTestServiceImpl_0", (String)"bos-unittest", (Object[])new Object[0]);
        mapRet.put("code", code);
        mapRet.put("msg", msg);
        return SerializationUtils.toJsonString(mapRet);
    }

    public String getPublishedCasdIdByApp(String arg0) {
        if (arg0.isEmpty()) {
            List<Map<String, Object>> lstPublished = UnitTestDao.getPublishedUnitTestCase();
            return SerializationUtils.toJsonString(lstPublished);
        }
        List<Map<String, Object>> lstPublished = UnitTestDao.getPublishedUnitTestCaseWithApp(arg0);
        return SerializationUtils.toJsonString(lstPublished);
    }

    public String getPublishedCaseId() {
        List<Map<String, Object>> lstPublished = UnitTestDao.getPublishedUnitTestCase();
        return SerializationUtils.toJsonString(lstPublished);
    }

    public String getAppStaticsByResult(String ret, String apps) {
        RequestContext ctx = RequestContext.get();
        String res = null;
        try {
            List lstRet = null;
            lstRet = (List)SerializationUtils.fromJsonString((String)ret, List.class);
            RequestContext.set((RequestContext)ctx);
            res = FormCoverCount.getFormCoverCount(lstRet, apps);
        }
        catch (Exception e) {
            res = this.getTrace(e);
        }
        return res;
    }

    protected String getTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    public void releaseAppEnv(String appId) {
    }

    public static List<String> getUnCheckControlFormNumberList() {
        ArrayList<String> lstFormNumber = new ArrayList<String>();
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObject = orm.query("ut_report_form_white_list", null);
        for (DynamicObject dynamicObject2 : dynamicObject) {
            lstFormNumber.add((String)dynamicObject2.get("number.id"));
        }
        return lstFormNumber;
    }

    public String getAllCasdIdByApp(String arg0) {
        if (arg0.isEmpty()) {
            List<Map<String, Object>> lstPublished = UnitTestDao.getAllUnitTestCase();
            return SerializationUtils.toJsonString(lstPublished);
        }
        List<Map<String, Object>> lstPublished = UnitTestDao.getAllUnitTestCaseWithApp(arg0);
        return SerializationUtils.toJsonString(lstPublished);
    }

    public String getAllCaseId() {
        List<Map<String, Object>> lstPublished = UnitTestDao.getAllUnitTestCase();
        return SerializationUtils.toJsonString(lstPublished);
    }

    public String testTaskByCaseId(String numbers) {
        HashMap<String, Object> mapInfo = new HashMap<String, Object>(16);
        mapInfo.put("ids", numbers);
        mapInfo.put("tasktype", "number");
        return this.doJob("\u6839\u636e\u7528\u4f8bnumbers\u5e76\u53d1\u6267\u884c\u7528\u4f8b", "kd.bos.mservice.form.unittest.task.CaseRunnerTask", mapInfo);
    }

    public String testTaskByCaseId(String numbers, int threadNumbers, Long methodTimeOut) {
        HashMap<String, Object> mapInfo = new HashMap<String, Object>(16);
        mapInfo.put("ids", numbers);
        mapInfo.put("tasktype", "number");
        mapInfo.put("threadNumber", threadNumbers);
        System.setProperty("unit_test_case_method_timeOut", String.valueOf(methodTimeOut));
        return this.doJob("\u6839\u636e\u7528\u4f8bnumbers\u5e76\u53d1\u6267\u884c\u7528\u4f8b", "kd.bos.mservice.form.unittest.task.CaseRunnerTask", mapInfo);
    }

    private JobInfo createRuntimeJob(String taskName, String taskClassName, Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setName(taskName);
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setParams(params);
        jobInfo.setCanStop(Boolean.TRUE);
        return jobInfo;
    }

    private String doJob(String taskName, String taskClassName, Map<String, Object> params) {
        int i;
        JobInfo createJob = this.createRuntimeJob(taskName, taskClassName, params);
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)createJob);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        for (i = 0; !(taskInfo != null && taskInfo.isTaskEnd() || i >= 120); ++i) {
            try {
                Thread.sleep(60000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        }
        if (i >= 120) {
            ScheduleServiceHelper.stopTask((String)taskId);
        }
        return taskInfo == null ? "" : taskInfo.getData();
    }

    public String getTaskStatus(String taskids) {
        String[] ids = taskids.split(",");
        ArrayList<TaskInfo> lstRet = new ArrayList<TaskInfo>(ids.length);
        for (String id : ids) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)id);
            lstRet.add(taskInfo);
        }
        return SerializationUtils.toJsonString(lstRet);
    }
}

