/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest.concurrent;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.unittest.concurrent.IRunTask;
import kd.bos.mservice.form.unittest.task.AbstractCaseRunner;

public class RunAppCasesTask
implements IRunTask {
    private static final Log logger = LogFactory.getLog(RunAppCasesTask.class);
    private final List<Map<String, Object>> caseMaps;
    private List<Map<String, Object>> lstResult;

    public RunAppCasesTask(List<Map<String, Object>> caseMaps, List<Map<String, Object>> lstResult) {
        this.caseMaps = caseMaps;
        this.lstResult = lstResult;
    }

    @Override
    public void execute(AbstractCaseRunner runner) throws IOException {
        String threadinfo = Thread.currentThread().getName();
        int i = 0;
        for (Map<String, Object> caseMap : this.caseMaps) {
            ++i;
            String caseId = (String)caseMap.get("number");
            String caseName = (String)caseMap.get("name");
            Object appnumber = caseMap.get("appnumber");
            String appId = "bos";
            if (appnumber != null) {
                appId = (String)appnumber;
            }
            String msg = String.format("%s \u5f00\u59cb\u6267\u884c(%s/%s/%s):", threadinfo, appId, i, this.caseMaps.size());
            logger.info(msg + "\u542f\u52a8\u6267\u884c\u7528\u4f8b: " + caseId + "(" + caseName + ")");
            AbstractCaseRunner.doOneTestCaseByCaseInfo(caseMap, this.lstResult);
        }
    }
}

