/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest.concurrent;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.unittest.concurrent.IRunTask;
import kd.bos.mservice.form.unittest.task.AbstractCaseRunner;

public class RunOneCaseTask
implements IRunTask {
    private static final Log logger = LogFactory.getLog(RunOneCaseTask.class);
    private final Map<String, Object> caseMap;
    private final int currentNo;
    private final int caseSum;
    private List<Map<String, Object>> lstResult;

    public RunOneCaseTask(Map<String, Object> caseMap, int currentNo, int caseSum, List<Map<String, Object>> lstResult) {
        this.caseMap = caseMap;
        this.currentNo = currentNo;
        this.caseSum = caseSum;
        this.lstResult = lstResult;
    }

    @Override
    public void execute(AbstractCaseRunner runner) throws IOException {
        String caseId = (String)this.caseMap.get("number");
        String caseName = (String)this.caseMap.get("name");
        String threadinfo = Thread.currentThread().getName();
        String msg = String.format("%s (%s/%s): \u6267\u884c\u7528\u4f8b\uff0cnumber(%s),name(%s)", threadinfo, this.currentNo, this.caseSum, caseId, caseName);
        AbstractCaseRunner.doOneTestCaseByCaseInfo(this.caseMap, this.lstResult);
        int nFC = runner.getNumberOfFinishCase().incrementAndGet();
        int progress = 100 * nFC / this.caseSum;
        runner.getTask().feedbackTaskProgress(progress, msg, null);
    }
}

