/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.unittest.concurrent.IRunTask;
import kd.bos.mservice.form.unittest.task.AbstractCaseRunner;
import kd.bos.thread.ThreadLifeCycleManager;

public class RunTaskManager {
    private static final Log logger = LogFactory.getLog(RunTaskManager.class);

    private RunTaskManager() {
    }

    public static void execute(RequestContext rc, AbstractCaseRunner runner, IRunTask task) {
        ArrayList<IRunTask> lstTask = new ArrayList<IRunTask>();
        lstTask.add(task);
        RunTaskManager.execute(rc, runner, lstTask, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(RequestContext rc, AbstractCaseRunner runner, List<IRunTask> lstTask, int param) {
        ExecutorService executor = null;
        try {
            executor = Executors.newFixedThreadPool(param);
            for (IRunTask task : lstTask) {
                if (runner.getTask().isTaskStop()) {
                    runner.getTask().stop();
                    break;
                }
                executor.execute(ThreadLifeCycleManager.wrapRunnable((Runnable)new TaskThread(rc, task, runner, executor)));
            }
            executor.shutdown();
            if (!executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    private static class TaskThread
    extends Thread {
        private final IRunTask fTask;
        private final AbstractCaseRunner runner;
        private final RequestContext rc;
        private final ExecutorService executor;

        public TaskThread(RequestContext rc, IRunTask fTask, AbstractCaseRunner runner, ExecutorService executor) {
            this.fTask = fTask;
            this.runner = runner;
            this.rc = rc;
            this.executor = executor;
        }

        @Override
        public void run() {
            try {
                RequestContext.set((RequestContext)this.rc);
                if (this.runner.getTask().isTaskStop()) {
                    this.runner.getTask().stop();
                    this.executor.shutdownNow();
                    return;
                }
                this.fTask.execute(this.runner);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }
}

