/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.mservice.form.unittest.TestObjectResult;
import kd.bos.mservice.form.unittest.concurrent.ICaseTaskConcurrentRun;
import kd.bos.mservice.form.unittest.concurrent.IRunTask;
import kd.bos.mservice.form.unittest.concurrent.RunAppCasesTask;
import kd.bos.mservice.form.unittest.concurrent.RunOneCaseTask;
import kd.bos.mservice.form.unittest.concurrent.RunTaskManager;
import kd.bos.mservice.form.unittest.concurrent.RunUnitCasesTask;
import kd.bos.mservice.form.unittest.task.CaseRunnerTask;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.unittest.UnitTestDao;

public class AbstractCaseRunner
implements ICaseTaskConcurrentRun {
    public static final String APPID = "appid";
    public static final String LINE_SEPARATOR = "line.separator";
    private final AtomicInteger numberOfFinishCase;
    private CaseRunnerTask task;
    protected List<Map<String, Object>> cases;
    private final List<Map<String, Object>> lstResult = Collections.synchronizedList(new ArrayList());
    protected Integer threadNumbers;

    public AbstractCaseRunner() {
        this.numberOfFinishCase = new AtomicInteger(0);
    }

    public AbstractCaseRunner(Integer threadNumbers) {
        this();
        this.threadNumbers = threadNumbers;
    }

    public void initTask(CaseRunnerTask task) {
        this.task = task;
    }

    public CaseRunnerTask getTask() {
        return this.task;
    }

    public AtomicInteger getNumberOfFinishCase() {
        return this.numberOfFinishCase;
    }

    protected int getRunThreads() {
        if (this.threadNumbers != null) {
            return this.threadNumbers;
        }
        int runThreads = 5;
        ICaseTaskConcurrentRun.RUN_TYPE runType = this.getRunType();
        if (runType.equals((Object)ICaseTaskConcurrentRun.RUN_TYPE.MULTI_BY_APP)) {
            runThreads = 5;
        } else if (runType.equals((Object)ICaseTaskConcurrentRun.RUN_TYPE.MULTI)) {
            runThreads = 10;
        } else if (runType.equals((Object)ICaseTaskConcurrentRun.RUN_TYPE.MULTI_BY_UNIT)) {
            runThreads = 10;
        }
        return runThreads;
    }

    @Override
    public List<Map<String, Object>> buildCases(String ids) {
        this.cases = UnitTestDao.getAllTestCaseByNumbers(ids);
        return this.cases;
    }

    @Override
    public ICaseTaskConcurrentRun.RUN_TYPE getRunType() {
        return ICaseTaskConcurrentRun.RUN_TYPE.SINGLE;
    }

    @Override
    public String run(RequestContext rc) {
        int i = 0;
        ICaseTaskConcurrentRun.RUN_TYPE runCaseType = this.getRunType();
        if (runCaseType == null) {
            runCaseType = ICaseTaskConcurrentRun.RUN_TYPE.SINGLE;
        }
        if (runCaseType.equals((Object)ICaseTaskConcurrentRun.RUN_TYPE.SINGLE)) {
            for (Map<String, Object> caseMap : this.cases) {
                String caseId = (String)caseMap.get("number");
                String caseName = (String)caseMap.get("name");
                String string = Thread.currentThread().getName();
                int progress = 100 * (++i - 1) / this.cases.size();
                String msg = String.format("%s (%s/%s): \u5f00\u59cb\u6267\u884c\u7528\u4f8b\uff0cnumber(%s),name(%s)", string, i, this.cases.size(), caseId, caseName);
                this.task.feedbackTaskProgress(progress, msg, null);
                AbstractCaseRunner.doOneTestCaseByCaseInfo(caseMap, this.lstResult);
                progress = 100 * i / this.cases.size();
                msg = String.format("%s (%s/%s): \u6267\u884c\u7528\u4f8b\u7ed3\u675f\uff0cnumber(%s),name(%s)", string, i, this.cases.size(), caseId, caseName);
                this.task.feedbackTaskProgress(progress, msg, null);
            }
        } else if (runCaseType.equals((Object)ICaseTaskConcurrentRun.RUN_TYPE.MULTI_BY_APP)) {
            HashMap<String, List> mapAppCases = new HashMap<String, List>(16);
            for (Map<String, Object> caseMap : this.cases) {
                ++i;
                String appNumber = (String)caseMap.get("appnumber");
                List list = mapAppCases.computeIfAbsent(appNumber, k -> new ArrayList(10));
                list.add(caseMap);
            }
            ArrayList<IRunTask> lstTask = new ArrayList<IRunTask>(10);
            int runThreads = this.getRunThreads();
            for (Map.Entry entry : mapAppCases.entrySet()) {
                if (entry.getKey() == null) continue;
                RunAppCasesTask caseTask = new RunAppCasesTask((List)entry.getValue(), this.lstResult);
                lstTask.add(caseTask);
            }
            if (!lstTask.isEmpty()) {
                RunTaskManager.execute(rc, this, lstTask, Math.min(lstTask.size(), runThreads));
            }
        } else if (runCaseType.equals((Object)ICaseTaskConcurrentRun.RUN_TYPE.MULTI)) {
            int runThreads = this.getRunThreads();
            ArrayList<IRunTask> lstTask = new ArrayList<IRunTask>(10);
            for (Map<String, Object> caseMap : this.cases) {
                RunOneCaseTask runOneCaseTask = new RunOneCaseTask(caseMap, ++i, this.cases.size(), this.lstResult);
                lstTask.add(runOneCaseTask);
            }
            if (!lstTask.isEmpty()) {
                RunTaskManager.execute(rc, this, lstTask, Math.min(lstTask.size(), runThreads));
            }
        } else if (runCaseType.equals((Object)ICaseTaskConcurrentRun.RUN_TYPE.MULTI_BY_UNIT)) {
            HashMap<String, List> mapUnitCases = new HashMap<String, List>();
            for (Map<String, Object> caseMap : this.cases) {
                ++i;
                String unitid = (String)caseMap.get("unitid");
                List list = mapUnitCases.computeIfAbsent(unitid, k -> new ArrayList(10));
                list.add(caseMap);
            }
            ArrayList lstTask = new ArrayList(10);
            int runThreads = this.getRunThreads();
            for (Map.Entry entry : mapUnitCases.entrySet()) {
                if (entry.getKey() == null) continue;
                RunUnitCasesTask caseTask = new RunUnitCasesTask((List)entry.getValue(), this.lstResult);
                lstTask.add(caseTask);
            }
            if (!lstTask.isEmpty()) {
                RunTaskManager.execute(rc, this, lstTask, Math.min(lstTask.size(), runThreads));
            }
        }
        return SerializationUtils.toJsonString(this.lstResult);
    }

    public static void doOneTestCaseByCaseInfo(Map<String, Object> caseMap, List<Map<String, Object>> lstResult) {
        Date startTime = new Date();
        String caseId = (String)caseMap.get("number");
        String caseName = (String)caseMap.get("name");
        String appnumber = (String)caseMap.get("appnumber");
        String appId = "bos";
        if (appnumber != null) {
            appId = appnumber;
        }
        long methodTimeOut = 180000L;
        String methodTimeOutStr = System.getProperty("unit_test_case_method_timeOut");
        if (methodTimeOutStr != null) {
            methodTimeOut = Long.parseLong(methodTimeOutStr);
        }
        String errorMsg = "";
        try {
            String caseRet = (String)DispatchServiceHelper.invokeBOSService((String)appId, (String)"UnitTestService", (String)"testByCaseIdWithIgnoreSuccessDetail", (Object[])new Object[]{caseId, Boolean.FALSE, Boolean.FALSE, methodTimeOut});
            try {
                List lstRet = (List)SerializationUtils.fromJsonString((String)caseRet, List.class);
                List lstRetTemp = new ArrayList();
                if (((Map)lstRet.get(0)).get("p") == null) {
                    lstRetTemp = lstRet;
                }
                lstResult.addAll(lstRetTemp);
            }
            catch (Exception e) {
                errorMsg = String.format("\u8fdc\u7a0b\u8c03\u7528\u6267\u884c\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b(%s)\u5931\u8d25, RPC\u6b63\u5e38\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f(%s)," + System.getProperty(LINE_SEPARATOR) + "%s" + System.getProperty(LINE_SEPARATOR) + ", RPC\u8fd4\u56de\u7ed3\u679c\uff1a%s", caseId, e.getMessage(), AbstractCaseRunner.getTrace(e), caseRet);
                TestObjectResult testResult = new TestObjectResult();
                testResult.setStartTime(startTime);
                testResult.setCompleted(false);
                testResult.setStatus(1);
                testResult.setEndTime(new Date());
                testResult.setName(caseName);
                testResult.setAppname((String)caseMap.get("subsysname"));
                testResult.setAppid((String)caseMap.get(APPID));
                testResult.setSubSystemId(caseMap.get(APPID));
                testResult.setMessage(errorMsg);
                String ret = SerializationUtils.toJsonString((Object)testResult);
                Map retMap = (Map)SerializationUtils.fromJsonString((String)ret, Map.class);
                lstResult.add(retMap);
            }
        }
        catch (Exception e) {
            errorMsg = String.format("\u8fdc\u7a0b\u8c03\u7528\u6267\u884c\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b(%s)\u5931\u8d25, RPC\u5f02\u5e38\uff0c\u9519\u8bef\u5185\u5bb9\uff1a%s" + System.getProperty(LINE_SEPARATOR) + "%s", caseId, e.getMessage(), AbstractCaseRunner.getTrace(e));
            TestObjectResult testResult = new TestObjectResult();
            testResult.setStartTime(startTime);
            testResult.setCompleted(false);
            testResult.setStatus(1);
            testResult.setEndTime(new Date());
            testResult.setName(caseName);
            testResult.setAppname((String)caseMap.get("subsysname"));
            testResult.setAppid((String)caseMap.get(APPID));
            testResult.setSubSystemId(caseMap.get(APPID));
            testResult.setMessage(errorMsg);
            String ret = SerializationUtils.toJsonString((Object)testResult);
            Map retMap = (Map)SerializationUtils.fromJsonString((String)ret, Map.class);
            lstResult.add(retMap);
        }
    }

    public static String getTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }
}

