/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.unittest.concurrent.ICaseTaskConcurrentRun;
import kd.bos.mservice.form.unittest.task.AbstractCaseRunner;
import kd.bos.mservice.form.unittest.task.GroupCaseRunner;
import kd.bos.mservice.form.unittest.task.NumberCaseRunner;
import kd.bos.mservice.form.unittest.task.StrategyCaseRunner;
import kd.bos.schedule.executor.AbstractTask;

public class CaseRunnerTask
extends AbstractTask {
    public static final String IDS_NAME = "ids";
    public static final String RESULT = "result";
    public static final String ERROR = "error";
    public static final String SUCCESS = "success";
    public static final String TASK_TYPE_NAME = "tasktype";
    public static final String THREAD_NUMBER = "threadNumber";
    private static final Log log = LogFactory.getLog(CaseRunnerTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String runRet = null;
        try {
            this.feedbackProgress(0, "\u5df2\u5f00\u542f\u5e76\u53d1\u6267\u884c\u7528\u4f8b\u4efb\u52a1", null);
            String type = (String)params.get(TASK_TYPE_NAME);
            Integer threadNumbers = (Integer)params.get(THREAD_NUMBER);
            ICaseTaskConcurrentRun runner = this.getRunner(type, threadNumbers);
            ((AbstractCaseRunner)runner).initTask(this);
            String ids = (String)params.get(IDS_NAME);
            List<Map<String, Object>> cases = runner.buildCases(ids);
            if (cases.isEmpty()) {
                String msg = String.format("\u83b7\u53d6\u7528\u4f8b\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u7ed9\u5b9a\u5408\u6cd5\u53c2\u6570\uff0cids=%s", ids);
                log.warn(msg);
                result.put(SUCCESS, Boolean.FALSE);
                result.put(ERROR, msg);
            } else {
                runRet = runner.run(rc);
                result.put(SUCCESS, Boolean.TRUE);
                result.put(RESULT, runRet);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            result.put(SUCCESS, Boolean.FALSE);
            result.put(ERROR, CaseRunnerTask.getTrace(e));
        }
        finally {
            this.feedbackCustomdata(result);
        }
    }

    private ICaseTaskConcurrentRun getRunner(String type, Integer threadNumbers) {
        AbstractCaseRunner runner = StringUtils.isNotBlank((CharSequence)type) && type.equals("number") ? new NumberCaseRunner(threadNumbers) : (StringUtils.isNotBlank((CharSequence)type) && type.equals("group") ? new GroupCaseRunner(threadNumbers) : (StringUtils.isNotBlank((CharSequence)type) && type.equals("strategy") ? new StrategyCaseRunner(threadNumbers) : new AbstractCaseRunner(threadNumbers)));
        return runner;
    }

    public boolean isTaskStop() {
        return this.isStop();
    }

    public void feedbackTaskProgress(int progress, String desc, Map<String, Object> customData) {
        this.feedbackProgress(progress, desc, customData);
    }

    public static String getTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }
}

