/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.unittest.webapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class UnitTestGroupApiPlugin
implements IBillWebApiPlugin {
    public static final String GROUP_ID = "groupId";
    public static final String APPID = "appid";
    public static final String BOS_UNITEST_GET_META_APP_INFO = "bos.unitest.getMetaAppInfo";

    public ApiResult doCustomService(WebApiContext ctx) {
        return null;
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        Object method = params.get("method");
        if (Objects.equals("getAllGroup", method)) {
            return ApiResult.success(this.getAllGroup());
        }
        if (Objects.equals("getCasesByGroupId", method)) {
            Object groupId = params.get(GROUP_ID);
            if (groupId == null) {
                ApiResult.fail((String)"groupId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return ApiResult.success(this.getCasesByGroupId(String.valueOf(groupId)));
        }
        if (Objects.equals("getAllCasesWithGroup", method)) {
            return ApiResult.success(this.getAllCasesWithGroup());
        }
        return ApiResult.fail((String)"\u8c03\u7528\u7684method\u4e0d\u5b58\u5728");
    }

    private List<Map<String, Object>> getAllGroup() {
        String sql = "select b.FID, a.FNAME from t_ut_group_type_l a inner join t_ut_group_type b on a.FID = b.FID where a.FLOCALEID = 'zh_CN'";
        DataSet ds = DB.queryDataSet((String)"bos.unitest.getCaseGroup", (DBRoute)DBRoute.basedata, (String)sql);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        while (ds.hasNext()) {
            Row row = ds.next();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(GROUP_ID, row.getString(0));
            map.put("groupName", row.getString(1));
            list.add(map);
        }
        return list;
    }

    private List<Map<String, Object>> getCasesByGroupId(String groupId) {
        Map<String, List<Map<String, Object>>> tagMap = this.getTags();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (DataSet cases = this.findCasesByGroupId(groupId);
             DataSet appInfo = this.getMetaAppInfo();){
            JoinDataSet jds = cases.leftJoin(appInfo);
            DataSet rs = jds.on("fbizappid", APPID).select(new String[]{"fid", "fnumber", "fname", "fresponsers", "freleasetype", "flevel", "fsort"}, new String[]{APPID, "appname"}).finish();
            while (rs.hasNext()) {
                Row row = rs.next();
                HashMap<String, Object> map = new HashMap<String, Object>();
                String caseId = row.getString(0);
                map.put("caseId", caseId);
                map.put("caseNumber", row.getString(1));
                map.put("caseName", row.getString(2));
                map.put("caseAuthor", row.getString(3));
                map.put("isPublished", row.getString(4));
                map.put("caseLevel", row.getString(5));
                map.put("groupSort", this.handleEmptyValue(row.getString(6)));
                map.put("appId", row.getString(7));
                map.put("appName", row.getString(8));
                map.put("caseTags", tagMap.get(caseId) == null ? Collections.emptyList() : tagMap.get(caseId));
                list.add(map);
            }
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:getCasesByGroupId(groupId).leftJoin(appInfo)", e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return list;
    }

    private List<Map<String, Object>> getAllCasesWithGroup() {
        Map<String, List<Map<String, Object>>> tagMap = this.getTags();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (DataSet cases = this.getCasesWithGroup();
             DataSet appInfo = this.getMetaAppInfo();){
            JoinDataSet jds = cases.leftJoin(appInfo);
            DataSet rs = jds.on("fbizappid", APPID).select(new String[]{"fid", "fnumber", "fname", "fresponsers", "freleasetype", "flevel", "fsort", "gId", "gname"}, new String[]{APPID, "appname"}).finish();
            while (rs.hasNext()) {
                Row row = rs.next();
                HashMap<String, Object> map = new HashMap<String, Object>();
                String caseId = row.getString(0);
                map.put("caseId", caseId);
                map.put("caseNumber", row.getString(1));
                map.put("caseName", row.getString(2));
                map.put("caseAuthor", row.getString(3));
                map.put("isPublished", row.getString(4));
                map.put("caseLevel", row.getString(5));
                map.put("groupSort", this.handleEmptyValue(row.getString(6)));
                map.put(GROUP_ID, this.handleEmptyValue(row.getString(7)));
                map.put("groupName", this.handleEmptyValue(row.getString(8)));
                map.put("appId", row.getString(9));
                map.put("appName", row.getString(10));
                map.put("caseTags", tagMap.get(caseId) == null ? Collections.emptyList() : tagMap.get(caseId));
                list.add(map);
            }
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:getCasesWithGroup().leftJoin(appInfo)", e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return list;
    }

    private Map<String, List<Map<String, Object>>> getTags() {
        HashMap<String, List<Map<String, Object>>> tags = new HashMap<String, List<Map<String, Object>>>();
        try (DataSet rs = this.getAllTags();){
            while (rs.hasNext()) {
                Row row = rs.next();
                String caseId = row.getString(0);
                ArrayList mapList = (ArrayList)tags.get(caseId);
                ArrayList list = mapList != null ? mapList : new ArrayList();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tagId", row.getString(1));
                map.put("tagName", row.getString(2));
                list.add(map);
                tags.put(caseId, list);
            }
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:getAllTags", e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return tags;
    }

    private DataSet getMetaAppInfo() {
        String sql = "select app.FID appid, app_l.fname appname from t_meta_bizapp app inner join t_meta_bizapp_l app_l on app.FID = app_l.FID where app_l.FLOCALEID = 'zh_CN'";
        return DB.queryDataSet((String)BOS_UNITEST_GET_META_APP_INFO, (DBRoute)DBRoute.meta, (String)sql);
    }

    private DataSet findCasesByGroupId(String groupId) {
        String sql = "select ut.FBIZAPPID, UT.FID, ut.FNUMBER, utl.FNAME, ut.FRESPONSERS, ut.FRELEASETYPE, GC.FSORT, ut.FLEVEL\nfrom T_BAS_UNITTESTDETAIL ut\nLEFT JOIN T_BAS_UNITTESTDETAIL_L utl on ut.FID = utl.FID and utl.FLOCALEID = 'zh_CN'\nLEFT JOIN T_UT_GROUP_TYPE_CASE gc on gc.FKCASEID=ut.FID \nLEFT JOIN T_UT_GROUP_TYPE_L g_l on g_l.FID=gc.FID and g_l.FLOCALEID = 'zh_CN'\nWHERE gc.FID='" + groupId + "'";
        return DB.queryDataSet((String)BOS_UNITEST_GET_META_APP_INFO, (DBRoute)DBRoute.basedata, (String)sql);
    }

    private DataSet getCasesWithGroup() {
        String sql = "select g_l.FID gId, g_l.FNAME gname, ut.FBIZAPPID, UT.FID, ut.FNUMBER, utl.FNAME, ut.FRESPONSERS, ut.FRELEASETYPE, GC.FSORT, ut.FLEVEL\nfrom T_BAS_UNITTESTDETAIL ut\nLEFT JOIN T_BAS_UNITTESTDETAIL_L utl on ut.FID = utl.FID and utl.FLOCALEID = 'zh_CN'\nLEFT JOIN T_UT_GROUP_TYPE_CASE gc on gc.FKCASEID=ut.FID \nLEFT JOIN T_UT_GROUP_TYPE_L g_l on g_l.FID=gc.FID and g_l.FLOCALEID = 'zh_CN'";
        return DB.queryDataSet((String)BOS_UNITEST_GET_META_APP_INFO, (DBRoute)DBRoute.basedata, (String)sql);
    }

    private String handleEmptyValue(String value) {
        if (null == value || Objects.equals("0", value)) {
            return "";
        }
        return value;
    }

    private DataSet getAllTags() {
        String sql = "select u_tag.FID caseId, tag_l.FID tagId, tag_l.FNAME tagName\nFROM t_bas_unittestdetail_tag u_tag \nINNER JOIN t_ut_app_tag_l tag_l ON u_tag.FBASEDATAID=tag_l.FID AND tag_l.FLOCALEID='zh_CN'";
        return DB.queryDataSet((String)BOS_UNITEST_GET_META_APP_INFO, (DBRoute)DBRoute.basedata, (String)sql);
    }
}

