/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

class UnitTestReader {
    private static Log log = LogFactory.getLog(UnitTestReader.class);
    private static final String FORM_UNITTEST_TABLE = "T_BAS_UNITTESTDETAIL";
    private static final String JS_PLUGIN_TABLE = "T_META_PLUGINSCRIPT";
    private static final String FBIZUNITID = "fbizunitid";
    private static final String APPNUMBER = "appnumber";
    private static final String FNUMBER = "fnumber";
    private static final String FBIZAPPID = "fbizappid";
    private static final String SUBSYSTEMNAME = "subsystemname";
    private static final String NUMBER = "number";
    private static final String APPID = "appid";
    private static final String CASEID = "caseId";
    private static final String CASENUMBER = "casenumber";
    private static final String SUBSYSID = "subsysid";
    private static final String PARAM = "param";
    private static final String PLUGIN = "plugin";
    private static final String FORMID = "formId";
    private static final String CASENAME = "casename";
    private static final String TXT_NUMBER = "txt_number";
    private static final String FORMNUMBER = "ide_unit_test_detail";
    private static final String BIZAPPID = "bizappid.id";
    private static final String BIZAPPNAME = "bizappid.name";
    private static final String TXT_PARAM = "txt_param";
    private static final String TXT_TEST_PLUGIN = "txt_test_plugin";
    private static final String TXT_OBJECT = "txt_object";
    private static final String APPNAME = "appname";
    private static final String MULTI_TXT_NAME = "multi_txt_name";
    private static final String CBOX_TYPE = "cbox_type";
    private static final String LISTFORM = "listform";
    private static final String TXT_FORM_LIST = "txt_form_list";
    private static final String RESPONSERS = "responsers";
    private static final String JMXLOACTION = "jmxloaction";
    private static final String FRAMECHOSE = "framechose";
    private static final String PREPAREINDEX = "prepareindex";
    private static final String CHECKRELEASETYPE = "checkreleasetype";
    private static final String FCASENUMBER = "fcasenumber";
    private static final String FGROUPCASENAME = "fgroupcasename";
    private static final String FLEVEL = "flevel";
    private static final String FDEVICETYPE = "fdevicetype";
    private static final String FNAME = "fname";
    private static final String UNITID = "unitid";
    private static final String SUBSYSNAME = "subsysname";
    private static final String RESPONSER_NAME = "responser.name";
    private String errorMsg = "error:%s;  sql:%s";

    public UnitTestReader() {
        this(false);
    }

    public UnitTestReader(boolean isExtend) {
    }

    public String getJsPluginContext(Object fid) {
        String sql = this.getReadJsPluginContextSql();
        Object[] params = new SqlParameter[1];
        if (fid instanceof Integer) {
            params[0] = new SqlParameter(":FID", 4, fid);
        } else if (fid instanceof String) {
            params[0] = new SqlParameter(":FID", 12, fid);
        }
        try {
            String sRet = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws KDException {
                    String sContext = null;
                    try {
                        if (rs.next()) {
                            sContext = rs.getString(1);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return sContext;
                }
            });
            return sRet;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{e});
        }
    }

    private DataSet getMetaAppInfoWithApps(String[] apps, String sqlApps) {
        String sql = "select c.FID,d.fname subsystemname,c.fnumber appnumber from t_meta_bizapp c inner join t_meta_bizapp_l d on c.FID = d.FID where FLOCALEID = 'zh_CN' and c.FNUMBER in (" + sqlApps + ")";
        DataSet ds = DB.queryDataSet((String)"bos.unitest.getMetaAppInfoWithApps", (DBRoute)DBRoute.meta, (String)sql, (Object[])apps);
        return ds;
    }

    private DataSet getMetaAppInfo() {
        String sql = "select c.FID,d.fname subsystemname,c.fnumber appnumber from t_meta_bizapp c inner join t_meta_bizapp_l d on c.FID = d.FID where FLOCALEID = 'zh_CN'";
        DataSet ds = DB.queryDataSet((String)"bos.unitest.getMetaAppInfo", (DBRoute)DBRoute.meta, (String)sql);
        return ds;
    }

    private DataSet getPublishedCase() {
        String sql = "select b.FBIZUNITID,b.FBIZAPPID,b.FNUMBER,a.FNAME,b.FLEVEL,b.FDEVICETYPE from T_BAS_UNITTESTDETAIL_L a inner join T_BAS_UNITTESTDETAIL b on a.FID = b.FID where FLOCALEID = 'zh_CN' and b.freleasetype = '1'";
        return DB.queryDataSet((String)"bos.unitest.getPublishedCase", (DBRoute)DBRoute.basedata, (String)sql);
    }

    private DataSet getAllCase() {
        String sql = "select b.FBIZUNITID,b.FBIZAPPID,b.FNUMBER,a.FNAME,b.FLEVEL,b.FDEVICETYPE from T_BAS_UNITTESTDETAIL_L a inner join T_BAS_UNITTESTDETAIL b on a.FID = b.FID where FLOCALEID = 'zh_CN'";
        return DB.queryDataSet((String)"bos.unitest.getAllCase", (DBRoute)DBRoute.basedata, (String)sql);
    }

    public List<Map<String, Object>> getPublishedUnitTestCase() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (DataSet publishedCases = this.getPublishedCase();
             DataSet appInfo = this.getMetaAppInfo();){
            JoinDataSet jds = publishedCases.leftJoin(appInfo);
            DataSet rs = jds.on(FBIZAPPID, "fid").select(new String[]{FNUMBER, FNAME, FBIZAPPID, FBIZUNITID, FLEVEL, FDEVICETYPE}, new String[]{SUBSYSTEMNAME, APPNUMBER}).finish();
            while (rs.hasNext()) {
                Row row = rs.next();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(NUMBER, row.getString(0));
                map.put("name", row.getString(1));
                map.put(APPID, row.getString(2));
                map.put(UNITID, row.getString(3));
                map.put("level", row.getString(4));
                map.put("devicetype", row.getString(5));
                map.put(SUBSYSNAME, row.getString(6));
                map.put(APPNUMBER, row.getString(7));
                list.add(map);
            }
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:publishedCases.leftJoin(appInfo)", e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return list;
    }

    public List<Map<String, Object>> getAllUnitTestCase() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (DataSet allCases = this.getAllCase();
             DataSet appInfo = this.getMetaAppInfo();){
            JoinDataSet jds = allCases.leftJoin(appInfo);
            DataSet rs = jds.on(FBIZAPPID, "fid").select(new String[]{FNUMBER, FNAME, FBIZAPPID, FBIZUNITID, FLEVEL, FDEVICETYPE}, new String[]{SUBSYSTEMNAME, APPNUMBER}).finish();
            while (rs.hasNext()) {
                Row row = rs.next();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(NUMBER, row.getString(0));
                map.put("name", row.getString(1));
                map.put(APPID, row.getString(2));
                map.put(UNITID, row.getString(3));
                map.put("level", row.getString(4));
                map.put("devicetype", row.getString(5));
                map.put(SUBSYSNAME, row.getString(6));
                map.put(APPNUMBER, row.getString(7));
                list.add(map);
            }
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:allCases.leftJoin(appInfo)", e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return list;
    }

    public Map<String, Object> getTestCase(String caseId) {
        Map mapCaseInfo = null;
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)caseId)};
        String sql = "select b.fid,b.fnumber,b.fbizappid,b.fparam,b.ftestplugin,b.fobject,a.fname from T_BAS_UNITTESTDETAIL_L a inner join T_BAS_UNITTESTDETAIL b on a.FID = b.FID and b.FNUMBER = ? where FLOCALEID = 'zh_CN'";
        try {
            mapCaseInfo = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

                public Map<String, Object> handle(ResultSet rs) throws SQLException {
                    HashMap<String, Object> map = null;
                    if (rs.next()) {
                        map = new HashMap<String, Object>();
                        map.put(UnitTestReader.CASEID, rs.getString(1));
                        map.put(UnitTestReader.CASENUMBER, rs.getString(2));
                        map.put(UnitTestReader.SUBSYSID, rs.getObject(3));
                        map.put(UnitTestReader.PARAM, rs.getString(4));
                        map.put(UnitTestReader.PLUGIN, rs.getString(5));
                        map.put(UnitTestReader.FORMID, rs.getString(6));
                        map.put(UnitTestReader.CASENAME, rs.getString(7));
                    }
                    return map;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(this.errorMsg, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return mapCaseInfo;
    }

    public Map<String, Object> getTestCaseByOrm(String caseId) {
        HashMap<String, Object> mapCaseInfo = new HashMap<String, Object>(16);
        ORM orm = ORM.create();
        QFilter q = new QFilter(TXT_NUMBER, "=", (Object)caseId);
        String selectFields = "id,txt_number,multi_txt_name,txt_object,bizappid,bizappid.name,txt_test_plugin,txt_param,cbox_type,txt_form_list,responser,responser.name,responsers,jmxcontext,jmxloaction,framechose,prepareindex,datasourcecontent,level,device_type,query_list_number";
        QFilter[] filters = new QFilter[]{q};
        DynamicObject ds = orm.queryOne(FORMNUMBER, selectFields, filters);
        if (ds != null) {
            mapCaseInfo.put(CASEID, ds.getString("id"));
            mapCaseInfo.put(CASENUMBER, ds.getString(TXT_NUMBER));
            mapCaseInfo.put(SUBSYSID, ds.getString(BIZAPPID));
            mapCaseInfo.put(APPID, ds.getString(BIZAPPID));
            mapCaseInfo.put(APPNAME, ds.getString(BIZAPPNAME));
            mapCaseInfo.put(PARAM, ds.getString(TXT_PARAM));
            mapCaseInfo.put(PLUGIN, ds.getString(TXT_TEST_PLUGIN));
            mapCaseInfo.put(FORMID, ds.getString(TXT_OBJECT));
            mapCaseInfo.put(CASENAME, ds.getString(MULTI_TXT_NAME));
            mapCaseInfo.put("type", ds.getString(CBOX_TYPE));
            mapCaseInfo.put(LISTFORM, ds.getString(TXT_FORM_LIST));
            String responsers = ds.getString(RESPONSERS);
            if (StringUtils.isBlank((CharSequence)responsers)) {
                mapCaseInfo.put("responser", ds.getString(RESPONSER_NAME));
            } else {
                mapCaseInfo.put("responser", responsers);
            }
            String context = "";
            try {
                context = URLDecoder.decode(ds.getString("jmxcontext"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Throwable)e);
            }
            mapCaseInfo.put("context", context);
            mapCaseInfo.put(JMXLOACTION, ds.getString(JMXLOACTION));
            mapCaseInfo.put(FRAMECHOSE, ds.getString(FRAMECHOSE));
            mapCaseInfo.put(PREPAREINDEX, ds.getString(PREPAREINDEX));
            mapCaseInfo.put("datasourcecontent", ds.getString("datasourcecontent"));
            mapCaseInfo.put("level", ds.getString("level"));
            mapCaseInfo.put("devicetype", ds.getString("device_type"));
            mapCaseInfo.put("querylistnumber", ds.getString("query_list_number"));
            return mapCaseInfo;
        }
        log.error(String.format("caseId=%s,selectFields=%s,filter=%s,RequestContext.tenantid=%s,RequestContext.sandboxId=%s", caseId, selectFields, q.toString(), RequestContext.get().getTenantId(), RequestContext.get().getAccountId()));
        return null;
    }

    public List<Map<String, Object>> getAllTestCaseByOrm() {
        ArrayList<Map<String, Object>> listCaseInfo = new ArrayList<Map<String, Object>>();
        ORM orm = ORM.create();
        String selectFields = "id,txt_number,multi_txt_name,bizappid.name,bizappid.id,txt_object.number,framechose";
        DynamicObjectCollection ds = orm.query(FORMNUMBER, selectFields, null);
        for (DynamicObject d : ds) {
            HashMap<String, String> mapCaseInfo = new HashMap<String, String>();
            mapCaseInfo.put(NUMBER, d.getString(TXT_NUMBER));
            mapCaseInfo.put(FNAME, d.getString(MULTI_TXT_NAME));
            mapCaseInfo.put(SUBSYSTEMNAME, d.getString(BIZAPPNAME));
            mapCaseInfo.put("ObjectNumber", d.getString("txt_object.number"));
            mapCaseInfo.put(FRAMECHOSE, d.getString(FRAMECHOSE));
            listCaseInfo.add(mapCaseInfo);
        }
        return listCaseInfo;
    }

    public List<Map<String, Object>> getTestCasesByFormId(String formId) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        ORM orm = ORM.create();
        QFilter q = new QFilter(TXT_OBJECT, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,txt_number,multi_txt_name,txt_object,bizappid,bizappid.name,txt_test_plugin,txt_param,cbox_type,txt_form_list,responser,responser.name,responsers";
        DynamicObjectCollection collection = orm.query(FORMNUMBER, selectFields, filters);
        for (DynamicObject ds : collection) {
            HashMap<String, String> mapCaseInfo = new HashMap<String, String>();
            mapCaseInfo.put(CASEID, ds.getString("id"));
            mapCaseInfo.put(CASENUMBER, ds.getString(TXT_NUMBER));
            mapCaseInfo.put(SUBSYSID, ds.getString(BIZAPPID));
            mapCaseInfo.put(APPID, ds.getString(BIZAPPID));
            mapCaseInfo.put(APPNAME, ds.getString(BIZAPPNAME));
            mapCaseInfo.put(PARAM, ds.getString(TXT_PARAM));
            mapCaseInfo.put(PLUGIN, ds.getString(TXT_TEST_PLUGIN));
            mapCaseInfo.put(FORMID, ds.getString(TXT_OBJECT));
            mapCaseInfo.put(CASENAME, ds.getString(MULTI_TXT_NAME));
            mapCaseInfo.put("type", ds.getString(CBOX_TYPE));
            mapCaseInfo.put(LISTFORM, ds.getString(TXT_FORM_LIST));
            String responsers = ds.getString(RESPONSERS);
            if (StringUtils.isBlank((CharSequence)responsers)) {
                mapCaseInfo.put("responser", ds.getString(RESPONSER_NAME));
            } else {
                mapCaseInfo.put("responser", responsers);
            }
            ret.add(mapCaseInfo);
        }
        return ret;
    }

    public List<Object> getFormUnitTestPlugins(String objectId) {
        String table = FORM_UNITTEST_TABLE;
        String sql = this.getReadFormUnitTestPluginsSql(table);
        Object[] params = new SqlParameter[]{new SqlParameter(":FOBJECTID", 12, (Object)objectId)};
        try {
            List list = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

                public List<Object> handle(ResultSet rs) throws KDException {
                    ArrayList<Object> list = new ArrayList<Object>();
                    try {
                        while (rs.next()) {
                            ArrayList<String> listItem = new ArrayList<String>();
                            String id = rs.getString("FDETAILFUNCID");
                            String number = rs.getString(UnitTestReader.FNUMBER);
                            String objectId = rs.getString("FOBJECTID");
                            String subSysId = rs.getString("FSUBSYSTEMID");
                            String type = rs.getString("FTYPE");
                            String param = rs.getString("FPARAM");
                            String testPlugin = rs.getString("FTESTPLUGIN");
                            String pluginType = rs.getString("FPLUGINTYPE");
                            listItem.add(id);
                            listItem.add(number);
                            listItem.add(objectId);
                            listItem.add(subSysId);
                            listItem.add(type);
                            listItem.add(param);
                            listItem.add(testPlugin);
                            listItem.add(pluginType);
                            list.add(listItem);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return list;
                }
            });
            return list;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{e});
        }
    }

    private String getReadFormUnitTestPluginsSql(String tableName) {
        String sql = String.format("select FDETAILFUNCID, FNUMBER, FOBJECTID, FSUBSYSTEMID, FTYPE, FPARAM, FTESTPLUGIN,FPLUGINTYPE from %s where FOBJECTID = ? ", tableName);
        return sql;
    }

    private String getReadJsPluginContextSql() {
        String sql = String.format("select FSCRIPTCONTEXT_TAG from %s where FID = ? ", JS_PLUGIN_TABLE);
        return sql;
    }

    public Object getSubSysId(String number) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number)};
        String sql = "select FSUBSYSID from T_META_ENTITYDESIGN where FNUMBER = ?";
        try {
            Object ObRet = DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws SQLException {
                    Object ob = null;
                    if (rs.next()) {
                        ob = rs.getObject(1);
                    }
                    return ob;
                }
            });
            return ObRet;
        }
        catch (Exception e) {
            String msg = String.format(this.errorMsg, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public List<Map<String, Object>> getPublishedUnitTestCaseWithApp(String app) {
        String[] apps = app.split(",");
        StringBuilder curApps = new StringBuilder();
        for (int i = 0; i < apps.length; ++i) {
            curApps.append("?,");
        }
        curApps = new StringBuilder(curApps.substring(0, curApps.length() - 1));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (DataSet publishedCases = this.getPublishedCase();
             DataSet appInfo = this.getMetaAppInfoWithApps(apps, curApps.toString());){
            JoinDataSet jds = publishedCases.join(appInfo, JoinType.INNER);
            DataSet rs = jds.on(FBIZAPPID, "fid").select(new String[]{FNUMBER, FNAME, FBIZAPPID, FBIZUNITID, FLEVEL, FDEVICETYPE}, new String[]{SUBSYSTEMNAME, APPNUMBER}).finish();
            while (rs.hasNext()) {
                Row row = rs.next();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(NUMBER, row.getString(0));
                map.put("name", row.getString(1));
                map.put(APPID, row.getString(2));
                map.put(UNITID, row.getString(3));
                map.put("level", row.getString(4));
                map.put("devicetype", row.getString(5));
                map.put(SUBSYSNAME, row.getString(6));
                map.put(APPNUMBER, row.getString(7));
                list.add(map);
            }
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:publishedCases.Join(appInfo,JoinType.INNER)", e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return list;
    }

    public Object getFormTypeInfo(String formid) {
        ORM orm = ORM.create();
        String selectFields = "id,dentityid,modeltype,istemplate,name,number";
        QFilter q = new QFilter("dentityid", "=", (Object)formid);
        QFilter[] filters = new QFilter[]{q};
        DynamicObject ds = orm.queryOne("bos_entityobject", selectFields, filters);
        if (ds == null) {
            return null;
        }
        HashMap<String, Object> mapCaseInfo = new HashMap<String, Object>();
        mapCaseInfo.put("modeltype", ds.getString("modeltype"));
        mapCaseInfo.put("istemplate", ds.getBoolean("istemplate"));
        mapCaseInfo.put("name", ds.getString("name"));
        mapCaseInfo.put(NUMBER, ds.getString("id"));
        return mapCaseInfo;
    }

    public Object hasFormRegisterUnittestCase(String formid) {
        ORM orm = ORM.create();
        String selectFields = "id,txt_test_plugin";
        QFilter q1 = new QFilter(TXT_OBJECT, "=", (Object)formid);
        QFilter q2 = new QFilter(CHECKRELEASETYPE, "=", (Object)1);
        QFilter[] filters = new QFilter[]{q1};
        DynamicObject ds = orm.queryOne(FORMNUMBER, selectFields, filters);
        return ds != null;
    }

    public Object hasFormRegisterUnittestCaseWithPlugin(String formid) {
        ORM orm = ORM.create();
        String selectFields = "id,txt_test_plugin";
        QFilter q1 = new QFilter(TXT_OBJECT, "=", (Object)formid);
        QFilter q2 = new QFilter(CHECKRELEASETYPE, "=", (Object)1);
        QFilter[] filters = new QFilter[]{q1};
        DynamicObject ds = orm.queryOne(FORMNUMBER, selectFields, filters);
        if (ds != null) {
            String plugin = ds.getString(TXT_TEST_PLUGIN);
            if (plugin == null || plugin.isEmpty()) {
                return Boolean.FALSE;
            }
            Map mapPlugin = (Map)SerializationUtils.fromJsonString((String)plugin, Map.class);
            List lstPlugin = (List)mapPlugin.get("value");
            boolean hasEnable = false;
            for (Map map : lstPlugin) {
                boolean bEnable = (Boolean)map.get("Enabled");
                if (!bEnable) continue;
                hasEnable = true;
                break;
            }
            return hasEnable;
        }
        return Boolean.FALSE;
    }

    public Map<String, Object> getPrepareEnvStartCase(String appId) {
        HashMap<String, Object> mapCaseInfo = new HashMap<String, Object>();
        ORM orm = ORM.create();
        QFilter q = new QFilter("bizappid", "=", (Object)appId);
        QFilter qfilterIndex = new QFilter(PREPAREINDEX, "=", (Object)"0");
        QFilter qfilterRelease = new QFilter(CHECKRELEASETYPE, "=", (Object)"1");
        String selectFields = "id,txt_number,multi_txt_name,txt_object,bizappid,bizappid.name,txt_test_plugin,txt_param,cbox_type,txt_form_list,responser,responser.name,responsers,jmxcontext,jmxloaction,framechose,checkreleasetype";
        QFilter[] filters = new QFilter[]{q, qfilterIndex, qfilterRelease};
        DynamicObject ds = orm.queryOne(FORMNUMBER, selectFields, filters);
        if (ds != null) {
            mapCaseInfo.put(CASEID, ds.getString("id"));
            mapCaseInfo.put(CASENUMBER, ds.getString(TXT_NUMBER));
            mapCaseInfo.put(SUBSYSID, ds.getString(BIZAPPID));
            mapCaseInfo.put(APPID, ds.getString(BIZAPPID));
            mapCaseInfo.put(APPNAME, ds.getString(BIZAPPNAME));
            mapCaseInfo.put(PARAM, ds.getString(TXT_PARAM));
            mapCaseInfo.put(PLUGIN, ds.getString(TXT_TEST_PLUGIN));
            mapCaseInfo.put(FORMID, ds.getString(TXT_OBJECT));
            mapCaseInfo.put(CASENAME, ds.getString(MULTI_TXT_NAME));
            mapCaseInfo.put("type", ds.getString(CBOX_TYPE));
            mapCaseInfo.put(LISTFORM, ds.getString(TXT_FORM_LIST));
            String responsers = ds.getString(RESPONSERS);
            if (StringUtils.isBlank((CharSequence)responsers)) {
                mapCaseInfo.put("responser", ds.getString(RESPONSER_NAME));
            } else {
                mapCaseInfo.put("responser", responsers);
            }
            String context = "";
            try {
                context = URLDecoder.decode(ds.getString("jmxcontext"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
            mapCaseInfo.put("context", context);
            mapCaseInfo.put(JMXLOACTION, ds.getString(JMXLOACTION));
            mapCaseInfo.put(FRAMECHOSE, ds.getString(FRAMECHOSE));
            return mapCaseInfo;
        }
        log.error(String.format("caseId=%s,selectFields=%s,filter=%s,RequestContext.tenantid=%s,RequestContext.sandboxId=%s", appId, selectFields, q.toString(), RequestContext.get().getTenantId(), RequestContext.get().getAccountId()));
        return null;
    }

    public void updateDataSetValue(String caseNumber, String groupCaseName, String excelName, String data) {
        String querysql = "select fcasenumber from t_bas_unittesthttpdatasets where fcasenumber=? and fgroupcasename=?";
        Object[] params = new Object[]{new SqlParameter(FCASENUMBER, 12, (Object)caseNumber), new SqlParameter(FGROUPCASENAME, 12, (Object)groupCaseName)};
        boolean hasThisDataSet = false;
        try {
            hasThisDataSet = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)querysql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws SQLException {
                    return rs.next();
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(this.errorMsg, e.getMessage(), querysql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        String insertOrUpdateSql = "insert into t_bas_unittesthttpdatasets (FCASENUMBER,FEXCELNAME,FGROUPCASENAME,FDATA) values (?,?,?,?)";
        Object[] saveParams = new Object[]{new SqlParameter(FCASENUMBER, 12, (Object)caseNumber), new SqlParameter("fexcelname", 12, (Object)excelName), new SqlParameter(FGROUPCASENAME, 12, (Object)groupCaseName), new SqlParameter("fdata", 12, (Object)data)};
        if (hasThisDataSet) {
            insertOrUpdateSql = "update t_bas_unittesthttpdatasets set fcasenumber = ? , fexcelname = ? ,fgroupcasename = ?, fdata=?  WHERE fcasenumber =? and  fgroupcasename=?";
            saveParams = new Object[]{new SqlParameter(FCASENUMBER, 12, (Object)caseNumber), new SqlParameter("fexcelname", 12, (Object)excelName), new SqlParameter(FGROUPCASENAME, 12, (Object)groupCaseName), new SqlParameter("fdata", 12, (Object)data), new SqlParameter(FCASENUMBER, 12, (Object)caseNumber), new SqlParameter(FGROUPCASENAME, 12, (Object)groupCaseName)};
        }
        try (TXHandle h = TX.beginRequired();){
            DB.update((DBRoute)DBRoute.basedata, (String)insertOrUpdateSql, (Object[])saveParams);
        }
    }

    public List<Map<String, Object>> getAllUnitTestCaseWithApp(String app) {
        String[] apps = app.split(",");
        StringBuilder curApps = new StringBuilder();
        for (String s : apps) {
            curApps.append("?,");
        }
        curApps = new StringBuilder(curApps.substring(0, curApps.length() - 1));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (DataSet allCases = this.getAllCase();
             DataSet appInfo = this.getMetaAppInfoWithApps(apps, curApps.toString());){
            JoinDataSet jds = allCases.join(appInfo, JoinType.INNER);
            DataSet rs = jds.on(FBIZAPPID, "fid").select(new String[]{FNUMBER, FNAME, FBIZAPPID, FBIZUNITID, FLEVEL, FDEVICETYPE}, new String[]{SUBSYSTEMNAME, APPNUMBER}).finish();
            while (rs.hasNext()) {
                Row row = rs.next();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(NUMBER, row.getString(0));
                map.put("name", row.getString(1));
                map.put(APPID, row.getString(2));
                map.put(UNITID, row.getString(3));
                map.put("level", row.getString(4));
                map.put("devicetype", row.getString(5));
                map.put(SUBSYSNAME, row.getString(6));
                map.put(APPNUMBER, row.getString(7));
                list.add(map);
            }
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:allCases.join(appInfo,JoinType.INNER)", e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return list;
    }

    public List<Map<String, Object>> getAllTestCaseByNumbers(String numbers) {
        ArrayList<Map<String, Object>> listCaseInfo = new ArrayList<Map<String, Object>>();
        ORM orm = ORM.create();
        String selectFields = "id,txt_number,multi_txt_name,bizappid.number";
        String[] arrayNumber = numbers.split(",");
        QFilter q = new QFilter(TXT_NUMBER, "in", (Object)arrayNumber);
        QFilter[] filters = new QFilter[]{q};
        DynamicObjectCollection ds = orm.query(FORMNUMBER, selectFields, filters);
        for (DynamicObject d : ds) {
            HashMap<String, String> mapCaseInfo = new HashMap<String, String>();
            mapCaseInfo.put("id", d.getString("id"));
            mapCaseInfo.put(NUMBER, d.getString(TXT_NUMBER));
            mapCaseInfo.put("name", d.getString(MULTI_TXT_NAME));
            mapCaseInfo.put(APPNUMBER, d.getString("bizappid.number"));
            listCaseInfo.add(mapCaseInfo);
        }
        return listCaseInfo;
    }
}

