/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.sequence.SequenceReader;

class UnitTestWriter {
    private static final String UNIT_TEST_RESULT_TABLE = "T_BAS_UNITTESTRESULT";
    private static final String UNIT_TEST_RESULT_DETAIL_TABLE = "T_BAS_UNITESTRESULTDETAIL";
    private static final String UNIT_TEST_RESULT = "ide_unit_test_result";
    private SimpleDateFormat datetimeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String STARTTIME = "startTime";
    private static final String RESULTTYPE = "resulttype";
    private static final String FRESULTTYPE = ":FRESULTTYPE";
    private static final String FRETURNMSG = ":FRETURNMSG";
    private static final String RETURNMSG = "returnmsg";

    public boolean saveTestCaseResult(Map<String, Object> result) {
        Date datetime;
        boolean bRet = false;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)UNIT_TEST_RESULT);
        DynamicObject resultitem = (DynamicObject)type.createInstance();
        try {
            datetime = this.datetimeformat.parse((String)result.get(STARTTIME));
        }
        catch (ParseException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"startTime\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef :", (String)"UnitTestWriter_0", (String)"bos-unittest", (Object[])new Object[0]) + result.get(STARTTIME), e);
        }
        resultitem.set("datetime", (Object)datetime);
        resultitem.set("testnumber", result.get("fucSum"));
        int status = (Integer)result.get("status");
        if (status == 0) {
            resultitem.set(RESULTTYPE, (Object)Character.valueOf('1'));
            resultitem.set(RETURNMSG, (Object)ResManager.loadKDString((String)"\u5168\u90e8\u7528\u4f8b\u6267\u884c\u6210\u529f", (String)"UnitTestWriter_1", (String)"bos-unittest", (Object[])new Object[0]));
        } else if (status == 1) {
            resultitem.set(RESULTTYPE, (Object)Character.valueOf('0'));
            resultitem.set(RETURNMSG, (Object)ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25", (String)"UnitTestWriter_2", (String)"bos-unittest", (Object[])new Object[0]));
        } else if (status == 2) {
            resultitem.set(RESULTTYPE, (Object)Character.valueOf('0'));
            resultitem.set(RETURNMSG, (Object)ResManager.loadKDString((String)"\u6709\u6267\u884c\u5931\u8d25\u7684\u7528\u4f8b\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5", (String)"UnitTestWriter_3", (String)"bos-unittest", (Object[])new Object[0]));
        }
        resultitem.set("caseid", result.get("caseId"));
        resultitem.set("subsysid", result.get("appid"));
        this.initResultDetailEntity(resultitem, result);
        Object[] rets = BusinessDataWriter.save((IDataEntityType)type, (Object[])new DynamicObject[]{resultitem});
        if (rets.length >= 1 && rets[0] != null) {
            bRet = true;
        }
        return bRet;
    }

    private void initResultDetailEntity(DynamicObject resultitem, Map<String, Object> result) {
        DynamicObjectCollection resultdetailentity = resultitem.getDynamicObjectCollection("entryentity");
        DynamicObjectType entityitemtype = resultdetailentity.getDynamicObjectType();
        List lstCaseResult = (List)result.get("testCaseResults");
        int i = 0;
        for (Map caseResult : lstCaseResult) {
            Date enddatetime;
            Date startdatetime;
            DynamicObject entityitem = (DynamicObject)entityitemtype.createInstance();
            try {
                startdatetime = this.datetimeformat.parse((String)caseResult.get(STARTTIME));
                enddatetime = this.datetimeformat.parse((String)caseResult.get("endTime"));
            }
            catch (ParseException e) {
                throw new RuntimeException(ResManager.loadKDString((String)"startTime\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef :", (String)"UnitTestWriter_0", (String)"bos-unittest", (Object[])new Object[0]) + caseResult.get(STARTTIME), e);
            }
            entityitem.set("startdatetime", (Object)startdatetime);
            entityitem.set("enddatetime", (Object)enddatetime);
            entityitem.set("testresult", caseResult.get("message"));
            entityitem.set("consume", caseResult.get("consumeTime"));
            if (((Boolean)caseResult.get("completed")).booleanValue()) {
                entityitem.set("return", (Object)Character.valueOf('1'));
            } else {
                entityitem.set("return", (Object)Character.valueOf('0'));
            }
            String funcdescript = (String)caseResult.get("name");
            if (funcdescript.length() > 200) {
                funcdescript = funcdescript.substring(0, 200);
            }
            entityitem.set("funcdescript", (Object)funcdescript);
            String funcname = (String)caseResult.get("methodName");
            if (funcname != null && funcname.length() > 200) {
                funcname = funcname.substring(0, 200);
            }
            entityitem.set("funcname", (Object)funcname);
            entityitem.set("seq", (Object)i++);
            resultdetailentity.add((Object)entityitem);
        }
    }

    public boolean saveTestCaseResultBk(Map<String, Object> result) {
        Object[] params = new SqlParameter[7];
        String Seq = DB.genStringId((String)UNIT_TEST_RESULT_TABLE);
        params[0] = new SqlParameter(":FID", 12, (Object)Seq);
        try {
            params[1] = new SqlParameter(":FDATETIME", 93, (Object)this.datetimeformat.parse((String)result.get(STARTTIME)));
        }
        catch (ParseException e) {
            throw new RuntimeException("startTime riqigeshi buzheng :" + result.get(STARTTIME), e);
        }
        params[2] = new SqlParameter(":FTESTNUMBER", 4, result.get("fucSum"));
        int status = (Integer)result.get("status");
        if (status == 0) {
            params[3] = new SqlParameter(FRESULTTYPE, 1, (Object)Character.valueOf('1'));
            params[4] = new SqlParameter(FRETURNMSG, 12, (Object)ResManager.loadKDString((String)"\u5168\u90e8\u7528\u4f8b\u6267\u884c\u6210\u529f", (String)"UnitTestWriter_1", (String)"bos-unittest", (Object[])new Object[0]));
        } else if (status == 1) {
            params[3] = new SqlParameter(FRESULTTYPE, 1, (Object)Character.valueOf('0'));
            params[4] = new SqlParameter(FRETURNMSG, 12, (Object)ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25", (String)"UnitTestWriter_2", (String)"bos-unittest", (Object[])new Object[0]));
        } else if (status == 2) {
            params[3] = new SqlParameter(FRESULTTYPE, 1, (Object)Character.valueOf('0'));
            params[4] = new SqlParameter(FRETURNMSG, 12, (Object)ResManager.loadKDString((String)"\u6709\u6267\u884c\u5931\u8d25\u7684\u7528\u4f8b\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5", (String)"UnitTestWriter_3", (String)"bos-unittest", (Object[])new Object[0]));
        }
        params[5] = new SqlParameter(":FCASEID", 12, result.get("caseId"));
        params[6] = new SqlParameter(":FSUBSYSID", 12, result.get("subSystemId"));
        String sql = this.getSaveTestCaseResultSql();
        boolean bRet = false;
        TXHandle h = TX.beginNew();
        Object object = null;
        try {
            bRet = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (object != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    h.close();
                }
            }
        }
        if (bRet) {
            List lstCaseResult = (List)result.get("testCaseResults");
            for (Map caseResult : lstCaseResult) {
                bRet = this.saveTestCaseResultDetail(caseResult, Seq);
            }
        }
        return bRet;
    }

    private String getSaveTestCaseResultSql() {
        String sql = String.format("insert into %s (FID,FDATETIME,FTESTNUMBER,FRESULTTYPE,FRETURNMSG,FCASEID,FSUBSYSID) values (?,?,?,?,?,?,?)", UNIT_TEST_RESULT_TABLE);
        return sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveTestCaseResultDetail(Map<String, Object> result, String fid) {
        try (TXHandle h = TX.beginNew();){
            SequenceReader seqReader = new SequenceReader(DBRoute.basedata);
            Object[] params = new SqlParameter[9];
            String Seq = SequenceReader.getStringSequence((int)1)[0];
            params[0] = new SqlParameter(":FID", 12, (Object)fid);
            params[1] = new SqlParameter(":FENTRYID", 12, (Object)Seq);
            params[2] = new SqlParameter(":FSTARTDATETIME", 93, result.get(STARTTIME));
            params[3] = new SqlParameter(":FENDDATETIME", 93, result.get("endTime"));
            params[4] = new SqlParameter(":FTESTRESULT", -9, result.get("message"));
            params[5] = new SqlParameter(":FCONSUME", 4, result.get("consumeTime"));
            params[6] = (Boolean)result.get("completed") != false ? new SqlParameter(":FRETURN", 1, (Object)Character.valueOf('1')) : new SqlParameter(":FRETURN", 1, (Object)Character.valueOf('0'));
            params[7] = new SqlParameter(":FFUNCDESCRIPT", 12, result.get("name"));
            params[8] = new SqlParameter(":FFUNCNAME", 12, result.get("methodName"));
            String sql = this.getSaveTestCaseResultDetailSql();
            boolean bl = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            return bl;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.sQL, new Object[]{e});
        }
    }

    private String getSaveTestCaseResultDetailSql() {
        String sql = String.format("insert into %s (FID,FENTRYID,FSTARTDATETIME,FENDDATETIME,FTESTRESULT,FCONSUME,FRETURN,FFUNCDESCRIPT,FFUNCNAME) values (?,?,?,?,?,?,?,?,?)", UNIT_TEST_RESULT_DETAIL_TABLE);
        return sql;
    }
}

