/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.unittest.IJUnitTestPlugIn;
import kd.bos.form.unittest.IKDUnitTestScriptPlugIn;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.form.FormServiceImpl;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.IFormController;
import kd.bos.script.annotations.KSMethod;
import kd.bos.unittest.framework.KDAssert;
import kd.bos.unittest.runners.KDUnitTestClassRunner;
import kd.bos.web.DispatchServiceHelper;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=KDUnitTestClassRunner.class)
public class AbstractBaseUnitTestPlugIn
extends KDAssert
implements IJUnitTestPlugIn,
IKDUnitTestScriptPlugIn {
    public static final String BOS_UNITTEST_PLUGIN = "bos-unittest-plugin";
    public static final String FORM_SERVICE = "FormService";
    public static final String KEY_METHOD_NAME_TIMER_ELAPSED = "[{\"key\":\"\",\"methodName\":\"timerElapsed\"";
    private FormService formService;
    private FormMetadata formMetadata;
    private EntityMetadata entityMetadata;
    private IPageCache pageCache;
    private String pageId;
    private String originPageId;
    private Map<String, Object> params = new HashMap<String, Object>();
    private IFormView view;

    public void Initialize(IFormView view) {
        this.pageId = view.getPageId();
        this.formService = new FormServiceImpl();
        this.pageCache = (IPageCache)view.getService(IPageCache.class);
        String clienttype = (String)this.getView().getFormShowParameter().getCustomParam("clienttype");
        String number = StringUtils.isNotBlank((CharSequence)clienttype) && "mobile".equalsIgnoreCase(clienttype) ? (String)this.getView().getFormShowParameter().getCustomParam("number") : this.getView().getFormShowParameter().getFormId();
        String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form);
        this.formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        if (this.formMetadata == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5931\u8d25\uff0c\u83b7\u53d6\u8868\u5355\u5143\u6570\u636e\u4e3a\u7a7a~", (String)"AbstractBaseUnitTestPlugIn_0", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]));
        }
        this.entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)this.formMetadata.getEntityId(), (MetaCategory)MetaCategory.Entity);
        if (this.entityMetadata == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5931\u8d25\uff0c\u83b7\u53d6\u8868\u5355\u5b9e\u4f53\u5143\u6570\u636e\u4e3a\u7a7a~", (String)"AbstractBaseUnitTestPlugIn_1", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]));
        }
        this.getFormMetadata().bindEntityMetadata(this.entityMetadata);
        this.initData();
    }

    public void initData() {
    }

    @KSMethod
    public IFormView getView() {
        IPageCache pagecache;
        if (this.view != null && (pagecache = (IPageCache)this.view.getService(IPageCache.class)) != null) {
            pagecache.saveChanges();
        }
        this.view = this.getView(this.pageId);
        return this.view;
    }

    @KSMethod
    public FormService getFormService() {
        return this.formService;
    }

    @KSMethod
    public FormMetadata getFormMetadata() {
        return this.formMetadata;
    }

    @KSMethod
    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public void initParams(Map<String, Object> params) {
        this.params = params;
    }

    @KSMethod
    public Map<String, Object> getParams() {
        if (this.params != null) {
            return (Map)this.params.get("casepluginparam");
        }
        return this.params;
    }

    @KSMethod
    public IPageCache getPageCache() {
        return this.pageCache;
    }

    @KSMethod
    public IDataModel getModel() {
        return this.getView().getModel();
    }

    @KSMethod
    public String getPageId() {
        return this.pageId;
    }

    @Deprecated
    @KSMethod
    public void invokeAction(String key, String methodName, Object[] args) {
        String currentPageId = this.getView().getPageId();
        ArrayList saveMapData = new ArrayList();
        String retAction = this.formService.invokeAction(currentPageId, key, methodName, args, saveMapData);
        AbstractBaseUnitTestPlugIn.assertInvokeAction(retAction);
    }

    @Deprecated
    @KSMethod
    public void invokeAction(String key, String methodName, Object[] args, ArrayList<Map<String, Object>> postData) {
        String currentPageId = this.getView().getPageId();
        String retAction = this.formService.invokeAction(currentPageId, key, methodName, args, postData);
        AbstractBaseUnitTestPlugIn.assertInvokeAction(retAction);
    }

    @Deprecated
    @KSMethod
    public void invokeActionSyncUseAssert(String key, String methodName, Object[] args) {
        this.getModel().updateCache();
        String currentPageId = this.getView().getPageId();
        ArrayList saveMapData = new ArrayList();
        String retAction = this.formService.invokeAction(currentPageId, key, methodName, args, saveMapData);
        AbstractBaseUnitTestPlugIn.assertInvokeAction(retAction);
    }

    @Deprecated
    @KSMethod
    public void invokeActionSyncUseAssert(String key, String methodName, Object[] args, ArrayList<Map<String, Object>> postData) {
        this.getModel().updateCache();
        String currentPageId = this.getView().getPageId();
        String retAction = this.formService.invokeAction(currentPageId, key, methodName, args, postData);
        AbstractBaseUnitTestPlugIn.assertInvokeAction(retAction);
    }

    @Deprecated
    @KSMethod
    public String invokeActionSync(String key, String methodName, Object[] args) {
        this.getModel().updateCache();
        String currentPageId = this.getView().getPageId();
        ArrayList saveMapData = new ArrayList();
        return this.formService.invokeAction(currentPageId, key, methodName, args, saveMapData);
    }

    @Deprecated
    @KSMethod
    public String invokeActionSync(IFormView view, String key, String methodName, Object[] args, ArrayList<Map<String, Object>> postData) {
        view.getModel().updateCache();
        String currentPageId = view.getPageId();
        return this.formService.invokeAction(currentPageId, key, methodName, args, postData);
    }

    @Deprecated
    @KSMethod
    public String invokeActionSync(IFormView view, String key, String methodName, Object[] args) {
        view.getModel().updateCache();
        String currentPageId = view.getPageId();
        ArrayList saveMapData = new ArrayList();
        return this.formService.invokeAction(currentPageId, key, methodName, args, saveMapData);
    }

    @Deprecated
    @KSMethod
    public String invokeActionSync(String key, String methodName, Object[] args, ArrayList<Map<String, Object>> postData) {
        this.getModel().updateCache();
        String currentPageId = this.getView().getPageId();
        return this.formService.invokeAction(currentPageId, key, methodName, args, postData);
    }

    private String innerBatInvk(String pageId, String params) {
        String result;
        block2: {
            result = "[]";
            try {
                result = (String)DispatchServiceHelper.invokeBOSService((String)FORM_SERVICE, (String)"batchInvokeAction", (Object[])new Object[]{pageId, params});
            }
            catch (Exception e) {
                if (params != null && params.startsWith(KEY_METHOD_NAME_TIMER_ELAPSED)) break block2;
                throw e;
            }
        }
        return result;
    }

    private String innerBatInvk(String appId, String pageId, String params) {
        String result;
        block2: {
            result = "[]";
            try {
                result = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)FORM_SERVICE, (String)"batchInvokeAction", (Object[])new Object[]{pageId, params});
            }
            catch (Exception e) {
                if (params != null && params.startsWith(KEY_METHOD_NAME_TIMER_ELAPSED)) break block2;
                throw e;
            }
        }
        return result;
    }

    private String innerBatInvkAssert(String pageId, String params) {
        String result;
        block3: {
            result = "[]";
            try {
                if (StringUtils.isBlank((CharSequence)pageId)) {
                    AbstractBaseUnitTestPlugIn.fail(String.format("\u53d1\u9001\u8bf7\u6c42\u65f6\u4f20\u5165\u7684pageId\u4e3a\u7a7a,pageId=%s,\u8bf7\u6839\u636e\u5806\u6808\u68c0\u67e5pageId\u7684\u6765\u6e90\u662f\u5426\u6b63\u5e38", pageId));
                }
                result = (String)DispatchServiceHelper.invokeBOSService((String)FORM_SERVICE, (String)"batchInvokeAction", (Object[])new Object[]{pageId, params});
                AbstractBaseUnitTestPlugIn.assertInvokeAction(result);
            }
            catch (Exception e) {
                if (params != null && params.startsWith(KEY_METHOD_NAME_TIMER_ELAPSED)) break block3;
                throw e;
            }
        }
        return result;
    }

    private String innerBatInvkAssert(String appId, String pageId, String params) {
        String result;
        block3: {
            result = "[]";
            try {
                if (StringUtils.isBlank((CharSequence)pageId)) {
                    AbstractBaseUnitTestPlugIn.fail(String.format("\u53d1\u9001\u8bf7\u6c42\u65f6\u4f20\u5165\u7684pageId\u4e3a\u7a7a,pageId=%s,\u8bf7\u6839\u636e\u5806\u6808\u68c0\u67e5pageId\u7684\u6765\u6e90\u662f\u5426\u6b63\u5e38", pageId));
                }
                result = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)FORM_SERVICE, (String)"batchInvokeAction", (Object[])new Object[]{pageId, params});
                AbstractBaseUnitTestPlugIn.assertInvokeAction(result);
            }
            catch (Exception e) {
                if (params != null && params.startsWith(KEY_METHOD_NAME_TIMER_ELAPSED)) break block3;
                throw e;
            }
        }
        return result;
    }

    @KSMethod
    public String batchInvokeAction(String params) {
        String pageId = this.getView().getPageId();
        return this.innerBatInvk(pageId, params);
    }

    @KSMethod
    public String batchInvokeAction(String appId, String params) {
        String pageId = this.getView().getPageId();
        return this.innerBatInvk(appId, pageId, params);
    }

    @KSMethod
    public String batchInvokeAction(IFormView view, String params) {
        String pageId = view.getPageId();
        return this.innerBatInvk(pageId, params);
    }

    @KSMethod
    public String batchInvokeAction(String appId, IFormView view, String params) {
        String pageId = view.getPageId();
        return this.innerBatInvk(appId, pageId, params);
    }

    @KSMethod
    public String batchInvokeAction(String appId, String pageId, String params) {
        return this.innerBatInvk(appId, pageId, params);
    }

    @KSMethod
    public String batchInvokeActionSync(String params) {
        this.getModel().updateCache();
        return this.batchInvokeAction(params);
    }

    @KSMethod
    public String batchInvokeActionSync(String appId, String params) {
        this.getModel().updateCache();
        return this.batchInvokeAction(appId, params);
    }

    @KSMethod
    public String batchInvokeActionSync(IFormView view, String params) {
        this.getModel().updateCache();
        return this.batchInvokeAction(view, params);
    }

    @KSMethod
    public String batchInvokeActionSync(String appId, IFormView view, String params) {
        this.getModel().updateCache();
        return this.innerBatInvk(appId, this.pageId, params);
    }

    @KSMethod
    public String batchInvokeActionAssertWithRet(String params) {
        String pageId = this.getView().getPageId();
        return this.innerBatInvkAssert(pageId, params);
    }

    @KSMethod
    public String batchInvokeActionSyncAssertWithRet(String params) {
        this.getModel().updateCache();
        return this.batchInvokeActionAssertWithRet(params);
    }

    @KSMethod
    public void batchInvokeActionAssert(String params) {
        this.batchInvokeActionAssertWithRet(params);
    }

    @KSMethod
    public void batchInvokeActionSyncAssert(String params) {
        this.batchInvokeActionSyncAssertWithRet(params);
    }

    @KSMethod
    public String batchInvokeActionAssertWithRet(String appId, String params) {
        String pageId = this.getView().getPageId();
        return this.innerBatInvkAssert(appId, pageId, params);
    }

    @KSMethod
    public void batchInvokeActionAssert(String appId, String params) {
        this.batchInvokeActionAssertWithRet(appId, params);
    }

    @KSMethod
    public String batchInvokeActionSyncAssertWithRet(String appId, String params) {
        this.getModel().updateCache();
        return this.batchInvokeActionAssertWithRet(appId, params);
    }

    @KSMethod
    public void batchInvokeActionSyncAssert(String appId, String params) {
        this.getModel().updateCache();
        this.batchInvokeActionAssertWithRet(appId, params);
    }

    @KSMethod
    public void invokeOperation(String key) {
        OperationResult opRet = this.getView().invokeOperation(key);
        this.getModel().updateCache();
        AbstractBaseUnitTestPlugIn.assertInvokeOperation(opRet);
    }

    @KSMethod
    public void invokeOperationSync(String key) {
        this.getModel().updateCache();
        OperationResult opRet = this.getView().invokeOperation(key);
        this.getModel().updateCache();
        AbstractBaseUnitTestPlugIn.assertInvokeOperation(opRet);
    }

    @KSMethod
    public IFormView switchToNewView(FormShowParameter para) {
        if (this.getView().getFormShowParameter().getFormId().equals(para.getFormId())) {
            return this.getView();
        }
        Map config = FormConfigFactory.createConfig((FormShowParameter)para);
        if (config != null) {
            if (config.get("cancel") != null) {
                return null;
            }
            String currentPageId = (String)config.get("pageId");
            if (this.loadData(currentPageId)) {
                if (this.originPageId == null) {
                    this.originPageId = this.pageId;
                }
                SessionManager.getCurrent().setRequestThread(true);
                IFormView view = SessionManager.getCurrent().getView(currentPageId);
                return view;
            }
        }
        return null;
    }

    @KSMethod
    public void switchToNewView(String pageId) {
        if (StringUtils.isBlank((CharSequence)pageId)) {
            AbstractBaseUnitTestPlugIn.fail(String.format("\u8868\u5355\u89c6\u56fe\u5207\u6362view\u65f6\u4f20\u5165\u7684pageId\u4e3a\u7a7a,pageId=%s,\u8bf7\u6839\u636e\u5806\u6808\u68c0\u67e5pageId\u7684\u6765\u6e90\u662f\u5426\u6b63\u5e38", pageId));
        }
        if (this.loadData(pageId)) {
            if (this.originPageId == null) {
                this.originPageId = this.pageId;
            }
            SessionManager.getCurrent().setRequestThread(true);
            IFormView view = SessionManager.getCurrent().getView(pageId);
            this.Initialize(view);
        }
    }

    @KSMethod
    public IFormView switchToOldView(String pageId) {
        if (StringUtils.isBlank((CharSequence)pageId)) {
            AbstractBaseUnitTestPlugIn.fail(String.format("\u8868\u5355\u89c6\u56fe\u5207\u6362view\u65f6\u4f20\u5165\u7684pageId\u4e3a\u7a7a,pageId=%s,\u8bf7\u6839\u636e\u5806\u6808\u68c0\u67e5pageId\u7684\u6765\u6e90\u662f\u5426\u6b63\u5e38", pageId));
        }
        SessionManager.getCurrent().setRequestThread(true);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        this.Initialize(view);
        return view;
    }

    @KSMethod
    public void switchToOriginView() {
        if (StringUtils.isBlank((CharSequence)this.originPageId) || this.pageId.equals(this.originPageId)) {
            return;
        }
        SessionManager.getCurrent().setRequestThread(true);
        IFormView view = SessionManager.getCurrent().getView(this.originPageId);
        this.Initialize(view);
    }

    @KSMethod
    public IFormView getView(String pageId) {
        if (StringUtils.isBlank((CharSequence)pageId)) {
            AbstractBaseUnitTestPlugIn.fail(String.format("\u83b7\u53d6\u8868\u5355view\u65f6\u4f20\u5165\u7684pageId\u4e3a\u7a7a,pageId=%s,\u8bf7\u6839\u636e\u5806\u6808\u68c0\u67e5pageId\u7684\u6765\u6e90\u662f\u5426\u6b63\u5e38", pageId));
        }
        SessionManager.getCurrent().setRequestThread(true);
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        if (null == formView) {
            if (this.loadData(pageId)) {
                SessionManager.getCurrent().setRequestThread(true);
                formView = SessionManager.getCurrent().getView(pageId);
            }
            if (null == formView) {
                PageCache pageCache = new PageCache(pageId);
                String parameter = pageCache.get(FormShowParameter.class.getSimpleName());
                String msg = String.format("pageId:%s, formView:null-from SessionManager.getCurrent().getView(), paramter:%s", pageId, parameter);
                Assert.fail((String)msg);
                return null;
            }
        }
        ((IFormController)formView.getService(IFormController.class)).registerListener();
        return formView;
    }

    @KSMethod
    public boolean loadData(String pageId) {
        boolean bRet = false;
        try {
            String loaddata;
            if (StringUtils.isBlank((CharSequence)pageId)) {
                AbstractBaseUnitTestPlugIn.fail(String.format("\u8868\u5355\u52a0\u8f7d\u6570\u636e\u65f6\u4f20\u5165\u7684pageId\u4e3a\u7a7a,pageId=%s,\u8bf7\u6839\u636e\u5806\u6808\u68c0\u67e5pageId\u7684\u6765\u6e90\u662f\u5426\u6b63\u5e38", pageId));
            }
            if (StringUtils.isBlank((CharSequence)(loaddata = this.formService.invokeAction(pageId, "", "loadData", new Object[0], new ArrayList())))) {
                junit.framework.Assert.fail((String)ResManager.loadKDString((String)"getView\u4e4b\u524dloadData\u5931\u8d25\uff0c\u8bfb\u53d6\u52a8\u6001\u8868\u5355\u6570\u636e\u4e3a\u7a7a~", (String)"AbstractBaseUnitTestPlugIn_2", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]));
            } else {
                bRet = true;
                List lstActRet = (List)SerializationUtils.fromJsonString((String)loaddata, List.class);
                if (lstActRet != null) {
                    List para = new ArrayList();
                    for (Object object : lstActRet) {
                        Map itemMap = (Map)object;
                        para = (List)itemMap.get("p");
                        if ("showErrMsg".equalsIgnoreCase((String)itemMap.get("a"))) {
                            junit.framework.Assert.fail((String)String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u51fa\u5931\u8d25\uff1a%s,%s", (String)"AbstractBaseUnitTestPlugIn_3", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), (String)((Map)para.get(0)).get("errorTitle"), (String)((Map)para.get(0)).get("errorInfo")));
                            continue;
                        }
                        if (!"showForm".equalsIgnoreCase((String)itemMap.get("a"))) continue;
                        String innerPageId = (String)((Map)para.get(0)).get("pageId");
                        this.formService.invokeAction(innerPageId, "", "loadData", new Object[0], new ArrayList());
                    }
                }
                bRet = true;
            }
        }
        catch (Exception e) {
            junit.framework.Assert.fail((String)this.getErrorInfoFromException(e));
        }
        return bRet;
    }

    public String getErrorInfoFromException(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "\r\n" + sw + "\r\n";
        }
        catch (Exception e2) {
            return "bad getErrorInfoFromException";
        }
    }
}

